// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicediscovery

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetOperationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the operation that you want to get more information about.
	//
	// OperationId is a required field
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetOperationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOperationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetOperationInput"}

	if s.OperationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OperationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetOperationOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the operation.
	Operation *Operation `type:"structure"`
}

// String returns the string representation
func (s GetOperationOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetOperation = "GetOperation"

// GetOperationRequest returns a request value for making API operation for
// AWS Cloud Map.
//
// Gets information about any operation that returns an operation ID in the
// response, such as a CreateService request.
//
// To get a list of operations that match specified criteria, see ListOperations.
//
//    // Example sending a request using GetOperationRequest.
//    req := client.GetOperationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetOperation
func (c *Client) GetOperationRequest(input *GetOperationInput) GetOperationRequest {
	op := &aws.Operation{
		Name:       opGetOperation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOperationInput{}
	}

	req := c.newRequest(op, input, &GetOperationOutput{})
	return GetOperationRequest{Request: req, Input: input, Copy: c.GetOperationRequest}
}

// GetOperationRequest is the request type for the
// GetOperation API operation.
type GetOperationRequest struct {
	*aws.Request
	Input *GetOperationInput
	Copy  func(*GetOperationInput) GetOperationRequest
}

// Send marshals and sends the GetOperation API request.
func (r GetOperationRequest) Send(ctx context.Context) (*GetOperationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetOperationResponse{
		GetOperationOutput: r.Request.Data.(*GetOperationOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetOperationResponse is the response type for the
// GetOperation API operation.
type GetOperationResponse struct {
	*GetOperationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetOperation request.
func (r *GetOperationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
