// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the template you want to retrieve.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetTemplateInput"}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The content of the email, composed of a subject line, an HTML part, and a
	// text-only part.
	Template *Template `type:"structure"`
}

// String returns the string representation
func (s GetTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetTemplate = "GetTemplate"

// GetTemplateRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Displays the template object (which includes the Subject line, HTML part
// and text part) for the template you specify.
//
// You can execute this operation no more than once per second.
//
//    // Example sending a request using GetTemplateRequest.
//    req := client.GetTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetTemplate
func (c *Client) GetTemplateRequest(input *GetTemplateInput) GetTemplateRequest {
	op := &aws.Operation{
		Name:       opGetTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTemplateInput{}
	}

	req := c.newRequest(op, input, &GetTemplateOutput{})
	return GetTemplateRequest{Request: req, Input: input, Copy: c.GetTemplateRequest}
}

// GetTemplateRequest is the request type for the
// GetTemplate API operation.
type GetTemplateRequest struct {
	*aws.Request
	Input *GetTemplateInput
	Copy  func(*GetTemplateInput) GetTemplateRequest
}

// Send marshals and sends the GetTemplate API request.
func (r GetTemplateRequest) Send(ctx context.Context) (*GetTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetTemplateResponse{
		GetTemplateOutput: r.Request.Data.(*GetTemplateOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetTemplateResponse is the response type for the
// GetTemplate API operation.
type GetTemplateResponse struct {
	*GetTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetTemplate request.
func (r *GetTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
