// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sesv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request to enable or disable tracking of reputation metrics for a configuration
// set.
type PutConfigurationSetReputationOptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to enable or disable reputation
	// metric tracking for.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`

	// If true, tracking of reputation metrics is enabled for the configuration
	// set. If false, tracking of reputation metrics is disabled for the configuration
	// set.
	ReputationMetricsEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s PutConfigurationSetReputationOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConfigurationSetReputationOptionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutConfigurationSetReputationOptionsInput"}

	if s.ConfigurationSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigurationSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutConfigurationSetReputationOptionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ReputationMetricsEnabled != nil {
		v := *s.ReputationMetricsEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReputationMetricsEnabled", protocol.BoolValue(v), metadata)
	}
	if s.ConfigurationSetName != nil {
		v := *s.ConfigurationSetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ConfigurationSetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutConfigurationSetReputationOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutConfigurationSetReputationOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutConfigurationSetReputationOptionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opPutConfigurationSetReputationOptions = "PutConfigurationSetReputationOptions"

// PutConfigurationSetReputationOptionsRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Enable or disable collection of reputation metrics for emails that you send
// using a particular configuration set in a specific AWS Region.
//
//    // Example sending a request using PutConfigurationSetReputationOptionsRequest.
//    req := client.PutConfigurationSetReputationOptionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetReputationOptions
func (c *Client) PutConfigurationSetReputationOptionsRequest(input *PutConfigurationSetReputationOptionsInput) PutConfigurationSetReputationOptionsRequest {
	op := &aws.Operation{
		Name:       opPutConfigurationSetReputationOptions,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/email/configuration-sets/{ConfigurationSetName}/reputation-options",
	}

	if input == nil {
		input = &PutConfigurationSetReputationOptionsInput{}
	}

	req := c.newRequest(op, input, &PutConfigurationSetReputationOptionsOutput{})
	return PutConfigurationSetReputationOptionsRequest{Request: req, Input: input, Copy: c.PutConfigurationSetReputationOptionsRequest}
}

// PutConfigurationSetReputationOptionsRequest is the request type for the
// PutConfigurationSetReputationOptions API operation.
type PutConfigurationSetReputationOptionsRequest struct {
	*aws.Request
	Input *PutConfigurationSetReputationOptionsInput
	Copy  func(*PutConfigurationSetReputationOptionsInput) PutConfigurationSetReputationOptionsRequest
}

// Send marshals and sends the PutConfigurationSetReputationOptions API request.
func (r PutConfigurationSetReputationOptionsRequest) Send(ctx context.Context) (*PutConfigurationSetReputationOptionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutConfigurationSetReputationOptionsResponse{
		PutConfigurationSetReputationOptionsOutput: r.Request.Data.(*PutConfigurationSetReputationOptionsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutConfigurationSetReputationOptionsResponse is the response type for the
// PutConfigurationSetReputationOptions API operation.
type PutConfigurationSetReputationOptionsResponse struct {
	*PutConfigurationSetReputationOptionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutConfigurationSetReputationOptions request.
func (r *PutConfigurationSetReputationOptionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
