// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// A JSON object containing one or more of the following fields:
//
//    * AddWorkingStorageInput$DiskIds
type AddWorkingStorageInput struct {
	_ struct{} `type:"structure"`

	// An array of strings that identify disks that are to be configured as working
	// storage. Each string have a minimum length of 1 and maximum length of 300.
	// You can get the disk IDs from the ListLocalDisks API.
	//
	// DiskIds is a required field
	DiskIds []string `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s AddWorkingStorageInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddWorkingStorageInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AddWorkingStorageInput"}

	if s.DiskIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("DiskIds"))
	}

	if s.GatewayARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the of the gateway for which working storage was
// configured.
type AddWorkingStorageOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s AddWorkingStorageOutput) String() string {
	return awsutil.Prettify(s)
}

const opAddWorkingStorage = "AddWorkingStorage"

// AddWorkingStorageRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Configures one or more gateway local disks as working storage for a gateway.
// This operation is only supported in the stored volume gateway type. This
// operation is deprecated in cached volume API version 20120630. Use AddUploadBuffer
// instead.
//
// Working storage is also referred to as upload buffer. You can also use the
// AddUploadBuffer operation to add upload buffer to a stored volume gateway.
//
// In the request, you specify the gateway Amazon Resource Name (ARN) to which
// you want to add working storage, and one or more disk IDs that you want to
// configure as working storage.
//
//    // Example sending a request using AddWorkingStorageRequest.
//    req := client.AddWorkingStorageRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddWorkingStorage
func (c *Client) AddWorkingStorageRequest(input *AddWorkingStorageInput) AddWorkingStorageRequest {
	op := &aws.Operation{
		Name:       opAddWorkingStorage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddWorkingStorageInput{}
	}

	req := c.newRequest(op, input, &AddWorkingStorageOutput{})
	return AddWorkingStorageRequest{Request: req, Input: input, Copy: c.AddWorkingStorageRequest}
}

// AddWorkingStorageRequest is the request type for the
// AddWorkingStorage API operation.
type AddWorkingStorageRequest struct {
	*aws.Request
	Input *AddWorkingStorageInput
	Copy  func(*AddWorkingStorageInput) AddWorkingStorageRequest
}

// Send marshals and sends the AddWorkingStorage API request.
func (r AddWorkingStorageRequest) Send(ctx context.Context) (*AddWorkingStorageResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AddWorkingStorageResponse{
		AddWorkingStorageOutput: r.Request.Data.(*AddWorkingStorageOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AddWorkingStorageResponse is the response type for the
// AddWorkingStorage API operation.
type AddWorkingStorageResponse struct {
	*AddWorkingStorageOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AddWorkingStorage request.
func (r *AddWorkingStorageResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
