// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// DescribeNFSFileSharesInput
type DescribeNFSFileSharesInput struct {
	_ struct{} `type:"structure"`

	// An array containing the Amazon Resource Name (ARN) of each file share to
	// be described.
	//
	// FileShareARNList is a required field
	FileShareARNList []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeNFSFileSharesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNFSFileSharesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeNFSFileSharesInput"}

	if s.FileShareARNList == nil {
		invalidParams.Add(aws.NewErrParamRequired("FileShareARNList"))
	}
	if s.FileShareARNList != nil && len(s.FileShareARNList) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FileShareARNList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// DescribeNFSFileSharesOutput
type DescribeNFSFileSharesOutput struct {
	_ struct{} `type:"structure"`

	// An array containing a description for each requested file share.
	NFSFileShareInfoList []NFSFileShareInfo `type:"list"`
}

// String returns the string representation
func (s DescribeNFSFileSharesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeNFSFileShares = "DescribeNFSFileShares"

// DescribeNFSFileSharesRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Gets a description for one or more Network File System (NFS) file shares
// from a file gateway. This operation is only supported for file gateways.
//
//    // Example sending a request using DescribeNFSFileSharesRequest.
//    req := client.DescribeNFSFileSharesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeNFSFileShares
func (c *Client) DescribeNFSFileSharesRequest(input *DescribeNFSFileSharesInput) DescribeNFSFileSharesRequest {
	op := &aws.Operation{
		Name:       opDescribeNFSFileShares,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNFSFileSharesInput{}
	}

	req := c.newRequest(op, input, &DescribeNFSFileSharesOutput{})
	return DescribeNFSFileSharesRequest{Request: req, Input: input, Copy: c.DescribeNFSFileSharesRequest}
}

// DescribeNFSFileSharesRequest is the request type for the
// DescribeNFSFileShares API operation.
type DescribeNFSFileSharesRequest struct {
	*aws.Request
	Input *DescribeNFSFileSharesInput
	Copy  func(*DescribeNFSFileSharesInput) DescribeNFSFileSharesRequest
}

// Send marshals and sends the DescribeNFSFileShares API request.
func (r DescribeNFSFileSharesRequest) Send(ctx context.Context) (*DescribeNFSFileSharesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeNFSFileSharesResponse{
		DescribeNFSFileSharesOutput: r.Request.Data.(*DescribeNFSFileSharesOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeNFSFileSharesResponse is the response type for the
// DescribeNFSFileShares API operation.
type DescribeNFSFileSharesResponse struct {
	*DescribeNFSFileSharesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeNFSFileShares request.
func (r *DescribeNFSFileSharesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
