// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type AssociateDeviceWithNetworkProfileInput struct {
	_ struct{} `type:"structure"`

	// The device ARN.
	//
	// DeviceArn is a required field
	DeviceArn *string `type:"string" required:"true"`

	// The ARN of the network profile to associate with a device.
	//
	// NetworkProfileArn is a required field
	NetworkProfileArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateDeviceWithNetworkProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateDeviceWithNetworkProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateDeviceWithNetworkProfileInput"}

	if s.DeviceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeviceArn"))
	}

	if s.NetworkProfileArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("NetworkProfileArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AssociateDeviceWithNetworkProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateDeviceWithNetworkProfileOutput) String() string {
	return awsutil.Prettify(s)
}

const opAssociateDeviceWithNetworkProfile = "AssociateDeviceWithNetworkProfile"

// AssociateDeviceWithNetworkProfileRequest returns a request value for making API operation for
// Alexa For Business.
//
// Associates a device with the specified network profile.
//
//    // Example sending a request using AssociateDeviceWithNetworkProfileRequest.
//    req := client.AssociateDeviceWithNetworkProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateDeviceWithNetworkProfile
func (c *Client) AssociateDeviceWithNetworkProfileRequest(input *AssociateDeviceWithNetworkProfileInput) AssociateDeviceWithNetworkProfileRequest {
	op := &aws.Operation{
		Name:       opAssociateDeviceWithNetworkProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateDeviceWithNetworkProfileInput{}
	}

	req := c.newRequest(op, input, &AssociateDeviceWithNetworkProfileOutput{})
	return AssociateDeviceWithNetworkProfileRequest{Request: req, Input: input, Copy: c.AssociateDeviceWithNetworkProfileRequest}
}

// AssociateDeviceWithNetworkProfileRequest is the request type for the
// AssociateDeviceWithNetworkProfile API operation.
type AssociateDeviceWithNetworkProfileRequest struct {
	*aws.Request
	Input *AssociateDeviceWithNetworkProfileInput
	Copy  func(*AssociateDeviceWithNetworkProfileInput) AssociateDeviceWithNetworkProfileRequest
}

// Send marshals and sends the AssociateDeviceWithNetworkProfile API request.
func (r AssociateDeviceWithNetworkProfileRequest) Send(ctx context.Context) (*AssociateDeviceWithNetworkProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateDeviceWithNetworkProfileResponse{
		AssociateDeviceWithNetworkProfileOutput: r.Request.Data.(*AssociateDeviceWithNetworkProfileOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateDeviceWithNetworkProfileResponse is the response type for the
// AssociateDeviceWithNetworkProfile API operation.
type AssociateDeviceWithNetworkProfileResponse struct {
	*AssociateDeviceWithNetworkProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateDeviceWithNetworkProfile request.
func (r *AssociateDeviceWithNetworkProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
