// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudsearch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Container for the parameters to the DescribeIndexFields operation. Specifies
// the name of the domain you want to describe. To restrict the response to
// particular index fields, specify the names of the index fields you want to
// describe. To show the active configuration and exclude any pending changes,
// set the Deployed option to true.
type DescribeIndexFieldsInput struct {
	_ struct{} `type:"structure"`

	// Whether to display the deployed configuration (true) or include any pending
	// changes (false). Defaults to false.
	Deployed *bool `type:"boolean"`

	// The name of the domain you want to describe.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// A list of the index fields you want to describe. If not specified, information
	// is returned for all configured index fields.
	FieldNames []string `type:"list"`
}

// String returns the string representation
func (s DescribeIndexFieldsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIndexFieldsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeIndexFieldsInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DescribeIndexFields request. Contains the index fields configured
// for the domain specified in the request.
type DescribeIndexFieldsOutput struct {
	_ struct{} `type:"structure"`

	// The index fields configured for the domain.
	//
	// IndexFields is a required field
	IndexFields []IndexFieldStatus `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeIndexFieldsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeIndexFields = "DescribeIndexFields"

// DescribeIndexFieldsRequest returns a request value for making API operation for
// Amazon CloudSearch.
//
// Gets information about the index fields configured for the search domain.
// Can be limited to specific fields by name. By default, shows all fields and
// includes any pending changes to the configuration. Set the Deployed option
// to true to show the active configuration and exclude pending changes. For
// more information, see Getting Domain Information (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html)
// in the Amazon CloudSearch Developer Guide.
//
//    // Example sending a request using DescribeIndexFieldsRequest.
//    req := client.DescribeIndexFieldsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeIndexFieldsRequest(input *DescribeIndexFieldsInput) DescribeIndexFieldsRequest {
	op := &aws.Operation{
		Name:       opDescribeIndexFields,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIndexFieldsInput{}
	}

	req := c.newRequest(op, input, &DescribeIndexFieldsOutput{})
	return DescribeIndexFieldsRequest{Request: req, Input: input, Copy: c.DescribeIndexFieldsRequest}
}

// DescribeIndexFieldsRequest is the request type for the
// DescribeIndexFields API operation.
type DescribeIndexFieldsRequest struct {
	*aws.Request
	Input *DescribeIndexFieldsInput
	Copy  func(*DescribeIndexFieldsInput) DescribeIndexFieldsRequest
}

// Send marshals and sends the DescribeIndexFields API request.
func (r DescribeIndexFieldsRequest) Send(ctx context.Context) (*DescribeIndexFieldsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeIndexFieldsResponse{
		DescribeIndexFieldsOutput: r.Request.Data.(*DescribeIndexFieldsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeIndexFieldsResponse is the response type for the
// DescribeIndexFields API operation.
type DescribeIndexFieldsResponse struct {
	*DescribeIndexFieldsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeIndexFields request.
func (r *DescribeIndexFieldsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
