// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudsearch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Container for the parameters to the UpdateDomainEndpointOptions operation.
// Specifies the name of the domain you want to update and the domain endpoint
// options.
type UpdateDomainEndpointOptionsInput struct {
	_ struct{} `type:"structure"`

	// Whether to require that all requests to the domain arrive over HTTPS. We
	// recommend Policy-Min-TLS-1-2-2019-07 for TLSSecurityPolicy. For compatibility
	// with older clients, the default is Policy-Min-TLS-1-0-2019-07.
	//
	// DomainEndpointOptions is a required field
	DomainEndpointOptions *DomainEndpointOptions `type:"structure" required:"true"`

	// A string that represents the name of a domain.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDomainEndpointOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDomainEndpointOptionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDomainEndpointOptionsInput"}

	if s.DomainEndpointOptions == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainEndpointOptions"))
	}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a UpdateDomainEndpointOptions request. Contains the configuration
// and status of the domain's endpoint options.
type UpdateDomainEndpointOptionsOutput struct {
	_ struct{} `type:"structure"`

	// The newly-configured domain endpoint options.
	DomainEndpointOptions *DomainEndpointOptionsStatus `type:"structure"`
}

// String returns the string representation
func (s UpdateDomainEndpointOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateDomainEndpointOptions = "UpdateDomainEndpointOptions"

// UpdateDomainEndpointOptionsRequest returns a request value for making API operation for
// Amazon CloudSearch.
//
// Updates the domain's endpoint options, specifically whether all requests
// to the domain must arrive over HTTPS. For more information, see Configuring
// Domain Endpoint Options (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-domain-endpoint-options.html)
// in the Amazon CloudSearch Developer Guide.
//
//    // Example sending a request using UpdateDomainEndpointOptionsRequest.
//    req := client.UpdateDomainEndpointOptionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) UpdateDomainEndpointOptionsRequest(input *UpdateDomainEndpointOptionsInput) UpdateDomainEndpointOptionsRequest {
	op := &aws.Operation{
		Name:       opUpdateDomainEndpointOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDomainEndpointOptionsInput{}
	}

	req := c.newRequest(op, input, &UpdateDomainEndpointOptionsOutput{})
	return UpdateDomainEndpointOptionsRequest{Request: req, Input: input, Copy: c.UpdateDomainEndpointOptionsRequest}
}

// UpdateDomainEndpointOptionsRequest is the request type for the
// UpdateDomainEndpointOptions API operation.
type UpdateDomainEndpointOptionsRequest struct {
	*aws.Request
	Input *UpdateDomainEndpointOptionsInput
	Copy  func(*UpdateDomainEndpointOptionsInput) UpdateDomainEndpointOptionsRequest
}

// Send marshals and sends the UpdateDomainEndpointOptions API request.
func (r UpdateDomainEndpointOptionsRequest) Send(ctx context.Context) (*UpdateDomainEndpointOptionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDomainEndpointOptionsResponse{
		UpdateDomainEndpointOptionsOutput: r.Request.Data.(*UpdateDomainEndpointOptionsOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDomainEndpointOptionsResponse is the response type for the
// UpdateDomainEndpointOptions API operation.
type UpdateDomainEndpointOptionsResponse struct {
	*UpdateDomainEndpointOptionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDomainEndpointOptions request.
func (r *UpdateDomainEndpointOptionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
