// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteInsightRulesInput struct {
	_ struct{} `type:"structure"`

	// An array of the rule names to delete. If you need to find out the names of
	// your rules, use DescribeInsightRules.
	//
	// RuleNames is a required field
	RuleNames []string `type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteInsightRulesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInsightRulesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteInsightRulesInput"}

	if s.RuleNames == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteInsightRulesOutput struct {
	_ struct{} `type:"structure"`

	// An array listing the rules that could not be deleted. You cannot delete built-in
	// rules.
	Failures []PartialFailure `type:"list"`
}

// String returns the string representation
func (s DeleteInsightRulesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteInsightRules = "DeleteInsightRules"

// DeleteInsightRulesRequest returns a request value for making API operation for
// Amazon CloudWatch.
//
// Permanently deletes the specified Contributor Insights rules.
//
// If you create a rule, delete it, and then re-create it with the same name,
// historical data from the first time the rule was created may or may not be
// available.
//
//    // Example sending a request using DeleteInsightRulesRequest.
//    req := client.DeleteInsightRulesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteInsightRules
func (c *Client) DeleteInsightRulesRequest(input *DeleteInsightRulesInput) DeleteInsightRulesRequest {
	op := &aws.Operation{
		Name:       opDeleteInsightRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInsightRulesInput{}
	}

	req := c.newRequest(op, input, &DeleteInsightRulesOutput{})
	return DeleteInsightRulesRequest{Request: req, Input: input, Copy: c.DeleteInsightRulesRequest}
}

// DeleteInsightRulesRequest is the request type for the
// DeleteInsightRules API operation.
type DeleteInsightRulesRequest struct {
	*aws.Request
	Input *DeleteInsightRulesInput
	Copy  func(*DeleteInsightRulesInput) DeleteInsightRulesRequest
}

// Send marshals and sends the DeleteInsightRules API request.
func (r DeleteInsightRulesRequest) Send(ctx context.Context) (*DeleteInsightRulesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteInsightRulesResponse{
		DeleteInsightRulesOutput: r.Request.Data.(*DeleteInsightRulesOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteInsightRulesResponse is the response type for the
// DeleteInsightRules API operation.
type DeleteInsightRulesResponse struct {
	*DeleteInsightRulesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteInsightRules request.
func (r *DeleteInsightRulesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
