// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codebuild

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteSourceCredentialsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the token.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSourceCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSourceCredentialsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteSourceCredentialsInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteSourceCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the token.
	Arn *string `locationName:"arn" min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteSourceCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteSourceCredentials = "DeleteSourceCredentials"

// DeleteSourceCredentialsRequest returns a request value for making API operation for
// AWS CodeBuild.
//
// Deletes a set of GitHub, GitHub Enterprise, or Bitbucket source credentials.
//
//    // Example sending a request using DeleteSourceCredentialsRequest.
//    req := client.DeleteSourceCredentialsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteSourceCredentials
func (c *Client) DeleteSourceCredentialsRequest(input *DeleteSourceCredentialsInput) DeleteSourceCredentialsRequest {
	op := &aws.Operation{
		Name:       opDeleteSourceCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSourceCredentialsInput{}
	}

	req := c.newRequest(op, input, &DeleteSourceCredentialsOutput{})
	return DeleteSourceCredentialsRequest{Request: req, Input: input, Copy: c.DeleteSourceCredentialsRequest}
}

// DeleteSourceCredentialsRequest is the request type for the
// DeleteSourceCredentials API operation.
type DeleteSourceCredentialsRequest struct {
	*aws.Request
	Input *DeleteSourceCredentialsInput
	Copy  func(*DeleteSourceCredentialsInput) DeleteSourceCredentialsRequest
}

// Send marshals and sends the DeleteSourceCredentials API request.
func (r DeleteSourceCredentialsRequest) Send(ctx context.Context) (*DeleteSourceCredentialsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteSourceCredentialsResponse{
		DeleteSourceCredentialsOutput: r.Request.Data.(*DeleteSourceCredentialsOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteSourceCredentialsResponse is the response type for the
// DeleteSourceCredentials API operation.
type DeleteSourceCredentialsResponse struct {
	*DeleteSourceCredentialsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteSourceCredentials request.
func (r *DeleteSourceCredentialsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
