// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodb

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of a DescribeTable operation.
type DescribeTableInput struct {
	_ struct{} `type:"structure"`

	// The name of the table to describe.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTableInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTableInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeTableInput"}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a DescribeTable operation.
type DescribeTableOutput struct {
	_ struct{} `type:"structure"`

	// The properties of the table.
	Table *TableDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeTableOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeTable = "DescribeTable"

// DescribeTableRequest returns a request value for making API operation for
// Amazon DynamoDB.
//
// Returns information about the table, including the current status of the
// table, when it was created, the primary key schema, and any indexes on the
// table.
//
// If you issue a DescribeTable request immediately after a CreateTable request,
// DynamoDB might return a ResourceNotFoundException. This is because DescribeTable
// uses an eventually consistent query, and the metadata for your table might
// not be available at that moment. Wait for a few seconds, and then try the
// DescribeTable request again.
//
//    // Example sending a request using DescribeTableRequest.
//    req := client.DescribeTableRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTable
func (c *Client) DescribeTableRequest(input *DescribeTableInput) DescribeTableRequest {
	op := &aws.Operation{
		Name:       opDescribeTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTableInput{}
	}

	req := c.newRequest(op, input, &DescribeTableOutput{})
	return DescribeTableRequest{Request: req, Input: input, Copy: c.DescribeTableRequest}
}

// DescribeTableRequest is the request type for the
// DescribeTable API operation.
type DescribeTableRequest struct {
	*aws.Request
	Input *DescribeTableInput
	Copy  func(*DescribeTableInput) DescribeTableRequest
}

// Send marshals and sends the DescribeTable API request.
func (r DescribeTableRequest) Send(ctx context.Context) (*DescribeTableResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTableResponse{
		DescribeTableOutput: r.Request.Data.(*DescribeTableOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeTableResponse is the response type for the
// DescribeTable API operation.
type DescribeTableResponse struct {
	*DescribeTableOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTable request.
func (r *DescribeTableResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
