// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/ec2query"
)

// Contains the parameters for DeleteVpnGateway.
type DeleteVpnGatewayInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the virtual private gateway.
	//
	// VpnGatewayId is a required field
	VpnGatewayId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVpnGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVpnGatewayInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteVpnGatewayInput"}

	if s.VpnGatewayId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VpnGatewayId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteVpnGatewayOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVpnGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteVpnGateway = "DeleteVpnGateway"

// DeleteVpnGatewayRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Deletes the specified virtual private gateway. We recommend that before you
// delete a virtual private gateway, you detach it from the VPC and delete the
// VPN connection. Note that you don't need to delete the virtual private gateway
// if you plan to delete and recreate the VPN connection between your VPC and
// your network.
//
//    // Example sending a request using DeleteVpnGatewayRequest.
//    req := client.DeleteVpnGatewayRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnGateway
func (c *Client) DeleteVpnGatewayRequest(input *DeleteVpnGatewayInput) DeleteVpnGatewayRequest {
	op := &aws.Operation{
		Name:       opDeleteVpnGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpnGatewayInput{}
	}

	req := c.newRequest(op, input, &DeleteVpnGatewayOutput{})
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteVpnGatewayRequest{Request: req, Input: input, Copy: c.DeleteVpnGatewayRequest}
}

// DeleteVpnGatewayRequest is the request type for the
// DeleteVpnGateway API operation.
type DeleteVpnGatewayRequest struct {
	*aws.Request
	Input *DeleteVpnGatewayInput
	Copy  func(*DeleteVpnGatewayInput) DeleteVpnGatewayRequest
}

// Send marshals and sends the DeleteVpnGateway API request.
func (r DeleteVpnGatewayRequest) Send(ctx context.Context) (*DeleteVpnGatewayResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteVpnGatewayResponse{
		DeleteVpnGatewayOutput: r.Request.Data.(*DeleteVpnGatewayOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteVpnGatewayResponse is the response type for the
// DeleteVpnGateway API operation.
type DeleteVpnGatewayResponse struct {
	*DeleteVpnGatewayOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteVpnGateway request.
func (r *DeleteVpnGatewayResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
