// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type BatchGetVariableInput struct {
	_ struct{} `type:"structure"`

	// The list of variable names to get.
	//
	// Names is a required field
	Names []string `locationName:"names" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetVariableInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetVariableInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchGetVariableInput"}

	if s.Names == nil {
		invalidParams.Add(aws.NewErrParamRequired("Names"))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Names", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type BatchGetVariableOutput struct {
	_ struct{} `type:"structure"`

	// The errors from the request.
	Errors []BatchGetVariableError `locationName:"errors" type:"list"`

	// The returned variables.
	Variables []Variable `locationName:"variables" type:"list"`
}

// String returns the string representation
func (s BatchGetVariableOutput) String() string {
	return awsutil.Prettify(s)
}

const opBatchGetVariable = "BatchGetVariable"

// BatchGetVariableRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Gets a batch of variables.
//
//    // Example sending a request using BatchGetVariableRequest.
//    req := client.BatchGetVariableRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchGetVariable
func (c *Client) BatchGetVariableRequest(input *BatchGetVariableInput) BatchGetVariableRequest {
	op := &aws.Operation{
		Name:       opBatchGetVariable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetVariableInput{}
	}

	req := c.newRequest(op, input, &BatchGetVariableOutput{})
	return BatchGetVariableRequest{Request: req, Input: input, Copy: c.BatchGetVariableRequest}
}

// BatchGetVariableRequest is the request type for the
// BatchGetVariable API operation.
type BatchGetVariableRequest struct {
	*aws.Request
	Input *BatchGetVariableInput
	Copy  func(*BatchGetVariableInput) BatchGetVariableRequest
}

// Send marshals and sends the BatchGetVariable API request.
func (r BatchGetVariableRequest) Send(ctx context.Context) (*BatchGetVariableResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchGetVariableResponse{
		BatchGetVariableOutput: r.Request.Data.(*BatchGetVariableOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchGetVariableResponse is the response type for the
// BatchGetVariable API operation.
type BatchGetVariableResponse struct {
	*BatchGetVariableOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchGetVariable request.
func (r *BatchGetVariableResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
