// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListMitigationActionsInput struct {
	_ struct{} `type:"structure"`

	// Specify a value to limit the result to mitigation actions with a specific
	// action type.
	ActionType MitigationActionType `location:"querystring" locationName:"actionType" type:"string" enum:"true"`

	// The maximum number of results to return at one time. The default is 25.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListMitigationActionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMitigationActionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListMitigationActionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListMitigationActionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if len(s.ActionType) > 0 {
		v := s.ActionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "actionType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListMitigationActionsOutput struct {
	_ struct{} `type:"structure"`

	// A set of actions that matched the specified filter criteria.
	ActionIdentifiers []MitigationActionIdentifier `locationName:"actionIdentifiers" type:"list"`

	// The token for the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListMitigationActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListMitigationActionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ActionIdentifiers != nil {
		v := s.ActionIdentifiers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "actionIdentifiers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListMitigationActions = "ListMitigationActions"

// ListMitigationActionsRequest returns a request value for making API operation for
// AWS IoT.
//
// Gets a list of all mitigation actions that match the specified filter criteria.
//
//    // Example sending a request using ListMitigationActionsRequest.
//    req := client.ListMitigationActionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListMitigationActionsRequest(input *ListMitigationActionsInput) ListMitigationActionsRequest {
	op := &aws.Operation{
		Name:       opListMitigationActions,
		HTTPMethod: "GET",
		HTTPPath:   "/mitigationactions/actions",
	}

	if input == nil {
		input = &ListMitigationActionsInput{}
	}

	req := c.newRequest(op, input, &ListMitigationActionsOutput{})
	return ListMitigationActionsRequest{Request: req, Input: input, Copy: c.ListMitigationActionsRequest}
}

// ListMitigationActionsRequest is the request type for the
// ListMitigationActions API operation.
type ListMitigationActionsRequest struct {
	*aws.Request
	Input *ListMitigationActionsInput
	Copy  func(*ListMitigationActionsInput) ListMitigationActionsRequest
}

// Send marshals and sends the ListMitigationActions API request.
func (r ListMitigationActionsRequest) Send(ctx context.Context) (*ListMitigationActionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListMitigationActionsResponse{
		ListMitigationActionsOutput: r.Request.Data.(*ListMitigationActionsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListMitigationActionsResponse is the response type for the
// ListMitigationActions API operation.
type ListMitigationActionsResponse struct {
	*ListMitigationActionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListMitigationActions request.
func (r *ListMitigationActionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
