// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediapackage

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListHarvestJobsInput struct {
	_ struct{} `type:"structure"`

	IncludeChannelId *string `location:"querystring" locationName:"includeChannelId" type:"string"`

	IncludeStatus *string `location:"querystring" locationName:"includeStatus" type:"string"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListHarvestJobsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListHarvestJobsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListHarvestJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListHarvestJobsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.IncludeChannelId != nil {
		v := *s.IncludeChannelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "includeChannelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IncludeStatus != nil {
		v := *s.IncludeStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "includeStatus", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListHarvestJobsOutput struct {
	_ struct{} `type:"structure"`

	HarvestJobs []HarvestJob `locationName:"harvestJobs" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListHarvestJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListHarvestJobsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.HarvestJobs != nil {
		v := s.HarvestJobs

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "harvestJobs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListHarvestJobs = "ListHarvestJobs"

// ListHarvestJobsRequest returns a request value for making API operation for
// AWS Elemental MediaPackage.
//
// Returns a collection of HarvestJob records.
//
//    // Example sending a request using ListHarvestJobsRequest.
//    req := client.ListHarvestJobsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/ListHarvestJobs
func (c *Client) ListHarvestJobsRequest(input *ListHarvestJobsInput) ListHarvestJobsRequest {
	op := &aws.Operation{
		Name:       opListHarvestJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/harvest_jobs",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListHarvestJobsInput{}
	}

	req := c.newRequest(op, input, &ListHarvestJobsOutput{})
	return ListHarvestJobsRequest{Request: req, Input: input, Copy: c.ListHarvestJobsRequest}
}

// ListHarvestJobsRequest is the request type for the
// ListHarvestJobs API operation.
type ListHarvestJobsRequest struct {
	*aws.Request
	Input *ListHarvestJobsInput
	Copy  func(*ListHarvestJobsInput) ListHarvestJobsRequest
}

// Send marshals and sends the ListHarvestJobs API request.
func (r ListHarvestJobsRequest) Send(ctx context.Context) (*ListHarvestJobsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListHarvestJobsResponse{
		ListHarvestJobsOutput: r.Request.Data.(*ListHarvestJobsOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListHarvestJobsRequestPaginator returns a paginator for ListHarvestJobs.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListHarvestJobsRequest(input)
//   p := mediapackage.NewListHarvestJobsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListHarvestJobsPaginator(req ListHarvestJobsRequest) ListHarvestJobsPaginator {
	return ListHarvestJobsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListHarvestJobsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListHarvestJobsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListHarvestJobsPaginator struct {
	aws.Pager
}

func (p *ListHarvestJobsPaginator) CurrentPage() *ListHarvestJobsOutput {
	return p.Pager.CurrentPage().(*ListHarvestJobsOutput)
}

// ListHarvestJobsResponse is the response type for the
// ListHarvestJobs API operation.
type ListHarvestJobsResponse struct {
	*ListHarvestJobsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListHarvestJobs request.
func (r *ListHarvestJobsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
