// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package outposts

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListSitesInput struct {
	_ struct{} `type:"structure"`

	// The maximum page size.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListSitesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSitesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListSitesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListSitesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListSitesOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `min:"1" type:"string"`

	// Information about the sites.
	Sites []Site `type:"list"`
}

// String returns the string representation
func (s ListSitesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListSitesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Sites != nil {
		v := s.Sites

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Sites", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListSites = "ListSites"

// ListSitesRequest returns a request value for making API operation for
// AWS Outposts.
//
// Lists the sites for the specified AWS account.
//
//    // Example sending a request using ListSitesRequest.
//    req := client.ListSitesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListSites
func (c *Client) ListSitesRequest(input *ListSitesInput) ListSitesRequest {
	op := &aws.Operation{
		Name:       opListSites,
		HTTPMethod: "GET",
		HTTPPath:   "/sites",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSitesInput{}
	}

	req := c.newRequest(op, input, &ListSitesOutput{})
	return ListSitesRequest{Request: req, Input: input, Copy: c.ListSitesRequest}
}

// ListSitesRequest is the request type for the
// ListSites API operation.
type ListSitesRequest struct {
	*aws.Request
	Input *ListSitesInput
	Copy  func(*ListSitesInput) ListSitesRequest
}

// Send marshals and sends the ListSites API request.
func (r ListSitesRequest) Send(ctx context.Context) (*ListSitesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListSitesResponse{
		ListSitesOutput: r.Request.Data.(*ListSitesOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListSitesRequestPaginator returns a paginator for ListSites.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListSitesRequest(input)
//   p := outposts.NewListSitesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListSitesPaginator(req ListSitesRequest) ListSitesPaginator {
	return ListSitesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListSitesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListSitesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListSitesPaginator struct {
	aws.Pager
}

func (p *ListSitesPaginator) CurrentPage() *ListSitesOutput {
	return p.Pager.CurrentPage().(*ListSitesOutput)
}

// ListSitesResponse is the response type for the
// ListSites API operation.
type ListSitesResponse struct {
	*ListSitesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListSites request.
func (r *ListSitesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
