// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
)

type PutBucketLifecycleConfigurationInput struct {
	_ struct{} `type:"structure" payload:"LifecycleConfiguration"`

	// The name of the bucket for which to set the configuration.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Container for lifecycle rules. You can add as many as 1,000 rules.
	LifecycleConfiguration *BucketLifecycleConfiguration `locationName:"LifecycleConfiguration" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketLifecycleConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketLifecycleConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketLifecycleConfigurationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}
	if s.LifecycleConfiguration != nil {
		if err := s.LifecycleConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LifecycleConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketLifecycleConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketLifecycleConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.LifecycleConfiguration != nil {
		v := s.LifecycleConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "LifecycleConfiguration", v, metadata)
	}
	return nil
}

type PutBucketLifecycleConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketLifecycleConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketLifecycleConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opPutBucketLifecycleConfiguration = "PutBucketLifecycleConfiguration"

// PutBucketLifecycleConfigurationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Creates a new lifecycle configuration for the bucket or replaces an existing
// lifecycle configuration. For information about lifecycle configuration, see
// Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html).
//
// Bucket lifecycle configuration now supports specifying a lifecycle rule using
// an object key name prefix, one or more object tags, or a combination of both.
// Accordingly, this section describes the latest API. The previous version
// of the API supported filtering based only on an object key name prefix, which
// is supported for backward compatibility. For the related API description,
// see PutBucketLifecycle.
//
// Rules
//
// You specify the lifecycle configuration in your request body. The lifecycle
// configuration is specified as XML consisting of one or more rules. Each rule
// consists of the following:
//
//    * Filter identifying a subset of objects to which the rule applies. The
//    filter can be based on a key name prefix, object tags, or a combination
//    of both.
//
//    * Status whether the rule is in effect.
//
//    * One or more lifecycle transition and expiration actions that you want
//    Amazon S3 to perform on the objects identified by the filter. If the state
//    of your bucket is versioning-enabled or versioning-suspended, you can
//    have many versions of the same object (one current version and zero or
//    more noncurrent versions). Amazon S3 provides predefined actions that
//    you can specify for current and noncurrent object versions.
//
// For more information, see Object Lifecycle Management (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html)
// and Lifecycle Configuration Elements (https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html).
//
// Permissions
//
// By default, all Amazon S3 resources are private, including buckets, objects,
// and related subresources (for example, lifecycle configuration and website
// configuration). Only the resource owner (that is, the AWS account that created
// it) can access the resource. The resource owner can optionally grant access
// permissions to others by writing an access policy. For this operation, a
// user must get the s3:PutLifecycleConfiguration permission.
//
// You can also explicitly deny permissions. Explicit deny also supersedes any
// other permissions. If you want to block users or accounts from removing or
// deleting objects from your bucket, you must deny them permissions for the
// following actions:
//
//    * s3:DeleteObject
//
//    * s3:DeleteObjectVersion
//
//    * s3:PutLifecycleConfiguration
//
// For more information about permissions, see Managing Access Permissions to
// Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html).
//
// The following are related to PutBucketLifecycleConfiguration:
//
//    * Examples of Lifecycle Configuration (https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-configuration-examples.html)
//
//    * GetBucketLifecycleConfiguration
//
//    * DeleteBucketLifecycle
//
//    // Example sending a request using PutBucketLifecycleConfigurationRequest.
//    req := client.PutBucketLifecycleConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycleConfiguration
func (c *Client) PutBucketLifecycleConfigurationRequest(input *PutBucketLifecycleConfigurationInput) PutBucketLifecycleConfigurationRequest {
	op := &aws.Operation{
		Name:       opPutBucketLifecycleConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &PutBucketLifecycleConfigurationInput{}
	}

	req := c.newRequest(op, input, &PutBucketLifecycleConfigurationOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return PutBucketLifecycleConfigurationRequest{Request: req, Input: input, Copy: c.PutBucketLifecycleConfigurationRequest}
}

// PutBucketLifecycleConfigurationRequest is the request type for the
// PutBucketLifecycleConfiguration API operation.
type PutBucketLifecycleConfigurationRequest struct {
	*aws.Request
	Input *PutBucketLifecycleConfigurationInput
	Copy  func(*PutBucketLifecycleConfigurationInput) PutBucketLifecycleConfigurationRequest
}

// Send marshals and sends the PutBucketLifecycleConfiguration API request.
func (r PutBucketLifecycleConfigurationRequest) Send(ctx context.Context) (*PutBucketLifecycleConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutBucketLifecycleConfigurationResponse{
		PutBucketLifecycleConfigurationOutput: r.Request.Data.(*PutBucketLifecycleConfigurationOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutBucketLifecycleConfigurationResponse is the response type for the
// PutBucketLifecycleConfiguration API operation.
type PutBucketLifecycleConfigurationResponse struct {
	*PutBucketLifecycleConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutBucketLifecycleConfiguration request.
func (r *PutBucketLifecycleConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
