// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connect

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateUser = "CreateUser"

// CreateUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUser for more information on using the CreateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserRequest method.
//    req, resp := client.CreateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUser
func (c *Connect) CreateUserRequest(input *CreateUserInput) (req *request.Request, output *CreateUserOutput) {
	op := &request.Operation{
		Name:       opCreateUser,
		HTTPMethod: "PUT",
		HTTPPath:   "/users/{InstanceId}",
	}

	if input == nil {
		input = &CreateUserInput{}
	}

	output = &CreateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUser API operation for Amazon Connect Service.
//
// Creates a user account for the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation CreateUser for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * LimitExceededException
//   The allowed limit for the resource has been exceeded.
//
//   * DuplicateResourceException
//   A resource with the specified name already exists.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUser
func (c *Connect) CreateUser(input *CreateUserInput) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	return out, req.Send()
}

// CreateUserWithContext is the same as CreateUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) CreateUserWithContext(ctx aws.Context, input *CreateUserInput, opts ...request.Option) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserRequest method.
//    req, resp := client.DeleteUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUser
func (c *Connect) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "DELETE",
		HTTPPath:   "/users/{InstanceId}/{UserId}",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUser API operation for Amazon Connect Service.
//
// Deletes a user account from the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DeleteUser for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUser
func (c *Connect) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUser = "DescribeUser"

// DescribeUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUser for more information on using the DescribeUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserRequest method.
//    req, resp := client.DescribeUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUser
func (c *Connect) DescribeUserRequest(input *DescribeUserInput) (req *request.Request, output *DescribeUserOutput) {
	op := &request.Operation{
		Name:       opDescribeUser,
		HTTPMethod: "GET",
		HTTPPath:   "/users/{InstanceId}/{UserId}",
	}

	if input == nil {
		input = &DescribeUserInput{}
	}

	output = &DescribeUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUser API operation for Amazon Connect Service.
//
// Describes the specified user account. You can find the instance ID in the
// console (it’s the final part of the ARN). The console does not display
// the user IDs. Instead, list the users and note the IDs provided in the output.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeUser for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUser
func (c *Connect) DescribeUser(input *DescribeUserInput) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	return out, req.Send()
}

// DescribeUserWithContext is the same as DescribeUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeUserWithContext(ctx aws.Context, input *DescribeUserInput, opts ...request.Option) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUserHierarchyGroup = "DescribeUserHierarchyGroup"

// DescribeUserHierarchyGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserHierarchyGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUserHierarchyGroup for more information on using the DescribeUserHierarchyGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserHierarchyGroupRequest method.
//    req, resp := client.DescribeUserHierarchyGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyGroup
func (c *Connect) DescribeUserHierarchyGroupRequest(input *DescribeUserHierarchyGroupInput) (req *request.Request, output *DescribeUserHierarchyGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeUserHierarchyGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/user-hierarchy-groups/{InstanceId}/{HierarchyGroupId}",
	}

	if input == nil {
		input = &DescribeUserHierarchyGroupInput{}
	}

	output = &DescribeUserHierarchyGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUserHierarchyGroup API operation for Amazon Connect Service.
//
// Describes the specified hierarchy group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeUserHierarchyGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyGroup
func (c *Connect) DescribeUserHierarchyGroup(input *DescribeUserHierarchyGroupInput) (*DescribeUserHierarchyGroupOutput, error) {
	req, out := c.DescribeUserHierarchyGroupRequest(input)
	return out, req.Send()
}

// DescribeUserHierarchyGroupWithContext is the same as DescribeUserHierarchyGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUserHierarchyGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeUserHierarchyGroupWithContext(ctx aws.Context, input *DescribeUserHierarchyGroupInput, opts ...request.Option) (*DescribeUserHierarchyGroupOutput, error) {
	req, out := c.DescribeUserHierarchyGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUserHierarchyStructure = "DescribeUserHierarchyStructure"

// DescribeUserHierarchyStructureRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserHierarchyStructure operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUserHierarchyStructure for more information on using the DescribeUserHierarchyStructure
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserHierarchyStructureRequest method.
//    req, resp := client.DescribeUserHierarchyStructureRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyStructure
func (c *Connect) DescribeUserHierarchyStructureRequest(input *DescribeUserHierarchyStructureInput) (req *request.Request, output *DescribeUserHierarchyStructureOutput) {
	op := &request.Operation{
		Name:       opDescribeUserHierarchyStructure,
		HTTPMethod: "GET",
		HTTPPath:   "/user-hierarchy-structure/{InstanceId}",
	}

	if input == nil {
		input = &DescribeUserHierarchyStructureInput{}
	}

	output = &DescribeUserHierarchyStructureOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUserHierarchyStructure API operation for Amazon Connect Service.
//
// Describes the hierarchy structure of the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeUserHierarchyStructure for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyStructure
func (c *Connect) DescribeUserHierarchyStructure(input *DescribeUserHierarchyStructureInput) (*DescribeUserHierarchyStructureOutput, error) {
	req, out := c.DescribeUserHierarchyStructureRequest(input)
	return out, req.Send()
}

// DescribeUserHierarchyStructureWithContext is the same as DescribeUserHierarchyStructure with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUserHierarchyStructure for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeUserHierarchyStructureWithContext(ctx aws.Context, input *DescribeUserHierarchyStructureInput, opts ...request.Option) (*DescribeUserHierarchyStructureOutput, error) {
	req, out := c.DescribeUserHierarchyStructureRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContactAttributes = "GetContactAttributes"

// GetContactAttributesRequest generates a "aws/request.Request" representing the
// client's request for the GetContactAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContactAttributes for more information on using the GetContactAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetContactAttributesRequest method.
//    req, resp := client.GetContactAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetContactAttributes
func (c *Connect) GetContactAttributesRequest(input *GetContactAttributesInput) (req *request.Request, output *GetContactAttributesOutput) {
	op := &request.Operation{
		Name:       opGetContactAttributes,
		HTTPMethod: "GET",
		HTTPPath:   "/contact/attributes/{InstanceId}/{InitialContactId}",
	}

	if input == nil {
		input = &GetContactAttributesInput{}
	}

	output = &GetContactAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContactAttributes API operation for Amazon Connect Service.
//
// Retrieves the contact attributes for the specified contact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation GetContactAttributes for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetContactAttributes
func (c *Connect) GetContactAttributes(input *GetContactAttributesInput) (*GetContactAttributesOutput, error) {
	req, out := c.GetContactAttributesRequest(input)
	return out, req.Send()
}

// GetContactAttributesWithContext is the same as GetContactAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See GetContactAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetContactAttributesWithContext(ctx aws.Context, input *GetContactAttributesInput, opts ...request.Option) (*GetContactAttributesOutput, error) {
	req, out := c.GetContactAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCurrentMetricData = "GetCurrentMetricData"

// GetCurrentMetricDataRequest generates a "aws/request.Request" representing the
// client's request for the GetCurrentMetricData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCurrentMetricData for more information on using the GetCurrentMetricData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCurrentMetricDataRequest method.
//    req, resp := client.GetCurrentMetricDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentMetricData
func (c *Connect) GetCurrentMetricDataRequest(input *GetCurrentMetricDataInput) (req *request.Request, output *GetCurrentMetricDataOutput) {
	op := &request.Operation{
		Name:       opGetCurrentMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/metrics/current/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetCurrentMetricDataInput{}
	}

	output = &GetCurrentMetricDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCurrentMetricData API operation for Amazon Connect Service.
//
// Gets the real-time metric data from the specified Amazon Connect instance.
//
// For more information, see Real-time Metrics Reports (https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-reports.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation GetCurrentMetricData for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentMetricData
func (c *Connect) GetCurrentMetricData(input *GetCurrentMetricDataInput) (*GetCurrentMetricDataOutput, error) {
	req, out := c.GetCurrentMetricDataRequest(input)
	return out, req.Send()
}

// GetCurrentMetricDataWithContext is the same as GetCurrentMetricData with the addition of
// the ability to pass a context and additional request options.
//
// See GetCurrentMetricData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetCurrentMetricDataWithContext(ctx aws.Context, input *GetCurrentMetricDataInput, opts ...request.Option) (*GetCurrentMetricDataOutput, error) {
	req, out := c.GetCurrentMetricDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetCurrentMetricDataPages iterates over the pages of a GetCurrentMetricData operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetCurrentMetricData method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetCurrentMetricData operation.
//    pageNum := 0
//    err := client.GetCurrentMetricDataPages(params,
//        func(page *connect.GetCurrentMetricDataOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Connect) GetCurrentMetricDataPages(input *GetCurrentMetricDataInput, fn func(*GetCurrentMetricDataOutput, bool) bool) error {
	return c.GetCurrentMetricDataPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetCurrentMetricDataPagesWithContext same as GetCurrentMetricDataPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetCurrentMetricDataPagesWithContext(ctx aws.Context, input *GetCurrentMetricDataInput, fn func(*GetCurrentMetricDataOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetCurrentMetricDataInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetCurrentMetricDataRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetCurrentMetricDataOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetFederationToken = "GetFederationToken"

// GetFederationTokenRequest generates a "aws/request.Request" representing the
// client's request for the GetFederationToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFederationToken for more information on using the GetFederationToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFederationTokenRequest method.
//    req, resp := client.GetFederationTokenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetFederationToken
func (c *Connect) GetFederationTokenRequest(input *GetFederationTokenInput) (req *request.Request, output *GetFederationTokenOutput) {
	op := &request.Operation{
		Name:       opGetFederationToken,
		HTTPMethod: "GET",
		HTTPPath:   "/user/federate/{InstanceId}",
	}

	if input == nil {
		input = &GetFederationTokenInput{}
	}

	output = &GetFederationTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFederationToken API operation for Amazon Connect Service.
//
// Retrieves a token for federation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation GetFederationToken for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * UserNotFoundException
//   No user with the specified credentials was found in the Amazon Connect instance.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
//   * DuplicateResourceException
//   A resource with the specified name already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetFederationToken
func (c *Connect) GetFederationToken(input *GetFederationTokenInput) (*GetFederationTokenOutput, error) {
	req, out := c.GetFederationTokenRequest(input)
	return out, req.Send()
}

// GetFederationTokenWithContext is the same as GetFederationToken with the addition of
// the ability to pass a context and additional request options.
//
// See GetFederationToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetFederationTokenWithContext(ctx aws.Context, input *GetFederationTokenInput, opts ...request.Option) (*GetFederationTokenOutput, error) {
	req, out := c.GetFederationTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMetricData = "GetMetricData"

// GetMetricDataRequest generates a "aws/request.Request" representing the
// client's request for the GetMetricData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMetricData for more information on using the GetMetricData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMetricDataRequest method.
//    req, resp := client.GetMetricDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricData
func (c *Connect) GetMetricDataRequest(input *GetMetricDataInput) (req *request.Request, output *GetMetricDataOutput) {
	op := &request.Operation{
		Name:       opGetMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/metrics/historical/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetMetricDataInput{}
	}

	output = &GetMetricDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMetricData API operation for Amazon Connect Service.
//
// Gets historical metric data from the specified Amazon Connect instance.
//
// For more information, see Historical Metrics Reports (https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation GetMetricData for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricData
func (c *Connect) GetMetricData(input *GetMetricDataInput) (*GetMetricDataOutput, error) {
	req, out := c.GetMetricDataRequest(input)
	return out, req.Send()
}

// GetMetricDataWithContext is the same as GetMetricData with the addition of
// the ability to pass a context and additional request options.
//
// See GetMetricData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetMetricDataWithContext(ctx aws.Context, input *GetMetricDataInput, opts ...request.Option) (*GetMetricDataOutput, error) {
	req, out := c.GetMetricDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetMetricDataPages iterates over the pages of a GetMetricData operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetMetricData method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetMetricData operation.
//    pageNum := 0
//    err := client.GetMetricDataPages(params,
//        func(page *connect.GetMetricDataOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Connect) GetMetricDataPages(input *GetMetricDataInput, fn func(*GetMetricDataOutput, bool) bool) error {
	return c.GetMetricDataPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetMetricDataPagesWithContext same as GetMetricDataPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetMetricDataPagesWithContext(ctx aws.Context, input *GetMetricDataInput, fn func(*GetMetricDataOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetMetricDataInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetMetricDataRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetMetricDataOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListContactFlows = "ListContactFlows"

// ListContactFlowsRequest generates a "aws/request.Request" representing the
// client's request for the ListContactFlows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListContactFlows for more information on using the ListContactFlows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListContactFlowsRequest method.
//    req, resp := client.ListContactFlowsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactFlows
func (c *Connect) ListContactFlowsRequest(input *ListContactFlowsInput) (req *request.Request, output *ListContactFlowsOutput) {
	op := &request.Operation{
		Name:       opListContactFlows,
		HTTPMethod: "GET",
		HTTPPath:   "/contact-flows-summary/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListContactFlowsInput{}
	}

	output = &ListContactFlowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListContactFlows API operation for Amazon Connect Service.
//
// Provides information about the contact flows for the specified Amazon Connect
// instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListContactFlows for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactFlows
func (c *Connect) ListContactFlows(input *ListContactFlowsInput) (*ListContactFlowsOutput, error) {
	req, out := c.ListContactFlowsRequest(input)
	return out, req.Send()
}

// ListContactFlowsWithContext is the same as ListContactFlows with the addition of
// the ability to pass a context and additional request options.
//
// See ListContactFlows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListContactFlowsWithContext(ctx aws.Context, input *ListContactFlowsInput, opts ...request.Option) (*ListContactFlowsOutput, error) {
	req, out := c.ListContactFlowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListContactFlowsPages iterates over the pages of a ListContactFlows operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListContactFlows method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListContactFlows operation.
//    pageNum := 0
//    err := client.ListContactFlowsPages(params,
//        func(page *connect.ListContactFlowsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Connect) ListContactFlowsPages(input *ListContactFlowsInput, fn func(*ListContactFlowsOutput, bool) bool) error {
	return c.ListContactFlowsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListContactFlowsPagesWithContext same as ListContactFlowsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListContactFlowsPagesWithContext(ctx aws.Context, input *ListContactFlowsInput, fn func(*ListContactFlowsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListContactFlowsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListContactFlowsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListContactFlowsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListHoursOfOperations = "ListHoursOfOperations"

// ListHoursOfOperationsRequest generates a "aws/request.Request" representing the
// client's request for the ListHoursOfOperations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListHoursOfOperations for more information on using the ListHoursOfOperations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListHoursOfOperationsRequest method.
//    req, resp := client.ListHoursOfOperationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListHoursOfOperations
func (c *Connect) ListHoursOfOperationsRequest(input *ListHoursOfOperationsInput) (req *request.Request, output *ListHoursOfOperationsOutput) {
	op := &request.Operation{
		Name:       opListHoursOfOperations,
		HTTPMethod: "GET",
		HTTPPath:   "/hours-of-operations-summary/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListHoursOfOperationsInput{}
	}

	output = &ListHoursOfOperationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHoursOfOperations API operation for Amazon Connect Service.
//
// Provides information about the hours of operation for the specified Amazon
// Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListHoursOfOperations for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListHoursOfOperations
func (c *Connect) ListHoursOfOperations(input *ListHoursOfOperationsInput) (*ListHoursOfOperationsOutput, error) {
	req, out := c.ListHoursOfOperationsRequest(input)
	return out, req.Send()
}

// ListHoursOfOperationsWithContext is the same as ListHoursOfOperations with the addition of
// the ability to pass a context and additional request options.
//
// See ListHoursOfOperations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListHoursOfOperationsWithContext(ctx aws.Context, input *ListHoursOfOperationsInput, opts ...request.Option) (*ListHoursOfOperationsOutput, error) {
	req, out := c.ListHoursOfOperationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListHoursOfOperationsPages iterates over the pages of a ListHoursOfOperations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListHoursOfOperations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListHoursOfOperations operation.
//    pageNum := 0
//    err := client.ListHoursOfOperationsPages(params,
//        func(page *connect.ListHoursOfOperationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Connect) ListHoursOfOperationsPages(input *ListHoursOfOperationsInput, fn func(*ListHoursOfOperationsOutput, bool) bool) error {
	return c.ListHoursOfOperationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListHoursOfOperationsPagesWithContext same as ListHoursOfOperationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListHoursOfOperationsPagesWithContext(ctx aws.Context, input *ListHoursOfOperationsInput, fn func(*ListHoursOfOperationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListHoursOfOperationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListHoursOfOperationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListHoursOfOperationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPhoneNumbers = "ListPhoneNumbers"

// ListPhoneNumbersRequest generates a "aws/request.Request" representing the
// client's request for the ListPhoneNumbers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPhoneNumbers for more information on using the ListPhoneNumbers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPhoneNumbersRequest method.
//    req, resp := client.ListPhoneNumbersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbers
func (c *Connect) ListPhoneNumbersRequest(input *ListPhoneNumbersInput) (req *request.Request, output *ListPhoneNumbersOutput) {
	op := &request.Operation{
		Name:       opListPhoneNumbers,
		HTTPMethod: "GET",
		HTTPPath:   "/phone-numbers-summary/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPhoneNumbersInput{}
	}

	output = &ListPhoneNumbersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPhoneNumbers API operation for Amazon Connect Service.
//
// Provides information about the phone numbers for the specified Amazon Connect
// instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListPhoneNumbers for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbers
func (c *Connect) ListPhoneNumbers(input *ListPhoneNumbersInput) (*ListPhoneNumbersOutput, error) {
	req, out := c.ListPhoneNumbersRequest(input)
	return out, req.Send()
}

// ListPhoneNumbersWithContext is the same as ListPhoneNumbers with the addition of
// the ability to pass a context and additional request options.
//
// See ListPhoneNumbers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListPhoneNumbersWithContext(ctx aws.Context, input *ListPhoneNumbersInput, opts ...request.Option) (*ListPhoneNumbersOutput, error) {
	req, out := c.ListPhoneNumbersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPhoneNumbersPages iterates over the pages of a ListPhoneNumbers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPhoneNumbers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPhoneNumbers operation.
//    pageNum := 0
//    err := client.ListPhoneNumbersPages(params,
//        func(page *connect.ListPhoneNumbersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Connect) ListPhoneNumbersPages(input *ListPhoneNumbersInput, fn func(*ListPhoneNumbersOutput, bool) bool) error {
	return c.ListPhoneNumbersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPhoneNumbersPagesWithContext same as ListPhoneNumbersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListPhoneNumbersPagesWithContext(ctx aws.Context, input *ListPhoneNumbersInput, fn func(*ListPhoneNumbersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPhoneNumbersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPhoneNumbersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPhoneNumbersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListQueues = "ListQueues"

// ListQueuesRequest generates a "aws/request.Request" representing the
// client's request for the ListQueues operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListQueues for more information on using the ListQueues
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListQueuesRequest method.
//    req, resp := client.ListQueuesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueues
func (c *Connect) ListQueuesRequest(input *ListQueuesInput) (req *request.Request, output *ListQueuesOutput) {
	op := &request.Operation{
		Name:       opListQueues,
		HTTPMethod: "GET",
		HTTPPath:   "/queues-summary/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListQueuesInput{}
	}

	output = &ListQueuesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListQueues API operation for Amazon Connect Service.
//
// Provides information about the queues for the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListQueues for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueues
func (c *Connect) ListQueues(input *ListQueuesInput) (*ListQueuesOutput, error) {
	req, out := c.ListQueuesRequest(input)
	return out, req.Send()
}

// ListQueuesWithContext is the same as ListQueues with the addition of
// the ability to pass a context and additional request options.
//
// See ListQueues for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListQueuesWithContext(ctx aws.Context, input *ListQueuesInput, opts ...request.Option) (*ListQueuesOutput, error) {
	req, out := c.ListQueuesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListQueuesPages iterates over the pages of a ListQueues operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListQueues method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListQueues operation.
//    pageNum := 0
//    err := client.ListQueuesPages(params,
//        func(page *connect.ListQueuesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Connect) ListQueuesPages(input *ListQueuesInput, fn func(*ListQueuesOutput, bool) bool) error {
	return c.ListQueuesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListQueuesPagesWithContext same as ListQueuesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListQueuesPagesWithContext(ctx aws.Context, input *ListQueuesInput, fn func(*ListQueuesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListQueuesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListQueuesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListQueuesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRoutingProfiles = "ListRoutingProfiles"

// ListRoutingProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListRoutingProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRoutingProfiles for more information on using the ListRoutingProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRoutingProfilesRequest method.
//    req, resp := client.ListRoutingProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListRoutingProfiles
func (c *Connect) ListRoutingProfilesRequest(input *ListRoutingProfilesInput) (req *request.Request, output *ListRoutingProfilesOutput) {
	op := &request.Operation{
		Name:       opListRoutingProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/routing-profiles-summary/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRoutingProfilesInput{}
	}

	output = &ListRoutingProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRoutingProfiles API operation for Amazon Connect Service.
//
// Provides summary information about the routing profiles for the specified
// Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListRoutingProfiles for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListRoutingProfiles
func (c *Connect) ListRoutingProfiles(input *ListRoutingProfilesInput) (*ListRoutingProfilesOutput, error) {
	req, out := c.ListRoutingProfilesRequest(input)
	return out, req.Send()
}

// ListRoutingProfilesWithContext is the same as ListRoutingProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListRoutingProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListRoutingProfilesWithContext(ctx aws.Context, input *ListRoutingProfilesInput, opts ...request.Option) (*ListRoutingProfilesOutput, error) {
	req, out := c.ListRoutingProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRoutingProfilesPages iterates over the pages of a ListRoutingProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRoutingProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRoutingProfiles operation.
//    pageNum := 0
//    err := client.ListRoutingProfilesPages(params,
//        func(page *connect.ListRoutingProfilesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Connect) ListRoutingProfilesPages(input *ListRoutingProfilesInput, fn func(*ListRoutingProfilesOutput, bool) bool) error {
	return c.ListRoutingProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRoutingProfilesPagesWithContext same as ListRoutingProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListRoutingProfilesPagesWithContext(ctx aws.Context, input *ListRoutingProfilesInput, fn func(*ListRoutingProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRoutingProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRoutingProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRoutingProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSecurityProfiles = "ListSecurityProfiles"

// ListSecurityProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListSecurityProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSecurityProfiles for more information on using the ListSecurityProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSecurityProfilesRequest method.
//    req, resp := client.ListSecurityProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityProfiles
func (c *Connect) ListSecurityProfilesRequest(input *ListSecurityProfilesInput) (req *request.Request, output *ListSecurityProfilesOutput) {
	op := &request.Operation{
		Name:       opListSecurityProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/security-profiles-summary/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSecurityProfilesInput{}
	}

	output = &ListSecurityProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSecurityProfiles API operation for Amazon Connect Service.
//
// Provides summary information about the security profiles for the specified
// Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListSecurityProfiles for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityProfiles
func (c *Connect) ListSecurityProfiles(input *ListSecurityProfilesInput) (*ListSecurityProfilesOutput, error) {
	req, out := c.ListSecurityProfilesRequest(input)
	return out, req.Send()
}

// ListSecurityProfilesWithContext is the same as ListSecurityProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListSecurityProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListSecurityProfilesWithContext(ctx aws.Context, input *ListSecurityProfilesInput, opts ...request.Option) (*ListSecurityProfilesOutput, error) {
	req, out := c.ListSecurityProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSecurityProfilesPages iterates over the pages of a ListSecurityProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSecurityProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSecurityProfiles operation.
//    pageNum := 0
//    err := client.ListSecurityProfilesPages(params,
//        func(page *connect.ListSecurityProfilesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Connect) ListSecurityProfilesPages(input *ListSecurityProfilesInput, fn func(*ListSecurityProfilesOutput, bool) bool) error {
	return c.ListSecurityProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSecurityProfilesPagesWithContext same as ListSecurityProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListSecurityProfilesPagesWithContext(ctx aws.Context, input *ListSecurityProfilesInput, fn func(*ListSecurityProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSecurityProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSecurityProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSecurityProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListTagsForResource
func (c *Connect) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Connect Service.
//
// Lists the tags for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListTagsForResource
func (c *Connect) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUserHierarchyGroups = "ListUserHierarchyGroups"

// ListUserHierarchyGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListUserHierarchyGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUserHierarchyGroups for more information on using the ListUserHierarchyGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUserHierarchyGroupsRequest method.
//    req, resp := client.ListUserHierarchyGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUserHierarchyGroups
func (c *Connect) ListUserHierarchyGroupsRequest(input *ListUserHierarchyGroupsInput) (req *request.Request, output *ListUserHierarchyGroupsOutput) {
	op := &request.Operation{
		Name:       opListUserHierarchyGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/user-hierarchy-groups-summary/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUserHierarchyGroupsInput{}
	}

	output = &ListUserHierarchyGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUserHierarchyGroups API operation for Amazon Connect Service.
//
// Provides summary information about the hierarchy groups for the specified
// Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListUserHierarchyGroups for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUserHierarchyGroups
func (c *Connect) ListUserHierarchyGroups(input *ListUserHierarchyGroupsInput) (*ListUserHierarchyGroupsOutput, error) {
	req, out := c.ListUserHierarchyGroupsRequest(input)
	return out, req.Send()
}

// ListUserHierarchyGroupsWithContext is the same as ListUserHierarchyGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListUserHierarchyGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListUserHierarchyGroupsWithContext(ctx aws.Context, input *ListUserHierarchyGroupsInput, opts ...request.Option) (*ListUserHierarchyGroupsOutput, error) {
	req, out := c.ListUserHierarchyGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUserHierarchyGroupsPages iterates over the pages of a ListUserHierarchyGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUserHierarchyGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListUserHierarchyGroups operation.
//    pageNum := 0
//    err := client.ListUserHierarchyGroupsPages(params,
//        func(page *connect.ListUserHierarchyGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Connect) ListUserHierarchyGroupsPages(input *ListUserHierarchyGroupsInput, fn func(*ListUserHierarchyGroupsOutput, bool) bool) error {
	return c.ListUserHierarchyGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUserHierarchyGroupsPagesWithContext same as ListUserHierarchyGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListUserHierarchyGroupsPagesWithContext(ctx aws.Context, input *ListUserHierarchyGroupsInput, fn func(*ListUserHierarchyGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUserHierarchyGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUserHierarchyGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUserHierarchyGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsers for more information on using the ListUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUsersRequest method.
//    req, resp := client.ListUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUsers
func (c *Connect) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "GET",
		HTTPPath:   "/users-summary/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	output = &ListUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsers API operation for Amazon Connect Service.
//
// Provides summary information about the users for the specified Amazon Connect
// instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListUsers for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUsers
func (c *Connect) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	return out, req.Send()
}

// ListUsersWithContext is the same as ListUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListUsersWithContext(ctx aws.Context, input *ListUsersInput, opts ...request.Option) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUsersPages iterates over the pages of a ListUsers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUsers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListUsers operation.
//    pageNum := 0
//    err := client.ListUsersPages(params,
//        func(page *connect.ListUsersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Connect) ListUsersPages(input *ListUsersInput, fn func(*ListUsersOutput, bool) bool) error {
	return c.ListUsersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUsersPagesWithContext same as ListUsersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListUsersPagesWithContext(ctx aws.Context, input *ListUsersInput, fn func(*ListUsersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUsersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUsersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUsersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartChatContact = "StartChatContact"

// StartChatContactRequest generates a "aws/request.Request" representing the
// client's request for the StartChatContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartChatContact for more information on using the StartChatContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartChatContactRequest method.
//    req, resp := client.StartChatContactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartChatContact
func (c *Connect) StartChatContactRequest(input *StartChatContactInput) (req *request.Request, output *StartChatContactOutput) {
	op := &request.Operation{
		Name:       opStartChatContact,
		HTTPMethod: "PUT",
		HTTPPath:   "/contact/chat",
	}

	if input == nil {
		input = &StartChatContactInput{}
	}

	output = &StartChatContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartChatContact API operation for Amazon Connect Service.
//
// Initiates a contact flow to start a new chat for the customer. Response of
// this API provides a token required to obtain credentials from the CreateParticipantConnection
// (https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html)
// API in the Amazon Connect Participant Service.
//
// When a new chat contact is successfully created, clients need to subscribe
// to the participant’s connection for the created chat within 5 minutes.
// This is achieved by invoking CreateParticipantConnection (https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html)
// with WEBSOCKET and CONNECTION_CREDENTIALS.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation StartChatContact for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
//   * LimitExceededException
//   The allowed limit for the resource has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartChatContact
func (c *Connect) StartChatContact(input *StartChatContactInput) (*StartChatContactOutput, error) {
	req, out := c.StartChatContactRequest(input)
	return out, req.Send()
}

// StartChatContactWithContext is the same as StartChatContact with the addition of
// the ability to pass a context and additional request options.
//
// See StartChatContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) StartChatContactWithContext(ctx aws.Context, input *StartChatContactInput, opts ...request.Option) (*StartChatContactOutput, error) {
	req, out := c.StartChatContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartOutboundVoiceContact = "StartOutboundVoiceContact"

// StartOutboundVoiceContactRequest generates a "aws/request.Request" representing the
// client's request for the StartOutboundVoiceContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartOutboundVoiceContact for more information on using the StartOutboundVoiceContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartOutboundVoiceContactRequest method.
//    req, resp := client.StartOutboundVoiceContactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartOutboundVoiceContact
func (c *Connect) StartOutboundVoiceContactRequest(input *StartOutboundVoiceContactInput) (req *request.Request, output *StartOutboundVoiceContactOutput) {
	op := &request.Operation{
		Name:       opStartOutboundVoiceContact,
		HTTPMethod: "PUT",
		HTTPPath:   "/contact/outbound-voice",
	}

	if input == nil {
		input = &StartOutboundVoiceContactInput{}
	}

	output = &StartOutboundVoiceContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartOutboundVoiceContact API operation for Amazon Connect Service.
//
// Initiates a contact flow to place an outbound call to a customer.
//
// There is a 60 second dialing timeout for this operation. If the call is not
// connected after 60 seconds, it fails.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation StartOutboundVoiceContact for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
//   * LimitExceededException
//   The allowed limit for the resource has been exceeded.
//
//   * DestinationNotAllowedException
//   Outbound calls to the destination number are not allowed.
//
//   * OutboundContactNotPermittedException
//   The contact is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartOutboundVoiceContact
func (c *Connect) StartOutboundVoiceContact(input *StartOutboundVoiceContactInput) (*StartOutboundVoiceContactOutput, error) {
	req, out := c.StartOutboundVoiceContactRequest(input)
	return out, req.Send()
}

// StartOutboundVoiceContactWithContext is the same as StartOutboundVoiceContact with the addition of
// the ability to pass a context and additional request options.
//
// See StartOutboundVoiceContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) StartOutboundVoiceContactWithContext(ctx aws.Context, input *StartOutboundVoiceContactInput, opts ...request.Option) (*StartOutboundVoiceContactOutput, error) {
	req, out := c.StartOutboundVoiceContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopContact = "StopContact"

// StopContactRequest generates a "aws/request.Request" representing the
// client's request for the StopContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopContact for more information on using the StopContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopContactRequest method.
//    req, resp := client.StopContactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StopContact
func (c *Connect) StopContactRequest(input *StopContactInput) (req *request.Request, output *StopContactOutput) {
	op := &request.Operation{
		Name:       opStopContact,
		HTTPMethod: "POST",
		HTTPPath:   "/contact/stop",
	}

	if input == nil {
		input = &StopContactInput{}
	}

	output = &StopContactOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopContact API operation for Amazon Connect Service.
//
// Ends the specified contact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation StopContact for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ContactNotFoundException
//   The contact with the specified ID is not active or does not exist.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StopContact
func (c *Connect) StopContact(input *StopContactInput) (*StopContactOutput, error) {
	req, out := c.StopContactRequest(input)
	return out, req.Send()
}

// StopContactWithContext is the same as StopContact with the addition of
// the ability to pass a context and additional request options.
//
// See StopContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) StopContactWithContext(ctx aws.Context, input *StopContactInput, opts ...request.Option) (*StopContactOutput, error) {
	req, out := c.StopContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/TagResource
func (c *Connect) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Connect Service.
//
// Adds the specified tags to the specified resource.
//
// The supported resource type is users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/TagResource
func (c *Connect) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UntagResource
func (c *Connect) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Connect Service.
//
// Removes the specified tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UntagResource
func (c *Connect) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContactAttributes = "UpdateContactAttributes"

// UpdateContactAttributesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContactAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContactAttributes for more information on using the UpdateContactAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateContactAttributesRequest method.
//    req, resp := client.UpdateContactAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactAttributes
func (c *Connect) UpdateContactAttributesRequest(input *UpdateContactAttributesInput) (req *request.Request, output *UpdateContactAttributesOutput) {
	op := &request.Operation{
		Name:       opUpdateContactAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/contact/attributes",
	}

	if input == nil {
		input = &UpdateContactAttributesInput{}
	}

	output = &UpdateContactAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateContactAttributes API operation for Amazon Connect Service.
//
// Creates or updates the contact attributes associated with the specified contact.
//
// You can add or update attributes for both ongoing and completed contacts.
// For example, you can update the customer's name or the reason the customer
// called while the call is active, or add notes about steps that the agent
// took during the call that are displayed to the next agent that takes the
// call. You can also update attributes for a contact using data from your CRM
// application and save the data with the contact in Amazon Connect. You could
// also flag calls for additional analysis, such as legal review or identifying
// abusive callers.
//
// Contact attributes are available in Amazon Connect for 24 months, and are
// then deleted.
//
// Important: You cannot use the operation to update attributes for contacts
// that occurred prior to the release of the API, September 12, 2018. You can
// update attributes only for contacts that started after the release of the
// API. If you attempt to update attributes for a contact that occurred prior
// to the release of the API, a 400 error is returned. This applies also to
// queued callbacks that were initiated prior to the release of the API but
// are still active in your instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateContactAttributes for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactAttributes
func (c *Connect) UpdateContactAttributes(input *UpdateContactAttributesInput) (*UpdateContactAttributesOutput, error) {
	req, out := c.UpdateContactAttributesRequest(input)
	return out, req.Send()
}

// UpdateContactAttributesWithContext is the same as UpdateContactAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContactAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateContactAttributesWithContext(ctx aws.Context, input *UpdateContactAttributesInput, opts ...request.Option) (*UpdateContactAttributesOutput, error) {
	req, out := c.UpdateContactAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserHierarchy = "UpdateUserHierarchy"

// UpdateUserHierarchyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserHierarchy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserHierarchy for more information on using the UpdateUserHierarchy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserHierarchyRequest method.
//    req, resp := client.UpdateUserHierarchyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserHierarchy
func (c *Connect) UpdateUserHierarchyRequest(input *UpdateUserHierarchyInput) (req *request.Request, output *UpdateUserHierarchyOutput) {
	op := &request.Operation{
		Name:       opUpdateUserHierarchy,
		HTTPMethod: "POST",
		HTTPPath:   "/users/{InstanceId}/{UserId}/hierarchy",
	}

	if input == nil {
		input = &UpdateUserHierarchyInput{}
	}

	output = &UpdateUserHierarchyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUserHierarchy API operation for Amazon Connect Service.
//
// Assigns the specified hierarchy group to the specified user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateUserHierarchy for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserHierarchy
func (c *Connect) UpdateUserHierarchy(input *UpdateUserHierarchyInput) (*UpdateUserHierarchyOutput, error) {
	req, out := c.UpdateUserHierarchyRequest(input)
	return out, req.Send()
}

// UpdateUserHierarchyWithContext is the same as UpdateUserHierarchy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserHierarchy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateUserHierarchyWithContext(ctx aws.Context, input *UpdateUserHierarchyInput, opts ...request.Option) (*UpdateUserHierarchyOutput, error) {
	req, out := c.UpdateUserHierarchyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserIdentityInfo = "UpdateUserIdentityInfo"

// UpdateUserIdentityInfoRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserIdentityInfo operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserIdentityInfo for more information on using the UpdateUserIdentityInfo
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserIdentityInfoRequest method.
//    req, resp := client.UpdateUserIdentityInfoRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserIdentityInfo
func (c *Connect) UpdateUserIdentityInfoRequest(input *UpdateUserIdentityInfoInput) (req *request.Request, output *UpdateUserIdentityInfoOutput) {
	op := &request.Operation{
		Name:       opUpdateUserIdentityInfo,
		HTTPMethod: "POST",
		HTTPPath:   "/users/{InstanceId}/{UserId}/identity-info",
	}

	if input == nil {
		input = &UpdateUserIdentityInfoInput{}
	}

	output = &UpdateUserIdentityInfoOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUserIdentityInfo API operation for Amazon Connect Service.
//
// Updates the identity information for the specified user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateUserIdentityInfo for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserIdentityInfo
func (c *Connect) UpdateUserIdentityInfo(input *UpdateUserIdentityInfoInput) (*UpdateUserIdentityInfoOutput, error) {
	req, out := c.UpdateUserIdentityInfoRequest(input)
	return out, req.Send()
}

// UpdateUserIdentityInfoWithContext is the same as UpdateUserIdentityInfo with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserIdentityInfo for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateUserIdentityInfoWithContext(ctx aws.Context, input *UpdateUserIdentityInfoInput, opts ...request.Option) (*UpdateUserIdentityInfoOutput, error) {
	req, out := c.UpdateUserIdentityInfoRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserPhoneConfig = "UpdateUserPhoneConfig"

// UpdateUserPhoneConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserPhoneConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserPhoneConfig for more information on using the UpdateUserPhoneConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserPhoneConfigRequest method.
//    req, resp := client.UpdateUserPhoneConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserPhoneConfig
func (c *Connect) UpdateUserPhoneConfigRequest(input *UpdateUserPhoneConfigInput) (req *request.Request, output *UpdateUserPhoneConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateUserPhoneConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/users/{InstanceId}/{UserId}/phone-config",
	}

	if input == nil {
		input = &UpdateUserPhoneConfigInput{}
	}

	output = &UpdateUserPhoneConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUserPhoneConfig API operation for Amazon Connect Service.
//
// Updates the phone configuration settings for the specified user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateUserPhoneConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserPhoneConfig
func (c *Connect) UpdateUserPhoneConfig(input *UpdateUserPhoneConfigInput) (*UpdateUserPhoneConfigOutput, error) {
	req, out := c.UpdateUserPhoneConfigRequest(input)
	return out, req.Send()
}

// UpdateUserPhoneConfigWithContext is the same as UpdateUserPhoneConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserPhoneConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateUserPhoneConfigWithContext(ctx aws.Context, input *UpdateUserPhoneConfigInput, opts ...request.Option) (*UpdateUserPhoneConfigOutput, error) {
	req, out := c.UpdateUserPhoneConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserRoutingProfile = "UpdateUserRoutingProfile"

// UpdateUserRoutingProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserRoutingProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserRoutingProfile for more information on using the UpdateUserRoutingProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserRoutingProfileRequest method.
//    req, resp := client.UpdateUserRoutingProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserRoutingProfile
func (c *Connect) UpdateUserRoutingProfileRequest(input *UpdateUserRoutingProfileInput) (req *request.Request, output *UpdateUserRoutingProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateUserRoutingProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/users/{InstanceId}/{UserId}/routing-profile",
	}

	if input == nil {
		input = &UpdateUserRoutingProfileInput{}
	}

	output = &UpdateUserRoutingProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUserRoutingProfile API operation for Amazon Connect Service.
//
// Assigns the specified routing profile to the specified user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateUserRoutingProfile for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserRoutingProfile
func (c *Connect) UpdateUserRoutingProfile(input *UpdateUserRoutingProfileInput) (*UpdateUserRoutingProfileOutput, error) {
	req, out := c.UpdateUserRoutingProfileRequest(input)
	return out, req.Send()
}

// UpdateUserRoutingProfileWithContext is the same as UpdateUserRoutingProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserRoutingProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateUserRoutingProfileWithContext(ctx aws.Context, input *UpdateUserRoutingProfileInput, opts ...request.Option) (*UpdateUserRoutingProfileOutput, error) {
	req, out := c.UpdateUserRoutingProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserSecurityProfiles = "UpdateUserSecurityProfiles"

// UpdateUserSecurityProfilesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserSecurityProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserSecurityProfiles for more information on using the UpdateUserSecurityProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserSecurityProfilesRequest method.
//    req, resp := client.UpdateUserSecurityProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserSecurityProfiles
func (c *Connect) UpdateUserSecurityProfilesRequest(input *UpdateUserSecurityProfilesInput) (req *request.Request, output *UpdateUserSecurityProfilesOutput) {
	op := &request.Operation{
		Name:       opUpdateUserSecurityProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/users/{InstanceId}/{UserId}/security-profiles",
	}

	if input == nil {
		input = &UpdateUserSecurityProfilesInput{}
	}

	output = &UpdateUserSecurityProfilesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUserSecurityProfiles API operation for Amazon Connect Service.
//
// Assigns the specified security profiles to the specified user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateUserSecurityProfiles for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidParameterException
//   One or more of the specified parameters are not valid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * InternalServiceException
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserSecurityProfiles
func (c *Connect) UpdateUserSecurityProfiles(input *UpdateUserSecurityProfilesInput) (*UpdateUserSecurityProfilesOutput, error) {
	req, out := c.UpdateUserSecurityProfilesRequest(input)
	return out, req.Send()
}

// UpdateUserSecurityProfilesWithContext is the same as UpdateUserSecurityProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserSecurityProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateUserSecurityProfilesWithContext(ctx aws.Context, input *UpdateUserSecurityProfilesInput, opts ...request.Option) (*UpdateUserSecurityProfilesOutput, error) {
	req, out := c.UpdateUserSecurityProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A chat message.
type ChatMessage struct {
	_ struct{} `type:"structure"`

	// The content of the chat message.
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true"`

	// The type of the content. Supported types are text/plain.
	//
	// ContentType is a required field
	ContentType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ChatMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChatMessage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChatMessage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChatMessage"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}
	if s.ContentType != nil && len(*s.ContentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *ChatMessage) SetContent(v string) *ChatMessage {
	s.Content = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *ChatMessage) SetContentType(v string) *ChatMessage {
	s.ContentType = &v
	return s
}

// Contains summary information about a contact flow.
type ContactFlowSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact flow.
	Arn *string `type:"string"`

	// The type of contact flow.
	ContactFlowType *string `type:"string" enum:"ContactFlowType"`

	// The identifier of the contact flow.
	Id *string `type:"string"`

	// The name of the contact flow.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ContactFlowSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContactFlowSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ContactFlowSummary) SetArn(v string) *ContactFlowSummary {
	s.Arn = &v
	return s
}

// SetContactFlowType sets the ContactFlowType field's value.
func (s *ContactFlowSummary) SetContactFlowType(v string) *ContactFlowSummary {
	s.ContactFlowType = &v
	return s
}

// SetId sets the Id field's value.
func (s *ContactFlowSummary) SetId(v string) *ContactFlowSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ContactFlowSummary) SetName(v string) *ContactFlowSummary {
	s.Name = &v
	return s
}

// The contact with the specified ID is not active or does not exist.
type ContactNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ContactNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContactNotFoundException) GoString() string {
	return s.String()
}

func newErrorContactNotFoundException(v protocol.ResponseMetadata) error {
	return &ContactNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ContactNotFoundException) Code() string {
	return "ContactNotFoundException"
}

// Message returns the exception's message.
func (s *ContactNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ContactNotFoundException) OrigErr() error {
	return nil
}

func (s *ContactNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ContactNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ContactNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateUserInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the user account in the directory used for identity management.
	// If Amazon Connect cannot access the directory, you can specify this identifier
	// to authenticate users. If you include the identifier, we assume that Amazon
	// Connect cannot access the directory. Otherwise, the identity information
	// is used to authenticate users from your directory.
	//
	// This parameter is required if you are using an existing directory for identity
	// management in Amazon Connect when Amazon Connect cannot access your directory
	// to authenticate users. If you are using SAML for identity management and
	// include this parameter, an error is returned.
	DirectoryUserId *string `type:"string"`

	// The identifier of the hierarchy group for the user.
	HierarchyGroupId *string `type:"string"`

	// The information about the identity of the user.
	IdentityInfo *UserIdentityInfo `type:"structure"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The password for the user account. A password is required if you are using
	// Amazon Connect for identity management. Otherwise, it is an error to include
	// a password.
	Password *string `type:"string"`

	// The phone settings for the user.
	//
	// PhoneConfig is a required field
	PhoneConfig *UserPhoneConfig `type:"structure" required:"true"`

	// The identifier of the routing profile for the user.
	//
	// RoutingProfileId is a required field
	RoutingProfileId *string `type:"string" required:"true"`

	// The identifier of the security profile for the user.
	//
	// SecurityProfileIds is a required field
	SecurityProfileIds []*string `min:"1" type:"list" required:"true"`

	// One or more tags.
	Tags map[string]*string `min:"1" type:"map"`

	// The user name for the account. For instances not using SAML for identity
	// management, the user name can include up to 20 characters. If you are using
	// SAML for identity management, the user name can include up to 64 characters
	// from [a-zA-Z0-9_-.\@]+.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.PhoneConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneConfig"))
	}
	if s.RoutingProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingProfileId"))
	}
	if s.SecurityProfileIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityProfileIds"))
	}
	if s.SecurityProfileIds != nil && len(s.SecurityProfileIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityProfileIds", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.IdentityInfo != nil {
		if err := s.IdentityInfo.Validate(); err != nil {
			invalidParams.AddNested("IdentityInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.PhoneConfig != nil {
		if err := s.PhoneConfig.Validate(); err != nil {
			invalidParams.AddNested("PhoneConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryUserId sets the DirectoryUserId field's value.
func (s *CreateUserInput) SetDirectoryUserId(v string) *CreateUserInput {
	s.DirectoryUserId = &v
	return s
}

// SetHierarchyGroupId sets the HierarchyGroupId field's value.
func (s *CreateUserInput) SetHierarchyGroupId(v string) *CreateUserInput {
	s.HierarchyGroupId = &v
	return s
}

// SetIdentityInfo sets the IdentityInfo field's value.
func (s *CreateUserInput) SetIdentityInfo(v *UserIdentityInfo) *CreateUserInput {
	s.IdentityInfo = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateUserInput) SetInstanceId(v string) *CreateUserInput {
	s.InstanceId = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *CreateUserInput) SetPassword(v string) *CreateUserInput {
	s.Password = &v
	return s
}

// SetPhoneConfig sets the PhoneConfig field's value.
func (s *CreateUserInput) SetPhoneConfig(v *UserPhoneConfig) *CreateUserInput {
	s.PhoneConfig = v
	return s
}

// SetRoutingProfileId sets the RoutingProfileId field's value.
func (s *CreateUserInput) SetRoutingProfileId(v string) *CreateUserInput {
	s.RoutingProfileId = &v
	return s
}

// SetSecurityProfileIds sets the SecurityProfileIds field's value.
func (s *CreateUserInput) SetSecurityProfileIds(v []*string) *CreateUserInput {
	s.SecurityProfileIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateUserInput) SetTags(v map[string]*string) *CreateUserInput {
	s.Tags = v
	return s
}

// SetUsername sets the Username field's value.
func (s *CreateUserInput) SetUsername(v string) *CreateUserInput {
	s.Username = &v
	return s
}

type CreateUserOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the user account.
	UserArn *string `type:"string"`

	// The identifier of the user account.
	UserId *string `type:"string"`
}

// String returns the string representation
func (s CreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserOutput) GoString() string {
	return s.String()
}

// SetUserArn sets the UserArn field's value.
func (s *CreateUserOutput) SetUserArn(v string) *CreateUserOutput {
	s.UserArn = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *CreateUserOutput) SetUserId(v string) *CreateUserOutput {
	s.UserId = &v
	return s
}

// Contains credentials to use for federation.
type Credentials struct {
	_ struct{} `type:"structure"`

	// An access token generated for a federated user to access Amazon Connect.
	AccessToken *string `type:"string" sensitive:"true"`

	// A token generated with an expiration time for the session a user is logged
	// in to Amazon Connect.
	AccessTokenExpiration *time.Time `type:"timestamp"`

	// Renews a token generated for a user to access the Amazon Connect instance.
	RefreshToken *string `type:"string" sensitive:"true"`

	// Renews the expiration timer for a generated token.
	RefreshTokenExpiration *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s Credentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Credentials) GoString() string {
	return s.String()
}

// SetAccessToken sets the AccessToken field's value.
func (s *Credentials) SetAccessToken(v string) *Credentials {
	s.AccessToken = &v
	return s
}

// SetAccessTokenExpiration sets the AccessTokenExpiration field's value.
func (s *Credentials) SetAccessTokenExpiration(v time.Time) *Credentials {
	s.AccessTokenExpiration = &v
	return s
}

// SetRefreshToken sets the RefreshToken field's value.
func (s *Credentials) SetRefreshToken(v string) *Credentials {
	s.RefreshToken = &v
	return s
}

// SetRefreshTokenExpiration sets the RefreshTokenExpiration field's value.
func (s *Credentials) SetRefreshTokenExpiration(v time.Time) *Credentials {
	s.RefreshTokenExpiration = &v
	return s
}

// Contains information about a real-time metric.
type CurrentMetric struct {
	_ struct{} `type:"structure"`

	// The name of the metric.
	Name *string `type:"string" enum:"CurrentMetricName"`

	// The unit for the metric.
	Unit *string `type:"string" enum:"Unit"`
}

// String returns the string representation
func (s CurrentMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CurrentMetric) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CurrentMetric) SetName(v string) *CurrentMetric {
	s.Name = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *CurrentMetric) SetUnit(v string) *CurrentMetric {
	s.Unit = &v
	return s
}

// Contains the data for a real-time metric.
type CurrentMetricData struct {
	_ struct{} `type:"structure"`

	// Information about the metric.
	Metric *CurrentMetric `type:"structure"`

	// The value of the metric.
	Value *float64 `type:"double"`
}

// String returns the string representation
func (s CurrentMetricData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CurrentMetricData) GoString() string {
	return s.String()
}

// SetMetric sets the Metric field's value.
func (s *CurrentMetricData) SetMetric(v *CurrentMetric) *CurrentMetricData {
	s.Metric = v
	return s
}

// SetValue sets the Value field's value.
func (s *CurrentMetricData) SetValue(v float64) *CurrentMetricData {
	s.Value = &v
	return s
}

// Contains information about a set of real-time metrics.
type CurrentMetricResult struct {
	_ struct{} `type:"structure"`

	// The set of metrics.
	Collections []*CurrentMetricData `type:"list"`

	// The dimensions for the metrics.
	Dimensions *Dimensions `type:"structure"`
}

// String returns the string representation
func (s CurrentMetricResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CurrentMetricResult) GoString() string {
	return s.String()
}

// SetCollections sets the Collections field's value.
func (s *CurrentMetricResult) SetCollections(v []*CurrentMetricData) *CurrentMetricResult {
	s.Collections = v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *CurrentMetricResult) SetDimensions(v *Dimensions) *CurrentMetricResult {
	s.Dimensions = v
	return s
}

type DeleteUserInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The identifier of the user.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"UserId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DeleteUserInput) SetInstanceId(v string) *DeleteUserInput {
	s.InstanceId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DeleteUserInput) SetUserId(v string) *DeleteUserInput {
	s.UserId = &v
	return s
}

type DeleteUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

type DescribeUserHierarchyGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the hierarchy group.
	//
	// HierarchyGroupId is a required field
	HierarchyGroupId *string `location:"uri" locationName:"HierarchyGroupId" type:"string" required:"true"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserHierarchyGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserHierarchyGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserHierarchyGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserHierarchyGroupInput"}
	if s.HierarchyGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("HierarchyGroupId"))
	}
	if s.HierarchyGroupId != nil && len(*s.HierarchyGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HierarchyGroupId", 1))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHierarchyGroupId sets the HierarchyGroupId field's value.
func (s *DescribeUserHierarchyGroupInput) SetHierarchyGroupId(v string) *DescribeUserHierarchyGroupInput {
	s.HierarchyGroupId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeUserHierarchyGroupInput) SetInstanceId(v string) *DescribeUserHierarchyGroupInput {
	s.InstanceId = &v
	return s
}

type DescribeUserHierarchyGroupOutput struct {
	_ struct{} `type:"structure"`

	// Information about the hierarchy group.
	HierarchyGroup *HierarchyGroup `type:"structure"`
}

// String returns the string representation
func (s DescribeUserHierarchyGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserHierarchyGroupOutput) GoString() string {
	return s.String()
}

// SetHierarchyGroup sets the HierarchyGroup field's value.
func (s *DescribeUserHierarchyGroupOutput) SetHierarchyGroup(v *HierarchyGroup) *DescribeUserHierarchyGroupOutput {
	s.HierarchyGroup = v
	return s
}

type DescribeUserHierarchyStructureInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserHierarchyStructureInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserHierarchyStructureInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserHierarchyStructureInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserHierarchyStructureInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeUserHierarchyStructureInput) SetInstanceId(v string) *DescribeUserHierarchyStructureInput {
	s.InstanceId = &v
	return s
}

type DescribeUserHierarchyStructureOutput struct {
	_ struct{} `type:"structure"`

	// Information about the hierarchy structure.
	HierarchyStructure *HierarchyStructure `type:"structure"`
}

// String returns the string representation
func (s DescribeUserHierarchyStructureOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserHierarchyStructureOutput) GoString() string {
	return s.String()
}

// SetHierarchyStructure sets the HierarchyStructure field's value.
func (s *DescribeUserHierarchyStructureOutput) SetHierarchyStructure(v *HierarchyStructure) *DescribeUserHierarchyStructureOutput {
	s.HierarchyStructure = v
	return s
}

type DescribeUserInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The identifier of the user account.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"UserId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeUserInput) SetInstanceId(v string) *DescribeUserInput {
	s.InstanceId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DescribeUserInput) SetUserId(v string) *DescribeUserInput {
	s.UserId = &v
	return s
}

type DescribeUserOutput struct {
	_ struct{} `type:"structure"`

	// Information about the user account and configuration settings.
	User *User `type:"structure"`
}

// String returns the string representation
func (s DescribeUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserOutput) GoString() string {
	return s.String()
}

// SetUser sets the User field's value.
func (s *DescribeUserOutput) SetUser(v *User) *DescribeUserOutput {
	s.User = v
	return s
}

// Outbound calls to the destination number are not allowed.
type DestinationNotAllowedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s DestinationNotAllowedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DestinationNotAllowedException) GoString() string {
	return s.String()
}

func newErrorDestinationNotAllowedException(v protocol.ResponseMetadata) error {
	return &DestinationNotAllowedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DestinationNotAllowedException) Code() string {
	return "DestinationNotAllowedException"
}

// Message returns the exception's message.
func (s *DestinationNotAllowedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DestinationNotAllowedException) OrigErr() error {
	return nil
}

func (s *DestinationNotAllowedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DestinationNotAllowedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DestinationNotAllowedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about the dimensions for a set of metrics.
type Dimensions struct {
	_ struct{} `type:"structure"`

	// The channel used for grouping and filters.
	Channel *string `type:"string" enum:"Channel"`

	// Information about the queue for which metrics are returned.
	Queue *QueueReference `type:"structure"`
}

// String returns the string representation
func (s Dimensions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Dimensions) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *Dimensions) SetChannel(v string) *Dimensions {
	s.Channel = &v
	return s
}

// SetQueue sets the Queue field's value.
func (s *Dimensions) SetQueue(v *QueueReference) *Dimensions {
	s.Queue = v
	return s
}

// A resource with the specified name already exists.
type DuplicateResourceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s DuplicateResourceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DuplicateResourceException) GoString() string {
	return s.String()
}

func newErrorDuplicateResourceException(v protocol.ResponseMetadata) error {
	return &DuplicateResourceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DuplicateResourceException) Code() string {
	return "DuplicateResourceException"
}

// Message returns the exception's message.
func (s *DuplicateResourceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DuplicateResourceException) OrigErr() error {
	return nil
}

func (s *DuplicateResourceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DuplicateResourceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DuplicateResourceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains the filter to apply when retrieving metrics.
type Filters struct {
	_ struct{} `type:"structure"`

	// The channel to use to filter the metrics.
	Channels []*string `type:"list"`

	// The queues to use to filter the metrics. You can specify up to 100 queues
	// per request.
	Queues []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s Filters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filters"}
	if s.Queues != nil && len(s.Queues) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Queues", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannels sets the Channels field's value.
func (s *Filters) SetChannels(v []*string) *Filters {
	s.Channels = v
	return s
}

// SetQueues sets the Queues field's value.
func (s *Filters) SetQueues(v []*string) *Filters {
	s.Queues = v
	return s
}

type GetContactAttributesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the initial contact.
	//
	// InitialContactId is a required field
	InitialContactId *string `location:"uri" locationName:"InitialContactId" min:"1" type:"string" required:"true"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetContactAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetContactAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetContactAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetContactAttributesInput"}
	if s.InitialContactId == nil {
		invalidParams.Add(request.NewErrParamRequired("InitialContactId"))
	}
	if s.InitialContactId != nil && len(*s.InitialContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InitialContactId", 1))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInitialContactId sets the InitialContactId field's value.
func (s *GetContactAttributesInput) SetInitialContactId(v string) *GetContactAttributesInput {
	s.InitialContactId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetContactAttributesInput) SetInstanceId(v string) *GetContactAttributesInput {
	s.InstanceId = &v
	return s
}

type GetContactAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the attributes.
	Attributes map[string]*string `type:"map"`
}

// String returns the string representation
func (s GetContactAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetContactAttributesOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *GetContactAttributesOutput) SetAttributes(v map[string]*string) *GetContactAttributesOutput {
	s.Attributes = v
	return s
}

type GetCurrentMetricDataInput struct {
	_ struct{} `type:"structure"`

	// The metrics to retrieve. Specify the name and unit for each metric. The following
	// metrics are available:
	//
	// AGENTS_AFTER_CONTACT_WORK
	//
	// Unit: COUNT
	//
	// AGENTS_AVAILABLE
	//
	// Unit: COUNT
	//
	// AGENTS_ERROR
	//
	// Unit: COUNT
	//
	// AGENTS_NON_PRODUCTIVE
	//
	// Unit: COUNT
	//
	// AGENTS_ON_CALL
	//
	// Unit: COUNT
	//
	// AGENTS_ON_CONTACT
	//
	// Unit: COUNT
	//
	// AGENTS_ONLINE
	//
	// Unit: COUNT
	//
	// AGENTS_STAFFED
	//
	// Unit: COUNT
	//
	// CONTACTS_IN_QUEUE
	//
	// Unit: COUNT
	//
	// CONTACTS_SCHEDULED
	//
	// Unit: COUNT
	//
	// OLDEST_CONTACT_AGE
	//
	// Unit: SECONDS
	//
	// SLOTS_ACTIVE
	//
	// Unit: COUNT
	//
	// SLOTS_AVAILABLE
	//
	// Unit: COUNT
	//
	// CurrentMetrics is a required field
	CurrentMetrics []*CurrentMetric `type:"list" required:"true"`

	// The queues, up to 100, or channels, to use to filter the metrics returned.
	// Metric data is retrieved only for the resources associated with the queues
	// or channels included in the filter. You can include both queue IDs and queue
	// ARNs in the same request. The only supported channel is VOICE.
	//
	// Filters is a required field
	Filters *Filters `type:"structure" required:"true"`

	// The grouping applied to the metrics returned. For example, when grouped by
	// QUEUE, the metrics returned apply to each queue rather than aggregated for
	// all queues. If you group by CHANNEL, you should include a Channels filter.
	// The only supported channel is VOICE.
	//
	// If no Grouping is included in the request, a summary of metrics is returned.
	Groupings []*string `type:"list"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The maximimum number of results to return per page.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	//
	// The token expires after 5 minutes from the time it is created. Subsequent
	// requests that use the token must use the same request parameters as the request
	// that generated the token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetCurrentMetricDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCurrentMetricDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCurrentMetricDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCurrentMetricDataInput"}
	if s.CurrentMetrics == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentMetrics"))
	}
	if s.Filters == nil {
		invalidParams.Add(request.NewErrParamRequired("Filters"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCurrentMetrics sets the CurrentMetrics field's value.
func (s *GetCurrentMetricDataInput) SetCurrentMetrics(v []*CurrentMetric) *GetCurrentMetricDataInput {
	s.CurrentMetrics = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *GetCurrentMetricDataInput) SetFilters(v *Filters) *GetCurrentMetricDataInput {
	s.Filters = v
	return s
}

// SetGroupings sets the Groupings field's value.
func (s *GetCurrentMetricDataInput) SetGroupings(v []*string) *GetCurrentMetricDataInput {
	s.Groupings = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetCurrentMetricDataInput) SetInstanceId(v string) *GetCurrentMetricDataInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetCurrentMetricDataInput) SetMaxResults(v int64) *GetCurrentMetricDataInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCurrentMetricDataInput) SetNextToken(v string) *GetCurrentMetricDataInput {
	s.NextToken = &v
	return s
}

type GetCurrentMetricDataOutput struct {
	_ struct{} `type:"structure"`

	// The time at which the metrics were retrieved and cached for pagination.
	DataSnapshotTime *time.Time `type:"timestamp"`

	// Information about the real-time metrics.
	MetricResults []*CurrentMetricResult `type:"list"`

	// If there are additional results, this is the token for the next set of results.
	//
	// The token expires after 5 minutes from the time it is created. Subsequent
	// requests that use the token must use the same request parameters as the request
	// that generated the token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetCurrentMetricDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCurrentMetricDataOutput) GoString() string {
	return s.String()
}

// SetDataSnapshotTime sets the DataSnapshotTime field's value.
func (s *GetCurrentMetricDataOutput) SetDataSnapshotTime(v time.Time) *GetCurrentMetricDataOutput {
	s.DataSnapshotTime = &v
	return s
}

// SetMetricResults sets the MetricResults field's value.
func (s *GetCurrentMetricDataOutput) SetMetricResults(v []*CurrentMetricResult) *GetCurrentMetricDataOutput {
	s.MetricResults = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCurrentMetricDataOutput) SetNextToken(v string) *GetCurrentMetricDataOutput {
	s.NextToken = &v
	return s
}

type GetFederationTokenInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFederationTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFederationTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFederationTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFederationTokenInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetFederationTokenInput) SetInstanceId(v string) *GetFederationTokenInput {
	s.InstanceId = &v
	return s
}

type GetFederationTokenOutput struct {
	_ struct{} `type:"structure"`

	// The credentials to use for federation.
	Credentials *Credentials `type:"structure"`
}

// String returns the string representation
func (s GetFederationTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFederationTokenOutput) GoString() string {
	return s.String()
}

// SetCredentials sets the Credentials field's value.
func (s *GetFederationTokenOutput) SetCredentials(v *Credentials) *GetFederationTokenOutput {
	s.Credentials = v
	return s
}

type GetMetricDataInput struct {
	_ struct{} `type:"structure"`

	// The timestamp, in UNIX Epoch time format, at which to end the reporting interval
	// for the retrieval of historical metrics data. The time must be specified
	// using an interval of 5 minutes, such as 11:00, 11:05, 11:10, and must be
	// later than the start time timestamp.
	//
	// The time range between the start and end time must be less than 24 hours.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// The queues, up to 100, or channels, to use to filter the metrics returned.
	// Metric data is retrieved only for the resources associated with the queues
	// or channels included in the filter. You can include both queue IDs and queue
	// ARNs in the same request. The only supported channel is VOICE.
	//
	// Filters is a required field
	Filters *Filters `type:"structure" required:"true"`

	// The grouping applied to the metrics returned. For example, when results are
	// grouped by queue, the metrics returned are grouped by queue. The values returned
	// apply to the metrics for each queue rather than aggregated for all queues.
	//
	// The only supported grouping is QUEUE.
	//
	// If no grouping is specified, a summary of metrics for all queues is returned.
	Groupings []*string `type:"list"`

	// The metrics to retrieve. Specify the name, unit, and statistic for each metric.
	// The following historical metrics are available:
	//
	// ABANDON_TIME
	//
	// Unit: SECONDS
	//
	// Statistic: AVG
	//
	// AFTER_CONTACT_WORK_TIME
	//
	// Unit: SECONDS
	//
	// Statistic: AVG
	//
	// API_CONTACTS_HANDLED
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CALLBACK_CONTACTS_HANDLED
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_ABANDONED
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_AGENT_HUNG_UP_FIRST
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_CONSULTED
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_HANDLED
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_HANDLED_INCOMING
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_HANDLED_OUTBOUND
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_HOLD_ABANDONS
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_MISSED
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_QUEUED
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_TRANSFERRED_IN
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_TRANSFERRED_IN_FROM_QUEUE
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_TRANSFERRED_OUT
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_TRANSFERRED_OUT_FROM_QUEUE
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// HANDLE_TIME
	//
	// Unit: SECONDS
	//
	// Statistic: AVG
	//
	// HOLD_TIME
	//
	// Unit: SECONDS
	//
	// Statistic: AVG
	//
	// INTERACTION_AND_HOLD_TIME
	//
	// Unit: SECONDS
	//
	// Statistic: AVG
	//
	// INTERACTION_TIME
	//
	// Unit: SECONDS
	//
	// Statistic: AVG
	//
	// OCCUPANCY
	//
	// Unit: PERCENT
	//
	// Statistic: AVG
	//
	// QUEUE_ANSWER_TIME
	//
	// Unit: SECONDS
	//
	// Statistic: AVG
	//
	// QUEUED_TIME
	//
	// Unit: SECONDS
	//
	// Statistic: MAX
	//
	// SERVICE_LEVEL
	//
	// Unit: PERCENT
	//
	// Statistic: AVG
	//
	// Threshold: Only "Less than" comparisons are supported, with the following
	// service level thresholds: 15, 20, 25, 30, 45, 60, 90, 120, 180, 240, 300,
	// 600
	//
	// HistoricalMetrics is a required field
	HistoricalMetrics []*HistoricalMetric `type:"list" required:"true"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The maximimum number of results to return per page.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The timestamp, in UNIX Epoch time format, at which to start the reporting
	// interval for the retrieval of historical metrics data. The time must be specified
	// using a multiple of 5 minutes, such as 10:05, 10:10, 10:15.
	//
	// The start time cannot be earlier than 24 hours before the time of the request.
	// Historical metrics are available only for 24 hours.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s GetMetricDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMetricDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMetricDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMetricDataInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.Filters == nil {
		invalidParams.Add(request.NewErrParamRequired("Filters"))
	}
	if s.HistoricalMetrics == nil {
		invalidParams.Add(request.NewErrParamRequired("HistoricalMetrics"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetMetricDataInput) SetEndTime(v time.Time) *GetMetricDataInput {
	s.EndTime = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *GetMetricDataInput) SetFilters(v *Filters) *GetMetricDataInput {
	s.Filters = v
	return s
}

// SetGroupings sets the Groupings field's value.
func (s *GetMetricDataInput) SetGroupings(v []*string) *GetMetricDataInput {
	s.Groupings = v
	return s
}

// SetHistoricalMetrics sets the HistoricalMetrics field's value.
func (s *GetMetricDataInput) SetHistoricalMetrics(v []*HistoricalMetric) *GetMetricDataInput {
	s.HistoricalMetrics = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetMetricDataInput) SetInstanceId(v string) *GetMetricDataInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetMetricDataInput) SetMaxResults(v int64) *GetMetricDataInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetMetricDataInput) SetNextToken(v string) *GetMetricDataInput {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetMetricDataInput) SetStartTime(v time.Time) *GetMetricDataInput {
	s.StartTime = &v
	return s
}

type GetMetricDataOutput struct {
	_ struct{} `type:"structure"`

	// Information about the historical metrics.
	//
	// If no grouping is specified, a summary of metric data is returned.
	MetricResults []*HistoricalMetricResult `type:"list"`

	// If there are additional results, this is the token for the next set of results.
	//
	// The token expires after 5 minutes from the time it is created. Subsequent
	// requests that use the token must use the same request parameters as the request
	// that generated the token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetMetricDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMetricDataOutput) GoString() string {
	return s.String()
}

// SetMetricResults sets the MetricResults field's value.
func (s *GetMetricDataOutput) SetMetricResults(v []*HistoricalMetricResult) *GetMetricDataOutput {
	s.MetricResults = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetMetricDataOutput) SetNextToken(v string) *GetMetricDataOutput {
	s.NextToken = &v
	return s
}

// Contains information about a hierarchy group.
type HierarchyGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the hierarchy group.
	Arn *string `type:"string"`

	// Information about the levels in the hierarchy group.
	HierarchyPath *HierarchyPath `type:"structure"`

	// The identifier of the hierarchy group.
	Id *string `type:"string"`

	// The identifier of the level in the hierarchy group.
	LevelId *string `type:"string"`

	// The name of the hierarchy group.
	Name *string `type:"string"`
}

// String returns the string representation
func (s HierarchyGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HierarchyGroup) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *HierarchyGroup) SetArn(v string) *HierarchyGroup {
	s.Arn = &v
	return s
}

// SetHierarchyPath sets the HierarchyPath field's value.
func (s *HierarchyGroup) SetHierarchyPath(v *HierarchyPath) *HierarchyGroup {
	s.HierarchyPath = v
	return s
}

// SetId sets the Id field's value.
func (s *HierarchyGroup) SetId(v string) *HierarchyGroup {
	s.Id = &v
	return s
}

// SetLevelId sets the LevelId field's value.
func (s *HierarchyGroup) SetLevelId(v string) *HierarchyGroup {
	s.LevelId = &v
	return s
}

// SetName sets the Name field's value.
func (s *HierarchyGroup) SetName(v string) *HierarchyGroup {
	s.Name = &v
	return s
}

// Contains summary information about a hierarchy group.
type HierarchyGroupSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the hierarchy group.
	Arn *string `type:"string"`

	// The identifier of the hierarchy group.
	Id *string `type:"string"`

	// The name of the hierarchy group.
	Name *string `type:"string"`
}

// String returns the string representation
func (s HierarchyGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HierarchyGroupSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *HierarchyGroupSummary) SetArn(v string) *HierarchyGroupSummary {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *HierarchyGroupSummary) SetId(v string) *HierarchyGroupSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *HierarchyGroupSummary) SetName(v string) *HierarchyGroupSummary {
	s.Name = &v
	return s
}

// Contains information about a hierarchy level.
type HierarchyLevel struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the hierarchy level.
	Arn *string `type:"string"`

	// The identifier of the hierarchy level.
	Id *string `type:"string"`

	// The name of the hierarchy level.
	Name *string `type:"string"`
}

// String returns the string representation
func (s HierarchyLevel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HierarchyLevel) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *HierarchyLevel) SetArn(v string) *HierarchyLevel {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *HierarchyLevel) SetId(v string) *HierarchyLevel {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *HierarchyLevel) SetName(v string) *HierarchyLevel {
	s.Name = &v
	return s
}

// Contains information about the levels of a hierarchy group.
type HierarchyPath struct {
	_ struct{} `type:"structure"`

	// Information about level five.
	LevelFive *HierarchyGroupSummary `type:"structure"`

	// Information about level four.
	LevelFour *HierarchyGroupSummary `type:"structure"`

	// Information about level one.
	LevelOne *HierarchyGroupSummary `type:"structure"`

	// Information about level three.
	LevelThree *HierarchyGroupSummary `type:"structure"`

	// Information about level two.
	LevelTwo *HierarchyGroupSummary `type:"structure"`
}

// String returns the string representation
func (s HierarchyPath) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HierarchyPath) GoString() string {
	return s.String()
}

// SetLevelFive sets the LevelFive field's value.
func (s *HierarchyPath) SetLevelFive(v *HierarchyGroupSummary) *HierarchyPath {
	s.LevelFive = v
	return s
}

// SetLevelFour sets the LevelFour field's value.
func (s *HierarchyPath) SetLevelFour(v *HierarchyGroupSummary) *HierarchyPath {
	s.LevelFour = v
	return s
}

// SetLevelOne sets the LevelOne field's value.
func (s *HierarchyPath) SetLevelOne(v *HierarchyGroupSummary) *HierarchyPath {
	s.LevelOne = v
	return s
}

// SetLevelThree sets the LevelThree field's value.
func (s *HierarchyPath) SetLevelThree(v *HierarchyGroupSummary) *HierarchyPath {
	s.LevelThree = v
	return s
}

// SetLevelTwo sets the LevelTwo field's value.
func (s *HierarchyPath) SetLevelTwo(v *HierarchyGroupSummary) *HierarchyPath {
	s.LevelTwo = v
	return s
}

// Contains information about a hierarchy structure.
type HierarchyStructure struct {
	_ struct{} `type:"structure"`

	// Information about level five.
	LevelFive *HierarchyLevel `type:"structure"`

	// Information about level four.
	LevelFour *HierarchyLevel `type:"structure"`

	// Information about level one.
	LevelOne *HierarchyLevel `type:"structure"`

	// Information about level three.
	LevelThree *HierarchyLevel `type:"structure"`

	// Information about level two.
	LevelTwo *HierarchyLevel `type:"structure"`
}

// String returns the string representation
func (s HierarchyStructure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HierarchyStructure) GoString() string {
	return s.String()
}

// SetLevelFive sets the LevelFive field's value.
func (s *HierarchyStructure) SetLevelFive(v *HierarchyLevel) *HierarchyStructure {
	s.LevelFive = v
	return s
}

// SetLevelFour sets the LevelFour field's value.
func (s *HierarchyStructure) SetLevelFour(v *HierarchyLevel) *HierarchyStructure {
	s.LevelFour = v
	return s
}

// SetLevelOne sets the LevelOne field's value.
func (s *HierarchyStructure) SetLevelOne(v *HierarchyLevel) *HierarchyStructure {
	s.LevelOne = v
	return s
}

// SetLevelThree sets the LevelThree field's value.
func (s *HierarchyStructure) SetLevelThree(v *HierarchyLevel) *HierarchyStructure {
	s.LevelThree = v
	return s
}

// SetLevelTwo sets the LevelTwo field's value.
func (s *HierarchyStructure) SetLevelTwo(v *HierarchyLevel) *HierarchyStructure {
	s.LevelTwo = v
	return s
}

// Contains information about a historical metric.
type HistoricalMetric struct {
	_ struct{} `type:"structure"`

	// The name of the metric.
	Name *string `type:"string" enum:"HistoricalMetricName"`

	// The statistic for the metric.
	Statistic *string `type:"string" enum:"Statistic"`

	// The threshold for the metric, used with service level metrics.
	Threshold *Threshold `type:"structure"`

	// The unit for the metric.
	Unit *string `type:"string" enum:"Unit"`
}

// String returns the string representation
func (s HistoricalMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HistoricalMetric) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *HistoricalMetric) SetName(v string) *HistoricalMetric {
	s.Name = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *HistoricalMetric) SetStatistic(v string) *HistoricalMetric {
	s.Statistic = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *HistoricalMetric) SetThreshold(v *Threshold) *HistoricalMetric {
	s.Threshold = v
	return s
}

// SetUnit sets the Unit field's value.
func (s *HistoricalMetric) SetUnit(v string) *HistoricalMetric {
	s.Unit = &v
	return s
}

// Contains the data for a historical metric.
type HistoricalMetricData struct {
	_ struct{} `type:"structure"`

	// Information about the metric.
	Metric *HistoricalMetric `type:"structure"`

	// The value of the metric.
	Value *float64 `type:"double"`
}

// String returns the string representation
func (s HistoricalMetricData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HistoricalMetricData) GoString() string {
	return s.String()
}

// SetMetric sets the Metric field's value.
func (s *HistoricalMetricData) SetMetric(v *HistoricalMetric) *HistoricalMetricData {
	s.Metric = v
	return s
}

// SetValue sets the Value field's value.
func (s *HistoricalMetricData) SetValue(v float64) *HistoricalMetricData {
	s.Value = &v
	return s
}

// Contains information about the historical metrics retrieved.
type HistoricalMetricResult struct {
	_ struct{} `type:"structure"`

	// The set of metrics.
	Collections []*HistoricalMetricData `type:"list"`

	// The dimension for the metrics.
	Dimensions *Dimensions `type:"structure"`
}

// String returns the string representation
func (s HistoricalMetricResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HistoricalMetricResult) GoString() string {
	return s.String()
}

// SetCollections sets the Collections field's value.
func (s *HistoricalMetricResult) SetCollections(v []*HistoricalMetricData) *HistoricalMetricResult {
	s.Collections = v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *HistoricalMetricResult) SetDimensions(v *Dimensions) *HistoricalMetricResult {
	s.Dimensions = v
	return s
}

// Contains summary information about hours of operation for a contact center.
type HoursOfOperationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the hours of operation.
	Arn *string `type:"string"`

	// The identifier of the hours of operation.
	Id *string `type:"string"`

	// The name of the hours of operation.
	Name *string `type:"string"`
}

// String returns the string representation
func (s HoursOfOperationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HoursOfOperationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *HoursOfOperationSummary) SetArn(v string) *HoursOfOperationSummary {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *HoursOfOperationSummary) SetId(v string) *HoursOfOperationSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *HoursOfOperationSummary) SetName(v string) *HoursOfOperationSummary {
	s.Name = &v
	return s
}

// Request processing failed due to an error or failure with the service.
type InternalServiceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServiceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServiceException) GoString() string {
	return s.String()
}

func newErrorInternalServiceException(v protocol.ResponseMetadata) error {
	return &InternalServiceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceException) Code() string {
	return "InternalServiceException"
}

// Message returns the exception's message.
func (s *InternalServiceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceException) OrigErr() error {
	return nil
}

func (s *InternalServiceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// One or more of the specified parameters are not valid.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request is not valid.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The allowed limit for the resource has been exceeded.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListContactFlowsInput struct {
	_ struct{} `type:"structure"`

	// The type of contact flow.
	ContactFlowTypes []*string `location:"querystring" locationName:"contactFlowTypes" type:"list"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The maximimum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListContactFlowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListContactFlowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListContactFlowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListContactFlowsInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactFlowTypes sets the ContactFlowTypes field's value.
func (s *ListContactFlowsInput) SetContactFlowTypes(v []*string) *ListContactFlowsInput {
	s.ContactFlowTypes = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *ListContactFlowsInput) SetInstanceId(v string) *ListContactFlowsInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListContactFlowsInput) SetMaxResults(v int64) *ListContactFlowsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContactFlowsInput) SetNextToken(v string) *ListContactFlowsInput {
	s.NextToken = &v
	return s
}

type ListContactFlowsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the contact flows.
	ContactFlowSummaryList []*ContactFlowSummary `type:"list"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListContactFlowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListContactFlowsOutput) GoString() string {
	return s.String()
}

// SetContactFlowSummaryList sets the ContactFlowSummaryList field's value.
func (s *ListContactFlowsOutput) SetContactFlowSummaryList(v []*ContactFlowSummary) *ListContactFlowsOutput {
	s.ContactFlowSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContactFlowsOutput) SetNextToken(v string) *ListContactFlowsOutput {
	s.NextToken = &v
	return s
}

type ListHoursOfOperationsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The maximimum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListHoursOfOperationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHoursOfOperationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListHoursOfOperationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListHoursOfOperationsInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *ListHoursOfOperationsInput) SetInstanceId(v string) *ListHoursOfOperationsInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListHoursOfOperationsInput) SetMaxResults(v int64) *ListHoursOfOperationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHoursOfOperationsInput) SetNextToken(v string) *ListHoursOfOperationsInput {
	s.NextToken = &v
	return s
}

type ListHoursOfOperationsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the hours of operation.
	HoursOfOperationSummaryList []*HoursOfOperationSummary `type:"list"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListHoursOfOperationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHoursOfOperationsOutput) GoString() string {
	return s.String()
}

// SetHoursOfOperationSummaryList sets the HoursOfOperationSummaryList field's value.
func (s *ListHoursOfOperationsOutput) SetHoursOfOperationSummaryList(v []*HoursOfOperationSummary) *ListHoursOfOperationsOutput {
	s.HoursOfOperationSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHoursOfOperationsOutput) SetNextToken(v string) *ListHoursOfOperationsOutput {
	s.NextToken = &v
	return s
}

type ListPhoneNumbersInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The maximimum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The ISO country code.
	PhoneNumberCountryCodes []*string `location:"querystring" locationName:"phoneNumberCountryCodes" type:"list"`

	// The type of phone number.
	PhoneNumberTypes []*string `location:"querystring" locationName:"phoneNumberTypes" type:"list"`
}

// String returns the string representation
func (s ListPhoneNumbersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPhoneNumbersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPhoneNumbersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPhoneNumbersInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *ListPhoneNumbersInput) SetInstanceId(v string) *ListPhoneNumbersInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPhoneNumbersInput) SetMaxResults(v int64) *ListPhoneNumbersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPhoneNumbersInput) SetNextToken(v string) *ListPhoneNumbersInput {
	s.NextToken = &v
	return s
}

// SetPhoneNumberCountryCodes sets the PhoneNumberCountryCodes field's value.
func (s *ListPhoneNumbersInput) SetPhoneNumberCountryCodes(v []*string) *ListPhoneNumbersInput {
	s.PhoneNumberCountryCodes = v
	return s
}

// SetPhoneNumberTypes sets the PhoneNumberTypes field's value.
func (s *ListPhoneNumbersInput) SetPhoneNumberTypes(v []*string) *ListPhoneNumbersInput {
	s.PhoneNumberTypes = v
	return s
}

type ListPhoneNumbersOutput struct {
	_ struct{} `type:"structure"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `type:"string"`

	// Information about the phone numbers.
	PhoneNumberSummaryList []*PhoneNumberSummary `type:"list"`
}

// String returns the string representation
func (s ListPhoneNumbersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPhoneNumbersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPhoneNumbersOutput) SetNextToken(v string) *ListPhoneNumbersOutput {
	s.NextToken = &v
	return s
}

// SetPhoneNumberSummaryList sets the PhoneNumberSummaryList field's value.
func (s *ListPhoneNumbersOutput) SetPhoneNumberSummaryList(v []*PhoneNumberSummary) *ListPhoneNumbersOutput {
	s.PhoneNumberSummaryList = v
	return s
}

type ListQueuesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The maximimum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The type of queue.
	QueueTypes []*string `location:"querystring" locationName:"queueTypes" type:"list"`
}

// String returns the string representation
func (s ListQueuesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListQueuesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListQueuesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListQueuesInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *ListQueuesInput) SetInstanceId(v string) *ListQueuesInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListQueuesInput) SetMaxResults(v int64) *ListQueuesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListQueuesInput) SetNextToken(v string) *ListQueuesInput {
	s.NextToken = &v
	return s
}

// SetQueueTypes sets the QueueTypes field's value.
func (s *ListQueuesInput) SetQueueTypes(v []*string) *ListQueuesInput {
	s.QueueTypes = v
	return s
}

type ListQueuesOutput struct {
	_ struct{} `type:"structure"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `type:"string"`

	// Information about the queues.
	QueueSummaryList []*QueueSummary `type:"list"`
}

// String returns the string representation
func (s ListQueuesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListQueuesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListQueuesOutput) SetNextToken(v string) *ListQueuesOutput {
	s.NextToken = &v
	return s
}

// SetQueueSummaryList sets the QueueSummaryList field's value.
func (s *ListQueuesOutput) SetQueueSummaryList(v []*QueueSummary) *ListQueuesOutput {
	s.QueueSummaryList = v
	return s
}

type ListRoutingProfilesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The maximimum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListRoutingProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRoutingProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRoutingProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRoutingProfilesInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *ListRoutingProfilesInput) SetInstanceId(v string) *ListRoutingProfilesInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRoutingProfilesInput) SetMaxResults(v int64) *ListRoutingProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRoutingProfilesInput) SetNextToken(v string) *ListRoutingProfilesInput {
	s.NextToken = &v
	return s
}

type ListRoutingProfilesOutput struct {
	_ struct{} `type:"structure"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `type:"string"`

	// Information about the routing profiles.
	RoutingProfileSummaryList []*RoutingProfileSummary `type:"list"`
}

// String returns the string representation
func (s ListRoutingProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRoutingProfilesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRoutingProfilesOutput) SetNextToken(v string) *ListRoutingProfilesOutput {
	s.NextToken = &v
	return s
}

// SetRoutingProfileSummaryList sets the RoutingProfileSummaryList field's value.
func (s *ListRoutingProfilesOutput) SetRoutingProfileSummaryList(v []*RoutingProfileSummary) *ListRoutingProfilesOutput {
	s.RoutingProfileSummaryList = v
	return s
}

type ListSecurityProfilesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The maximimum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListSecurityProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSecurityProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSecurityProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSecurityProfilesInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *ListSecurityProfilesInput) SetInstanceId(v string) *ListSecurityProfilesInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSecurityProfilesInput) SetMaxResults(v int64) *ListSecurityProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSecurityProfilesInput) SetNextToken(v string) *ListSecurityProfilesInput {
	s.NextToken = &v
	return s
}

type ListSecurityProfilesOutput struct {
	_ struct{} `type:"structure"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `type:"string"`

	// Information about the security profiles.
	SecurityProfileSummaryList []*SecurityProfileSummary `type:"list"`
}

// String returns the string representation
func (s ListSecurityProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSecurityProfilesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSecurityProfilesOutput) SetNextToken(v string) *ListSecurityProfilesOutput {
	s.NextToken = &v
	return s
}

// SetSecurityProfileSummaryList sets the SecurityProfileSummaryList field's value.
func (s *ListSecurityProfilesOutput) SetSecurityProfileSummaryList(v []*SecurityProfileSummary) *ListSecurityProfilesOutput {
	s.SecurityProfileSummaryList = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the tags.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListUserHierarchyGroupsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The maximimum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListUserHierarchyGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserHierarchyGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserHierarchyGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUserHierarchyGroupsInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *ListUserHierarchyGroupsInput) SetInstanceId(v string) *ListUserHierarchyGroupsInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUserHierarchyGroupsInput) SetMaxResults(v int64) *ListUserHierarchyGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserHierarchyGroupsInput) SetNextToken(v string) *ListUserHierarchyGroupsInput {
	s.NextToken = &v
	return s
}

type ListUserHierarchyGroupsOutput struct {
	_ struct{} `type:"structure"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `type:"string"`

	// Information about the hierarchy groups.
	UserHierarchyGroupSummaryList []*HierarchyGroupSummary `type:"list"`
}

// String returns the string representation
func (s ListUserHierarchyGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserHierarchyGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserHierarchyGroupsOutput) SetNextToken(v string) *ListUserHierarchyGroupsOutput {
	s.NextToken = &v
	return s
}

// SetUserHierarchyGroupSummaryList sets the UserHierarchyGroupSummaryList field's value.
func (s *ListUserHierarchyGroupsOutput) SetUserHierarchyGroupSummaryList(v []*HierarchyGroupSummary) *ListUserHierarchyGroupsOutput {
	s.UserHierarchyGroupSummaryList = v
	return s
}

type ListUsersInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The maximimum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsersInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *ListUsersInput) SetInstanceId(v string) *ListUsersInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUsersInput) SetMaxResults(v int64) *ListUsersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersInput) SetNextToken(v string) *ListUsersInput {
	s.NextToken = &v
	return s
}

type ListUsersOutput struct {
	_ struct{} `type:"structure"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `type:"string"`

	// Information about the users.
	UserSummaryList []*UserSummary `type:"list"`
}

// String returns the string representation
func (s ListUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersOutput) SetNextToken(v string) *ListUsersOutput {
	s.NextToken = &v
	return s
}

// SetUserSummaryList sets the UserSummaryList field's value.
func (s *ListUsersOutput) SetUserSummaryList(v []*UserSummary) *ListUsersOutput {
	s.UserSummaryList = v
	return s
}

// The contact is not permitted.
type OutboundContactNotPermittedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s OutboundContactNotPermittedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutboundContactNotPermittedException) GoString() string {
	return s.String()
}

func newErrorOutboundContactNotPermittedException(v protocol.ResponseMetadata) error {
	return &OutboundContactNotPermittedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OutboundContactNotPermittedException) Code() string {
	return "OutboundContactNotPermittedException"
}

// Message returns the exception's message.
func (s *OutboundContactNotPermittedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OutboundContactNotPermittedException) OrigErr() error {
	return nil
}

func (s *OutboundContactNotPermittedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OutboundContactNotPermittedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OutboundContactNotPermittedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The customer's details.
type ParticipantDetails struct {
	_ struct{} `type:"structure"`

	// Display name of the participant.
	//
	// DisplayName is a required field
	DisplayName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ParticipantDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParticipantDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParticipantDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ParticipantDetails"}
	if s.DisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("DisplayName"))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayName sets the DisplayName field's value.
func (s *ParticipantDetails) SetDisplayName(v string) *ParticipantDetails {
	s.DisplayName = &v
	return s
}

// Contains summary information about a phone number for a contact center.
type PhoneNumberSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the phone number.
	Arn *string `type:"string"`

	// The identifier of the phone number.
	Id *string `type:"string"`

	// The phone number.
	PhoneNumber *string `type:"string"`

	// The ISO country code.
	PhoneNumberCountryCode *string `type:"string" enum:"PhoneNumberCountryCode"`

	// The type of phone number.
	PhoneNumberType *string `type:"string" enum:"PhoneNumberType"`
}

// String returns the string representation
func (s PhoneNumberSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PhoneNumberSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PhoneNumberSummary) SetArn(v string) *PhoneNumberSummary {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *PhoneNumberSummary) SetId(v string) *PhoneNumberSummary {
	s.Id = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *PhoneNumberSummary) SetPhoneNumber(v string) *PhoneNumberSummary {
	s.PhoneNumber = &v
	return s
}

// SetPhoneNumberCountryCode sets the PhoneNumberCountryCode field's value.
func (s *PhoneNumberSummary) SetPhoneNumberCountryCode(v string) *PhoneNumberSummary {
	s.PhoneNumberCountryCode = &v
	return s
}

// SetPhoneNumberType sets the PhoneNumberType field's value.
func (s *PhoneNumberSummary) SetPhoneNumberType(v string) *PhoneNumberSummary {
	s.PhoneNumberType = &v
	return s
}

// Contains information about a queue resource for which metrics are returned.
type QueueReference struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the queue.
	Arn *string `type:"string"`

	// The identifier of the queue.
	Id *string `type:"string"`
}

// String returns the string representation
func (s QueueReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueueReference) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *QueueReference) SetArn(v string) *QueueReference {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *QueueReference) SetId(v string) *QueueReference {
	s.Id = &v
	return s
}

// Contains summary information about a queue.
type QueueSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the queue.
	Arn *string `type:"string"`

	// The identifier of the queue.
	Id *string `type:"string"`

	// The name of the queue.
	Name *string `min:"1" type:"string"`

	// The type of queue.
	QueueType *string `type:"string" enum:"QueueType"`
}

// String returns the string representation
func (s QueueSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueueSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *QueueSummary) SetArn(v string) *QueueSummary {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *QueueSummary) SetId(v string) *QueueSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *QueueSummary) SetName(v string) *QueueSummary {
	s.Name = &v
	return s
}

// SetQueueType sets the QueueType field's value.
func (s *QueueSummary) SetQueueType(v string) *QueueSummary {
	s.QueueType = &v
	return s
}

// The specified resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains summary information about a routing profile.
type RoutingProfileSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the routing profile.
	Arn *string `type:"string"`

	// The identifier of the routing profile.
	Id *string `type:"string"`

	// The name of the routing profile.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RoutingProfileSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RoutingProfileSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RoutingProfileSummary) SetArn(v string) *RoutingProfileSummary {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *RoutingProfileSummary) SetId(v string) *RoutingProfileSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *RoutingProfileSummary) SetName(v string) *RoutingProfileSummary {
	s.Name = &v
	return s
}

// Contains information about a security profile.
type SecurityProfileSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the security profile.
	Arn *string `type:"string"`

	// The identifier of the security profile.
	Id *string `type:"string"`

	// The name of the security profile.
	Name *string `type:"string"`
}

// String returns the string representation
func (s SecurityProfileSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SecurityProfileSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SecurityProfileSummary) SetArn(v string) *SecurityProfileSummary {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *SecurityProfileSummary) SetId(v string) *SecurityProfileSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *SecurityProfileSummary) SetName(v string) *SecurityProfileSummary {
	s.Name = &v
	return s
}

type StartChatContactInput struct {
	_ struct{} `type:"structure"`

	// A custom key-value pair using an attribute map. The attributes are standard
	// Amazon Connect attributes, and can be accessed in contact flows just like
	// any other contact attributes.
	//
	// There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact.
	// Attribute keys can include only alphanumeric, dash, and underscore characters.
	Attributes map[string]*string `type:"map"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// The identifier of the contact flow for the chat.
	//
	// ContactFlowId is a required field
	ContactFlowId *string `type:"string" required:"true"`

	// The initial message to be sent to the newly created chat.
	InitialMessage *ChatMessage `type:"structure"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`

	// Information identifying the participant.
	//
	// ParticipantDetails is a required field
	ParticipantDetails *ParticipantDetails `type:"structure" required:"true"`
}

// String returns the string representation
func (s StartChatContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartChatContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartChatContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartChatContactInput"}
	if s.ContactFlowId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactFlowId"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.ParticipantDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("ParticipantDetails"))
	}
	if s.InitialMessage != nil {
		if err := s.InitialMessage.Validate(); err != nil {
			invalidParams.AddNested("InitialMessage", err.(request.ErrInvalidParams))
		}
	}
	if s.ParticipantDetails != nil {
		if err := s.ParticipantDetails.Validate(); err != nil {
			invalidParams.AddNested("ParticipantDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *StartChatContactInput) SetAttributes(v map[string]*string) *StartChatContactInput {
	s.Attributes = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *StartChatContactInput) SetClientToken(v string) *StartChatContactInput {
	s.ClientToken = &v
	return s
}

// SetContactFlowId sets the ContactFlowId field's value.
func (s *StartChatContactInput) SetContactFlowId(v string) *StartChatContactInput {
	s.ContactFlowId = &v
	return s
}

// SetInitialMessage sets the InitialMessage field's value.
func (s *StartChatContactInput) SetInitialMessage(v *ChatMessage) *StartChatContactInput {
	s.InitialMessage = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *StartChatContactInput) SetInstanceId(v string) *StartChatContactInput {
	s.InstanceId = &v
	return s
}

// SetParticipantDetails sets the ParticipantDetails field's value.
func (s *StartChatContactInput) SetParticipantDetails(v *ParticipantDetails) *StartChatContactInput {
	s.ParticipantDetails = v
	return s
}

type StartChatContactOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of this contact within the Amazon Connect instance.
	ContactId *string `min:"1" type:"string"`

	// The identifier for a chat participant. The participantId for a chat participant
	// is the same throughout the chat lifecycle.
	ParticipantId *string `min:"1" type:"string"`

	// The token used by the chat participant to call CreateParticipantConnection
	// (https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html).
	// The participant token is valid for the lifetime of a chat participant.
	ParticipantToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartChatContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartChatContactOutput) GoString() string {
	return s.String()
}

// SetContactId sets the ContactId field's value.
func (s *StartChatContactOutput) SetContactId(v string) *StartChatContactOutput {
	s.ContactId = &v
	return s
}

// SetParticipantId sets the ParticipantId field's value.
func (s *StartChatContactOutput) SetParticipantId(v string) *StartChatContactOutput {
	s.ParticipantId = &v
	return s
}

// SetParticipantToken sets the ParticipantToken field's value.
func (s *StartChatContactOutput) SetParticipantToken(v string) *StartChatContactOutput {
	s.ParticipantToken = &v
	return s
}

type StartOutboundVoiceContactInput struct {
	_ struct{} `type:"structure"`

	// A custom key-value pair using an attribute map. The attributes are standard
	// Amazon Connect attributes, and can be accessed in contact flows just like
	// any other contact attributes.
	//
	// There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact.
	// Attribute keys can include only alphanumeric, dash, and underscore characters.
	Attributes map[string]*string `type:"map"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. The token is valid for 7 days after creation. If a contact
	// is already started, the contact ID is returned. If the contact is disconnected,
	// a new contact is started.
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// The identifier of the contact flow for the outbound call.
	//
	// ContactFlowId is a required field
	ContactFlowId *string `type:"string" required:"true"`

	// The phone number of the customer, in E.164 format.
	//
	// DestinationPhoneNumber is a required field
	DestinationPhoneNumber *string `type:"string" required:"true"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`

	// The queue for the call. If you specify a queue, the phone displayed for caller
	// ID is the phone number specified in the queue. If you do not specify a queue,
	// the queue defined in the contact flow is used. If you do not specify a queue,
	// you must specify a source phone number.
	QueueId *string `type:"string"`

	// The phone number associated with the Amazon Connect instance, in E.164 format.
	// If you do not specify a source phone number, you must specify a queue.
	SourcePhoneNumber *string `type:"string"`
}

// String returns the string representation
func (s StartOutboundVoiceContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartOutboundVoiceContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartOutboundVoiceContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartOutboundVoiceContactInput"}
	if s.ContactFlowId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactFlowId"))
	}
	if s.DestinationPhoneNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationPhoneNumber"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *StartOutboundVoiceContactInput) SetAttributes(v map[string]*string) *StartOutboundVoiceContactInput {
	s.Attributes = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *StartOutboundVoiceContactInput) SetClientToken(v string) *StartOutboundVoiceContactInput {
	s.ClientToken = &v
	return s
}

// SetContactFlowId sets the ContactFlowId field's value.
func (s *StartOutboundVoiceContactInput) SetContactFlowId(v string) *StartOutboundVoiceContactInput {
	s.ContactFlowId = &v
	return s
}

// SetDestinationPhoneNumber sets the DestinationPhoneNumber field's value.
func (s *StartOutboundVoiceContactInput) SetDestinationPhoneNumber(v string) *StartOutboundVoiceContactInput {
	s.DestinationPhoneNumber = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *StartOutboundVoiceContactInput) SetInstanceId(v string) *StartOutboundVoiceContactInput {
	s.InstanceId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *StartOutboundVoiceContactInput) SetQueueId(v string) *StartOutboundVoiceContactInput {
	s.QueueId = &v
	return s
}

// SetSourcePhoneNumber sets the SourcePhoneNumber field's value.
func (s *StartOutboundVoiceContactInput) SetSourcePhoneNumber(v string) *StartOutboundVoiceContactInput {
	s.SourcePhoneNumber = &v
	return s
}

type StartOutboundVoiceContactOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of this contact within the Amazon Connect instance.
	ContactId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartOutboundVoiceContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartOutboundVoiceContactOutput) GoString() string {
	return s.String()
}

// SetContactId sets the ContactId field's value.
func (s *StartOutboundVoiceContactOutput) SetContactId(v string) *StartOutboundVoiceContactOutput {
	s.ContactId = &v
	return s
}

type StopContactInput struct {
	_ struct{} `type:"structure"`

	// The ID of the contact.
	//
	// ContactId is a required field
	ContactId *string `min:"1" type:"string" required:"true"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopContactInput"}
	if s.ContactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactId"))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactId sets the ContactId field's value.
func (s *StopContactInput) SetContactId(v string) *StopContactInput {
	s.ContactId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *StopContactInput) SetInstanceId(v string) *StopContactInput {
	s.InstanceId = &v
	return s
}

type StopContactOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopContactOutput) GoString() string {
	return s.String()
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// One or more tags. For example, { "tags": {"key1":"value1", "key2":"value2"}
	// }.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Contains information about the threshold for service level metrics.
type Threshold struct {
	_ struct{} `type:"structure"`

	// The type of comparison. Only "less than" (LT) comparisons are supported.
	Comparison *string `type:"string" enum:"Comparison"`

	// The threshold value to compare.
	ThresholdValue *float64 `type:"double"`
}

// String returns the string representation
func (s Threshold) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Threshold) GoString() string {
	return s.String()
}

// SetComparison sets the Comparison field's value.
func (s *Threshold) SetComparison(v string) *Threshold {
	s.Comparison = &v
	return s
}

// SetThresholdValue sets the ThresholdValue field's value.
func (s *Threshold) SetThresholdValue(v float64) *Threshold {
	s.ThresholdValue = &v
	return s
}

// The throttling limit has been exceeded.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tag keys.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateContactAttributesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Connect attributes. These attributes can be accessed in contact
	// flows just like any other contact attributes.
	//
	// You can have up to 32,768 UTF-8 bytes across all attributes for a contact.
	// Attribute keys can include only alphanumeric, dash, and underscore characters.
	//
	// Attributes is a required field
	Attributes map[string]*string `type:"map" required:"true"`

	// The identifier of the contact. This is the identifier of the contact associated
	// with the first interaction with the contact center.
	//
	// InitialContactId is a required field
	InitialContactId *string `min:"1" type:"string" required:"true"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateContactAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateContactAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateContactAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateContactAttributesInput"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.InitialContactId == nil {
		invalidParams.Add(request.NewErrParamRequired("InitialContactId"))
	}
	if s.InitialContactId != nil && len(*s.InitialContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InitialContactId", 1))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *UpdateContactAttributesInput) SetAttributes(v map[string]*string) *UpdateContactAttributesInput {
	s.Attributes = v
	return s
}

// SetInitialContactId sets the InitialContactId field's value.
func (s *UpdateContactAttributesInput) SetInitialContactId(v string) *UpdateContactAttributesInput {
	s.InitialContactId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *UpdateContactAttributesInput) SetInstanceId(v string) *UpdateContactAttributesInput {
	s.InstanceId = &v
	return s
}

type UpdateContactAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateContactAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateContactAttributesOutput) GoString() string {
	return s.String()
}

type UpdateUserHierarchyInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the hierarchy group.
	HierarchyGroupId *string `type:"string"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The identifier of the user account.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"UserId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserHierarchyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserHierarchyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserHierarchyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserHierarchyInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHierarchyGroupId sets the HierarchyGroupId field's value.
func (s *UpdateUserHierarchyInput) SetHierarchyGroupId(v string) *UpdateUserHierarchyInput {
	s.HierarchyGroupId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *UpdateUserHierarchyInput) SetInstanceId(v string) *UpdateUserHierarchyInput {
	s.InstanceId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UpdateUserHierarchyInput) SetUserId(v string) *UpdateUserHierarchyInput {
	s.UserId = &v
	return s
}

type UpdateUserHierarchyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateUserHierarchyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserHierarchyOutput) GoString() string {
	return s.String()
}

type UpdateUserIdentityInfoInput struct {
	_ struct{} `type:"structure"`

	// The identity information for the user.
	//
	// IdentityInfo is a required field
	IdentityInfo *UserIdentityInfo `type:"structure" required:"true"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The identifier of the user account.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"UserId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserIdentityInfoInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserIdentityInfoInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserIdentityInfoInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserIdentityInfoInput"}
	if s.IdentityInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityInfo"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}
	if s.IdentityInfo != nil {
		if err := s.IdentityInfo.Validate(); err != nil {
			invalidParams.AddNested("IdentityInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityInfo sets the IdentityInfo field's value.
func (s *UpdateUserIdentityInfoInput) SetIdentityInfo(v *UserIdentityInfo) *UpdateUserIdentityInfoInput {
	s.IdentityInfo = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *UpdateUserIdentityInfoInput) SetInstanceId(v string) *UpdateUserIdentityInfoInput {
	s.InstanceId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UpdateUserIdentityInfoInput) SetUserId(v string) *UpdateUserIdentityInfoInput {
	s.UserId = &v
	return s
}

type UpdateUserIdentityInfoOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateUserIdentityInfoOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserIdentityInfoOutput) GoString() string {
	return s.String()
}

type UpdateUserPhoneConfigInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// Information about phone configuration settings for the user.
	//
	// PhoneConfig is a required field
	PhoneConfig *UserPhoneConfig `type:"structure" required:"true"`

	// The identifier of the user account.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"UserId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserPhoneConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserPhoneConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserPhoneConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserPhoneConfigInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.PhoneConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneConfig"))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}
	if s.PhoneConfig != nil {
		if err := s.PhoneConfig.Validate(); err != nil {
			invalidParams.AddNested("PhoneConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *UpdateUserPhoneConfigInput) SetInstanceId(v string) *UpdateUserPhoneConfigInput {
	s.InstanceId = &v
	return s
}

// SetPhoneConfig sets the PhoneConfig field's value.
func (s *UpdateUserPhoneConfigInput) SetPhoneConfig(v *UserPhoneConfig) *UpdateUserPhoneConfigInput {
	s.PhoneConfig = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UpdateUserPhoneConfigInput) SetUserId(v string) *UpdateUserPhoneConfigInput {
	s.UserId = &v
	return s
}

type UpdateUserPhoneConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateUserPhoneConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserPhoneConfigOutput) GoString() string {
	return s.String()
}

type UpdateUserRoutingProfileInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The identifier of the routing profile for the user.
	//
	// RoutingProfileId is a required field
	RoutingProfileId *string `type:"string" required:"true"`

	// The identifier of the user account.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"UserId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserRoutingProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserRoutingProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserRoutingProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserRoutingProfileInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.RoutingProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingProfileId"))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *UpdateUserRoutingProfileInput) SetInstanceId(v string) *UpdateUserRoutingProfileInput {
	s.InstanceId = &v
	return s
}

// SetRoutingProfileId sets the RoutingProfileId field's value.
func (s *UpdateUserRoutingProfileInput) SetRoutingProfileId(v string) *UpdateUserRoutingProfileInput {
	s.RoutingProfileId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UpdateUserRoutingProfileInput) SetUserId(v string) *UpdateUserRoutingProfileInput {
	s.UserId = &v
	return s
}

type UpdateUserRoutingProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateUserRoutingProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserRoutingProfileOutput) GoString() string {
	return s.String()
}

type UpdateUserSecurityProfilesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The identifiers of the security profiles for the user.
	//
	// SecurityProfileIds is a required field
	SecurityProfileIds []*string `min:"1" type:"list" required:"true"`

	// The identifier of the user account.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"UserId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserSecurityProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserSecurityProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserSecurityProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserSecurityProfilesInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.SecurityProfileIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityProfileIds"))
	}
	if s.SecurityProfileIds != nil && len(s.SecurityProfileIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityProfileIds", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *UpdateUserSecurityProfilesInput) SetInstanceId(v string) *UpdateUserSecurityProfilesInput {
	s.InstanceId = &v
	return s
}

// SetSecurityProfileIds sets the SecurityProfileIds field's value.
func (s *UpdateUserSecurityProfilesInput) SetSecurityProfileIds(v []*string) *UpdateUserSecurityProfilesInput {
	s.SecurityProfileIds = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UpdateUserSecurityProfilesInput) SetUserId(v string) *UpdateUserSecurityProfilesInput {
	s.UserId = &v
	return s
}

type UpdateUserSecurityProfilesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateUserSecurityProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserSecurityProfilesOutput) GoString() string {
	return s.String()
}

// Contains information about a user account for a Amazon Connect instance.
type User struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the user account.
	Arn *string `type:"string"`

	// The identifier of the user account in the directory used for identity management.
	DirectoryUserId *string `type:"string"`

	// The identifier of the hierarchy group for the user.
	HierarchyGroupId *string `type:"string"`

	// The identifier of the user account.
	Id *string `type:"string"`

	// Information about the user identity.
	IdentityInfo *UserIdentityInfo `type:"structure"`

	// Information about the phone configuration for the user.
	PhoneConfig *UserPhoneConfig `type:"structure"`

	// The identifier of the routing profile for the user.
	RoutingProfileId *string `type:"string"`

	// The identifiers of the security profiles for the user.
	SecurityProfileIds []*string `min:"1" type:"list"`

	// The tags.
	Tags map[string]*string `min:"1" type:"map"`

	// The user name assigned to the user account.
	Username *string `min:"1" type:"string"`
}

// String returns the string representation
func (s User) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s User) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *User) SetArn(v string) *User {
	s.Arn = &v
	return s
}

// SetDirectoryUserId sets the DirectoryUserId field's value.
func (s *User) SetDirectoryUserId(v string) *User {
	s.DirectoryUserId = &v
	return s
}

// SetHierarchyGroupId sets the HierarchyGroupId field's value.
func (s *User) SetHierarchyGroupId(v string) *User {
	s.HierarchyGroupId = &v
	return s
}

// SetId sets the Id field's value.
func (s *User) SetId(v string) *User {
	s.Id = &v
	return s
}

// SetIdentityInfo sets the IdentityInfo field's value.
func (s *User) SetIdentityInfo(v *UserIdentityInfo) *User {
	s.IdentityInfo = v
	return s
}

// SetPhoneConfig sets the PhoneConfig field's value.
func (s *User) SetPhoneConfig(v *UserPhoneConfig) *User {
	s.PhoneConfig = v
	return s
}

// SetRoutingProfileId sets the RoutingProfileId field's value.
func (s *User) SetRoutingProfileId(v string) *User {
	s.RoutingProfileId = &v
	return s
}

// SetSecurityProfileIds sets the SecurityProfileIds field's value.
func (s *User) SetSecurityProfileIds(v []*string) *User {
	s.SecurityProfileIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *User) SetTags(v map[string]*string) *User {
	s.Tags = v
	return s
}

// SetUsername sets the Username field's value.
func (s *User) SetUsername(v string) *User {
	s.Username = &v
	return s
}

// Contains information about the identity of a user.
type UserIdentityInfo struct {
	_ struct{} `type:"structure"`

	// The email address. If you are using SAML for identity management and include
	// this parameter, an error is returned.
	Email *string `type:"string"`

	// The first name. This is required if you are using Amazon Connect or SAML
	// for identity management.
	FirstName *string `min:"1" type:"string"`

	// The last name. This is required if you are using Amazon Connect or SAML for
	// identity management.
	LastName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UserIdentityInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserIdentityInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserIdentityInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserIdentityInfo"}
	if s.FirstName != nil && len(*s.FirstName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirstName", 1))
	}
	if s.LastName != nil && len(*s.LastName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LastName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmail sets the Email field's value.
func (s *UserIdentityInfo) SetEmail(v string) *UserIdentityInfo {
	s.Email = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *UserIdentityInfo) SetFirstName(v string) *UserIdentityInfo {
	s.FirstName = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *UserIdentityInfo) SetLastName(v string) *UserIdentityInfo {
	s.LastName = &v
	return s
}

// No user with the specified credentials was found in the Amazon Connect instance.
type UserNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s UserNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserNotFoundException) GoString() string {
	return s.String()
}

func newErrorUserNotFoundException(v protocol.ResponseMetadata) error {
	return &UserNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UserNotFoundException) Code() string {
	return "UserNotFoundException"
}

// Message returns the exception's message.
func (s *UserNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UserNotFoundException) OrigErr() error {
	return nil
}

func (s *UserNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UserNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UserNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about the phone configuration settings for a user.
type UserPhoneConfig struct {
	_ struct{} `type:"structure"`

	// The After Call Work (ACW) timeout setting, in seconds.
	AfterContactWorkTimeLimit *int64 `type:"integer"`

	// The Auto accept setting.
	AutoAccept *bool `type:"boolean"`

	// The phone number for the user's desk phone.
	DeskPhoneNumber *string `type:"string"`

	// The phone type.
	//
	// PhoneType is a required field
	PhoneType *string `type:"string" required:"true" enum:"PhoneType"`
}

// String returns the string representation
func (s UserPhoneConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserPhoneConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserPhoneConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserPhoneConfig"}
	if s.PhoneType == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterContactWorkTimeLimit sets the AfterContactWorkTimeLimit field's value.
func (s *UserPhoneConfig) SetAfterContactWorkTimeLimit(v int64) *UserPhoneConfig {
	s.AfterContactWorkTimeLimit = &v
	return s
}

// SetAutoAccept sets the AutoAccept field's value.
func (s *UserPhoneConfig) SetAutoAccept(v bool) *UserPhoneConfig {
	s.AutoAccept = &v
	return s
}

// SetDeskPhoneNumber sets the DeskPhoneNumber field's value.
func (s *UserPhoneConfig) SetDeskPhoneNumber(v string) *UserPhoneConfig {
	s.DeskPhoneNumber = &v
	return s
}

// SetPhoneType sets the PhoneType field's value.
func (s *UserPhoneConfig) SetPhoneType(v string) *UserPhoneConfig {
	s.PhoneType = &v
	return s
}

// Contains summary information about a user.
type UserSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the user account.
	Arn *string `type:"string"`

	// The identifier of the user account.
	Id *string `type:"string"`

	// The Amazon Connect user name of the user account.
	Username *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UserSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UserSummary) SetArn(v string) *UserSummary {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *UserSummary) SetId(v string) *UserSummary {
	s.Id = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *UserSummary) SetUsername(v string) *UserSummary {
	s.Username = &v
	return s
}

const (
	// ChannelVoice is a Channel enum value
	ChannelVoice = "VOICE"

	// ChannelChat is a Channel enum value
	ChannelChat = "CHAT"
)

const (
	// ComparisonLt is a Comparison enum value
	ComparisonLt = "LT"
)

const (
	// ContactFlowTypeContactFlow is a ContactFlowType enum value
	ContactFlowTypeContactFlow = "CONTACT_FLOW"

	// ContactFlowTypeCustomerQueue is a ContactFlowType enum value
	ContactFlowTypeCustomerQueue = "CUSTOMER_QUEUE"

	// ContactFlowTypeCustomerHold is a ContactFlowType enum value
	ContactFlowTypeCustomerHold = "CUSTOMER_HOLD"

	// ContactFlowTypeCustomerWhisper is a ContactFlowType enum value
	ContactFlowTypeCustomerWhisper = "CUSTOMER_WHISPER"

	// ContactFlowTypeAgentHold is a ContactFlowType enum value
	ContactFlowTypeAgentHold = "AGENT_HOLD"

	// ContactFlowTypeAgentWhisper is a ContactFlowType enum value
	ContactFlowTypeAgentWhisper = "AGENT_WHISPER"

	// ContactFlowTypeOutboundWhisper is a ContactFlowType enum value
	ContactFlowTypeOutboundWhisper = "OUTBOUND_WHISPER"

	// ContactFlowTypeAgentTransfer is a ContactFlowType enum value
	ContactFlowTypeAgentTransfer = "AGENT_TRANSFER"

	// ContactFlowTypeQueueTransfer is a ContactFlowType enum value
	ContactFlowTypeQueueTransfer = "QUEUE_TRANSFER"
)

// The current metric names.
const (
	// CurrentMetricNameAgentsOnline is a CurrentMetricName enum value
	CurrentMetricNameAgentsOnline = "AGENTS_ONLINE"

	// CurrentMetricNameAgentsAvailable is a CurrentMetricName enum value
	CurrentMetricNameAgentsAvailable = "AGENTS_AVAILABLE"

	// CurrentMetricNameAgentsOnCall is a CurrentMetricName enum value
	CurrentMetricNameAgentsOnCall = "AGENTS_ON_CALL"

	// CurrentMetricNameAgentsNonProductive is a CurrentMetricName enum value
	CurrentMetricNameAgentsNonProductive = "AGENTS_NON_PRODUCTIVE"

	// CurrentMetricNameAgentsAfterContactWork is a CurrentMetricName enum value
	CurrentMetricNameAgentsAfterContactWork = "AGENTS_AFTER_CONTACT_WORK"

	// CurrentMetricNameAgentsError is a CurrentMetricName enum value
	CurrentMetricNameAgentsError = "AGENTS_ERROR"

	// CurrentMetricNameAgentsStaffed is a CurrentMetricName enum value
	CurrentMetricNameAgentsStaffed = "AGENTS_STAFFED"

	// CurrentMetricNameContactsInQueue is a CurrentMetricName enum value
	CurrentMetricNameContactsInQueue = "CONTACTS_IN_QUEUE"

	// CurrentMetricNameOldestContactAge is a CurrentMetricName enum value
	CurrentMetricNameOldestContactAge = "OLDEST_CONTACT_AGE"

	// CurrentMetricNameContactsScheduled is a CurrentMetricName enum value
	CurrentMetricNameContactsScheduled = "CONTACTS_SCHEDULED"

	// CurrentMetricNameAgentsOnContact is a CurrentMetricName enum value
	CurrentMetricNameAgentsOnContact = "AGENTS_ON_CONTACT"

	// CurrentMetricNameSlotsActive is a CurrentMetricName enum value
	CurrentMetricNameSlotsActive = "SLOTS_ACTIVE"

	// CurrentMetricNameSlotsAvailable is a CurrentMetricName enum value
	CurrentMetricNameSlotsAvailable = "SLOTS_AVAILABLE"
)

const (
	// GroupingQueue is a Grouping enum value
	GroupingQueue = "QUEUE"

	// GroupingChannel is a Grouping enum value
	GroupingChannel = "CHANNEL"
)

// The historical metric names.
const (
	// HistoricalMetricNameContactsQueued is a HistoricalMetricName enum value
	HistoricalMetricNameContactsQueued = "CONTACTS_QUEUED"

	// HistoricalMetricNameContactsHandled is a HistoricalMetricName enum value
	HistoricalMetricNameContactsHandled = "CONTACTS_HANDLED"

	// HistoricalMetricNameContactsAbandoned is a HistoricalMetricName enum value
	HistoricalMetricNameContactsAbandoned = "CONTACTS_ABANDONED"

	// HistoricalMetricNameContactsConsulted is a HistoricalMetricName enum value
	HistoricalMetricNameContactsConsulted = "CONTACTS_CONSULTED"

	// HistoricalMetricNameContactsAgentHungUpFirst is a HistoricalMetricName enum value
	HistoricalMetricNameContactsAgentHungUpFirst = "CONTACTS_AGENT_HUNG_UP_FIRST"

	// HistoricalMetricNameContactsHandledIncoming is a HistoricalMetricName enum value
	HistoricalMetricNameContactsHandledIncoming = "CONTACTS_HANDLED_INCOMING"

	// HistoricalMetricNameContactsHandledOutbound is a HistoricalMetricName enum value
	HistoricalMetricNameContactsHandledOutbound = "CONTACTS_HANDLED_OUTBOUND"

	// HistoricalMetricNameContactsHoldAbandons is a HistoricalMetricName enum value
	HistoricalMetricNameContactsHoldAbandons = "CONTACTS_HOLD_ABANDONS"

	// HistoricalMetricNameContactsTransferredIn is a HistoricalMetricName enum value
	HistoricalMetricNameContactsTransferredIn = "CONTACTS_TRANSFERRED_IN"

	// HistoricalMetricNameContactsTransferredOut is a HistoricalMetricName enum value
	HistoricalMetricNameContactsTransferredOut = "CONTACTS_TRANSFERRED_OUT"

	// HistoricalMetricNameContactsTransferredInFromQueue is a HistoricalMetricName enum value
	HistoricalMetricNameContactsTransferredInFromQueue = "CONTACTS_TRANSFERRED_IN_FROM_QUEUE"

	// HistoricalMetricNameContactsTransferredOutFromQueue is a HistoricalMetricName enum value
	HistoricalMetricNameContactsTransferredOutFromQueue = "CONTACTS_TRANSFERRED_OUT_FROM_QUEUE"

	// HistoricalMetricNameContactsMissed is a HistoricalMetricName enum value
	HistoricalMetricNameContactsMissed = "CONTACTS_MISSED"

	// HistoricalMetricNameCallbackContactsHandled is a HistoricalMetricName enum value
	HistoricalMetricNameCallbackContactsHandled = "CALLBACK_CONTACTS_HANDLED"

	// HistoricalMetricNameApiContactsHandled is a HistoricalMetricName enum value
	HistoricalMetricNameApiContactsHandled = "API_CONTACTS_HANDLED"

	// HistoricalMetricNameOccupancy is a HistoricalMetricName enum value
	HistoricalMetricNameOccupancy = "OCCUPANCY"

	// HistoricalMetricNameHandleTime is a HistoricalMetricName enum value
	HistoricalMetricNameHandleTime = "HANDLE_TIME"

	// HistoricalMetricNameAfterContactWorkTime is a HistoricalMetricName enum value
	HistoricalMetricNameAfterContactWorkTime = "AFTER_CONTACT_WORK_TIME"

	// HistoricalMetricNameQueuedTime is a HistoricalMetricName enum value
	HistoricalMetricNameQueuedTime = "QUEUED_TIME"

	// HistoricalMetricNameAbandonTime is a HistoricalMetricName enum value
	HistoricalMetricNameAbandonTime = "ABANDON_TIME"

	// HistoricalMetricNameQueueAnswerTime is a HistoricalMetricName enum value
	HistoricalMetricNameQueueAnswerTime = "QUEUE_ANSWER_TIME"

	// HistoricalMetricNameHoldTime is a HistoricalMetricName enum value
	HistoricalMetricNameHoldTime = "HOLD_TIME"

	// HistoricalMetricNameInteractionTime is a HistoricalMetricName enum value
	HistoricalMetricNameInteractionTime = "INTERACTION_TIME"

	// HistoricalMetricNameInteractionAndHoldTime is a HistoricalMetricName enum value
	HistoricalMetricNameInteractionAndHoldTime = "INTERACTION_AND_HOLD_TIME"

	// HistoricalMetricNameServiceLevel is a HistoricalMetricName enum value
	HistoricalMetricNameServiceLevel = "SERVICE_LEVEL"
)

const (
	// PhoneNumberCountryCodeAf is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeAf = "AF"

	// PhoneNumberCountryCodeAl is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeAl = "AL"

	// PhoneNumberCountryCodeDz is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeDz = "DZ"

	// PhoneNumberCountryCodeAs is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeAs = "AS"

	// PhoneNumberCountryCodeAd is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeAd = "AD"

	// PhoneNumberCountryCodeAo is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeAo = "AO"

	// PhoneNumberCountryCodeAi is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeAi = "AI"

	// PhoneNumberCountryCodeAq is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeAq = "AQ"

	// PhoneNumberCountryCodeAg is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeAg = "AG"

	// PhoneNumberCountryCodeAr is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeAr = "AR"

	// PhoneNumberCountryCodeAm is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeAm = "AM"

	// PhoneNumberCountryCodeAw is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeAw = "AW"

	// PhoneNumberCountryCodeAu is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeAu = "AU"

	// PhoneNumberCountryCodeAt is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeAt = "AT"

	// PhoneNumberCountryCodeAz is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeAz = "AZ"

	// PhoneNumberCountryCodeBs is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeBs = "BS"

	// PhoneNumberCountryCodeBh is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeBh = "BH"

	// PhoneNumberCountryCodeBd is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeBd = "BD"

	// PhoneNumberCountryCodeBb is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeBb = "BB"

	// PhoneNumberCountryCodeBy is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeBy = "BY"

	// PhoneNumberCountryCodeBe is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeBe = "BE"

	// PhoneNumberCountryCodeBz is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeBz = "BZ"

	// PhoneNumberCountryCodeBj is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeBj = "BJ"

	// PhoneNumberCountryCodeBm is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeBm = "BM"

	// PhoneNumberCountryCodeBt is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeBt = "BT"

	// PhoneNumberCountryCodeBo is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeBo = "BO"

	// PhoneNumberCountryCodeBa is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeBa = "BA"

	// PhoneNumberCountryCodeBw is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeBw = "BW"

	// PhoneNumberCountryCodeBr is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeBr = "BR"

	// PhoneNumberCountryCodeIo is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeIo = "IO"

	// PhoneNumberCountryCodeVg is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeVg = "VG"

	// PhoneNumberCountryCodeBn is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeBn = "BN"

	// PhoneNumberCountryCodeBg is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeBg = "BG"

	// PhoneNumberCountryCodeBf is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeBf = "BF"

	// PhoneNumberCountryCodeBi is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeBi = "BI"

	// PhoneNumberCountryCodeKh is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeKh = "KH"

	// PhoneNumberCountryCodeCm is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeCm = "CM"

	// PhoneNumberCountryCodeCa is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeCa = "CA"

	// PhoneNumberCountryCodeCv is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeCv = "CV"

	// PhoneNumberCountryCodeKy is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeKy = "KY"

	// PhoneNumberCountryCodeCf is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeCf = "CF"

	// PhoneNumberCountryCodeTd is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeTd = "TD"

	// PhoneNumberCountryCodeCl is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeCl = "CL"

	// PhoneNumberCountryCodeCn is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeCn = "CN"

	// PhoneNumberCountryCodeCx is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeCx = "CX"

	// PhoneNumberCountryCodeCc is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeCc = "CC"

	// PhoneNumberCountryCodeCo is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeCo = "CO"

	// PhoneNumberCountryCodeKm is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeKm = "KM"

	// PhoneNumberCountryCodeCk is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeCk = "CK"

	// PhoneNumberCountryCodeCr is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeCr = "CR"

	// PhoneNumberCountryCodeHr is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeHr = "HR"

	// PhoneNumberCountryCodeCu is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeCu = "CU"

	// PhoneNumberCountryCodeCw is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeCw = "CW"

	// PhoneNumberCountryCodeCy is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeCy = "CY"

	// PhoneNumberCountryCodeCz is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeCz = "CZ"

	// PhoneNumberCountryCodeCd is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeCd = "CD"

	// PhoneNumberCountryCodeDk is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeDk = "DK"

	// PhoneNumberCountryCodeDj is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeDj = "DJ"

	// PhoneNumberCountryCodeDm is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeDm = "DM"

	// PhoneNumberCountryCodeDo is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeDo = "DO"

	// PhoneNumberCountryCodeTl is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeTl = "TL"

	// PhoneNumberCountryCodeEc is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeEc = "EC"

	// PhoneNumberCountryCodeEg is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeEg = "EG"

	// PhoneNumberCountryCodeSv is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeSv = "SV"

	// PhoneNumberCountryCodeGq is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeGq = "GQ"

	// PhoneNumberCountryCodeEr is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeEr = "ER"

	// PhoneNumberCountryCodeEe is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeEe = "EE"

	// PhoneNumberCountryCodeEt is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeEt = "ET"

	// PhoneNumberCountryCodeFk is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeFk = "FK"

	// PhoneNumberCountryCodeFo is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeFo = "FO"

	// PhoneNumberCountryCodeFj is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeFj = "FJ"

	// PhoneNumberCountryCodeFi is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeFi = "FI"

	// PhoneNumberCountryCodeFr is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeFr = "FR"

	// PhoneNumberCountryCodePf is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodePf = "PF"

	// PhoneNumberCountryCodeGa is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeGa = "GA"

	// PhoneNumberCountryCodeGm is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeGm = "GM"

	// PhoneNumberCountryCodeGe is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeGe = "GE"

	// PhoneNumberCountryCodeDe is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeDe = "DE"

	// PhoneNumberCountryCodeGh is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeGh = "GH"

	// PhoneNumberCountryCodeGi is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeGi = "GI"

	// PhoneNumberCountryCodeGr is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeGr = "GR"

	// PhoneNumberCountryCodeGl is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeGl = "GL"

	// PhoneNumberCountryCodeGd is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeGd = "GD"

	// PhoneNumberCountryCodeGu is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeGu = "GU"

	// PhoneNumberCountryCodeGt is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeGt = "GT"

	// PhoneNumberCountryCodeGg is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeGg = "GG"

	// PhoneNumberCountryCodeGn is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeGn = "GN"

	// PhoneNumberCountryCodeGw is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeGw = "GW"

	// PhoneNumberCountryCodeGy is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeGy = "GY"

	// PhoneNumberCountryCodeHt is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeHt = "HT"

	// PhoneNumberCountryCodeHn is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeHn = "HN"

	// PhoneNumberCountryCodeHk is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeHk = "HK"

	// PhoneNumberCountryCodeHu is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeHu = "HU"

	// PhoneNumberCountryCodeIs is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeIs = "IS"

	// PhoneNumberCountryCodeIn is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeIn = "IN"

	// PhoneNumberCountryCodeId is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeId = "ID"

	// PhoneNumberCountryCodeIr is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeIr = "IR"

	// PhoneNumberCountryCodeIq is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeIq = "IQ"

	// PhoneNumberCountryCodeIe is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeIe = "IE"

	// PhoneNumberCountryCodeIm is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeIm = "IM"

	// PhoneNumberCountryCodeIl is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeIl = "IL"

	// PhoneNumberCountryCodeIt is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeIt = "IT"

	// PhoneNumberCountryCodeCi is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeCi = "CI"

	// PhoneNumberCountryCodeJm is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeJm = "JM"

	// PhoneNumberCountryCodeJp is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeJp = "JP"

	// PhoneNumberCountryCodeJe is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeJe = "JE"

	// PhoneNumberCountryCodeJo is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeJo = "JO"

	// PhoneNumberCountryCodeKz is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeKz = "KZ"

	// PhoneNumberCountryCodeKe is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeKe = "KE"

	// PhoneNumberCountryCodeKi is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeKi = "KI"

	// PhoneNumberCountryCodeKw is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeKw = "KW"

	// PhoneNumberCountryCodeKg is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeKg = "KG"

	// PhoneNumberCountryCodeLa is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeLa = "LA"

	// PhoneNumberCountryCodeLv is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeLv = "LV"

	// PhoneNumberCountryCodeLb is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeLb = "LB"

	// PhoneNumberCountryCodeLs is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeLs = "LS"

	// PhoneNumberCountryCodeLr is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeLr = "LR"

	// PhoneNumberCountryCodeLy is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeLy = "LY"

	// PhoneNumberCountryCodeLi is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeLi = "LI"

	// PhoneNumberCountryCodeLt is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeLt = "LT"

	// PhoneNumberCountryCodeLu is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeLu = "LU"

	// PhoneNumberCountryCodeMo is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeMo = "MO"

	// PhoneNumberCountryCodeMk is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeMk = "MK"

	// PhoneNumberCountryCodeMg is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeMg = "MG"

	// PhoneNumberCountryCodeMw is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeMw = "MW"

	// PhoneNumberCountryCodeMy is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeMy = "MY"

	// PhoneNumberCountryCodeMv is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeMv = "MV"

	// PhoneNumberCountryCodeMl is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeMl = "ML"

	// PhoneNumberCountryCodeMt is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeMt = "MT"

	// PhoneNumberCountryCodeMh is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeMh = "MH"

	// PhoneNumberCountryCodeMr is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeMr = "MR"

	// PhoneNumberCountryCodeMu is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeMu = "MU"

	// PhoneNumberCountryCodeYt is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeYt = "YT"

	// PhoneNumberCountryCodeMx is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeMx = "MX"

	// PhoneNumberCountryCodeFm is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeFm = "FM"

	// PhoneNumberCountryCodeMd is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeMd = "MD"

	// PhoneNumberCountryCodeMc is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeMc = "MC"

	// PhoneNumberCountryCodeMn is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeMn = "MN"

	// PhoneNumberCountryCodeMe is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeMe = "ME"

	// PhoneNumberCountryCodeMs is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeMs = "MS"

	// PhoneNumberCountryCodeMa is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeMa = "MA"

	// PhoneNumberCountryCodeMz is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeMz = "MZ"

	// PhoneNumberCountryCodeMm is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeMm = "MM"

	// PhoneNumberCountryCodeNa is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeNa = "NA"

	// PhoneNumberCountryCodeNr is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeNr = "NR"

	// PhoneNumberCountryCodeNp is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeNp = "NP"

	// PhoneNumberCountryCodeNl is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeNl = "NL"

	// PhoneNumberCountryCodeAn is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeAn = "AN"

	// PhoneNumberCountryCodeNc is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeNc = "NC"

	// PhoneNumberCountryCodeNz is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeNz = "NZ"

	// PhoneNumberCountryCodeNi is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeNi = "NI"

	// PhoneNumberCountryCodeNe is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeNe = "NE"

	// PhoneNumberCountryCodeNg is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeNg = "NG"

	// PhoneNumberCountryCodeNu is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeNu = "NU"

	// PhoneNumberCountryCodeKp is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeKp = "KP"

	// PhoneNumberCountryCodeMp is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeMp = "MP"

	// PhoneNumberCountryCodeNo is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeNo = "NO"

	// PhoneNumberCountryCodeOm is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeOm = "OM"

	// PhoneNumberCountryCodePk is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodePk = "PK"

	// PhoneNumberCountryCodePw is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodePw = "PW"

	// PhoneNumberCountryCodePa is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodePa = "PA"

	// PhoneNumberCountryCodePg is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodePg = "PG"

	// PhoneNumberCountryCodePy is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodePy = "PY"

	// PhoneNumberCountryCodePe is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodePe = "PE"

	// PhoneNumberCountryCodePh is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodePh = "PH"

	// PhoneNumberCountryCodePn is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodePn = "PN"

	// PhoneNumberCountryCodePl is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodePl = "PL"

	// PhoneNumberCountryCodePt is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodePt = "PT"

	// PhoneNumberCountryCodePr is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodePr = "PR"

	// PhoneNumberCountryCodeQa is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeQa = "QA"

	// PhoneNumberCountryCodeCg is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeCg = "CG"

	// PhoneNumberCountryCodeRe is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeRe = "RE"

	// PhoneNumberCountryCodeRo is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeRo = "RO"

	// PhoneNumberCountryCodeRu is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeRu = "RU"

	// PhoneNumberCountryCodeRw is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeRw = "RW"

	// PhoneNumberCountryCodeBl is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeBl = "BL"

	// PhoneNumberCountryCodeSh is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeSh = "SH"

	// PhoneNumberCountryCodeKn is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeKn = "KN"

	// PhoneNumberCountryCodeLc is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeLc = "LC"

	// PhoneNumberCountryCodeMf is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeMf = "MF"

	// PhoneNumberCountryCodePm is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodePm = "PM"

	// PhoneNumberCountryCodeVc is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeVc = "VC"

	// PhoneNumberCountryCodeWs is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeWs = "WS"

	// PhoneNumberCountryCodeSm is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeSm = "SM"

	// PhoneNumberCountryCodeSt is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeSt = "ST"

	// PhoneNumberCountryCodeSa is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeSa = "SA"

	// PhoneNumberCountryCodeSn is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeSn = "SN"

	// PhoneNumberCountryCodeRs is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeRs = "RS"

	// PhoneNumberCountryCodeSc is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeSc = "SC"

	// PhoneNumberCountryCodeSl is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeSl = "SL"

	// PhoneNumberCountryCodeSg is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeSg = "SG"

	// PhoneNumberCountryCodeSx is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeSx = "SX"

	// PhoneNumberCountryCodeSk is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeSk = "SK"

	// PhoneNumberCountryCodeSi is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeSi = "SI"

	// PhoneNumberCountryCodeSb is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeSb = "SB"

	// PhoneNumberCountryCodeSo is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeSo = "SO"

	// PhoneNumberCountryCodeZa is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeZa = "ZA"

	// PhoneNumberCountryCodeKr is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeKr = "KR"

	// PhoneNumberCountryCodeEs is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeEs = "ES"

	// PhoneNumberCountryCodeLk is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeLk = "LK"

	// PhoneNumberCountryCodeSd is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeSd = "SD"

	// PhoneNumberCountryCodeSr is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeSr = "SR"

	// PhoneNumberCountryCodeSj is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeSj = "SJ"

	// PhoneNumberCountryCodeSz is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeSz = "SZ"

	// PhoneNumberCountryCodeSe is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeSe = "SE"

	// PhoneNumberCountryCodeCh is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeCh = "CH"

	// PhoneNumberCountryCodeSy is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeSy = "SY"

	// PhoneNumberCountryCodeTw is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeTw = "TW"

	// PhoneNumberCountryCodeTj is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeTj = "TJ"

	// PhoneNumberCountryCodeTz is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeTz = "TZ"

	// PhoneNumberCountryCodeTh is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeTh = "TH"

	// PhoneNumberCountryCodeTg is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeTg = "TG"

	// PhoneNumberCountryCodeTk is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeTk = "TK"

	// PhoneNumberCountryCodeTo is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeTo = "TO"

	// PhoneNumberCountryCodeTt is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeTt = "TT"

	// PhoneNumberCountryCodeTn is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeTn = "TN"

	// PhoneNumberCountryCodeTr is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeTr = "TR"

	// PhoneNumberCountryCodeTm is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeTm = "TM"

	// PhoneNumberCountryCodeTc is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeTc = "TC"

	// PhoneNumberCountryCodeTv is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeTv = "TV"

	// PhoneNumberCountryCodeVi is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeVi = "VI"

	// PhoneNumberCountryCodeUg is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeUg = "UG"

	// PhoneNumberCountryCodeUa is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeUa = "UA"

	// PhoneNumberCountryCodeAe is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeAe = "AE"

	// PhoneNumberCountryCodeGb is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeGb = "GB"

	// PhoneNumberCountryCodeUs is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeUs = "US"

	// PhoneNumberCountryCodeUy is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeUy = "UY"

	// PhoneNumberCountryCodeUz is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeUz = "UZ"

	// PhoneNumberCountryCodeVu is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeVu = "VU"

	// PhoneNumberCountryCodeVa is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeVa = "VA"

	// PhoneNumberCountryCodeVe is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeVe = "VE"

	// PhoneNumberCountryCodeVn is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeVn = "VN"

	// PhoneNumberCountryCodeWf is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeWf = "WF"

	// PhoneNumberCountryCodeEh is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeEh = "EH"

	// PhoneNumberCountryCodeYe is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeYe = "YE"

	// PhoneNumberCountryCodeZm is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeZm = "ZM"

	// PhoneNumberCountryCodeZw is a PhoneNumberCountryCode enum value
	PhoneNumberCountryCodeZw = "ZW"
)

const (
	// PhoneNumberTypeTollFree is a PhoneNumberType enum value
	PhoneNumberTypeTollFree = "TOLL_FREE"

	// PhoneNumberTypeDid is a PhoneNumberType enum value
	PhoneNumberTypeDid = "DID"
)

const (
	// PhoneTypeSoftPhone is a PhoneType enum value
	PhoneTypeSoftPhone = "SOFT_PHONE"

	// PhoneTypeDeskPhone is a PhoneType enum value
	PhoneTypeDeskPhone = "DESK_PHONE"
)

const (
	// QueueTypeStandard is a QueueType enum value
	QueueTypeStandard = "STANDARD"

	// QueueTypeAgent is a QueueType enum value
	QueueTypeAgent = "AGENT"
)

const (
	// StatisticSum is a Statistic enum value
	StatisticSum = "SUM"

	// StatisticMax is a Statistic enum value
	StatisticMax = "MAX"

	// StatisticAvg is a Statistic enum value
	StatisticAvg = "AVG"
)

const (
	// UnitSeconds is a Unit enum value
	UnitSeconds = "SECONDS"

	// UnitCount is a Unit enum value
	UnitCount = "COUNT"

	// UnitPercent is a Unit enum value
	UnitPercent = "PERCENT"
)
