// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/videointelligence/v1beta2/video_intelligence.proto

package videointelligence

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Video annotation feature.
type Feature int32

const (
	// Unspecified.
	Feature_FEATURE_UNSPECIFIED Feature = 0
	// Label detection. Detect objects, such as dog or flower.
	Feature_LABEL_DETECTION Feature = 1
	// Shot change detection.
	Feature_SHOT_CHANGE_DETECTION Feature = 2
	// Explicit content detection.
	Feature_EXPLICIT_CONTENT_DETECTION Feature = 3
	// Human face detection and tracking.
	Feature_FACE_DETECTION Feature = 4
)

var Feature_name = map[int32]string{
	0: "FEATURE_UNSPECIFIED",
	1: "LABEL_DETECTION",
	2: "SHOT_CHANGE_DETECTION",
	3: "EXPLICIT_CONTENT_DETECTION",
	4: "FACE_DETECTION",
}

var Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED":        0,
	"LABEL_DETECTION":            1,
	"SHOT_CHANGE_DETECTION":      2,
	"EXPLICIT_CONTENT_DETECTION": 3,
	"FACE_DETECTION":             4,
}

func (x Feature) String() string {
	return proto.EnumName(Feature_name, int32(x))
}

func (Feature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{0}
}

// Label detection mode.
type LabelDetectionMode int32

const (
	// Unspecified.
	LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED LabelDetectionMode = 0
	// Detect shot-level labels.
	LabelDetectionMode_SHOT_MODE LabelDetectionMode = 1
	// Detect frame-level labels.
	LabelDetectionMode_FRAME_MODE LabelDetectionMode = 2
	// Detect both shot-level and frame-level labels.
	LabelDetectionMode_SHOT_AND_FRAME_MODE LabelDetectionMode = 3
)

var LabelDetectionMode_name = map[int32]string{
	0: "LABEL_DETECTION_MODE_UNSPECIFIED",
	1: "SHOT_MODE",
	2: "FRAME_MODE",
	3: "SHOT_AND_FRAME_MODE",
}

var LabelDetectionMode_value = map[string]int32{
	"LABEL_DETECTION_MODE_UNSPECIFIED": 0,
	"SHOT_MODE":                        1,
	"FRAME_MODE":                       2,
	"SHOT_AND_FRAME_MODE":              3,
}

func (x LabelDetectionMode) String() string {
	return proto.EnumName(LabelDetectionMode_name, int32(x))
}

func (LabelDetectionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{1}
}

// Bucketized representation of likelihood.
type Likelihood int32

const (
	// Unspecified likelihood.
	Likelihood_LIKELIHOOD_UNSPECIFIED Likelihood = 0
	// Very unlikely.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// Unlikely.
	Likelihood_UNLIKELY Likelihood = 2
	// Possible.
	Likelihood_POSSIBLE Likelihood = 3
	// Likely.
	Likelihood_LIKELY Likelihood = 4
	// Very likely.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "LIKELIHOOD_UNSPECIFIED",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}

var Likelihood_value = map[string]int32{
	"LIKELIHOOD_UNSPECIFIED": 0,
	"VERY_UNLIKELY":          1,
	"UNLIKELY":               2,
	"POSSIBLE":               3,
	"LIKELY":                 4,
	"VERY_LIKELY":            5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}

func (Likelihood) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{2}
}

// Video annotation request.
type AnnotateVideoRequest struct {
	// Input video location. Currently, only
	// [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
	// supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
	// more information, see [Request URIs](https://cloud.google.com/storage/docs/request-endpoints). A video
	// URI may include wildcards in `object-id`, and thus identify multiple
	// videos. Supported wildcards: '*' to match 0 or more characters;
	// '?' to match 1 character. If unset, the input video should be embedded
	// in the request as `input_content`. If set, `input_content` should be unset.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// The video data bytes.
	// If unset, the input video(s) should be specified via `input_uri`.
	// If set, `input_uri` should be unset.
	InputContent []byte `protobuf:"bytes,6,opt,name=input_content,json=inputContent,proto3" json:"input_content,omitempty"`
	// Required. Requested video annotation features.
	Features []Feature `protobuf:"varint,2,rep,packed,name=features,proto3,enum=google.cloud.videointelligence.v1beta2.Feature" json:"features,omitempty"`
	// Additional video context and/or feature-specific parameters.
	VideoContext *VideoContext `protobuf:"bytes,3,opt,name=video_context,json=videoContext,proto3" json:"video_context,omitempty"`
	// Optional. Location where the output (in JSON format) should be stored.
	// Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
	// URIs are supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
	// more information, see [Request URIs](https://cloud.google.com/storage/docs/request-endpoints).
	OutputUri string `protobuf:"bytes,4,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Optional. Cloud region where annotation should take place. Supported cloud
	// regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
	// is specified, a region will be determined based on video file location.
	LocationId           string   `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AnnotateVideoRequest) Reset()         { *m = AnnotateVideoRequest{} }
func (m *AnnotateVideoRequest) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoRequest) ProtoMessage()    {}
func (*AnnotateVideoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{0}
}

func (m *AnnotateVideoRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoRequest.Unmarshal(m, b)
}
func (m *AnnotateVideoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoRequest.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoRequest.Merge(m, src)
}
func (m *AnnotateVideoRequest) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoRequest.Size(m)
}
func (m *AnnotateVideoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoRequest proto.InternalMessageInfo

func (m *AnnotateVideoRequest) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetInputContent() []byte {
	if m != nil {
		return m.InputContent
	}
	return nil
}

func (m *AnnotateVideoRequest) GetFeatures() []Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateVideoRequest) GetVideoContext() *VideoContext {
	if m != nil {
		return m.VideoContext
	}
	return nil
}

func (m *AnnotateVideoRequest) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

// Video context and/or feature-specific parameters.
type VideoContext struct {
	// Video segments to annotate. The segments may overlap and are not required
	// to be contiguous or span the whole video. If unspecified, each video is
	// treated as a single segment.
	Segments []*VideoSegment `protobuf:"bytes,1,rep,name=segments,proto3" json:"segments,omitempty"`
	// Config for LABEL_DETECTION.
	LabelDetectionConfig *LabelDetectionConfig `protobuf:"bytes,2,opt,name=label_detection_config,json=labelDetectionConfig,proto3" json:"label_detection_config,omitempty"`
	// Config for SHOT_CHANGE_DETECTION.
	ShotChangeDetectionConfig *ShotChangeDetectionConfig `protobuf:"bytes,3,opt,name=shot_change_detection_config,json=shotChangeDetectionConfig,proto3" json:"shot_change_detection_config,omitempty"`
	// Config for EXPLICIT_CONTENT_DETECTION.
	ExplicitContentDetectionConfig *ExplicitContentDetectionConfig `protobuf:"bytes,4,opt,name=explicit_content_detection_config,json=explicitContentDetectionConfig,proto3" json:"explicit_content_detection_config,omitempty"`
	// Config for FACE_DETECTION.
	FaceDetectionConfig  *FaceDetectionConfig `protobuf:"bytes,5,opt,name=face_detection_config,json=faceDetectionConfig,proto3" json:"face_detection_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *VideoContext) Reset()         { *m = VideoContext{} }
func (m *VideoContext) String() string { return proto.CompactTextString(m) }
func (*VideoContext) ProtoMessage()    {}
func (*VideoContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{1}
}

func (m *VideoContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoContext.Unmarshal(m, b)
}
func (m *VideoContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoContext.Marshal(b, m, deterministic)
}
func (m *VideoContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoContext.Merge(m, src)
}
func (m *VideoContext) XXX_Size() int {
	return xxx_messageInfo_VideoContext.Size(m)
}
func (m *VideoContext) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoContext.DiscardUnknown(m)
}

var xxx_messageInfo_VideoContext proto.InternalMessageInfo

func (m *VideoContext) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *VideoContext) GetLabelDetectionConfig() *LabelDetectionConfig {
	if m != nil {
		return m.LabelDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetShotChangeDetectionConfig() *ShotChangeDetectionConfig {
	if m != nil {
		return m.ShotChangeDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetExplicitContentDetectionConfig() *ExplicitContentDetectionConfig {
	if m != nil {
		return m.ExplicitContentDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetFaceDetectionConfig() *FaceDetectionConfig {
	if m != nil {
		return m.FaceDetectionConfig
	}
	return nil
}

// Config for LABEL_DETECTION.
type LabelDetectionConfig struct {
	// What labels should be detected with LABEL_DETECTION, in addition to
	// video-level labels or segment-level labels.
	// If unspecified, defaults to `SHOT_MODE`.
	LabelDetectionMode LabelDetectionMode `protobuf:"varint,1,opt,name=label_detection_mode,json=labelDetectionMode,proto3,enum=google.cloud.videointelligence.v1beta2.LabelDetectionMode" json:"label_detection_mode,omitempty"`
	// Whether the video has been shot from a stationary (i.e. non-moving) camera.
	// When set to true, might improve detection accuracy for moving objects.
	// Should be used with `SHOT_AND_FRAME_MODE` enabled.
	StationaryCamera bool `protobuf:"varint,2,opt,name=stationary_camera,json=stationaryCamera,proto3" json:"stationary_camera,omitempty"`
	// Model to use for label detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelDetectionConfig) Reset()         { *m = LabelDetectionConfig{} }
func (m *LabelDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*LabelDetectionConfig) ProtoMessage()    {}
func (*LabelDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{2}
}

func (m *LabelDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelDetectionConfig.Unmarshal(m, b)
}
func (m *LabelDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelDetectionConfig.Marshal(b, m, deterministic)
}
func (m *LabelDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelDetectionConfig.Merge(m, src)
}
func (m *LabelDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_LabelDetectionConfig.Size(m)
}
func (m *LabelDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_LabelDetectionConfig proto.InternalMessageInfo

func (m *LabelDetectionConfig) GetLabelDetectionMode() LabelDetectionMode {
	if m != nil {
		return m.LabelDetectionMode
	}
	return LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED
}

func (m *LabelDetectionConfig) GetStationaryCamera() bool {
	if m != nil {
		return m.StationaryCamera
	}
	return false
}

func (m *LabelDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for SHOT_CHANGE_DETECTION.
type ShotChangeDetectionConfig struct {
	// Model to use for shot change detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShotChangeDetectionConfig) Reset()         { *m = ShotChangeDetectionConfig{} }
func (m *ShotChangeDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*ShotChangeDetectionConfig) ProtoMessage()    {}
func (*ShotChangeDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{3}
}

func (m *ShotChangeDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShotChangeDetectionConfig.Unmarshal(m, b)
}
func (m *ShotChangeDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShotChangeDetectionConfig.Marshal(b, m, deterministic)
}
func (m *ShotChangeDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShotChangeDetectionConfig.Merge(m, src)
}
func (m *ShotChangeDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_ShotChangeDetectionConfig.Size(m)
}
func (m *ShotChangeDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ShotChangeDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ShotChangeDetectionConfig proto.InternalMessageInfo

func (m *ShotChangeDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for EXPLICIT_CONTENT_DETECTION.
type ExplicitContentDetectionConfig struct {
	// Model to use for explicit content detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExplicitContentDetectionConfig) Reset()         { *m = ExplicitContentDetectionConfig{} }
func (m *ExplicitContentDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentDetectionConfig) ProtoMessage()    {}
func (*ExplicitContentDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{4}
}

func (m *ExplicitContentDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Unmarshal(m, b)
}
func (m *ExplicitContentDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Marshal(b, m, deterministic)
}
func (m *ExplicitContentDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentDetectionConfig.Merge(m, src)
}
func (m *ExplicitContentDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Size(m)
}
func (m *ExplicitContentDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentDetectionConfig proto.InternalMessageInfo

func (m *ExplicitContentDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for FACE_DETECTION.
type FaceDetectionConfig struct {
	// Model to use for face detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Whether bounding boxes be included in the face annotation output.
	IncludeBoundingBoxes bool     `protobuf:"varint,2,opt,name=include_bounding_boxes,json=includeBoundingBoxes,proto3" json:"include_bounding_boxes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FaceDetectionConfig) Reset()         { *m = FaceDetectionConfig{} }
func (m *FaceDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*FaceDetectionConfig) ProtoMessage()    {}
func (*FaceDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{5}
}

func (m *FaceDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceDetectionConfig.Unmarshal(m, b)
}
func (m *FaceDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceDetectionConfig.Marshal(b, m, deterministic)
}
func (m *FaceDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceDetectionConfig.Merge(m, src)
}
func (m *FaceDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_FaceDetectionConfig.Size(m)
}
func (m *FaceDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_FaceDetectionConfig proto.InternalMessageInfo

func (m *FaceDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *FaceDetectionConfig) GetIncludeBoundingBoxes() bool {
	if m != nil {
		return m.IncludeBoundingBoxes
	}
	return false
}

// Video segment.
type VideoSegment struct {
	// Time-offset, relative to the beginning of the video,
	// corresponding to the start of the segment (inclusive).
	StartTimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the end of the segment (inclusive).
	EndTimeOffset        *duration.Duration `protobuf:"bytes,2,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *VideoSegment) Reset()         { *m = VideoSegment{} }
func (m *VideoSegment) String() string { return proto.CompactTextString(m) }
func (*VideoSegment) ProtoMessage()    {}
func (*VideoSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{6}
}

func (m *VideoSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoSegment.Unmarshal(m, b)
}
func (m *VideoSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoSegment.Marshal(b, m, deterministic)
}
func (m *VideoSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoSegment.Merge(m, src)
}
func (m *VideoSegment) XXX_Size() int {
	return xxx_messageInfo_VideoSegment.Size(m)
}
func (m *VideoSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoSegment.DiscardUnknown(m)
}

var xxx_messageInfo_VideoSegment proto.InternalMessageInfo

func (m *VideoSegment) GetStartTimeOffset() *duration.Duration {
	if m != nil {
		return m.StartTimeOffset
	}
	return nil
}

func (m *VideoSegment) GetEndTimeOffset() *duration.Duration {
	if m != nil {
		return m.EndTimeOffset
	}
	return nil
}

// Video segment level annotation results for label detection.
type LabelSegment struct {
	// Video segment where a label was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelSegment) Reset()         { *m = LabelSegment{} }
func (m *LabelSegment) String() string { return proto.CompactTextString(m) }
func (*LabelSegment) ProtoMessage()    {}
func (*LabelSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{7}
}

func (m *LabelSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelSegment.Unmarshal(m, b)
}
func (m *LabelSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelSegment.Marshal(b, m, deterministic)
}
func (m *LabelSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelSegment.Merge(m, src)
}
func (m *LabelSegment) XXX_Size() int {
	return xxx_messageInfo_LabelSegment.Size(m)
}
func (m *LabelSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelSegment.DiscardUnknown(m)
}

var xxx_messageInfo_LabelSegment proto.InternalMessageInfo

func (m *LabelSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *LabelSegment) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Video frame level annotation results for label detection.
type LabelFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelFrame) Reset()         { *m = LabelFrame{} }
func (m *LabelFrame) String() string { return proto.CompactTextString(m) }
func (*LabelFrame) ProtoMessage()    {}
func (*LabelFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{8}
}

func (m *LabelFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelFrame.Unmarshal(m, b)
}
func (m *LabelFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelFrame.Marshal(b, m, deterministic)
}
func (m *LabelFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelFrame.Merge(m, src)
}
func (m *LabelFrame) XXX_Size() int {
	return xxx_messageInfo_LabelFrame.Size(m)
}
func (m *LabelFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelFrame.DiscardUnknown(m)
}

var xxx_messageInfo_LabelFrame proto.InternalMessageInfo

func (m *LabelFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *LabelFrame) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Detected entity from video analysis.
type Entity struct {
	// Opaque entity ID. Some IDs may be available in
	// [Google Knowledge Graph Search
	// API](https://developers.google.com/knowledge-graph/).
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// Textual description, e.g. `Fixed-gear bicycle`.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Language code for `description` in BCP-47 format.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Entity) Reset()         { *m = Entity{} }
func (m *Entity) String() string { return proto.CompactTextString(m) }
func (*Entity) ProtoMessage()    {}
func (*Entity) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{9}
}

func (m *Entity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Entity.Unmarshal(m, b)
}
func (m *Entity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Entity.Marshal(b, m, deterministic)
}
func (m *Entity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Entity.Merge(m, src)
}
func (m *Entity) XXX_Size() int {
	return xxx_messageInfo_Entity.Size(m)
}
func (m *Entity) XXX_DiscardUnknown() {
	xxx_messageInfo_Entity.DiscardUnknown(m)
}

var xxx_messageInfo_Entity proto.InternalMessageInfo

func (m *Entity) GetEntityId() string {
	if m != nil {
		return m.EntityId
	}
	return ""
}

func (m *Entity) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Entity) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Label annotation.
type LabelAnnotation struct {
	// Detected entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Common categories for the detected entity.
	// E.g. when the label is `Terrier` the category is likely `dog`. And in some
	// cases there might be more than one categories e.g. `Terrier` could also be
	// a `pet`.
	CategoryEntities []*Entity `protobuf:"bytes,2,rep,name=category_entities,json=categoryEntities,proto3" json:"category_entities,omitempty"`
	// All video segments where a label was detected.
	Segments []*LabelSegment `protobuf:"bytes,3,rep,name=segments,proto3" json:"segments,omitempty"`
	// All video frames where a label was detected.
	Frames               []*LabelFrame `protobuf:"bytes,4,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *LabelAnnotation) Reset()         { *m = LabelAnnotation{} }
func (m *LabelAnnotation) String() string { return proto.CompactTextString(m) }
func (*LabelAnnotation) ProtoMessage()    {}
func (*LabelAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{10}
}

func (m *LabelAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelAnnotation.Unmarshal(m, b)
}
func (m *LabelAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelAnnotation.Marshal(b, m, deterministic)
}
func (m *LabelAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelAnnotation.Merge(m, src)
}
func (m *LabelAnnotation) XXX_Size() int {
	return xxx_messageInfo_LabelAnnotation.Size(m)
}
func (m *LabelAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_LabelAnnotation proto.InternalMessageInfo

func (m *LabelAnnotation) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *LabelAnnotation) GetCategoryEntities() []*Entity {
	if m != nil {
		return m.CategoryEntities
	}
	return nil
}

func (m *LabelAnnotation) GetSegments() []*LabelSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *LabelAnnotation) GetFrames() []*LabelFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Video frame level annotation results for explicit content.
type ExplicitContentFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Likelihood of the pornography content..
	PornographyLikelihood Likelihood `protobuf:"varint,2,opt,name=pornography_likelihood,json=pornographyLikelihood,proto3,enum=google.cloud.videointelligence.v1beta2.Likelihood" json:"pornography_likelihood,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}   `json:"-"`
	XXX_unrecognized      []byte     `json:"-"`
	XXX_sizecache         int32      `json:"-"`
}

func (m *ExplicitContentFrame) Reset()         { *m = ExplicitContentFrame{} }
func (m *ExplicitContentFrame) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentFrame) ProtoMessage()    {}
func (*ExplicitContentFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{11}
}

func (m *ExplicitContentFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentFrame.Unmarshal(m, b)
}
func (m *ExplicitContentFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentFrame.Marshal(b, m, deterministic)
}
func (m *ExplicitContentFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentFrame.Merge(m, src)
}
func (m *ExplicitContentFrame) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentFrame.Size(m)
}
func (m *ExplicitContentFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentFrame proto.InternalMessageInfo

func (m *ExplicitContentFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *ExplicitContentFrame) GetPornographyLikelihood() Likelihood {
	if m != nil {
		return m.PornographyLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

// Explicit content annotation (based on per-frame visual signals only).
// If no explicit content has been detected in a frame, no annotations are
// present for that frame.
type ExplicitContentAnnotation struct {
	// All video frames where explicit content was detected.
	Frames               []*ExplicitContentFrame `protobuf:"bytes,1,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *ExplicitContentAnnotation) Reset()         { *m = ExplicitContentAnnotation{} }
func (m *ExplicitContentAnnotation) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentAnnotation) ProtoMessage()    {}
func (*ExplicitContentAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{12}
}

func (m *ExplicitContentAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentAnnotation.Unmarshal(m, b)
}
func (m *ExplicitContentAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentAnnotation.Marshal(b, m, deterministic)
}
func (m *ExplicitContentAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentAnnotation.Merge(m, src)
}
func (m *ExplicitContentAnnotation) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentAnnotation.Size(m)
}
func (m *ExplicitContentAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentAnnotation proto.InternalMessageInfo

func (m *ExplicitContentAnnotation) GetFrames() []*ExplicitContentFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Normalized bounding box.
// The normalized vertex coordinates are relative to the original image.
// Range: [0, 1].
type NormalizedBoundingBox struct {
	// Left X coordinate.
	Left float32 `protobuf:"fixed32,1,opt,name=left,proto3" json:"left,omitempty"`
	// Top Y coordinate.
	Top float32 `protobuf:"fixed32,2,opt,name=top,proto3" json:"top,omitempty"`
	// Right X coordinate.
	Right float32 `protobuf:"fixed32,3,opt,name=right,proto3" json:"right,omitempty"`
	// Bottom Y coordinate.
	Bottom               float32  `protobuf:"fixed32,4,opt,name=bottom,proto3" json:"bottom,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NormalizedBoundingBox) Reset()         { *m = NormalizedBoundingBox{} }
func (m *NormalizedBoundingBox) String() string { return proto.CompactTextString(m) }
func (*NormalizedBoundingBox) ProtoMessage()    {}
func (*NormalizedBoundingBox) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{13}
}

func (m *NormalizedBoundingBox) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NormalizedBoundingBox.Unmarshal(m, b)
}
func (m *NormalizedBoundingBox) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NormalizedBoundingBox.Marshal(b, m, deterministic)
}
func (m *NormalizedBoundingBox) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NormalizedBoundingBox.Merge(m, src)
}
func (m *NormalizedBoundingBox) XXX_Size() int {
	return xxx_messageInfo_NormalizedBoundingBox.Size(m)
}
func (m *NormalizedBoundingBox) XXX_DiscardUnknown() {
	xxx_messageInfo_NormalizedBoundingBox.DiscardUnknown(m)
}

var xxx_messageInfo_NormalizedBoundingBox proto.InternalMessageInfo

func (m *NormalizedBoundingBox) GetLeft() float32 {
	if m != nil {
		return m.Left
	}
	return 0
}

func (m *NormalizedBoundingBox) GetTop() float32 {
	if m != nil {
		return m.Top
	}
	return 0
}

func (m *NormalizedBoundingBox) GetRight() float32 {
	if m != nil {
		return m.Right
	}
	return 0
}

func (m *NormalizedBoundingBox) GetBottom() float32 {
	if m != nil {
		return m.Bottom
	}
	return 0
}

// Video segment level annotation results for face detection.
type FaceSegment struct {
	// Video segment where a face was detected.
	Segment              *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *FaceSegment) Reset()         { *m = FaceSegment{} }
func (m *FaceSegment) String() string { return proto.CompactTextString(m) }
func (*FaceSegment) ProtoMessage()    {}
func (*FaceSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{14}
}

func (m *FaceSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceSegment.Unmarshal(m, b)
}
func (m *FaceSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceSegment.Marshal(b, m, deterministic)
}
func (m *FaceSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceSegment.Merge(m, src)
}
func (m *FaceSegment) XXX_Size() int {
	return xxx_messageInfo_FaceSegment.Size(m)
}
func (m *FaceSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceSegment.DiscardUnknown(m)
}

var xxx_messageInfo_FaceSegment proto.InternalMessageInfo

func (m *FaceSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

// Video frame level annotation results for face detection.
type FaceFrame struct {
	// Normalized Bounding boxes in a frame.
	// There can be more than one boxes if the same face is detected in multiple
	// locations within the current frame.
	NormalizedBoundingBoxes []*NormalizedBoundingBox `protobuf:"bytes,1,rep,name=normalized_bounding_boxes,json=normalizedBoundingBoxes,proto3" json:"normalized_bounding_boxes,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the video frame for this location.
	TimeOffset           *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *FaceFrame) Reset()         { *m = FaceFrame{} }
func (m *FaceFrame) String() string { return proto.CompactTextString(m) }
func (*FaceFrame) ProtoMessage()    {}
func (*FaceFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{15}
}

func (m *FaceFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceFrame.Unmarshal(m, b)
}
func (m *FaceFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceFrame.Marshal(b, m, deterministic)
}
func (m *FaceFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceFrame.Merge(m, src)
}
func (m *FaceFrame) XXX_Size() int {
	return xxx_messageInfo_FaceFrame.Size(m)
}
func (m *FaceFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceFrame.DiscardUnknown(m)
}

var xxx_messageInfo_FaceFrame proto.InternalMessageInfo

func (m *FaceFrame) GetNormalizedBoundingBoxes() []*NormalizedBoundingBox {
	if m != nil {
		return m.NormalizedBoundingBoxes
	}
	return nil
}

func (m *FaceFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

// Face annotation.
type FaceAnnotation struct {
	// Thumbnail of a representative face view (in JPEG format).
	Thumbnail []byte `protobuf:"bytes,1,opt,name=thumbnail,proto3" json:"thumbnail,omitempty"`
	// All video segments where a face was detected.
	Segments []*FaceSegment `protobuf:"bytes,2,rep,name=segments,proto3" json:"segments,omitempty"`
	// All video frames where a face was detected.
	Frames               []*FaceFrame `protobuf:"bytes,3,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *FaceAnnotation) Reset()         { *m = FaceAnnotation{} }
func (m *FaceAnnotation) String() string { return proto.CompactTextString(m) }
func (*FaceAnnotation) ProtoMessage()    {}
func (*FaceAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{16}
}

func (m *FaceAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceAnnotation.Unmarshal(m, b)
}
func (m *FaceAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceAnnotation.Marshal(b, m, deterministic)
}
func (m *FaceAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceAnnotation.Merge(m, src)
}
func (m *FaceAnnotation) XXX_Size() int {
	return xxx_messageInfo_FaceAnnotation.Size(m)
}
func (m *FaceAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_FaceAnnotation proto.InternalMessageInfo

func (m *FaceAnnotation) GetThumbnail() []byte {
	if m != nil {
		return m.Thumbnail
	}
	return nil
}

func (m *FaceAnnotation) GetSegments() []*FaceSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *FaceAnnotation) GetFrames() []*FaceFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Annotation results for a single video.
type VideoAnnotationResults struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Label annotations on video level or user specified segment level.
	// There is exactly one element for each unique label.
	SegmentLabelAnnotations []*LabelAnnotation `protobuf:"bytes,2,rep,name=segment_label_annotations,json=segmentLabelAnnotations,proto3" json:"segment_label_annotations,omitempty"`
	// Label annotations on shot level.
	// There is exactly one element for each unique label.
	ShotLabelAnnotations []*LabelAnnotation `protobuf:"bytes,3,rep,name=shot_label_annotations,json=shotLabelAnnotations,proto3" json:"shot_label_annotations,omitempty"`
	// Label annotations on frame level.
	// There is exactly one element for each unique label.
	FrameLabelAnnotations []*LabelAnnotation `protobuf:"bytes,4,rep,name=frame_label_annotations,json=frameLabelAnnotations,proto3" json:"frame_label_annotations,omitempty"`
	// Face annotations. There is exactly one element for each unique face.
	FaceAnnotations []*FaceAnnotation `protobuf:"bytes,5,rep,name=face_annotations,json=faceAnnotations,proto3" json:"face_annotations,omitempty"`
	// Shot annotations. Each shot is represented as a video segment.
	ShotAnnotations []*VideoSegment `protobuf:"bytes,6,rep,name=shot_annotations,json=shotAnnotations,proto3" json:"shot_annotations,omitempty"`
	// Explicit content annotation.
	ExplicitAnnotation *ExplicitContentAnnotation `protobuf:"bytes,7,opt,name=explicit_annotation,json=explicitAnnotation,proto3" json:"explicit_annotation,omitempty"`
	// If set, indicates an error. Note that for a single `AnnotateVideoRequest`
	// some videos may succeed and some may fail.
	Error                *status.Status `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *VideoAnnotationResults) Reset()         { *m = VideoAnnotationResults{} }
func (m *VideoAnnotationResults) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationResults) ProtoMessage()    {}
func (*VideoAnnotationResults) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{17}
}

func (m *VideoAnnotationResults) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationResults.Unmarshal(m, b)
}
func (m *VideoAnnotationResults) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationResults.Marshal(b, m, deterministic)
}
func (m *VideoAnnotationResults) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationResults.Merge(m, src)
}
func (m *VideoAnnotationResults) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationResults.Size(m)
}
func (m *VideoAnnotationResults) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationResults.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationResults proto.InternalMessageInfo

func (m *VideoAnnotationResults) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationResults) GetSegmentLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.SegmentLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.ShotLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFrameLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.FrameLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFaceAnnotations() []*FaceAnnotation {
	if m != nil {
		return m.FaceAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotAnnotations() []*VideoSegment {
	if m != nil {
		return m.ShotAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetExplicitAnnotation() *ExplicitContentAnnotation {
	if m != nil {
		return m.ExplicitAnnotation
	}
	return nil
}

func (m *VideoAnnotationResults) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// Video annotation response. Included in the `response`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoResponse struct {
	// Annotation results for all videos specified in `AnnotateVideoRequest`.
	AnnotationResults    []*VideoAnnotationResults `protobuf:"bytes,1,rep,name=annotation_results,json=annotationResults,proto3" json:"annotation_results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *AnnotateVideoResponse) Reset()         { *m = AnnotateVideoResponse{} }
func (m *AnnotateVideoResponse) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoResponse) ProtoMessage()    {}
func (*AnnotateVideoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{18}
}

func (m *AnnotateVideoResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoResponse.Unmarshal(m, b)
}
func (m *AnnotateVideoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoResponse.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoResponse.Merge(m, src)
}
func (m *AnnotateVideoResponse) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoResponse.Size(m)
}
func (m *AnnotateVideoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoResponse proto.InternalMessageInfo

func (m *AnnotateVideoResponse) GetAnnotationResults() []*VideoAnnotationResults {
	if m != nil {
		return m.AnnotationResults
	}
	return nil
}

// Annotation progress for a single video.
type VideoAnnotationProgress struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Approximate percentage processed thus far.
	// Guaranteed to be 100 when fully processed.
	ProgressPercent int32 `protobuf:"varint,2,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Time when the request was received.
	StartTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time of the most recent update.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *VideoAnnotationProgress) Reset()         { *m = VideoAnnotationProgress{} }
func (m *VideoAnnotationProgress) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationProgress) ProtoMessage()    {}
func (*VideoAnnotationProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{19}
}

func (m *VideoAnnotationProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationProgress.Unmarshal(m, b)
}
func (m *VideoAnnotationProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationProgress.Marshal(b, m, deterministic)
}
func (m *VideoAnnotationProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationProgress.Merge(m, src)
}
func (m *VideoAnnotationProgress) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationProgress.Size(m)
}
func (m *VideoAnnotationProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationProgress.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationProgress proto.InternalMessageInfo

func (m *VideoAnnotationProgress) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationProgress) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *VideoAnnotationProgress) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *VideoAnnotationProgress) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// Video annotation progress. Included in the `metadata`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoProgress struct {
	// Progress metadata for all videos specified in `AnnotateVideoRequest`.
	AnnotationProgress   []*VideoAnnotationProgress `protobuf:"bytes,1,rep,name=annotation_progress,json=annotationProgress,proto3" json:"annotation_progress,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *AnnotateVideoProgress) Reset()         { *m = AnnotateVideoProgress{} }
func (m *AnnotateVideoProgress) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoProgress) ProtoMessage()    {}
func (*AnnotateVideoProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{20}
}

func (m *AnnotateVideoProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoProgress.Unmarshal(m, b)
}
func (m *AnnotateVideoProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoProgress.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoProgress.Merge(m, src)
}
func (m *AnnotateVideoProgress) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoProgress.Size(m)
}
func (m *AnnotateVideoProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoProgress.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoProgress proto.InternalMessageInfo

func (m *AnnotateVideoProgress) GetAnnotationProgress() []*VideoAnnotationProgress {
	if m != nil {
		return m.AnnotationProgress
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.videointelligence.v1beta2.Feature", Feature_name, Feature_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1beta2.LabelDetectionMode", LabelDetectionMode_name, LabelDetectionMode_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1beta2.Likelihood", Likelihood_name, Likelihood_value)
	proto.RegisterType((*AnnotateVideoRequest)(nil), "google.cloud.videointelligence.v1beta2.AnnotateVideoRequest")
	proto.RegisterType((*VideoContext)(nil), "google.cloud.videointelligence.v1beta2.VideoContext")
	proto.RegisterType((*LabelDetectionConfig)(nil), "google.cloud.videointelligence.v1beta2.LabelDetectionConfig")
	proto.RegisterType((*ShotChangeDetectionConfig)(nil), "google.cloud.videointelligence.v1beta2.ShotChangeDetectionConfig")
	proto.RegisterType((*ExplicitContentDetectionConfig)(nil), "google.cloud.videointelligence.v1beta2.ExplicitContentDetectionConfig")
	proto.RegisterType((*FaceDetectionConfig)(nil), "google.cloud.videointelligence.v1beta2.FaceDetectionConfig")
	proto.RegisterType((*VideoSegment)(nil), "google.cloud.videointelligence.v1beta2.VideoSegment")
	proto.RegisterType((*LabelSegment)(nil), "google.cloud.videointelligence.v1beta2.LabelSegment")
	proto.RegisterType((*LabelFrame)(nil), "google.cloud.videointelligence.v1beta2.LabelFrame")
	proto.RegisterType((*Entity)(nil), "google.cloud.videointelligence.v1beta2.Entity")
	proto.RegisterType((*LabelAnnotation)(nil), "google.cloud.videointelligence.v1beta2.LabelAnnotation")
	proto.RegisterType((*ExplicitContentFrame)(nil), "google.cloud.videointelligence.v1beta2.ExplicitContentFrame")
	proto.RegisterType((*ExplicitContentAnnotation)(nil), "google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation")
	proto.RegisterType((*NormalizedBoundingBox)(nil), "google.cloud.videointelligence.v1beta2.NormalizedBoundingBox")
	proto.RegisterType((*FaceSegment)(nil), "google.cloud.videointelligence.v1beta2.FaceSegment")
	proto.RegisterType((*FaceFrame)(nil), "google.cloud.videointelligence.v1beta2.FaceFrame")
	proto.RegisterType((*FaceAnnotation)(nil), "google.cloud.videointelligence.v1beta2.FaceAnnotation")
	proto.RegisterType((*VideoAnnotationResults)(nil), "google.cloud.videointelligence.v1beta2.VideoAnnotationResults")
	proto.RegisterType((*AnnotateVideoResponse)(nil), "google.cloud.videointelligence.v1beta2.AnnotateVideoResponse")
	proto.RegisterType((*VideoAnnotationProgress)(nil), "google.cloud.videointelligence.v1beta2.VideoAnnotationProgress")
	proto.RegisterType((*AnnotateVideoProgress)(nil), "google.cloud.videointelligence.v1beta2.AnnotateVideoProgress")
}

func init() {
	proto.RegisterFile("google/cloud/videointelligence/v1beta2/video_intelligence.proto", fileDescriptor_84237f664d80452c)
}

var fileDescriptor_84237f664d80452c = []byte{
	// 1825 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0xdd, 0x6f, 0xe3, 0x58,
	0x15, 0xc7, 0x4e, 0xda, 0x99, 0x9c, 0x7e, 0x65, 0x6e, 0xbf, 0xd2, 0x32, 0x53, 0x8a, 0x77, 0xb5,
	0xea, 0x16, 0x48, 0x34, 0xdd, 0xd5, 0x22, 0x32, 0x0b, 0xab, 0x34, 0x75, 0x77, 0x02, 0x9d, 0xa4,
	0x72, 0x33, 0x03, 0x03, 0x83, 0x2c, 0xc7, 0xbe, 0x71, 0xac, 0x75, 0x7c, 0xbd, 0xf6, 0x75, 0x67,
	0xca, 0x03, 0x0f, 0xfb, 0xb0, 0x12, 0x8f, 0x88, 0x17, 0xfe, 0x00, 0x9e, 0xf8, 0x1f, 0x78, 0xe1,
	0x05, 0xa9, 0x2f, 0x48, 0x80, 0x84, 0xe0, 0x01, 0xf1, 0xc0, 0x13, 0xe2, 0x8f, 0x40, 0xbe, 0xf7,
	0x3a, 0x71, 0xec, 0x74, 0x9a, 0xcc, 0x68, 0xdf, 0xec, 0xf3, 0xf1, 0x3b, 0x1f, 0xf7, 0x9c, 0x73,
	0x3f, 0xe0, 0x13, 0x9b, 0x10, 0xdb, 0xc5, 0x35, 0xd3, 0x25, 0x91, 0x55, 0xbb, 0x74, 0x2c, 0x4c,
	0x1c, 0x8f, 0x62, 0xd7, 0x75, 0x6c, 0xec, 0x99, 0xb8, 0x76, 0xf9, 0xb0, 0x87, 0xa9, 0x71, 0xc4,
	0x39, 0x7a, 0x9a, 0x55, 0xf5, 0x03, 0x42, 0x09, 0x7a, 0x8f, 0x03, 0x54, 0x19, 0x40, 0x35, 0x07,
	0x50, 0x15, 0x00, 0xbb, 0xf7, 0x85, 0x21, 0xc3, 0x77, 0x6a, 0x86, 0xe7, 0x11, 0x6a, 0x50, 0x87,
	0x78, 0x21, 0x47, 0xd9, 0xdd, 0x4e, 0x71, 0x4d, 0xd7, 0xc1, 0x1e, 0x15, 0x8c, 0x6f, 0xa4, 0x18,
	0x7d, 0x07, 0xbb, 0x96, 0xde, 0xc3, 0x03, 0xe3, 0xd2, 0x21, 0x81, 0x10, 0x78, 0x47, 0x08, 0xb8,
	0xc4, 0xb3, 0x83, 0xc8, 0xf3, 0x1c, 0xcf, 0xae, 0x11, 0x1f, 0x07, 0x13, 0xf0, 0x7b, 0x42, 0x88,
	0xfd, 0xf5, 0xa2, 0x7e, 0xcd, 0x8a, 0xb8, 0x40, 0xc6, 0xca, 0x88, 0x4f, 0x9d, 0x21, 0x0e, 0xa9,
	0x31, 0xf4, 0x33, 0xfe, 0x05, 0xbe, 0x59, 0x0b, 0xa9, 0x41, 0x23, 0x81, 0xac, 0xfc, 0x59, 0x86,
	0x8d, 0x06, 0x0f, 0x07, 0x3f, 0x8b, 0x83, 0xd7, 0xf0, 0xe7, 0x11, 0x0e, 0x29, 0xfa, 0x3a, 0x94,
	0x1c, 0xcf, 0x8f, 0xa8, 0x1e, 0x05, 0x4e, 0x45, 0xda, 0x97, 0x0e, 0x4a, 0xda, 0x5d, 0x46, 0x78,
	0x1a, 0x38, 0xe8, 0x1d, 0x58, 0xe1, 0x4c, 0x93, 0x78, 0x14, 0x7b, 0xb4, 0xb2, 0xb8, 0x2f, 0x1d,
	0x2c, 0x6b, 0xcb, 0x8c, 0xd8, 0xe4, 0x34, 0x74, 0x0e, 0x77, 0xfb, 0xd8, 0xa0, 0x51, 0x80, 0xc3,
	0x8a, 0xbc, 0x5f, 0x38, 0x58, 0x3d, 0xaa, 0x55, 0x67, 0x4b, 0x76, 0xf5, 0x94, 0xeb, 0x1d, 0x17,
	0xfe, 0xdd, 0x90, 0xb5, 0x11, 0x0a, 0x7a, 0x0e, 0x2b, 0x7c, 0x1d, 0x99, 0xd9, 0x57, 0xb4, 0x52,
	0xd8, 0x97, 0x0e, 0x96, 0x8e, 0x3e, 0x9c, 0x15, 0x96, 0x05, 0xd8, 0xe4, 0xba, 0xda, 0xf2, 0x65,
	0xea, 0x0f, 0x29, 0x00, 0x24, 0xa2, 0x49, 0xbc, 0xc5, 0x38, 0xde, 0xd8, 0xba, 0xa4, 0x95, 0x38,
	0x39, 0x8e, 0xfa, 0x5d, 0x58, 0x72, 0x89, 0xc9, 0xf2, 0xae, 0x3b, 0x56, 0x65, 0x61, 0x2c, 0x04,
	0x09, 0xbd, 0x65, 0x29, 0xff, 0x2a, 0xc2, 0x72, 0xda, 0x50, 0x9c, 0x87, 0x10, 0xdb, 0x43, 0xec,
	0xd1, 0xb0, 0x22, 0xed, 0x17, 0xe6, 0x76, 0xf8, 0x82, 0x2b, 0x6b, 0x23, 0x14, 0x14, 0xc0, 0x96,
	0x6b, 0xf4, 0xb0, 0xab, 0x5b, 0x98, 0x62, 0x93, 0xf9, 0x63, 0x12, 0xaf, 0xef, 0xd8, 0x15, 0x99,
	0x25, 0xe4, 0xe3, 0x59, 0xf1, 0xcf, 0x62, 0x94, 0x93, 0x04, 0xa4, 0xc9, 0x30, 0xb4, 0x0d, 0x77,
	0x0a, 0x15, 0x7d, 0x21, 0xc1, 0xfd, 0x70, 0x40, 0xa8, 0x6e, 0x0e, 0x0c, 0xcf, 0xc6, 0x79, 0xd3,
	0x7c, 0x2d, 0x1a, 0xb3, 0x9a, 0xbe, 0x18, 0x10, 0xda, 0x64, 0x50, 0x59, 0xfb, 0x3b, 0xe1, 0x4d,
	0x2c, 0xf4, 0x6b, 0x09, 0xbe, 0x89, 0x5f, 0xf9, 0xae, 0x63, 0x3a, 0xa3, 0xda, 0xcb, 0x7b, 0x52,
	0x64, 0x9e, 0x9c, 0xce, 0xea, 0x89, 0x2a, 0x00, 0x45, 0xdd, 0x66, 0xdd, 0xd9, 0xc3, 0xaf, 0xe5,
	0x23, 0x02, 0x9b, 0x7d, 0xc3, 0x9c, 0x92, 0x90, 0x05, 0xe6, 0xc6, 0xa3, 0x99, 0x6b, 0xde, 0x30,
	0x73, 0xa9, 0x58, 0xef, 0xe7, 0x89, 0xca, 0x9f, 0x24, 0xd8, 0x98, 0xb6, 0x70, 0xc8, 0x85, 0x8d,
	0x6c, 0x59, 0x0c, 0x89, 0x85, 0x59, 0xf7, 0xae, 0x1e, 0xd5, 0xdf, 0xac, 0x28, 0x9e, 0x10, 0x0b,
	0x6b, 0xc8, 0xcd, 0xd1, 0xd0, 0xb7, 0xe0, 0x5e, 0xc8, 0x87, 0xa0, 0x11, 0x5c, 0xe9, 0xa6, 0x31,
	0xc4, 0x81, 0xc1, 0xea, 0xef, 0xae, 0x56, 0x1e, 0x33, 0x9a, 0x8c, 0x8e, 0x36, 0x60, 0x21, 0x76,
	0xc5, 0x65, 0x55, 0x52, 0xd2, 0xf8, 0x8f, 0xf2, 0x10, 0x76, 0x6e, 0x2c, 0x83, 0xb1, 0x8a, 0x94,
	0x56, 0xf9, 0x08, 0xf6, 0x5e, 0xbf, 0x5e, 0x37, 0xe8, 0x19, 0xb0, 0x3e, 0x25, 0xc1, 0xd3, 0x85,
	0xd1, 0x87, 0xb0, 0xe5, 0x78, 0xa6, 0x1b, 0x59, 0x58, 0xef, 0x91, 0xc8, 0xb3, 0x1c, 0xcf, 0xd6,
	0x7b, 0xe4, 0x15, 0x9b, 0x63, 0x71, 0x7c, 0x1b, 0x82, 0x7b, 0x2c, 0x98, 0xc7, 0x31, 0x4f, 0xf9,
	0xad, 0x24, 0x1a, 0x5f, 0x34, 0x2c, 0x52, 0x59, 0x86, 0x02, 0xaa, 0xc7, 0xd3, 0x58, 0x27, 0xfd,
	0x7e, 0x88, 0x29, 0x33, 0xb4, 0x74, 0xb4, 0x93, 0x2c, 0x46, 0x32, 0xb1, 0xab, 0x27, 0x62, 0xa2,
	0x6b, 0x6b, 0x4c, 0xa7, 0xeb, 0x0c, 0x71, 0x87, 0x69, 0xa0, 0x06, 0xac, 0x61, 0xcf, 0x9a, 0x00,
	0x91, 0x6f, 0x03, 0x59, 0xc1, 0x9e, 0x35, 0x86, 0x50, 0x7e, 0x09, 0xcb, 0x6c, 0x55, 0x13, 0xcf,
	0xda, 0x70, 0x47, 0x0c, 0x13, 0xe1, 0xcf, 0x9b, 0x4d, 0xa4, 0x04, 0x04, 0xed, 0x01, 0xb0, 0xa2,
	0xb7, 0x62, 0x59, 0xe6, 0x9d, 0xac, 0xa5, 0x28, 0xca, 0x00, 0x80, 0xd9, 0x3f, 0x0d, 0x8c, 0x21,
	0x46, 0x75, 0x58, 0x9a, 0x2b, 0x23, 0x40, 0xc7, 0xc9, 0xb8, 0xcd, 0x92, 0x0b, 0x8b, 0xaa, 0x47,
	0x1d, 0x7a, 0x15, 0x6f, 0x60, 0x98, 0x7d, 0xc5, 0xb3, 0x5a, 0x6c, 0x60, 0x9c, 0xd0, 0xb2, 0xd0,
	0x3e, 0x2c, 0x59, 0x38, 0x34, 0x03, 0xc7, 0x8f, 0x2d, 0x30, 0x9c, 0x92, 0x96, 0x26, 0xc5, 0x5b,
	0x9c, 0x6b, 0x78, 0x76, 0x64, 0xd8, 0x58, 0x37, 0xe3, 0x2e, 0xe2, 0x95, 0xbb, 0x9c, 0x10, 0x9b,
	0xc4, 0xc2, 0xca, 0xdf, 0x64, 0x58, 0x63, 0x81, 0x35, 0x46, 0x27, 0x02, 0x74, 0x0a, 0x8b, 0xdc,
	0x8c, 0x08, 0xac, 0x3a, 0xf3, 0x1c, 0x62, 0x5a, 0x9a, 0xd0, 0x46, 0x3f, 0x83, 0x7b, 0xa6, 0x41,
	0xb1, 0x4d, 0x82, 0x2b, 0x9d, 0x91, 0x1c, 0xb1, 0x8f, 0xce, 0x0f, 0x59, 0x4e, 0x80, 0x54, 0x81,
	0x33, 0xb1, 0x27, 0x15, 0xe6, 0xdb, 0x93, 0xd2, 0x85, 0x94, 0xda, 0x93, 0x7e, 0x08, 0x8b, 0xfd,
	0x78, 0x75, 0xc3, 0x4a, 0x91, 0xe1, 0x1d, 0xcd, 0x85, 0xc7, 0x0a, 0x43, 0x13, 0x08, 0xca, 0x1f,
	0x24, 0xd8, 0xc8, 0x74, 0xf9, 0xdb, 0x57, 0x8e, 0x03, 0x5b, 0x3e, 0x09, 0x3c, 0x62, 0x07, 0x86,
	0x3f, 0xb8, 0xd2, 0x5d, 0xe7, 0x33, 0xec, 0x3a, 0x03, 0x42, 0x2c, 0xb6, 0xfa, 0xab, 0x73, 0x38,
	0x3c, 0xd2, 0xd4, 0x36, 0x53, 0x88, 0x63, 0xb2, 0xf2, 0x39, 0xec, 0x64, 0xdc, 0x4f, 0xd5, 0x47,
	0x77, 0x94, 0x28, 0x7e, 0x18, 0xf8, 0xf8, 0x0d, 0xf7, 0xa9, 0xc9, 0x94, 0x7d, 0x06, 0x9b, 0x6d,
	0x12, 0x0c, 0x0d, 0xd7, 0xf9, 0x05, 0xb6, 0x52, 0x73, 0x09, 0x21, 0x28, 0xba, 0xb8, 0xcf, 0x73,
	0x25, 0x6b, 0xec, 0x1b, 0x95, 0xa1, 0x40, 0x89, 0x2f, 0xba, 0x27, 0xfe, 0x8c, 0xe7, 0x60, 0xe0,
	0xd8, 0x03, 0x7e, 0xa2, 0x92, 0x35, 0xfe, 0x83, 0xb6, 0x60, 0xb1, 0x47, 0x28, 0x25, 0x43, 0xb6,
	0xa5, 0xca, 0x9a, 0xf8, 0x53, 0x7e, 0x0e, 0x4b, 0xf1, 0x30, 0xfd, 0x8a, 0xa6, 0x89, 0xf2, 0x47,
	0x09, 0x4a, 0x31, 0x3e, 0x5f, 0xf3, 0x2b, 0xd8, 0xf1, 0x46, 0x91, 0x65, 0xe7, 0x31, 0x4f, 0xe1,
	0xf7, 0x67, 0xb5, 0x37, 0x35, 0x45, 0xda, 0xb6, 0x37, 0x8d, 0x8c, 0xc3, 0x6c, 0xb9, 0xc9, 0x73,
	0x94, 0x9b, 0x72, 0x2d, 0xc1, 0x6a, 0x1c, 0x44, 0x6a, 0xe5, 0xef, 0x43, 0x89, 0x0e, 0xa2, 0x61,
	0xcf, 0x33, 0x1c, 0xbe, 0xe1, 0x2c, 0x6b, 0x63, 0x02, 0xea, 0xa4, 0x5a, 0x92, 0xb7, 0xf9, 0x07,
	0xf3, 0x1c, 0x1d, 0xf2, 0x1d, 0xd9, 0x1a, 0x15, 0x1a, 0xef, 0xf0, 0x87, 0xf3, 0xc0, 0x4d, 0x56,
	0xd7, 0xff, 0x16, 0x60, 0x8b, 0xad, 0xd5, 0x38, 0x1a, 0x0d, 0x87, 0x91, 0x4b, 0xc3, 0xd7, 0xdf,
	0x13, 0x42, 0xd8, 0x11, 0xee, 0xe8, 0xfc, 0x64, 0x92, 0xba, 0x39, 0x89, 0x20, 0xbf, 0x3b, 0xd7,
	0x9c, 0x48, 0xd9, 0xdf, 0x16, 0xc8, 0x19, 0x7a, 0x88, 0x86, 0xb0, 0xc5, 0x0e, 0xaa, 0x79, 0x8b,
	0x85, 0xb7, 0xb3, 0xb8, 0x11, 0xc3, 0xe6, 0xcc, 0x11, 0xd8, 0x66, 0x59, 0x9a, 0x62, 0xaf, 0xf8,
	0x76, 0xf6, 0x36, 0x19, 0x6e, 0xce, 0xa0, 0x01, 0x65, 0x76, 0xe0, 0x4c, 0x5b, 0x5a, 0x60, 0x96,
	0x3e, 0x9a, 0x67, 0x85, 0x53, 0x86, 0xd6, 0xfa, 0x13, 0xff, 0x21, 0xd2, 0xa1, 0xcc, 0x52, 0x98,
	0x36, 0xb1, 0xf8, 0x16, 0x57, 0x97, 0xb5, 0x18, 0x2d, 0x6d, 0x20, 0x80, 0xf5, 0xd1, 0x39, 0x7e,
	0x6c, 0xa4, 0x72, 0x67, 0xbe, 0x3b, 0xc4, 0x8d, 0x43, 0x56, 0x43, 0x09, 0x7a, 0xaa, 0xfd, 0x0e,
	0x60, 0x01, 0x07, 0x01, 0x09, 0x2a, 0x25, 0x66, 0x05, 0x25, 0x56, 0x02, 0xdf, 0xac, 0x5e, 0xb0,
	0x3b, 0xb1, 0xc6, 0x05, 0x94, 0x2f, 0x25, 0xd8, 0xcc, 0x5c, 0x8a, 0x43, 0x9f, 0x78, 0x21, 0x46,
	0x43, 0x40, 0x63, 0x77, 0xf5, 0x80, 0xf7, 0x80, 0x98, 0x42, 0x3f, 0x98, 0x2b, 0x35, 0xb9, 0x4e,
	0xd2, 0xee, 0x19, 0x59, 0x92, 0xf2, 0x0f, 0x09, 0xb6, 0x33, 0xd2, 0xe7, 0x01, 0xb1, 0x03, 0x1c,
	0xde, 0xd2, 0x78, 0xef, 0x43, 0xd9, 0x17, 0x82, 0xba, 0x8f, 0x03, 0x33, 0x9e, 0xcd, 0xf1, 0xf8,
	0x5a, 0xd0, 0xd6, 0x12, 0xfa, 0x39, 0x27, 0xa3, 0xef, 0x01, 0x8c, 0x4f, 0xa9, 0xe2, 0x16, 0xb7,
	0x9b, 0x9b, 0x71, 0xdd, 0xe4, 0x41, 0x41, 0x2b, 0x8d, 0xce, 0xa7, 0xe8, 0x11, 0x2c, 0x45, 0xbe,
	0x65, 0x50, 0xcc, 0x75, 0x8b, 0xb7, 0xea, 0x02, 0x17, 0x8f, 0x09, 0xca, 0xaf, 0xb2, 0x49, 0x1e,
	0x45, 0xe6, 0xc3, 0x7a, 0x2a, 0xc9, 0x89, 0xbf, 0x22, 0xcb, 0x9f, 0xbc, 0x61, 0x96, 0x13, 0x74,
	0x2d, 0xb5, 0x80, 0x09, 0xed, 0xf0, 0x4b, 0x09, 0xee, 0x88, 0x37, 0x07, 0xb4, 0x0d, 0xeb, 0xa7,
	0x6a, 0xa3, 0xfb, 0x54, 0x53, 0xf5, 0xa7, 0xed, 0x8b, 0x73, 0xb5, 0xd9, 0x3a, 0x6d, 0xa9, 0x27,
	0xe5, 0xaf, 0xa1, 0x75, 0x58, 0x3b, 0x6b, 0x1c, 0xab, 0x67, 0xfa, 0x89, 0xda, 0x55, 0x9b, 0xdd,
	0x56, 0xa7, 0x5d, 0x96, 0xd0, 0x0e, 0x6c, 0x5e, 0x3c, 0xee, 0x74, 0xf5, 0xe6, 0xe3, 0x46, 0xfb,
	0x53, 0x35, 0xc5, 0x92, 0xd1, 0x1e, 0xec, 0xaa, 0x3f, 0x39, 0x3f, 0x6b, 0x35, 0x5b, 0x5d, 0xbd,
	0xd9, 0x69, 0x77, 0xd5, 0x76, 0x37, 0xc5, 0x2f, 0x20, 0x04, 0xab, 0xa7, 0x8d, 0x66, 0x5a, 0xa7,
	0x78, 0x18, 0x00, 0xca, 0x5f, 0xbf, 0xd0, 0xbb, 0xb0, 0x9f, 0xb1, 0xac, 0x3f, 0xe9, 0x9c, 0x64,
	0xfd, 0x5b, 0x81, 0x12, 0x73, 0x25, 0x66, 0x95, 0x25, 0xb4, 0x0a, 0x70, 0xaa, 0x35, 0x9e, 0xa8,
	0xfc, 0x5f, 0x8e, 0xe3, 0x62, 0xec, 0x46, 0xfb, 0x44, 0x4f, 0x31, 0x0a, 0x87, 0x14, 0x60, 0x7c,
	0x76, 0x41, 0xbb, 0xb0, 0x75, 0xd6, 0xfa, 0x91, 0x7a, 0xd6, 0x7a, 0xdc, 0xe9, 0x9c, 0x64, 0x2c,
	0xdc, 0x83, 0x95, 0x67, 0xaa, 0xf6, 0x5c, 0x7f, 0xda, 0x66, 0x22, 0xcf, 0xcb, 0x12, 0x5a, 0x86,
	0xbb, 0xa3, 0x3f, 0x39, 0xfe, 0x3b, 0xef, 0x5c, 0x5c, 0xb4, 0x8e, 0xcf, 0xd4, 0x72, 0x01, 0x01,
	0x2c, 0x0a, 0x4e, 0x11, 0xad, 0xc1, 0x12, 0x53, 0x15, 0x84, 0x85, 0xa3, 0x6b, 0x19, 0x2a, 0x6c,
	0x89, 0x5a, 0xa9, 0xc5, 0xbb, 0xc0, 0xc1, 0xa5, 0x63, 0x62, 0xf4, 0x77, 0x09, 0x56, 0x26, 0x6a,
	0x03, 0xcd, 0x7c, 0x4a, 0x9a, 0xf6, 0x98, 0xb5, 0xfb, 0x20, 0xd1, 0x4e, 0xbd, 0xb2, 0x55, 0x3b,
	0xc9, 0x2b, 0x9b, 0xe2, 0x5c, 0x37, 0xaa, 0x37, 0x75, 0xfc, 0xf4, 0x1a, 0xfd, 0x67, 0x03, 0x8d,
	0x9a, 0xef, 0xdb, 0xc9, 0xfb, 0xd4, 0x17, 0x7f, 0xfd, 0xcf, 0x6f, 0xe4, 0x07, 0x4a, 0x65, 0xf2,
	0xd1, 0x31, 0xac, 0x8b, 0x82, 0xc3, 0x75, 0xe9, 0x70, 0xb7, 0x7b, 0xdd, 0xd8, 0xcf, 0x3b, 0xcf,
	0xbd, 0x33, 0x7c, 0x27, 0xac, 0x9a, 0x64, 0xf8, 0x97, 0x46, 0x75, 0x40, 0xa9, 0x1f, 0xd6, 0x6b,
	0xb5, 0x97, 0x2f, 0x5f, 0x66, 0x98, 0x35, 0x23, 0xa2, 0x03, 0xfe, 0xdc, 0xf9, 0x1d, 0xdf, 0x35,
	0x68, 0x9f, 0x04, 0xc3, 0xe3, 0xdf, 0xc9, 0x70, 0x68, 0x92, 0xe1, 0x8c, 0x39, 0x3a, 0x7e, 0x70,
	0x53, 0xe2, 0xcf, 0xe3, 0x96, 0x3d, 0x97, 0x7e, 0xfa, 0x63, 0x01, 0x64, 0x93, 0xf8, 0xba, 0x53,
	0x25, 0x81, 0x5d, 0xb3, 0xb1, 0xc7, 0x1a, 0xba, 0x36, 0x76, 0xe7, 0xb6, 0x47, 0xd7, 0x47, 0x39,
	0xce, 0xef, 0xe5, 0xf7, 0x3e, 0xe5, 0xc8, 0x4d, 0xe6, 0x62, 0xce, 0x8f, 0xea, 0xb3, 0x87, 0xc7,
	0xb1, 0xea, 0x75, 0x22, 0xf8, 0x82, 0x09, 0xbe, 0xc8, 0x09, 0xbe, 0x78, 0xc6, 0x6d, 0xfc, 0x57,
	0x7e, 0x9f, 0x0b, 0xd6, 0xeb, 0x4c, 0xb2, 0x5e, 0xcf, 0x89, 0xd6, 0xeb, 0x42, 0xb6, 0xb7, 0xc8,
	0x22, 0xf8, 0xe0, 0xff, 0x01, 0x00, 0x00, 0xff, 0xff, 0x05, 0x71, 0x0e, 0x60, 0x35, 0x16, 0x00,
	0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// VideoIntelligenceServiceClient is the client API for VideoIntelligenceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VideoIntelligenceServiceClient interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type videoIntelligenceServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewVideoIntelligenceServiceClient(cc grpc.ClientConnInterface) VideoIntelligenceServiceClient {
	return &videoIntelligenceServiceClient{cc}
}

func (c *videoIntelligenceServiceClient) AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.videointelligence.v1beta2.VideoIntelligenceService/AnnotateVideo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VideoIntelligenceServiceServer is the server API for VideoIntelligenceService service.
type VideoIntelligenceServiceServer interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(context.Context, *AnnotateVideoRequest) (*longrunning.Operation, error)
}

// UnimplementedVideoIntelligenceServiceServer can be embedded to have forward compatible implementations.
type UnimplementedVideoIntelligenceServiceServer struct {
}

func (*UnimplementedVideoIntelligenceServiceServer) AnnotateVideo(ctx context.Context, req *AnnotateVideoRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AnnotateVideo not implemented")
}

func RegisterVideoIntelligenceServiceServer(s *grpc.Server, srv VideoIntelligenceServiceServer) {
	s.RegisterService(&_VideoIntelligenceService_serviceDesc, srv)
}

func _VideoIntelligenceService_AnnotateVideo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.videointelligence.v1beta2.VideoIntelligenceService/AnnotateVideo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, req.(*AnnotateVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VideoIntelligenceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.videointelligence.v1beta2.VideoIntelligenceService",
	HandlerType: (*VideoIntelligenceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnnotateVideo",
			Handler:    _VideoIntelligenceService_AnnotateVideo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/videointelligence/v1beta2/video_intelligence.proto",
}
