// +build go1.9

// Copyright 2020 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package azuredata

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/azuredata/mgmt/2017-03-01-preview/azuredata"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type OperationOrigin = original.OperationOrigin

const (
	System OperationOrigin = original.System
	User   OperationOrigin = original.User
)

type BaseClient = original.BaseClient
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationsClient = original.OperationsClient
type ProxyResource = original.ProxyResource
type Resource = original.Resource
type SQLServer = original.SQLServer
type SQLServerListResult = original.SQLServerListResult
type SQLServerListResultIterator = original.SQLServerListResultIterator
type SQLServerListResultPage = original.SQLServerListResultPage
type SQLServerProperties = original.SQLServerProperties
type SQLServerRegistration = original.SQLServerRegistration
type SQLServerRegistrationListResult = original.SQLServerRegistrationListResult
type SQLServerRegistrationListResultIterator = original.SQLServerRegistrationListResultIterator
type SQLServerRegistrationListResultPage = original.SQLServerRegistrationListResultPage
type SQLServerRegistrationProperties = original.SQLServerRegistrationProperties
type SQLServerRegistrationUpdate = original.SQLServerRegistrationUpdate
type SQLServerRegistrationsClient = original.SQLServerRegistrationsClient
type SQLServersClient = original.SQLServersClient
type TrackedResource = original.TrackedResource

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLServerListResultIterator(page SQLServerListResultPage) SQLServerListResultIterator {
	return original.NewSQLServerListResultIterator(page)
}
func NewSQLServerListResultPage(getNextPage func(context.Context, SQLServerListResult) (SQLServerListResult, error)) SQLServerListResultPage {
	return original.NewSQLServerListResultPage(getNextPage)
}
func NewSQLServerRegistrationListResultIterator(page SQLServerRegistrationListResultPage) SQLServerRegistrationListResultIterator {
	return original.NewSQLServerRegistrationListResultIterator(page)
}
func NewSQLServerRegistrationListResultPage(getNextPage func(context.Context, SQLServerRegistrationListResult) (SQLServerRegistrationListResult, error)) SQLServerRegistrationListResultPage {
	return original.NewSQLServerRegistrationListResultPage(getNextPage)
}
func NewSQLServerRegistrationsClient(subscriptionID string) SQLServerRegistrationsClient {
	return original.NewSQLServerRegistrationsClient(subscriptionID)
}
func NewSQLServerRegistrationsClientWithBaseURI(baseURI string, subscriptionID string) SQLServerRegistrationsClient {
	return original.NewSQLServerRegistrationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLServersClient(subscriptionID string) SQLServersClient {
	return original.NewSQLServersClient(subscriptionID)
}
func NewSQLServersClientWithBaseURI(baseURI string, subscriptionID string) SQLServersClient {
	return original.NewSQLServersClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleOperationOriginValues() []OperationOrigin {
	return original.PossibleOperationOriginValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
