package servicefabricmeshapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/servicefabricmesh/mgmt/2018-07-01-preview/servicefabricmesh"
	"github.com/Azure/go-autorest/autorest"
)

// ApplicationClientAPI contains the set of methods on the ApplicationClient type.
type ApplicationClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, applicationName string, applicationResourceDescription servicefabricmesh.ApplicationResourceDescription) (result servicefabricmesh.ApplicationResourceDescription, err error)
	Delete(ctx context.Context, resourceGroupName string, applicationName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, applicationName string) (result servicefabricmesh.ApplicationResourceDescription, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result servicefabricmesh.ApplicationResourceDescriptionListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result servicefabricmesh.ApplicationResourceDescriptionListIterator, err error)
	ListBySubscription(ctx context.Context) (result servicefabricmesh.ApplicationResourceDescriptionListPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result servicefabricmesh.ApplicationResourceDescriptionListIterator, err error)
}

var _ ApplicationClientAPI = (*servicefabricmesh.ApplicationClient)(nil)

// ServiceClientAPI contains the set of methods on the ServiceClient type.
type ServiceClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, applicationName string, serviceName string) (result servicefabricmesh.ServiceResourceDescription, err error)
	ListByApplicationName(ctx context.Context, resourceGroupName string, applicationName string) (result servicefabricmesh.ServiceListPage, err error)
	ListByApplicationNameComplete(ctx context.Context, resourceGroupName string, applicationName string) (result servicefabricmesh.ServiceListIterator, err error)
}

var _ ServiceClientAPI = (*servicefabricmesh.ServiceClient)(nil)

// ReplicaClientAPI contains the set of methods on the ReplicaClient type.
type ReplicaClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, applicationName string, serviceName string, replicaName string) (result servicefabricmesh.ServiceReplicaDescription, err error)
	ListByServiceName(ctx context.Context, resourceGroupName string, applicationName string, serviceName string) (result servicefabricmesh.ServiceReplicaListPage, err error)
	ListByServiceNameComplete(ctx context.Context, resourceGroupName string, applicationName string, serviceName string) (result servicefabricmesh.ServiceReplicaListIterator, err error)
}

var _ ReplicaClientAPI = (*servicefabricmesh.ReplicaClient)(nil)

// CodePackageClientAPI contains the set of methods on the CodePackageClient type.
type CodePackageClientAPI interface {
	GetContainerLog(ctx context.Context, resourceGroupName string, applicationName string, serviceName string, replicaName string, codePackageName string, tail *int32) (result servicefabricmesh.ContainerLogs, err error)
}

var _ CodePackageClientAPI = (*servicefabricmesh.CodePackageClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result servicefabricmesh.OperationListResultPage, err error)
	ListComplete(ctx context.Context) (result servicefabricmesh.OperationListResultIterator, err error)
}

var _ OperationsClientAPI = (*servicefabricmesh.OperationsClient)(nil)

// NetworkClientAPI contains the set of methods on the NetworkClient type.
type NetworkClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, networkName string, networkResourceDescription servicefabricmesh.NetworkResourceDescription) (result servicefabricmesh.NetworkResourceDescription, err error)
	Delete(ctx context.Context, resourceGroupName string, networkName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, networkName string) (result servicefabricmesh.NetworkResourceDescription, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result servicefabricmesh.NetworkResourceDescriptionListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result servicefabricmesh.NetworkResourceDescriptionListIterator, err error)
	ListBySubscription(ctx context.Context) (result servicefabricmesh.NetworkResourceDescriptionListPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result servicefabricmesh.NetworkResourceDescriptionListIterator, err error)
}

var _ NetworkClientAPI = (*servicefabricmesh.NetworkClient)(nil)

// VolumeClientAPI contains the set of methods on the VolumeClient type.
type VolumeClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, volumeName string, volumeResourceDescription servicefabricmesh.VolumeResourceDescription) (result servicefabricmesh.VolumeResourceDescription, err error)
	Delete(ctx context.Context, resourceGroupName string, volumeName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, volumeName string) (result servicefabricmesh.VolumeResourceDescription, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result servicefabricmesh.VolumeResourceDescriptionListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result servicefabricmesh.VolumeResourceDescriptionListIterator, err error)
	ListBySubscription(ctx context.Context) (result servicefabricmesh.VolumeResourceDescriptionListPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result servicefabricmesh.VolumeResourceDescriptionListIterator, err error)
}

var _ VolumeClientAPI = (*servicefabricmesh.VolumeClient)(nil)
