// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codedeploy

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of a ListApplicationRevisions operation.
type ListApplicationRevisionsInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the IAM user or
	// AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// Whether to list revisions based on whether the revision is the target revision
	// of an deployment group:
	//
	//    * include: List revisions that are target revisions of a deployment group.
	//
	//    * exclude: Do not list revisions that are target revisions of a deployment
	//    group.
	//
	//    * ignore: List all revisions.
	Deployed ListStateFilterAction `locationName:"deployed" type:"string" enum:"true"`

	// An identifier returned from the previous ListApplicationRevisions call. It
	// can be used to return the next set of applications in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An Amazon S3 bucket name to limit the search for revisions.
	//
	// If set to null, all of the user's buckets are searched.
	S3Bucket *string `locationName:"s3Bucket" type:"string"`

	// A key prefix for the set of Amazon S3 objects to limit the search for revisions.
	S3KeyPrefix *string `locationName:"s3KeyPrefix" type:"string"`

	// The column name to use to sort the list results:
	//
	//    * registerTime: Sort by the time the revisions were registered with AWS
	//    CodeDeploy.
	//
	//    * firstUsedTime: Sort by the time the revisions were first used in a deployment.
	//
	//    * lastUsedTime: Sort by the time the revisions were last used in a deployment.
	//
	// If not specified or set to null, the results are returned in an arbitrary
	// order.
	SortBy ApplicationRevisionSortBy `locationName:"sortBy" type:"string" enum:"true"`

	// The order in which to sort the list results:
	//
	//    * ascending: ascending order.
	//
	//    * descending: descending order.
	//
	// If not specified, the results are sorted in ascending order.
	//
	// If set to null, the results are sorted in an arbitrary order.
	SortOrder SortOrder `locationName:"sortOrder" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListApplicationRevisionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationRevisionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListApplicationRevisionsInput"}

	if s.ApplicationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a ListApplicationRevisions operation.
type ListApplicationRevisionsOutput struct {
	_ struct{} `type:"structure"`

	// If a large amount of information is returned, an identifier is also returned.
	// It can be used in a subsequent list application revisions call to return
	// the next set of application revisions in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of locations that contain the matching revisions.
	Revisions []RevisionLocation `locationName:"revisions" type:"list"`
}

// String returns the string representation
func (s ListApplicationRevisionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListApplicationRevisions = "ListApplicationRevisions"

// ListApplicationRevisionsRequest returns a request value for making API operation for
// AWS CodeDeploy.
//
// Lists information about revisions for an application.
//
//    // Example sending a request using ListApplicationRevisionsRequest.
//    req := client.ListApplicationRevisionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplicationRevisions
func (c *Client) ListApplicationRevisionsRequest(input *ListApplicationRevisionsInput) ListApplicationRevisionsRequest {
	op := &aws.Operation{
		Name:       opListApplicationRevisions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationRevisionsInput{}
	}

	req := c.newRequest(op, input, &ListApplicationRevisionsOutput{})
	return ListApplicationRevisionsRequest{Request: req, Input: input, Copy: c.ListApplicationRevisionsRequest}
}

// ListApplicationRevisionsRequest is the request type for the
// ListApplicationRevisions API operation.
type ListApplicationRevisionsRequest struct {
	*aws.Request
	Input *ListApplicationRevisionsInput
	Copy  func(*ListApplicationRevisionsInput) ListApplicationRevisionsRequest
}

// Send marshals and sends the ListApplicationRevisions API request.
func (r ListApplicationRevisionsRequest) Send(ctx context.Context) (*ListApplicationRevisionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListApplicationRevisionsResponse{
		ListApplicationRevisionsOutput: r.Request.Data.(*ListApplicationRevisionsOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListApplicationRevisionsRequestPaginator returns a paginator for ListApplicationRevisions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListApplicationRevisionsRequest(input)
//   p := codedeploy.NewListApplicationRevisionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListApplicationRevisionsPaginator(req ListApplicationRevisionsRequest) ListApplicationRevisionsPaginator {
	return ListApplicationRevisionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListApplicationRevisionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListApplicationRevisionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListApplicationRevisionsPaginator struct {
	aws.Pager
}

func (p *ListApplicationRevisionsPaginator) CurrentPage() *ListApplicationRevisionsOutput {
	return p.Pager.CurrentPage().(*ListApplicationRevisionsOutput)
}

// ListApplicationRevisionsResponse is the response type for the
// ListApplicationRevisions API operation.
type ListApplicationRevisionsResponse struct {
	*ListApplicationRevisionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListApplicationRevisions request.
func (r *ListApplicationRevisionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
