// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/ec2query"
)

type ResetInstanceAttributeInput struct {
	_ struct{} `type:"structure"`

	// The attribute to reset.
	//
	// You can only reset the following attributes: kernel | ramdisk | sourceDestCheck.
	// To change an instance attribute, use ModifyInstanceAttribute.
	//
	// Attribute is a required field
	Attribute InstanceAttributeName `locationName:"attribute" type:"string" required:"true" enum:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `locationName:"instanceId" type:"string" required:"true"`
}

// String returns the string representation
func (s ResetInstanceAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetInstanceAttributeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResetInstanceAttributeInput"}
	if len(s.Attribute) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Attribute"))
	}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ResetInstanceAttributeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ResetInstanceAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

const opResetInstanceAttribute = "ResetInstanceAttribute"

// ResetInstanceAttributeRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Resets an attribute of an instance to its default value. To reset the kernel
// or ramdisk, the instance must be in a stopped state. To reset the sourceDestCheck,
// the instance can be either running or stopped.
//
// The sourceDestCheck attribute controls whether source/destination checking
// is enabled. The default value is true, which means checking is enabled. This
// value must be false for a NAT instance to perform NAT. For more information,
// see NAT Instances (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html)
// in the Amazon Virtual Private Cloud User Guide.
//
//    // Example sending a request using ResetInstanceAttributeRequest.
//    req := client.ResetInstanceAttributeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ResetInstanceAttribute
func (c *Client) ResetInstanceAttributeRequest(input *ResetInstanceAttributeInput) ResetInstanceAttributeRequest {
	op := &aws.Operation{
		Name:       opResetInstanceAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetInstanceAttributeInput{}
	}

	req := c.newRequest(op, input, &ResetInstanceAttributeOutput{})
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return ResetInstanceAttributeRequest{Request: req, Input: input, Copy: c.ResetInstanceAttributeRequest}
}

// ResetInstanceAttributeRequest is the request type for the
// ResetInstanceAttribute API operation.
type ResetInstanceAttributeRequest struct {
	*aws.Request
	Input *ResetInstanceAttributeInput
	Copy  func(*ResetInstanceAttributeInput) ResetInstanceAttributeRequest
}

// Send marshals and sends the ResetInstanceAttribute API request.
func (r ResetInstanceAttributeRequest) Send(ctx context.Context) (*ResetInstanceAttributeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ResetInstanceAttributeResponse{
		ResetInstanceAttributeOutput: r.Request.Data.(*ResetInstanceAttributeOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ResetInstanceAttributeResponse is the response type for the
// ResetInstanceAttribute API operation.
type ResetInstanceAttributeResponse struct {
	*ResetInstanceAttributeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ResetInstanceAttribute request.
func (r *ResetInstanceAttributeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
