// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListNetworkProfilesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the project for which you want to list
	// network profiles.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// The type of network profile you wish to return information about. Valid values
	// are listed below.
	Type NetworkProfileType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListNetworkProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNetworkProfilesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListNetworkProfilesInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListNetworkProfilesOutput struct {
	_ struct{} `type:"structure"`

	// A list of the available network profiles.
	NetworkProfiles []NetworkProfile `locationName:"networkProfiles" type:"list"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListNetworkProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListNetworkProfiles = "ListNetworkProfiles"

// ListNetworkProfilesRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Returns the list of available network profiles.
//
//    // Example sending a request using ListNetworkProfilesRequest.
//    req := client.ListNetworkProfilesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListNetworkProfiles
func (c *Client) ListNetworkProfilesRequest(input *ListNetworkProfilesInput) ListNetworkProfilesRequest {
	op := &aws.Operation{
		Name:       opListNetworkProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListNetworkProfilesInput{}
	}

	req := c.newRequest(op, input, &ListNetworkProfilesOutput{})
	return ListNetworkProfilesRequest{Request: req, Input: input, Copy: c.ListNetworkProfilesRequest}
}

// ListNetworkProfilesRequest is the request type for the
// ListNetworkProfiles API operation.
type ListNetworkProfilesRequest struct {
	*aws.Request
	Input *ListNetworkProfilesInput
	Copy  func(*ListNetworkProfilesInput) ListNetworkProfilesRequest
}

// Send marshals and sends the ListNetworkProfiles API request.
func (r ListNetworkProfilesRequest) Send(ctx context.Context) (*ListNetworkProfilesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListNetworkProfilesResponse{
		ListNetworkProfilesOutput: r.Request.Data.(*ListNetworkProfilesOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListNetworkProfilesResponse is the response type for the
// ListNetworkProfiles API operation.
type ListNetworkProfilesResponse struct {
	*ListNetworkProfilesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListNetworkProfiles request.
func (r *ListNetworkProfilesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
