// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to set a receipt rule set as the active receipt rule
// set. You use receipt rule sets to receive email with Amazon SES. For more
// information, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
type SetActiveReceiptRuleSetInput struct {
	_ struct{} `type:"structure"`

	// The name of the receipt rule set to make active. Setting this value to null
	// disables all email receiving.
	RuleSetName *string `type:"string"`
}

// String returns the string representation
func (s SetActiveReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// An empty element returned on a successful request.
type SetActiveReceiptRuleSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetActiveReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

const opSetActiveReceiptRuleSet = "SetActiveReceiptRuleSet"

// SetActiveReceiptRuleSetRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Sets the specified receipt rule set as the active receipt rule set.
//
// To disable your email-receiving through Amazon SES completely, you can call
// this API with RuleSetName set to null.
//
// For information about managing receipt rule sets, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html).
//
// You can execute this operation no more than once per second.
//
//    // Example sending a request using SetActiveReceiptRuleSetRequest.
//    req := client.SetActiveReceiptRuleSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetActiveReceiptRuleSet
func (c *Client) SetActiveReceiptRuleSetRequest(input *SetActiveReceiptRuleSetInput) SetActiveReceiptRuleSetRequest {
	op := &aws.Operation{
		Name:       opSetActiveReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetActiveReceiptRuleSetInput{}
	}

	req := c.newRequest(op, input, &SetActiveReceiptRuleSetOutput{})
	return SetActiveReceiptRuleSetRequest{Request: req, Input: input, Copy: c.SetActiveReceiptRuleSetRequest}
}

// SetActiveReceiptRuleSetRequest is the request type for the
// SetActiveReceiptRuleSet API operation.
type SetActiveReceiptRuleSetRequest struct {
	*aws.Request
	Input *SetActiveReceiptRuleSetInput
	Copy  func(*SetActiveReceiptRuleSetInput) SetActiveReceiptRuleSetRequest
}

// Send marshals and sends the SetActiveReceiptRuleSet API request.
func (r SetActiveReceiptRuleSetRequest) Send(ctx context.Context) (*SetActiveReceiptRuleSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetActiveReceiptRuleSetResponse{
		SetActiveReceiptRuleSetOutput: r.Request.Data.(*SetActiveReceiptRuleSetOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetActiveReceiptRuleSetResponse is the response type for the
// SetActiveReceiptRuleSet API operation.
type SetActiveReceiptRuleSetResponse struct {
	*SetActiveReceiptRuleSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetActiveReceiptRuleSet request.
func (r *SetActiveReceiptRuleSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
