#!/bin/bash
set -e

echo "> Running build/run-unit-tests.sh"

# Check if buffersize has been increased in vendor/RedisGraph<version>/src/Makefile
bufferSizeIncreased=$(find ../. -type f -name 'Makefile' -exec grep -i 'DYY_BUFFER_SIZE=1048576' '{}' + | wc -l| xargs)
if [ $bufferSizeIncreased -ne 0 ]; then
   echo "Error: Redisgraph buffersize not increased. Please check Makefile and correct.";
   exit 1;
else
    echo "Test Passed: Redisgraph buffersize increased"
fi
# make unit-test
exit 0
