# RediSearch Client Libraries

RediSearch has several client libraries, written by the module authors and community members - abstracting the API in different programming languages. 

While it is possible and simple to use the raw Redis commands API, in most cases it's easier to just use a client library abstracting it. 

## Currently available Libraries

| Language | Library | Author | License | Comments |
|---|---|---|---|---|
|Python | [redisearch-py](https://github.com/RediSearch/redisearch-py) | Redis Labs | BSD | Usually the most up-to-date client library |
| Java | [JRediSearch](https://github.com/RediSearch/JRediSearch) | Redis Labs | BSD | |
| Java | [lettusearch](https://github.com/RediSearch/lettusearch) | Redis Labs | Apache-2.0 | |
| Java | [spring-redisearch](https://github.com/RediSearch/spring-redisearch) | Redis Labs | Apache-2.0 | |
| Go | [redisearch-go](https://github.com/RediSearch/redisearch-go) | Redis Labs | BSD |  | 
| JavaScript | [RedRediSearch](https://github.com/stockholmux/redredisearch) | Kyle J. Davis | MIT | Partial API, compatible with [Reds](https://github.com/tj/reds) |
| JavaScript | [redis-redisearch](https://github.com/stockholmux/node_redis-redisearch) | Kyle J. Davis | MIT | |
| C# | [NRediSearch](https://libraries.io/nuget/NRediSearch) | Marc Gravell | MIT | Part of StackExchange.Redis |
| PHP | [redisearch-php](https://github.com/ethanhann/redisearch-php) | Ethan Hann | MIT |
| Ruby on Rails | [redi_search_rails](https://github.com/dmitrypol/redi_search_rails)  | Dmitry Polyakovsky | MIT | |
| Ruby | [redisearch-rb](https://github.com/vruizext/redisearch-rb) | Victor Ruiz | MIT | |
| Ruby | [redi_search](https://github.com/npezza93/redi_search) | Nick Pezza | MIT | Also works with Ruby on Rails |


## Other available Libraries

| Language | Library | Author | License | Comments |
|---|---|---|---|---|
| Rust | [redisearch-api-rs](https://github.com/RediSearch/redisearch-api-rs) | Redis Labs | BSD | API for Redis Modules written in Rust |
