// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/asset/v1p4beta1/assets.proto

package asset

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	code "google.golang.org/genproto/googleapis/rpc/code"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// IAM Policy analysis result, consisting of one IAM policy binding and derived
// access control lists.
type IamPolicyAnalysisResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full name of the resource to which the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] policy attaches.
	AttachedResourceFullName string `protobuf:"bytes,1,opt,name=attached_resource_full_name,json=attachedResourceFullName,proto3" json:"attached_resource_full_name,omitempty"`
	// The Cloud IAM policy binding under analysis.
	IamBinding *v1.Binding `protobuf:"bytes,2,opt,name=iam_binding,json=iamBinding,proto3" json:"iam_binding,omitempty"`
	// The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
	// potentially match resource and access selectors specified in the request.
	AccessControlLists []*IamPolicyAnalysisResult_AccessControlList `protobuf:"bytes,3,rep,name=access_control_lists,json=accessControlLists,proto3" json:"access_control_lists,omitempty"`
	// The identity list derived from members of the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
	// potentially match identity selector specified in the request.
	IdentityList *IamPolicyAnalysisResult_IdentityList `protobuf:"bytes,4,opt,name=identity_list,json=identityList,proto3" json:"identity_list,omitempty"`
	// Represents whether all nodes in the transitive closure of the
	// [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] node have been explored.
	FullyExplored bool `protobuf:"varint,5,opt,name=fully_explored,json=fullyExplored,proto3" json:"fully_explored,omitempty"`
}

func (x *IamPolicyAnalysisResult) Reset() {
	*x = IamPolicyAnalysisResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisResult) ProtoMessage() {}

func (x *IamPolicyAnalysisResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisResult.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p4beta1_assets_proto_rawDescGZIP(), []int{0}
}

func (x *IamPolicyAnalysisResult) GetAttachedResourceFullName() string {
	if x != nil {
		return x.AttachedResourceFullName
	}
	return ""
}

func (x *IamPolicyAnalysisResult) GetIamBinding() *v1.Binding {
	if x != nil {
		return x.IamBinding
	}
	return nil
}

func (x *IamPolicyAnalysisResult) GetAccessControlLists() []*IamPolicyAnalysisResult_AccessControlList {
	if x != nil {
		return x.AccessControlLists
	}
	return nil
}

func (x *IamPolicyAnalysisResult) GetIdentityList() *IamPolicyAnalysisResult_IdentityList {
	if x != nil {
		return x.IdentityList
	}
	return nil
}

func (x *IamPolicyAnalysisResult) GetFullyExplored() bool {
	if x != nil {
		return x.FullyExplored
	}
	return false
}

// Represents analysis state of each node in the result graph or non-critical
// errors in the response.
type IamPolicyAnalysisResult_AnalysisState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Google standard error code that best describes the state.
	// For example:
	// - OK means the node has been successfully explored;
	// - PERMISSION_DENIED means an access denied error is encountered;
	// - DEADLINE_EXCEEDED means the node hasn't been explored in time;
	Code code.Code `protobuf:"varint,1,opt,name=code,proto3,enum=google.rpc.Code" json:"code,omitempty"`
	// The human-readable description of the cause of failure.
	Cause string `protobuf:"bytes,2,opt,name=cause,proto3" json:"cause,omitempty"`
}

func (x *IamPolicyAnalysisResult_AnalysisState) Reset() {
	*x = IamPolicyAnalysisResult_AnalysisState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisResult_AnalysisState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisResult_AnalysisState) ProtoMessage() {}

func (x *IamPolicyAnalysisResult_AnalysisState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisResult_AnalysisState.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisResult_AnalysisState) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p4beta1_assets_proto_rawDescGZIP(), []int{0, 0}
}

func (x *IamPolicyAnalysisResult_AnalysisState) GetCode() code.Code {
	if x != nil {
		return x.Code
	}
	return code.Code_OK
}

func (x *IamPolicyAnalysisResult_AnalysisState) GetCause() string {
	if x != nil {
		return x.Cause
	}
	return ""
}

// A GCP resource that appears in an access control list.
type IamPolicyAnalysisResult_Resource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [full resource name](https://aip.dev/122#full-resource-names).
	FullResourceName string `protobuf:"bytes,1,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
	// The analysis state of this resource node.
	AnalysisState *IamPolicyAnalysisResult_AnalysisState `protobuf:"bytes,2,opt,name=analysis_state,json=analysisState,proto3" json:"analysis_state,omitempty"`
}

func (x *IamPolicyAnalysisResult_Resource) Reset() {
	*x = IamPolicyAnalysisResult_Resource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisResult_Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisResult_Resource) ProtoMessage() {}

func (x *IamPolicyAnalysisResult_Resource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisResult_Resource.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisResult_Resource) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p4beta1_assets_proto_rawDescGZIP(), []int{0, 1}
}

func (x *IamPolicyAnalysisResult_Resource) GetFullResourceName() string {
	if x != nil {
		return x.FullResourceName
	}
	return ""
}

func (x *IamPolicyAnalysisResult_Resource) GetAnalysisState() *IamPolicyAnalysisResult_AnalysisState {
	if x != nil {
		return x.AnalysisState
	}
	return nil
}

// A role or permission that appears in an access control list.
type IamPolicyAnalysisResult_Access struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to OneofAccess:
	//	*IamPolicyAnalysisResult_Access_Role
	//	*IamPolicyAnalysisResult_Access_Permission
	OneofAccess isIamPolicyAnalysisResult_Access_OneofAccess `protobuf_oneof:"oneof_access"`
	// The analysis state of this access node.
	AnalysisState *IamPolicyAnalysisResult_AnalysisState `protobuf:"bytes,3,opt,name=analysis_state,json=analysisState,proto3" json:"analysis_state,omitempty"`
}

func (x *IamPolicyAnalysisResult_Access) Reset() {
	*x = IamPolicyAnalysisResult_Access{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisResult_Access) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisResult_Access) ProtoMessage() {}

func (x *IamPolicyAnalysisResult_Access) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisResult_Access.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisResult_Access) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p4beta1_assets_proto_rawDescGZIP(), []int{0, 2}
}

func (m *IamPolicyAnalysisResult_Access) GetOneofAccess() isIamPolicyAnalysisResult_Access_OneofAccess {
	if m != nil {
		return m.OneofAccess
	}
	return nil
}

func (x *IamPolicyAnalysisResult_Access) GetRole() string {
	if x, ok := x.GetOneofAccess().(*IamPolicyAnalysisResult_Access_Role); ok {
		return x.Role
	}
	return ""
}

func (x *IamPolicyAnalysisResult_Access) GetPermission() string {
	if x, ok := x.GetOneofAccess().(*IamPolicyAnalysisResult_Access_Permission); ok {
		return x.Permission
	}
	return ""
}

func (x *IamPolicyAnalysisResult_Access) GetAnalysisState() *IamPolicyAnalysisResult_AnalysisState {
	if x != nil {
		return x.AnalysisState
	}
	return nil
}

type isIamPolicyAnalysisResult_Access_OneofAccess interface {
	isIamPolicyAnalysisResult_Access_OneofAccess()
}

type IamPolicyAnalysisResult_Access_Role struct {
	// The role.
	Role string `protobuf:"bytes,1,opt,name=role,proto3,oneof"`
}

type IamPolicyAnalysisResult_Access_Permission struct {
	// The permission.
	Permission string `protobuf:"bytes,2,opt,name=permission,proto3,oneof"`
}

func (*IamPolicyAnalysisResult_Access_Role) isIamPolicyAnalysisResult_Access_OneofAccess() {}

func (*IamPolicyAnalysisResult_Access_Permission) isIamPolicyAnalysisResult_Access_OneofAccess() {}

// A directional edge.
type IamPolicyAnalysisResult_Edge struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source node of the edge.
	SourceNode string `protobuf:"bytes,1,opt,name=source_node,json=sourceNode,proto3" json:"source_node,omitempty"`
	// The target node of the edge.
	TargetNode string `protobuf:"bytes,2,opt,name=target_node,json=targetNode,proto3" json:"target_node,omitempty"`
}

func (x *IamPolicyAnalysisResult_Edge) Reset() {
	*x = IamPolicyAnalysisResult_Edge{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisResult_Edge) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisResult_Edge) ProtoMessage() {}

func (x *IamPolicyAnalysisResult_Edge) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisResult_Edge.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisResult_Edge) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p4beta1_assets_proto_rawDescGZIP(), []int{0, 3}
}

func (x *IamPolicyAnalysisResult_Edge) GetSourceNode() string {
	if x != nil {
		return x.SourceNode
	}
	return ""
}

func (x *IamPolicyAnalysisResult_Edge) GetTargetNode() string {
	if x != nil {
		return x.TargetNode
	}
	return ""
}

// An identity that appears in an access control list.
type IamPolicyAnalysisResult_Identity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identity name in any form of members appear in
	// [IAM policy
	// binding](https://cloud.google.com/iam/reference/rest/v1/Binding), such
	// as:
	// - user:foo@google.com
	// - group:group1@google.com
	// - serviceAccount:s1@prj1.iam.gserviceaccount.com
	// - projectOwner:some_project_id
	// - domain:google.com
	// - allUsers
	// - etc.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The analysis state of this identity node.
	AnalysisState *IamPolicyAnalysisResult_AnalysisState `protobuf:"bytes,2,opt,name=analysis_state,json=analysisState,proto3" json:"analysis_state,omitempty"`
}

func (x *IamPolicyAnalysisResult_Identity) Reset() {
	*x = IamPolicyAnalysisResult_Identity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisResult_Identity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisResult_Identity) ProtoMessage() {}

func (x *IamPolicyAnalysisResult_Identity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisResult_Identity.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisResult_Identity) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p4beta1_assets_proto_rawDescGZIP(), []int{0, 4}
}

func (x *IamPolicyAnalysisResult_Identity) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *IamPolicyAnalysisResult_Identity) GetAnalysisState() *IamPolicyAnalysisResult_AnalysisState {
	if x != nil {
		return x.AnalysisState
	}
	return nil
}

// An access control list, derived from the above IAM policy binding, which
// contains a set of resources and accesses. May include one
// item from each set to compose an access control entry.
//
// NOTICE that there could be multiple access control lists for one IAM policy
// binding. The access control lists are created based on resource and access
// combinations.
//
// For example, assume we have the following cases in one IAM policy binding:
// - Permission P1 and P2 apply to resource R1 and R2;
// - Permission P3 applies to resource R2 and R3;
//
// This will result in the following access control lists:
// - AccessControlList 1: [R1, R2], [P1, P2]
// - AccessControlList 2: [R2, R3], [P3]
type IamPolicyAnalysisResult_AccessControlList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resources that match one of the following conditions:
	// - The resource_selector, if it is specified in request;
	// - Otherwise, resources reachable from the policy attached resource.
	Resources []*IamPolicyAnalysisResult_Resource `protobuf:"bytes,1,rep,name=resources,proto3" json:"resources,omitempty"`
	// The accesses that match one of the following conditions:
	// - The access_selector, if it is specified in request;
	// - Otherwise, access specifiers reachable from the policy binding's role.
	Accesses []*IamPolicyAnalysisResult_Access `protobuf:"bytes,2,rep,name=accesses,proto3" json:"accesses,omitempty"`
	// Resource edges of the graph starting from the policy attached
	// resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
	// the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
	// contains the full resource name of a child resource. This field is
	// present only if the output_resource_edges option is enabled in request.
	ResourceEdges []*IamPolicyAnalysisResult_Edge `protobuf:"bytes,3,rep,name=resource_edges,json=resourceEdges,proto3" json:"resource_edges,omitempty"`
}

func (x *IamPolicyAnalysisResult_AccessControlList) Reset() {
	*x = IamPolicyAnalysisResult_AccessControlList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisResult_AccessControlList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisResult_AccessControlList) ProtoMessage() {}

func (x *IamPolicyAnalysisResult_AccessControlList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisResult_AccessControlList.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisResult_AccessControlList) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p4beta1_assets_proto_rawDescGZIP(), []int{0, 5}
}

func (x *IamPolicyAnalysisResult_AccessControlList) GetResources() []*IamPolicyAnalysisResult_Resource {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *IamPolicyAnalysisResult_AccessControlList) GetAccesses() []*IamPolicyAnalysisResult_Access {
	if x != nil {
		return x.Accesses
	}
	return nil
}

func (x *IamPolicyAnalysisResult_AccessControlList) GetResourceEdges() []*IamPolicyAnalysisResult_Edge {
	if x != nil {
		return x.ResourceEdges
	}
	return nil
}

type IamPolicyAnalysisResult_IdentityList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Only the identities that match one of the following conditions will be
	// presented:
	// - The identity_selector, if it is specified in request;
	// - Otherwise, identities reachable from the policy binding's members.
	Identities []*IamPolicyAnalysisResult_Identity `protobuf:"bytes,1,rep,name=identities,proto3" json:"identities,omitempty"`
	// Group identity edges of the graph starting from the binding's
	// group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
	// contains a group, such as "group:parent@google.com". The
	// [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
	// such as "group:child@google.com" or "user:foo@google.com".
	// This field is present only if the output_group_edges option is enabled in
	// request.
	GroupEdges []*IamPolicyAnalysisResult_Edge `protobuf:"bytes,2,rep,name=group_edges,json=groupEdges,proto3" json:"group_edges,omitempty"`
}

func (x *IamPolicyAnalysisResult_IdentityList) Reset() {
	*x = IamPolicyAnalysisResult_IdentityList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisResult_IdentityList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisResult_IdentityList) ProtoMessage() {}

func (x *IamPolicyAnalysisResult_IdentityList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisResult_IdentityList.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisResult_IdentityList) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p4beta1_assets_proto_rawDescGZIP(), []int{0, 6}
}

func (x *IamPolicyAnalysisResult_IdentityList) GetIdentities() []*IamPolicyAnalysisResult_Identity {
	if x != nil {
		return x.Identities
	}
	return nil
}

func (x *IamPolicyAnalysisResult_IdentityList) GetGroupEdges() []*IamPolicyAnalysisResult_Edge {
	if x != nil {
		return x.GroupEdges
	}
	return nil
}

var File_google_cloud_asset_v1p4beta1_assets_proto protoreflect.FileDescriptor

var file_google_cloud_asset_v1p4beta1_assets_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2f, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70,
	0x63, 0x2f, 0x63, 0x6f, 0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa5, 0x0c, 0x0a, 0x17, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x3d, 0x0a, 0x1b, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x66, 0x75, 0x6c, 0x6c,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x18, 0x61, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x75, 0x6c,
	0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x37, 0x0a, 0x0b, 0x69, 0x61, 0x6d, 0x5f, 0x62, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x52, 0x0a, 0x69, 0x61, 0x6d, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x79,
	0x0a, 0x14, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x5f, 0x6c, 0x69, 0x73, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x12, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x4c, 0x69, 0x73, 0x74, 0x73, 0x12, 0x67, 0x0a, 0x0d, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x0c, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4c, 0x69,
	0x73, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6c,
	0x6f, 0x72, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x66, 0x75, 0x6c, 0x6c,
	0x79, 0x45, 0x78, 0x70, 0x6c, 0x6f, 0x72, 0x65, 0x64, 0x1a, 0x4b, 0x0a, 0x0d, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x24, 0x0a, 0x04, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x63, 0x61, 0x75, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x63, 0x61, 0x75, 0x73, 0x65, 0x1a, 0xa4, 0x01, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x10, 0x66, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x6a, 0x0a, 0x0e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0d,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x1a, 0xbc, 0x01,
	0x0a, 0x06, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x14, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x20,
	0x0a, 0x0a, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x6a, 0x0a, 0x0e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0d, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x0e, 0x0a, 0x0c,
	0x6f, 0x6e, 0x65, 0x6f, 0x66, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x1a, 0x48, 0x0a, 0x04,
	0x45, 0x64, 0x67, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e,
	0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x6e, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x1a, 0x8a, 0x01, 0x0a, 0x08, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x6a, 0x0a, 0x0e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x0d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x1a, 0xae, 0x02, 0x0a, 0x11, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x5c, 0x0a, 0x09, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x09, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x58, 0x0a, 0x08, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x08, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x65,
	0x73, 0x12, 0x61, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x65, 0x64,
	0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x2e, 0x45, 0x64, 0x67, 0x65, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45,
	0x64, 0x67, 0x65, 0x73, 0x1a, 0xcb, 0x01, 0x0a, 0x0c, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x5e, 0x0a, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x5b, 0x0a, 0x0b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x65,
	0x64, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x2e, 0x45, 0x64, 0x67, 0x65, 0x52, 0x0a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x45, 0x64, 0x67,
	0x65, 0x73, 0x42, 0xb4, 0x01, 0x0a, 0x20, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x0a, 0x41, 0x73, 0x73, 0x65, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2f, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x3b, 0x61, 0x73, 0x73, 0x65, 0x74, 0xf8, 0x01, 0x01, 0xaa, 0x02, 0x1c, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x56, 0x31, 0x50, 0x34, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1c, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x73, 0x73, 0x65, 0x74, 0x5c,
	0x56, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_asset_v1p4beta1_assets_proto_rawDescOnce sync.Once
	file_google_cloud_asset_v1p4beta1_assets_proto_rawDescData = file_google_cloud_asset_v1p4beta1_assets_proto_rawDesc
)

func file_google_cloud_asset_v1p4beta1_assets_proto_rawDescGZIP() []byte {
	file_google_cloud_asset_v1p4beta1_assets_proto_rawDescOnce.Do(func() {
		file_google_cloud_asset_v1p4beta1_assets_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_asset_v1p4beta1_assets_proto_rawDescData)
	})
	return file_google_cloud_asset_v1p4beta1_assets_proto_rawDescData
}

var file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_asset_v1p4beta1_assets_proto_goTypes = []interface{}{
	(*IamPolicyAnalysisResult)(nil),                   // 0: google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult
	(*IamPolicyAnalysisResult_AnalysisState)(nil),     // 1: google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
	(*IamPolicyAnalysisResult_Resource)(nil),          // 2: google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource
	(*IamPolicyAnalysisResult_Access)(nil),            // 3: google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access
	(*IamPolicyAnalysisResult_Edge)(nil),              // 4: google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge
	(*IamPolicyAnalysisResult_Identity)(nil),          // 5: google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity
	(*IamPolicyAnalysisResult_AccessControlList)(nil), // 6: google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
	(*IamPolicyAnalysisResult_IdentityList)(nil),      // 7: google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList
	(*v1.Binding)(nil),                                // 8: google.iam.v1.Binding
	(code.Code)(0),                                    // 9: google.rpc.Code
}
var file_google_cloud_asset_v1p4beta1_assets_proto_depIdxs = []int32{
	8,  // 0: google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding:type_name -> google.iam.v1.Binding
	6,  // 1: google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.access_control_lists:type_name -> google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
	7,  // 2: google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.identity_list:type_name -> google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList
	9,  // 3: google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.code:type_name -> google.rpc.Code
	1,  // 4: google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource.analysis_state:type_name -> google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
	1,  // 5: google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access.analysis_state:type_name -> google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
	1,  // 6: google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity.analysis_state:type_name -> google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
	2,  // 7: google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList.resources:type_name -> google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource
	3,  // 8: google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList.accesses:type_name -> google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access
	4,  // 9: google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList.resource_edges:type_name -> google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge
	5,  // 10: google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities:type_name -> google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity
	4,  // 11: google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.group_edges:type_name -> google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_asset_v1p4beta1_assets_proto_init() }
func file_google_cloud_asset_v1p4beta1_assets_proto_init() {
	if File_google_cloud_asset_v1p4beta1_assets_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisResult_AnalysisState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisResult_Resource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisResult_Access); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisResult_Edge); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisResult_Identity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisResult_AccessControlList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisResult_IdentityList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*IamPolicyAnalysisResult_Access_Role)(nil),
		(*IamPolicyAnalysisResult_Access_Permission)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_asset_v1p4beta1_assets_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_asset_v1p4beta1_assets_proto_goTypes,
		DependencyIndexes: file_google_cloud_asset_v1p4beta1_assets_proto_depIdxs,
		MessageInfos:      file_google_cloud_asset_v1p4beta1_assets_proto_msgTypes,
	}.Build()
	File_google_cloud_asset_v1p4beta1_assets_proto = out.File
	file_google_cloud_asset_v1p4beta1_assets_proto_rawDesc = nil
	file_google_cloud_asset_v1p4beta1_assets_proto_goTypes = nil
	file_google_cloud_asset_v1p4beta1_assets_proto_depIdxs = nil
}
