// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/actions/sdk/v2/interactionmodel/scene.proto

package interactionmodel

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Scene is the basic unit of control flow when designing a conversation. They
// can be chained together with other scenes, generate prompts for the end user,
// and define slots.
// The scene name is specified in the name of the file.
type Scene struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Handler to invoke when transitioning into this scene.
	OnEnter *EventHandler `protobuf:"bytes,1,opt,name=on_enter,json=onEnter,proto3" json:"on_enter,omitempty"`
	// The list of events that trigger based on intents. These events can
	// be triggered at any time after the on_load Handler has been called.
	// Important - these events define the set of intents which are scoped to
	// this scene and will take precedence over any globally defined events that
	// have the same intents or their triggering phrases. Intent names must be
	// unique within a scene.
	IntentEvents []*IntentEvent `protobuf:"bytes,2,rep,name=intent_events,json=intentEvents,proto3" json:"intent_events,omitempty"`
	// The list of events to trigger based on conditional statements. These are
	// evaluated after the form has been filled or immediately after on_load if
	// this scene does not have a form (evaluation is only done once). Only the
	// first matching event will be triggered.
	ConditionalEvents []*ConditionalEvent `protobuf:"bytes,3,rep,name=conditional_events,json=conditionalEvents,proto3" json:"conditional_events,omitempty"`
	// Ordered list of slots. Each slot defines the type of data
	// that it will resolve and configuration to customize the experience of this
	// resolution (e.g. prompts).
	Slots []*Slot `protobuf:"bytes,4,rep,name=slots,proto3" json:"slots,omitempty"`
	// Handler called when there is a change in state of a slot not
	// caused by updates within another Handler. This allows slots to be
	// invalidated, the scene invalidated or other changes to scene state.
	OnSlotUpdated *EventHandler `protobuf:"bytes,5,opt,name=on_slot_updated,json=onSlotUpdated,proto3" json:"on_slot_updated,omitempty"`
}

func (x *Scene) Reset() {
	*x = Scene{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_interactionmodel_scene_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Scene) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Scene) ProtoMessage() {}

func (x *Scene) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_interactionmodel_scene_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Scene.ProtoReflect.Descriptor instead.
func (*Scene) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_interactionmodel_scene_proto_rawDescGZIP(), []int{0}
}

func (x *Scene) GetOnEnter() *EventHandler {
	if x != nil {
		return x.OnEnter
	}
	return nil
}

func (x *Scene) GetIntentEvents() []*IntentEvent {
	if x != nil {
		return x.IntentEvents
	}
	return nil
}

func (x *Scene) GetConditionalEvents() []*ConditionalEvent {
	if x != nil {
		return x.ConditionalEvents
	}
	return nil
}

func (x *Scene) GetSlots() []*Slot {
	if x != nil {
		return x.Slots
	}
	return nil
}

func (x *Scene) GetOnSlotUpdated() *EventHandler {
	if x != nil {
		return x.OnSlotUpdated
	}
	return nil
}

var File_google_actions_sdk_v2_interactionmodel_scene_proto protoreflect.FileDescriptor

var file_google_actions_sdk_v2_interactionmodel_scene_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x73, 0x63, 0x65, 0x6e, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x1a, 0x3e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b,
	0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b,
	0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c,
	0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x73, 0x6c, 0x6f, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbd, 0x03, 0x0a, 0x05, 0x53, 0x63, 0x65, 0x6e, 0x65,
	0x12, 0x4f, 0x0a, 0x08, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x52, 0x07, 0x6f, 0x6e, 0x45, 0x6e, 0x74, 0x65,
	0x72, 0x12, 0x58, 0x0a, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32,
	0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x0c, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x67, 0x0a, 0x12, 0x63,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0x42, 0x0a, 0x05, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x53, 0x6c, 0x6f,
	0x74, 0x52, 0x05, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x12, 0x5c, 0x0a, 0x0f, 0x6f, 0x6e, 0x5f, 0x73,
	0x6c, 0x6f, 0x74, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x52, 0x0d, 0x6f, 0x6e, 0x53, 0x6c, 0x6f, 0x74, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x42, 0x92, 0x01, 0x0a, 0x2a, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64,
	0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x0a, 0x53, 0x63, 0x65, 0x6e, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x56, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3b, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_actions_sdk_v2_interactionmodel_scene_proto_rawDescOnce sync.Once
	file_google_actions_sdk_v2_interactionmodel_scene_proto_rawDescData = file_google_actions_sdk_v2_interactionmodel_scene_proto_rawDesc
)

func file_google_actions_sdk_v2_interactionmodel_scene_proto_rawDescGZIP() []byte {
	file_google_actions_sdk_v2_interactionmodel_scene_proto_rawDescOnce.Do(func() {
		file_google_actions_sdk_v2_interactionmodel_scene_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_actions_sdk_v2_interactionmodel_scene_proto_rawDescData)
	})
	return file_google_actions_sdk_v2_interactionmodel_scene_proto_rawDescData
}

var file_google_actions_sdk_v2_interactionmodel_scene_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_actions_sdk_v2_interactionmodel_scene_proto_goTypes = []interface{}{
	(*Scene)(nil),            // 0: google.actions.sdk.v2.interactionmodel.Scene
	(*EventHandler)(nil),     // 1: google.actions.sdk.v2.interactionmodel.EventHandler
	(*IntentEvent)(nil),      // 2: google.actions.sdk.v2.interactionmodel.IntentEvent
	(*ConditionalEvent)(nil), // 3: google.actions.sdk.v2.interactionmodel.ConditionalEvent
	(*Slot)(nil),             // 4: google.actions.sdk.v2.interactionmodel.Slot
}
var file_google_actions_sdk_v2_interactionmodel_scene_proto_depIdxs = []int32{
	1, // 0: google.actions.sdk.v2.interactionmodel.Scene.on_enter:type_name -> google.actions.sdk.v2.interactionmodel.EventHandler
	2, // 1: google.actions.sdk.v2.interactionmodel.Scene.intent_events:type_name -> google.actions.sdk.v2.interactionmodel.IntentEvent
	3, // 2: google.actions.sdk.v2.interactionmodel.Scene.conditional_events:type_name -> google.actions.sdk.v2.interactionmodel.ConditionalEvent
	4, // 3: google.actions.sdk.v2.interactionmodel.Scene.slots:type_name -> google.actions.sdk.v2.interactionmodel.Slot
	1, // 4: google.actions.sdk.v2.interactionmodel.Scene.on_slot_updated:type_name -> google.actions.sdk.v2.interactionmodel.EventHandler
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_google_actions_sdk_v2_interactionmodel_scene_proto_init() }
func file_google_actions_sdk_v2_interactionmodel_scene_proto_init() {
	if File_google_actions_sdk_v2_interactionmodel_scene_proto != nil {
		return
	}
	file_google_actions_sdk_v2_interactionmodel_conditional_event_proto_init()
	file_google_actions_sdk_v2_interactionmodel_event_handler_proto_init()
	file_google_actions_sdk_v2_interactionmodel_intent_event_proto_init()
	file_google_actions_sdk_v2_interactionmodel_slot_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_actions_sdk_v2_interactionmodel_scene_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Scene); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_actions_sdk_v2_interactionmodel_scene_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_actions_sdk_v2_interactionmodel_scene_proto_goTypes,
		DependencyIndexes: file_google_actions_sdk_v2_interactionmodel_scene_proto_depIdxs,
		MessageInfos:      file_google_actions_sdk_v2_interactionmodel_scene_proto_msgTypes,
	}.Build()
	File_google_actions_sdk_v2_interactionmodel_scene_proto = out.File
	file_google_actions_sdk_v2_interactionmodel_scene_proto_rawDesc = nil
	file_google_actions_sdk_v2_interactionmodel_scene_proto_goTypes = nil
	file_google_actions_sdk_v2_interactionmodel_scene_proto_depIdxs = nil
}
