import { GraphQLSchema } from 'graphql';
import { Transform } from '@graphql-tools/utils';
import { SubschemaConfig, MergedTypeConfig, CreateProxyingResolverFn, Subscriber, Executor } from './types';
export declare function getSubschema(result: any, responseKey: string): GraphQLSchema | SubschemaConfig;
export declare function setObjectSubschema(result: any, subschema: GraphQLSchema | SubschemaConfig): void;
export declare function isSubschemaConfig(value: any): value is SubschemaConfig;
export declare function isSubschema(value: any): value is Subschema;
export declare class Subschema {
    schema: GraphQLSchema;
    rootValue?: Record<string, any>;
    executor?: Executor;
    subscriber?: Subscriber;
    createProxyingResolver?: CreateProxyingResolverFn;
    transforms: Array<Transform>;
    transformedSchema: GraphQLSchema;
    merge?: Record<string, MergedTypeConfig>;
    constructor(config: SubschemaConfig);
}
