"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("../utils");
class BranchDeletionBatch {
    constructor() {
        this.all = [];
        this.branches = {};
        this.errors = [];
    }
    get success() {
        return !this.errors.length;
    }
}
exports.BranchDeletionBatch = BranchDeletionBatch;
class BranchDeletion {
    constructor(branch, hash) {
        this.branch = branch;
        this.hash = hash;
    }
    get success() {
        return this.hash !== null;
    }
}
exports.BranchDeletion = BranchDeletion;
exports.deleteSuccessRegex = /(\S+)\s+\(\S+\s([^)]+)\)/;
exports.deleteErrorRegex = /^error[^']+'([^']+)'/m;
function hasBranchDeletionError(data, processExitCode = utils_1.ExitCodes.ERROR) {
    return exports.deleteErrorRegex.test(data) && processExitCode === utils_1.ExitCodes.ERROR;
}
exports.hasBranchDeletionError = hasBranchDeletionError;
function parseBranchDeletions(data) {
    const batch = new BranchDeletionBatch();
    data.trim().split('\n').forEach((line) => {
        const deletion = toBranchDeletion(line);
        if (!deletion) {
            return;
        }
        batch.all.push(batch.branches[deletion.branch] = deletion);
        if (!deletion.success) {
            batch.errors.push(deletion);
        }
    });
    return batch;
}
exports.parseBranchDeletions = parseBranchDeletions;
function toBranchDeletion(line) {
    const result = exports.deleteSuccessRegex.exec(line) || exports.deleteErrorRegex.exec(line);
    return result && new BranchDeletion(result[1], result.length > 1 && result[2] || null);
}
//# sourceMappingURL=BranchDeleteSummary.js.map