"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function filterType(input, ...filters) {
    return filters.some((filter) => filter(input)) ? input : undefined;
}
exports.filterType = filterType;
exports.filterArray = (input) => {
    return Array.isArray(input);
};
exports.filterPrimitives = (input) => {
    return /number|string|boolean/.test(typeof input);
};
exports.filterString = (input) => {
    return typeof input === 'string';
};
exports.filterPlainObject = (input) => {
    return !!input && Object.prototype.toString.call(input) === '[object Object]';
};
exports.filterFunction = (input) => {
    return typeof input === 'function';
};
//# sourceMappingURL=argument-filters.js.map