/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 * @emails oncall+relay
 */
// flowlint ambiguous-object-type:error
'use strict';

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var IRTransformer = require('../core/IRTransformer');

// The purpose of this directive is to add GraphQL type inform for fields in
// the operation selection in order to use in in RelayMockPayloadGenerator
// to generate better mock values, and expand the API of MockResolvers
var SCHEMA_EXTENSION = 'directive @relay_test_operation on QUERY | MUTATION | SUBSCRIPTION';

function testOperationDirective(context) {
  return IRTransformer.transform(context, {
    Fragment: function Fragment(node) {
      return node;
    },
    Root: visitRoot,
    SplitOperation: function SplitOperation(node) {
      return node;
    }
  });
}

function getTypeDetails(schema, fieldType) {
  var nullableType = schema.getNullableType(fieldType);
  var isNullable = !schema.isNonNull(fieldType);
  var isPlural = schema.isList(nullableType);
  var type = schema.getRawType(nullableType);
  return {
    type: schema.getTypeString(type),
    enumValues: schema.isEnum(type) ? schema.getEnumValues(schema.assertEnumType(type)) : null,
    plural: isPlural,
    nullable: isNullable
  };
}

function visitRoot(node) {
  var schema = this.getContext().getSchema();
  var testDirective = node.directives.find(function (directive) {
    return directive.name === 'relay_test_operation';
  });

  if (testDirective == null) {
    return node;
  }

  var context = this.getContext();
  var queue = [{
    selections: node.selections,
    path: null
  }];
  var selectionsTypeInfo = {};

  var _loop = function _loop() {
    var _queue$pop = queue.pop(),
        currentSelections = _queue$pop.selections,
        path = _queue$pop.path;

    currentSelections.forEach(function (selection) {
      switch (selection.kind) {
        case 'FragmentSpread':
          var fragment = context.get(selection.name);

          if (fragment != null) {
            queue.unshift({
              selections: fragment.selections,
              path: path
            });
          }

          break;

        case 'ScalarField':
          {
            var nextPath = path === null ? selection.alias : "".concat(path, ".").concat(selection.alias);
            selectionsTypeInfo[nextPath] = getTypeDetails(schema, selection.type);
            break;
          }

        case 'LinkedField':
          {
            var _nextPath = path === null ? selection.alias : "".concat(path, ".").concat(selection.alias);

            selectionsTypeInfo[_nextPath] = getTypeDetails(schema, selection.type);
            queue.unshift({
              selections: selection.selections,
              path: _nextPath
            });
            break;
          }

        case 'Condition':
        case 'ClientExtension':
        case 'Defer':
        case 'InlineDataFragmentSpread':
        case 'InlineFragment':
        case 'ModuleImport':
        case 'Stream':
          queue.unshift({
            selections: selection.selections,
            path: path
          });
          break;

        default:
          selection;
          break;
      }
    });
  };

  while (queue.length > 0) {
    _loop();
  }

  return _objectSpread({}, node, {
    directives: node.directives.filter(function (directive) {
      return directive !== testDirective;
    }),
    metadata: _objectSpread({}, node.metadata || {}, {
      relayTestingSelectionTypeInfo: selectionsTypeInfo
    })
  });
}

module.exports = {
  SCHEMA_EXTENSION: SCHEMA_EXTENSION,
  transform: testOperationDirective
};