import { EdgeServerInfo } from './reportingOperationTypes';
import { Logger } from 'apollo-server-types';
export declare const reportServerInfoGql = "\n  mutation ReportServerInfo($info: EdgeServerInfo!, $executableSchema: String) {\n    me {\n      __typename\n      ... on ServiceMutation {\n        reportServerInfo(info: $info, executableSchema: $executableSchema) {\n          __typename\n          ... on ReportServerInfoError {\n            message\n            code\n          }\n          ... on ReportServerInfoResponse {\n            inSeconds\n            withExecutableSchema\n          }\n        }\n      }\n    }\n  }\n";
export declare type ReportInfoResult = ReportInfoStop | ReportInfoNext;
export interface ReportInfoNext {
    kind: 'next';
    inSeconds: number;
    withExecutableSchema: boolean;
}
export interface ReportInfoStop {
    kind: 'stop';
    stopReporting: true;
}
export declare function reportingLoop(schemaReporter: SchemaReporter, logger: Logger, sendNextWithExecutableSchema: boolean, fallbackReportingDelayInMs: number): void;
export declare class SchemaReporter {
    private readonly serverInfo;
    private readonly executableSchemaDocument;
    private readonly url;
    private isStopped;
    private readonly headers;
    private readonly logger;
    constructor(serverInfo: EdgeServerInfo, schemaSdl: string, apiKey: string, schemaReportingEndpoint: string | undefined, logger: Logger);
    stopped(): Boolean;
    stop(): void;
    reportServerInfo(withExecutableSchema: boolean): Promise<ReportInfoResult>;
    private graphManagerQuery;
}
//# sourceMappingURL=schemaReporter.d.ts.map