import { IntrospectionOptions } from 'graphql';
import { SchemaPointerSingle, Source, DocumentLoader, SingleFileOptions } from '@graphql-tools/utils';
import { fetch as crossFetch } from 'cross-fetch';
import { AsyncExecutor, Subscriber } from '@graphql-tools/delegate';
import { w3cwebsocket } from 'websocket';
export declare type FetchFn = typeof import('cross-fetch').fetch;
declare type Headers = Record<string, string> | Array<Record<string, string>>;
export interface LoadFromUrlOptions extends SingleFileOptions, Partial<IntrospectionOptions> {
    headers?: Headers;
    customFetch?: FetchFn | string;
    method?: 'GET' | 'POST';
    enableSubscriptions?: boolean;
    webSocketImpl?: typeof w3cwebsocket | string;
    useGETForQueries?: boolean;
}
export declare class UrlLoader implements DocumentLoader<LoadFromUrlOptions> {
    loaderId(): string;
    canLoad(pointer: SchemaPointerSingle, options: LoadFromUrlOptions): Promise<boolean>;
    canLoadSync(pointer: SchemaPointerSingle, _options: LoadFromUrlOptions): boolean;
    buildAsyncExecutor({ pointer, fetch, extraHeaders, defaultMethod, useGETForQueries, }: {
        pointer: string;
        fetch: typeof crossFetch;
        extraHeaders: any;
        defaultMethod: 'GET' | 'POST';
        useGETForQueries: boolean;
    }): AsyncExecutor;
    buildSubscriber(pointer: string, webSocketImpl: typeof w3cwebsocket): Subscriber;
    getExecutorAndSubscriber(pointer: SchemaPointerSingle, options: LoadFromUrlOptions): Promise<{
        executor: AsyncExecutor;
        subscriber: Subscriber;
    }>;
    getSubschemaConfig(pointer: SchemaPointerSingle, options: LoadFromUrlOptions): Promise<{
        schema: import("graphql").GraphQLSchema;
        executor: AsyncExecutor;
        subscriber: Subscriber;
    }>;
    load(pointer: SchemaPointerSingle, options: LoadFromUrlOptions): Promise<Source>;
    loadSync(): never;
}
export {};
