/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 * @emails oncall+relay
 */
// flowlint ambiguous-object-type:error
'use strict';

var _asyncToGenerator = require("@babel/runtime/helpers/asyncToGenerator");

function _createForOfIteratorHelper(o) { if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (o = _unsupportedIterableToArray(o))) { var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var it, normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var invariant = require("fbjs/lib/invariant");

var StrictMap = /*#__PURE__*/function () {
  function StrictMap(iterable) {
    this._map = new Map(iterable);
    return this;
  }

  var _proto = StrictMap.prototype;

  _proto.clear = function clear() {
    this._map.clear();
  };

  _proto["delete"] = function _delete(key) {
    return this._map["delete"](key);
  };

  _proto.entries = function entries() {
    return this._map.entries();
  };

  _proto.forEach = function forEach(callbackfn, thisArg) {
    this._map.forEach(callbackfn, thisArg);
  };

  _proto.map = function map(f) {
    var result = new StrictMap();

    var _iterator = _createForOfIteratorHelper(this._map),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var _step$value = _step.value,
            key = _step$value[0],
            val = _step$value[1];
        result.set(key, f(val, key, this));
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    return result;
  };

  _proto.asyncMap = /*#__PURE__*/function () {
    var _asyncMap = _asyncToGenerator(function* (f) {
      var _this = this;

      var entryPromises = [];

      var _iterator2 = _createForOfIteratorHelper(this._map),
          _step2;

      try {
        var _loop = function _loop() {
          var _step2$value = _step2.value,
              key = _step2$value[0],
              val = _step2$value[1];
          entryPromises.push(f(val, key, _this).then(function (resultVal) {
            return [key, resultVal];
          }));
        };

        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          _loop();
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      var entries = yield Promise.all(entryPromises);
      return new StrictMap(entries);
    });

    function asyncMap(_x) {
      return _asyncMap.apply(this, arguments);
    }

    return asyncMap;
  }();

  _proto.get = function get(key) {
    !this.has(key) ? process.env.NODE_ENV !== "production" ? invariant(false, 'StrictMap: trying to read non-existent key `%s`.', String(key)) : invariant(false) : void 0; // $FlowFixMe - we checked the key exists

    return this._map.get(key);
  };

  _proto.has = function has(key) {
    return this._map.has(key);
  };

  _proto.keys = function keys() {
    return this._map.keys();
  };

  _proto.set = function set(key, value) {
    this._map.set(key, value);

    return this;
  };

  _proto.values = function values() {
    return this._map.values();
  };

  return StrictMap;
}();

module.exports = StrictMap;