/// <reference types="node" />
export * from './handlers';
/**
 * Options supplied in most tasks as an optional trailing object
 */
export declare type Options = {
    [key: string]: null | string | any;
};
/**
 * A function called by the executor immediately after creating a child
 * process. Allows the calling application to implement custom handling of
 * the incoming stream of data from the `git`.
 */
export declare type outputHandler = (command: string, stdout: NodeJS.ReadableStream, stderr: NodeJS.ReadableStream) => void;
/**
 * Environment variables to be passed into the child process.
 */
export declare type GitExecutorEnv = NodeJS.ProcessEnv | undefined;
