import { GraphQLSchema } from 'graphql';
import { Transform, Request, FieldNodeMappers, ExecutionResult } from '@graphql-tools/utils';
import { ObjectValueTransformerMap, ErrorsTransformer } from '../types';
export default class MapFields implements Transform {
    private readonly transformer;
    constructor(fieldNodeTransformerMap: FieldNodeMappers, objectValueTransformerMap?: ObjectValueTransformerMap, errorsTransformer?: ErrorsTransformer);
    transformSchema(schema: GraphQLSchema): GraphQLSchema;
    transformRequest(originalRequest: Request, delegationContext?: Record<string, any>, transformationContext?: Record<string, any>): Request;
    transformResult(originalResult: ExecutionResult, delegationContext?: Record<string, any>, transformationContext?: Record<string, any>): ExecutionResult;
}
