'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function _interopNamespace(e) {
    if (e && e.__esModule) { return e; } else {
        var n = {};
        if (e) {
            Object.keys(e).forEach(function (k) {
                var d = Object.getOwnPropertyDescriptor(e, k);
                Object.defineProperty(n, k, d.get ? d : {
                    enumerable: true,
                    get: function () {
                        return e[k];
                    }
                });
            });
        }
        n['default'] = e;
        return n;
    }
}

const tslib = require('tslib');
const graphql = require('graphql');
const utils = require('@graphql-tools/utils/es5');
const validUrl = require('valid-url');
const crossFetch = require('cross-fetch');
const wrap = require('@graphql-tools/wrap/es5');
const subscriptionsTransportWs = require('subscriptions-transport-ws');
const websocket = require('websocket');

/**
 * This loader loads a schema from a URL. The loaded schema is a fully-executable,
 * remote schema since it's created using [@graphql-tools/wrap](/docs/remote-schemas).
 *
 * ```
 * const schema = await loadSchema('http://localhost:3000/graphql', {
 *   loaders: [
 *     new UrlLoader(),
 *   ]
 * });
 * ```
 */
var UrlLoader = /** @class */ (function () {
    function UrlLoader() {
    }
    UrlLoader.prototype.loaderId = function () {
        return 'url';
    };
    UrlLoader.prototype.canLoad = function (pointer, options) {
        return tslib.__awaiter(this, void 0, void 0, function () {
            return tslib.__generator(this, function (_a) {
                return [2 /*return*/, this.canLoadSync(pointer, options)];
            });
        });
    };
    UrlLoader.prototype.canLoadSync = function (pointer, _options) {
        return !!validUrl.isWebUri(pointer);
    };
    UrlLoader.prototype.buildAsyncExecutor = function (_a) {
        var _this = this;
        var pointer = _a.pointer, fetch = _a.fetch, extraHeaders = _a.extraHeaders, defaultMethod = _a.defaultMethod, useGETForQueries = _a.useGETForQueries;
        var HTTP_URL = switchProtocols(pointer, {
            wss: 'https',
            ws: 'http',
        });
        return function (_a) {
            var document = _a.document, variables = _a.variables;
            return tslib.__awaiter(_this, void 0, void 0, function () {
                var method, _b, _c, definition, fetchResult, query, _d, urlObj, finalUrl;
                var e_1, _e;
                return tslib.__generator(this, function (_f) {
                    switch (_f.label) {
                        case 0:
                            method = defaultMethod;
                            if (useGETForQueries) {
                                method = 'GET';
                                try {
                                    for (_b = tslib.__values(document.definitions), _c = _b.next(); !_c.done; _c = _b.next()) {
                                        definition = _c.value;
                                        if (definition.kind === graphql.Kind.OPERATION_DEFINITION) {
                                            if (definition.operation !== 'query') {
                                                method = defaultMethod;
                                            }
                                        }
                                    }
                                }
                                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                                finally {
                                    try {
                                        if (_c && !_c.done && (_e = _b.return)) _e.call(_b);
                                    }
                                    finally { if (e_1) throw e_1.error; }
                                }
                            }
                            query = graphql.print(document);
                            _d = method;
                            switch (_d) {
                                case 'GET': return [3 /*break*/, 1];
                                case 'POST': return [3 /*break*/, 3];
                            }
                            return [3 /*break*/, 5];
                        case 1:
                            urlObj = new URL(HTTP_URL);
                            urlObj.searchParams.set('query', query);
                            if (variables && Object.keys(variables).length > 0) {
                                urlObj.searchParams.set('variables', JSON.stringify(variables));
                            }
                            finalUrl = urlObj.toString();
                            return [4 /*yield*/, fetch(finalUrl, {
                                    method: 'GET',
                                    headers: extraHeaders,
                                })];
                        case 2:
                            fetchResult = _f.sent();
                            return [3 /*break*/, 5];
                        case 3: return [4 /*yield*/, fetch(HTTP_URL, {
                                method: 'POST',
                                body: JSON.stringify({
                                    query: query,
                                    variables: variables,
                                }),
                                headers: extraHeaders,
                            })];
                        case 4:
                            fetchResult = _f.sent();
                            return [3 /*break*/, 5];
                        case 5: return [2 /*return*/, fetchResult.json()];
                    }
                });
            });
        };
    };
    UrlLoader.prototype.buildSubscriber = function (pointer, webSocketImpl) {
        var _this = this;
        var WS_URL = switchProtocols(pointer, {
            https: 'wss',
            http: 'ws',
        });
        var subscriptionClient = new subscriptionsTransportWs.SubscriptionClient(WS_URL, {}, webSocketImpl);
        return function (_a) {
            var document = _a.document, variables = _a.variables;
            return tslib.__awaiter(_this, void 0, void 0, function () {
                return tslib.__generator(this, function (_b) {
                    return [2 /*return*/, utils.observableToAsyncIterable(subscriptionClient.request({
                            query: document,
                            variables: variables,
                        }))];
                });
            });
        };
    };
    UrlLoader.prototype.getExecutorAndSubscriber = function (pointer, options) {
        return tslib.__awaiter(this, void 0, void 0, function () {
            var headers, fetch, defaultMethod, webSocketImpl, _a, moduleName, fetchFnName_1, _b, moduleName, webSocketImplName_1, extraHeaders, executor, subscriber;
            return tslib.__generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        headers = {};
                        fetch = crossFetch.fetch;
                        defaultMethod = 'POST';
                        webSocketImpl = websocket.w3cwebsocket;
                        if (!options) return [3 /*break*/, 7];
                        if (Array.isArray(options.headers)) {
                            headers = options.headers.reduce(function (prev, v) { return (tslib.__assign(tslib.__assign({}, prev), v)); }, {});
                        }
                        else if (typeof options.headers === 'object') {
                            headers = options.headers;
                        }
                        if (!options.customFetch) return [3 /*break*/, 3];
                        if (!(typeof options.customFetch === 'string')) return [3 /*break*/, 2];
                        _a = tslib.__read(options.customFetch.split('#'), 2), moduleName = _a[0], fetchFnName_1 = _a[1];
                        return [4 /*yield*/, new Promise(function (resolve) { resolve(_interopNamespace(require(moduleName))); }).then(function (module) { return (fetchFnName_1 ? module[fetchFnName_1] : module); })];
                    case 1:
                        fetch = _c.sent();
                        return [3 /*break*/, 3];
                    case 2:
                        fetch = options.customFetch;
                        _c.label = 3;
                    case 3:
                        if (!options.webSocketImpl) return [3 /*break*/, 6];
                        if (!(typeof options.webSocketImpl === 'string')) return [3 /*break*/, 5];
                        _b = tslib.__read(options.webSocketImpl.split('#'), 2), moduleName = _b[0], webSocketImplName_1 = _b[1];
                        return [4 /*yield*/, new Promise(function (resolve) { resolve(_interopNamespace(require(moduleName))); }).then(function (module) {
                                return webSocketImplName_1 ? module[webSocketImplName_1] : module;
                            })];
                    case 4:
                        webSocketImpl = _c.sent();
                        return [3 /*break*/, 6];
                    case 5:
                        webSocketImpl = options.webSocketImpl;
                        _c.label = 6;
                    case 6:
                        if (options.method) {
                            defaultMethod = options.method;
                        }
                        _c.label = 7;
                    case 7:
                        extraHeaders = tslib.__assign({ Accept: 'application/json', 'Content-Type': 'application/json' }, headers);
                        executor = this.buildAsyncExecutor({
                            pointer: pointer,
                            fetch: fetch,
                            extraHeaders: extraHeaders,
                            defaultMethod: defaultMethod,
                            useGETForQueries: options.useGETForQueries,
                        });
                        if (options.enableSubscriptions) {
                            subscriber = this.buildSubscriber(pointer, webSocketImpl);
                        }
                        return [2 /*return*/, {
                                executor: executor,
                                subscriber: subscriber,
                            }];
                }
            });
        });
    };
    UrlLoader.prototype.getSubschemaConfig = function (pointer, options) {
        return tslib.__awaiter(this, void 0, void 0, function () {
            var _a, executor, subscriber;
            var _b;
            return tslib.__generator(this, function (_c) {
                switch (_c.label) {
                    case 0: return [4 /*yield*/, this.getExecutorAndSubscriber(pointer, options)];
                    case 1:
                        _a = _c.sent(), executor = _a.executor, subscriber = _a.subscriber;
                        _b = {};
                        return [4 /*yield*/, wrap.introspectSchema(executor, undefined, options)];
                    case 2: return [2 /*return*/, (_b.schema = _c.sent(),
                            _b.executor = executor,
                            _b.subscriber = subscriber,
                            _b)];
                }
            });
        });
    };
    UrlLoader.prototype.load = function (pointer, options) {
        return tslib.__awaiter(this, void 0, void 0, function () {
            var subschemaConfig, remoteExecutableSchema;
            return tslib.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getSubschemaConfig(pointer, options)];
                    case 1:
                        subschemaConfig = _a.sent();
                        remoteExecutableSchema = wrap.wrapSchema(subschemaConfig);
                        return [2 /*return*/, {
                                location: pointer,
                                schema: remoteExecutableSchema,
                            }];
                }
            });
        });
    };
    UrlLoader.prototype.loadSync = function () {
        throw new Error('Loader Url has no sync mode');
    };
    return UrlLoader;
}());
function switchProtocols(pointer, protocolMap) {
    var protocols = Object.keys(protocolMap).map(function (source) { return [source, protocolMap[source]]; });
    return protocols.reduce(function (prev, _a) {
        var _b = tslib.__read(_a, 2), source = _b[0], target = _b[1];
        return prev.replace(source + "://", target + "://").replace(source + ":\\", target + ":\\");
    }, pointer);
}

exports.UrlLoader = UrlLoader;
//# sourceMappingURL=index.cjs.js.map
