import { __awaiter, __generator, __assign } from 'tslib';
import { GraphQLList, getNamedType } from 'graphql';
import DataLoader from 'dataloader';
import { delegateToSchema } from '@graphql-tools/delegate/es5';

var cache = new WeakMap();
function createBatchFn(options) {
    var _this = this;
    var _a;
    var argsFromKeys = (_a = options.argsFromKeys) !== null && _a !== void 0 ? _a : (function (keys) { return ({ ids: keys }); });
    var valuesFromResults = options.valuesFromResults, lazyOptionsFn = options.lazyOptionsFn;
    return function (keys) { return __awaiter(_this, void 0, void 0, function () {
        var results, values;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, delegateToSchema(__assign({ returnType: new GraphQLList(getNamedType(options.info.returnType)), args: argsFromKeys(keys) }, (lazyOptionsFn == null ? options : lazyOptionsFn(options))))];
                case 1:
                    results = _a.sent();
                    values = valuesFromResults == null ? results : valuesFromResults(results, keys);
                    return [2 /*return*/, Array.isArray(values) ? values : keys.map(function () { return values; })];
            }
        });
    }); };
}
function createLoader(options) {
    var batchFn = createBatchFn(options);
    var newValue = new DataLoader(function (keys) { return batchFn(keys); }, options.dataLoaderOptions);
    cache.set(options.info.fieldNodes, newValue);
    return newValue;
}
function getLoader(options) {
    var cachedValue = cache.get(options.info.fieldNodes);
    if (cachedValue === undefined) {
        return createLoader(options);
    }
    return cachedValue;
}

function batchDelegateToSchema(options) {
    var key = options.key;
    if (key == null) {
        return null;
    }
    else if (Array.isArray(key) && !key.length) {
        return [];
    }
    var loader = getLoader(options);
    return Array.isArray(key) ? loader.loadMany(key) : loader.load(key);
}

function createBatchDelegateFn(optionsOrArgsFromKeys, lazyOptionsFn, dataLoaderOptions, valuesFromResults) {
    return typeof optionsOrArgsFromKeys === 'function'
        ? createBatchDelegateFnImpl({
            argsFromKeys: optionsOrArgsFromKeys,
            lazyOptionsFn: lazyOptionsFn,
            dataLoaderOptions: dataLoaderOptions,
            valuesFromResults: valuesFromResults,
        })
        : createBatchDelegateFnImpl(optionsOrArgsFromKeys);
}
function createBatchDelegateFnImpl(options) {
    return function (batchDelegateOptions) {
        var loader = getLoader(__assign(__assign({}, options), batchDelegateOptions));
        return loader.load(batchDelegateOptions.key);
    };
}

export { batchDelegateToSchema, createBatchDelegateFn };
//# sourceMappingURL=index.esm.js.map
