import { __awaiter, __generator, __read, __values, __assign } from 'tslib';
import { Kind, print } from 'graphql';
import { observableToAsyncIterable } from '@graphql-tools/utils/es5';
import { isWebUri } from 'valid-url';
import { fetch } from 'cross-fetch';
import { introspectSchema, wrapSchema } from '@graphql-tools/wrap/es5';
import { SubscriptionClient } from 'subscriptions-transport-ws';
import { w3cwebsocket } from 'websocket';

/**
 * This loader loads a schema from a URL. The loaded schema is a fully-executable,
 * remote schema since it's created using [@graphql-tools/wrap](/docs/remote-schemas).
 *
 * ```
 * const schema = await loadSchema('http://localhost:3000/graphql', {
 *   loaders: [
 *     new UrlLoader(),
 *   ]
 * });
 * ```
 */
var UrlLoader = /** @class */ (function () {
    function UrlLoader() {
    }
    UrlLoader.prototype.loaderId = function () {
        return 'url';
    };
    UrlLoader.prototype.canLoad = function (pointer, options) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.canLoadSync(pointer, options)];
            });
        });
    };
    UrlLoader.prototype.canLoadSync = function (pointer, _options) {
        return !!isWebUri(pointer);
    };
    UrlLoader.prototype.buildAsyncExecutor = function (_a) {
        var _this = this;
        var pointer = _a.pointer, fetch = _a.fetch, extraHeaders = _a.extraHeaders, defaultMethod = _a.defaultMethod, useGETForQueries = _a.useGETForQueries;
        var HTTP_URL = switchProtocols(pointer, {
            wss: 'https',
            ws: 'http',
        });
        return function (_a) {
            var document = _a.document, variables = _a.variables;
            return __awaiter(_this, void 0, void 0, function () {
                var method, _b, _c, definition, fetchResult, query, _d, urlObj, finalUrl;
                var e_1, _e;
                return __generator(this, function (_f) {
                    switch (_f.label) {
                        case 0:
                            method = defaultMethod;
                            if (useGETForQueries) {
                                method = 'GET';
                                try {
                                    for (_b = __values(document.definitions), _c = _b.next(); !_c.done; _c = _b.next()) {
                                        definition = _c.value;
                                        if (definition.kind === Kind.OPERATION_DEFINITION) {
                                            if (definition.operation !== 'query') {
                                                method = defaultMethod;
                                            }
                                        }
                                    }
                                }
                                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                                finally {
                                    try {
                                        if (_c && !_c.done && (_e = _b.return)) _e.call(_b);
                                    }
                                    finally { if (e_1) throw e_1.error; }
                                }
                            }
                            query = print(document);
                            _d = method;
                            switch (_d) {
                                case 'GET': return [3 /*break*/, 1];
                                case 'POST': return [3 /*break*/, 3];
                            }
                            return [3 /*break*/, 5];
                        case 1:
                            urlObj = new URL(HTTP_URL);
                            urlObj.searchParams.set('query', query);
                            if (variables && Object.keys(variables).length > 0) {
                                urlObj.searchParams.set('variables', JSON.stringify(variables));
                            }
                            finalUrl = urlObj.toString();
                            return [4 /*yield*/, fetch(finalUrl, {
                                    method: 'GET',
                                    headers: extraHeaders,
                                })];
                        case 2:
                            fetchResult = _f.sent();
                            return [3 /*break*/, 5];
                        case 3: return [4 /*yield*/, fetch(HTTP_URL, {
                                method: 'POST',
                                body: JSON.stringify({
                                    query: query,
                                    variables: variables,
                                }),
                                headers: extraHeaders,
                            })];
                        case 4:
                            fetchResult = _f.sent();
                            return [3 /*break*/, 5];
                        case 5: return [2 /*return*/, fetchResult.json()];
                    }
                });
            });
        };
    };
    UrlLoader.prototype.buildSubscriber = function (pointer, webSocketImpl) {
        var _this = this;
        var WS_URL = switchProtocols(pointer, {
            https: 'wss',
            http: 'ws',
        });
        var subscriptionClient = new SubscriptionClient(WS_URL, {}, webSocketImpl);
        return function (_a) {
            var document = _a.document, variables = _a.variables;
            return __awaiter(_this, void 0, void 0, function () {
                return __generator(this, function (_b) {
                    return [2 /*return*/, observableToAsyncIterable(subscriptionClient.request({
                            query: document,
                            variables: variables,
                        }))];
                });
            });
        };
    };
    UrlLoader.prototype.getExecutorAndSubscriber = function (pointer, options) {
        return __awaiter(this, void 0, void 0, function () {
            var headers, fetch$1, defaultMethod, webSocketImpl, _a, moduleName, fetchFnName_1, _b, moduleName, webSocketImplName_1, extraHeaders, executor, subscriber;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        headers = {};
                        fetch$1 = fetch;
                        defaultMethod = 'POST';
                        webSocketImpl = w3cwebsocket;
                        if (!options) return [3 /*break*/, 7];
                        if (Array.isArray(options.headers)) {
                            headers = options.headers.reduce(function (prev, v) { return (__assign(__assign({}, prev), v)); }, {});
                        }
                        else if (typeof options.headers === 'object') {
                            headers = options.headers;
                        }
                        if (!options.customFetch) return [3 /*break*/, 3];
                        if (!(typeof options.customFetch === 'string')) return [3 /*break*/, 2];
                        _a = __read(options.customFetch.split('#'), 2), moduleName = _a[0], fetchFnName_1 = _a[1];
                        return [4 /*yield*/, import(moduleName).then(function (module) { return (fetchFnName_1 ? module[fetchFnName_1] : module); })];
                    case 1:
                        fetch$1 = _c.sent();
                        return [3 /*break*/, 3];
                    case 2:
                        fetch$1 = options.customFetch;
                        _c.label = 3;
                    case 3:
                        if (!options.webSocketImpl) return [3 /*break*/, 6];
                        if (!(typeof options.webSocketImpl === 'string')) return [3 /*break*/, 5];
                        _b = __read(options.webSocketImpl.split('#'), 2), moduleName = _b[0], webSocketImplName_1 = _b[1];
                        return [4 /*yield*/, import(moduleName).then(function (module) {
                                return webSocketImplName_1 ? module[webSocketImplName_1] : module;
                            })];
                    case 4:
                        webSocketImpl = _c.sent();
                        return [3 /*break*/, 6];
                    case 5:
                        webSocketImpl = options.webSocketImpl;
                        _c.label = 6;
                    case 6:
                        if (options.method) {
                            defaultMethod = options.method;
                        }
                        _c.label = 7;
                    case 7:
                        extraHeaders = __assign({ Accept: 'application/json', 'Content-Type': 'application/json' }, headers);
                        executor = this.buildAsyncExecutor({
                            pointer: pointer,
                            fetch: fetch$1,
                            extraHeaders: extraHeaders,
                            defaultMethod: defaultMethod,
                            useGETForQueries: options.useGETForQueries,
                        });
                        if (options.enableSubscriptions) {
                            subscriber = this.buildSubscriber(pointer, webSocketImpl);
                        }
                        return [2 /*return*/, {
                                executor: executor,
                                subscriber: subscriber,
                            }];
                }
            });
        });
    };
    UrlLoader.prototype.getSubschemaConfig = function (pointer, options) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, executor, subscriber;
            var _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0: return [4 /*yield*/, this.getExecutorAndSubscriber(pointer, options)];
                    case 1:
                        _a = _c.sent(), executor = _a.executor, subscriber = _a.subscriber;
                        _b = {};
                        return [4 /*yield*/, introspectSchema(executor, undefined, options)];
                    case 2: return [2 /*return*/, (_b.schema = _c.sent(),
                            _b.executor = executor,
                            _b.subscriber = subscriber,
                            _b)];
                }
            });
        });
    };
    UrlLoader.prototype.load = function (pointer, options) {
        return __awaiter(this, void 0, void 0, function () {
            var subschemaConfig, remoteExecutableSchema;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getSubschemaConfig(pointer, options)];
                    case 1:
                        subschemaConfig = _a.sent();
                        remoteExecutableSchema = wrapSchema(subschemaConfig);
                        return [2 /*return*/, {
                                location: pointer,
                                schema: remoteExecutableSchema,
                            }];
                }
            });
        });
    };
    UrlLoader.prototype.loadSync = function () {
        throw new Error('Loader Url has no sync mode');
    };
    return UrlLoader;
}());
function switchProtocols(pointer, protocolMap) {
    var protocols = Object.keys(protocolMap).map(function (source) { return [source, protocolMap[source]]; });
    return protocols.reduce(function (prev, _a) {
        var _b = __read(_a, 2), source = _b[0], target = _b[1];
        return prev.replace(source + "://", target + "://").replace(source + ":\\", target + ":\\");
    }, pointer);
}

export { UrlLoader };
//# sourceMappingURL=index.esm.js.map
