import { GraphQLSchema } from 'graphql';
import { Transform, Request, ExecutionResult } from '@graphql-tools/utils';
import { RootFieldTransformer, FieldNodeTransformer } from '../types';
export default class TransformRootFields implements Transform {
    private readonly rootFieldTransformer;
    private readonly fieldNodeTransformer;
    private transformer;
    constructor(rootFieldTransformer: RootFieldTransformer, fieldNodeTransformer?: FieldNodeTransformer);
    transformSchema(originalSchema: GraphQLSchema): GraphQLSchema;
    transformRequest(originalRequest: Request, delegationContext?: Record<string, any>, transformationContext?: Record<string, any>): Request;
    transformResult(originalResult: ExecutionResult, delegationContext?: Record<string, any>, transformationContext?: Record<string, any>): ExecutionResult;
}
