"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.add = exports.set = void 0;
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const log_1 = require("../log");
function data(cmd) {
    return `#!/bin/sh
. "$(dirname "$0")/_/husky.sh"

${cmd}
`;
}
function format(file) {
    return `${path_1.default.dirname(file)}${path_1.default.sep}${path_1.default.basename(file)}`;
}
function set(file, cmd) {
    const dir = path_1.default.dirname(file);
    if (!fs_1.default.existsSync(dir)) {
        throw new Error(`can't create hook, ${dir} directory doesn't exist (try running husky install)`);
    }
    fs_1.default.writeFileSync(file, data(cmd), { mode: 0o0755 });
    log_1.l(`created ${format(file)}`);
}
exports.set = set;
function add(file, cmd) {
    if (fs_1.default.existsSync(file)) {
        fs_1.default.appendFileSync(file, `${cmd}\n`);
        log_1.l(`updated ${format(file)}`);
    }
    else {
        set(file, cmd);
    }
}
exports.add = add;
