/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
// flowlint ambiguous-object-type:error
'use strict';

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var IRTransformer = require('../core/IRTransformer');

var SchemaUtils = require('../core/SchemaUtils');

var invariant = require("fbjs/lib/invariant");

var nullthrows = require('nullthrows');

var _require = require('relay-runtime'),
    getRelayHandleKey = _require.getRelayHandleKey;

function fieldHandleTransform(context) {
  return IRTransformer.transform(context, {
    LinkedField: visitField,
    ScalarField: visitField
  });
}
/**
 * @internal
 */


function visitField(field) {
  var nextField = field.kind === 'LinkedField' ? this.traverse(field) : field;
  var handles = nextField.handles;

  if (!handles || !handles.length) {
    return nextField;
  } // ensure exactly one handle


  !(handles.length === 1) ? process.env.NODE_ENV !== "production" ? invariant(false, 'FieldHandleTransform: Expected fields to have at most one ' + '"handle" property, got `%s`.', handles.join(', ')) : invariant(false) : void 0;
  var context = this.getContext();
  var schema = context.getSchema();
  var alias = nextField.alias;
  var handle = handles[0];
  var name = getRelayHandleKey(handle.name, handle.key, nextField.name);
  var filters = handle.filters;
  var args = filters ? nextField.args.filter(function (arg) {
    return filters.indexOf(arg.name) !== -1;
  }) : [];

  if (handle.dynamicKey != null) {
    args.push({
      kind: 'Argument',
      loc: handle.dynamicKey.loc,
      name: '__dynamicKey',
      type: SchemaUtils.getNullableStringInput(schema),
      value: nullthrows(handle.dynamicKey)
    });
  }

  return _objectSpread(_objectSpread({}, nextField), {}, {
    args: args,
    alias: alias,
    name: name,
    handles: null
  });
}

module.exports = {
  transform: fieldHandleTransform
};