import { ASTNode, NameNode, DefinitionNode } from 'graphql';
export declare type NamedDefinitionNode = DefinitionNode & {
    name?: NameNode;
};
export declare function resetComments(): void;
export declare function collectComment(node: NamedDefinitionNode): void;
export declare function pushComment(node: any, entity: string, field?: string, argument?: string): void;
export declare function printComment(comment: string): string;
/**
 * Converts an AST into a string, using one set of reasonable
 * formatting rules.
 */
export declare function printWithComments(ast: ASTNode): any;
