// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/talent/v4beta1/event.proto

package talent

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An enumeration of an event attributed to the behavior of the end user,
// such as a job seeker.
type JobEvent_JobEventType int32

const (
	// The event is unspecified by other provided values.
	JobEvent_JOB_EVENT_TYPE_UNSPECIFIED JobEvent_JobEventType = 0
	// The job seeker or other entity interacting with the service has
	// had a job rendered in their view, such as in a list of search results in
	// a compressed or clipped format. This event is typically associated with
	// the viewing of a jobs list on a single page by a job seeker.
	JobEvent_IMPRESSION JobEvent_JobEventType = 1
	// The job seeker, or other entity interacting with the service, has
	// viewed the details of a job, including the full description. This
	// event doesn't apply to the viewing a snippet of a job appearing as a
	// part of the job search results. Viewing a snippet is associated with an
	// [impression][google.cloud.talent.v4beta1.JobEvent.JobEventType.IMPRESSION]).
	JobEvent_VIEW JobEvent_JobEventType = 2
	// The job seeker or other entity interacting with the service
	// performed an action to view a job and was redirected to a different
	// website for job.
	JobEvent_VIEW_REDIRECT JobEvent_JobEventType = 3
	// The job seeker or other entity interacting with the service
	// began the process or demonstrated the intention of applying for a job.
	JobEvent_APPLICATION_START JobEvent_JobEventType = 4
	// The job seeker or other entity interacting with the service
	// submitted an application for a job.
	JobEvent_APPLICATION_FINISH JobEvent_JobEventType = 5
	// The job seeker or other entity interacting with the service
	// submitted an application for a job with a single click without
	// entering information. If a job seeker performs this action, send only
	// this event to the service. Do not also send
	// [JobEventType.APPLICATION_START][google.cloud.talent.v4beta1.JobEvent.JobEventType.APPLICATION_START]
	// or
	// [JobEventType.APPLICATION_FINISH][google.cloud.talent.v4beta1.JobEvent.JobEventType.APPLICATION_FINISH]
	// events.
	JobEvent_APPLICATION_QUICK_SUBMISSION JobEvent_JobEventType = 6
	// The job seeker or other entity interacting with the service
	// performed an action to apply to a job and was redirected to a different
	// website to complete the application.
	JobEvent_APPLICATION_REDIRECT JobEvent_JobEventType = 7
	// The job seeker or other entity interacting with the service began the
	// process or demonstrated the intention of applying for a job from the
	// search results page without viewing the details of the job posting.
	// If sending this event, JobEventType.VIEW event shouldn't be sent.
	JobEvent_APPLICATION_START_FROM_SEARCH JobEvent_JobEventType = 8
	// The job seeker, or other entity interacting with the service, performs an
	// action with a single click from the search results page to apply to a job
	// (without viewing the details of the job posting), and is redirected
	// to a different website to complete the application. If a candidate
	// performs this action, send only this event to the service. Do not also
	// send
	// [JobEventType.APPLICATION_START][google.cloud.talent.v4beta1.JobEvent.JobEventType.APPLICATION_START],
	// [JobEventType.APPLICATION_FINISH][google.cloud.talent.v4beta1.JobEvent.JobEventType.APPLICATION_FINISH]
	// or
	// [JobEventType.VIEW][google.cloud.talent.v4beta1.JobEvent.JobEventType.VIEW]
	// events.
	JobEvent_APPLICATION_REDIRECT_FROM_SEARCH JobEvent_JobEventType = 9
	// This event should be used when a company submits an application
	// on behalf of a job seeker. This event is intended for use by staffing
	// agencies attempting to place candidates.
	JobEvent_APPLICATION_COMPANY_SUBMIT JobEvent_JobEventType = 10
	// The job seeker or other entity interacting with the service demonstrated
	// an interest in a job by bookmarking or saving it.
	JobEvent_BOOKMARK JobEvent_JobEventType = 11
	// The job seeker or other entity interacting with the service was
	// sent a notification, such as an email alert or device notification,
	// containing one or more jobs listings generated by the service.
	JobEvent_NOTIFICATION JobEvent_JobEventType = 12
	// The job seeker or other entity interacting with the service was
	// employed by the hiring entity (employer). Send this event
	// only if the job seeker was hired through an application that was
	// initiated by a search conducted through the Cloud Talent Solution
	// service.
	JobEvent_HIRED JobEvent_JobEventType = 13
	// A recruiter or staffing agency submitted an application on behalf of the
	// candidate after interacting with the service to identify a suitable job
	// posting.
	JobEvent_SENT_CV JobEvent_JobEventType = 14
	// The entity interacting with the service (for example, the job seeker),
	// was granted an initial interview by the hiring entity (employer). This
	// event should only be sent if the job seeker was granted an interview as
	// part of an application that was initiated by a search conducted through /
	// recommendation provided by the Cloud Talent Solution service.
	JobEvent_INTERVIEW_GRANTED JobEvent_JobEventType = 15
)

var JobEvent_JobEventType_name = map[int32]string{
	0:  "JOB_EVENT_TYPE_UNSPECIFIED",
	1:  "IMPRESSION",
	2:  "VIEW",
	3:  "VIEW_REDIRECT",
	4:  "APPLICATION_START",
	5:  "APPLICATION_FINISH",
	6:  "APPLICATION_QUICK_SUBMISSION",
	7:  "APPLICATION_REDIRECT",
	8:  "APPLICATION_START_FROM_SEARCH",
	9:  "APPLICATION_REDIRECT_FROM_SEARCH",
	10: "APPLICATION_COMPANY_SUBMIT",
	11: "BOOKMARK",
	12: "NOTIFICATION",
	13: "HIRED",
	14: "SENT_CV",
	15: "INTERVIEW_GRANTED",
}

var JobEvent_JobEventType_value = map[string]int32{
	"JOB_EVENT_TYPE_UNSPECIFIED":       0,
	"IMPRESSION":                       1,
	"VIEW":                             2,
	"VIEW_REDIRECT":                    3,
	"APPLICATION_START":                4,
	"APPLICATION_FINISH":               5,
	"APPLICATION_QUICK_SUBMISSION":     6,
	"APPLICATION_REDIRECT":             7,
	"APPLICATION_START_FROM_SEARCH":    8,
	"APPLICATION_REDIRECT_FROM_SEARCH": 9,
	"APPLICATION_COMPANY_SUBMIT":       10,
	"BOOKMARK":                         11,
	"NOTIFICATION":                     12,
	"HIRED":                            13,
	"SENT_CV":                          14,
	"INTERVIEW_GRANTED":                15,
}

func (x JobEvent_JobEventType) String() string {
	return proto.EnumName(JobEvent_JobEventType_name, int32(x))
}

func (JobEvent_JobEventType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e736440ac47f3d40, []int{1, 0}
}

// The enum represents types of client events for a candidate profile.
type ProfileEvent_ProfileEventType int32

const (
	// Default value.
	ProfileEvent_PROFILE_EVENT_TYPE_UNSPECIFIED ProfileEvent_ProfileEventType = 0
	// Send this event when a
	// [ProfileEvent.profiles][google.cloud.talent.v4beta1.ProfileEvent.profiles]
	// was sent as a part of a result set for a CTS API call and was rendered in
	// the end user's UI (that is, the
	// [ProfileEvent.recruiter][google.cloud.talent.v4beta1.ProfileEvent.recruiter]).
	ProfileEvent_IMPRESSION ProfileEvent_ProfileEventType = 1
	// The VIEW event records the action of a candidate's profile being
	// viewed by an end user. This is critical to tracking product metrics and
	// should be sent for every profile VIEW that happens in your system,
	// whether the event is associated with an API call (for example, a
	// recruiter making a request for a result set and clicking on a profile)
	// or not (a recruiter using the system to view profile details without
	// making a request).
	//
	// For a VIEW events associated with API calls, the
	// [ClientEvent.request_id][google.cloud.talent.v4beta1.ClientEvent.request_id]
	// should be populated.  If the VIEW is not associated with an API call,
	// [request_id][google.cloud.talent.v4beta1.ClientEvent.request_id] should
	// not be populated.
	//
	// This event requires a valid recruiter and one valid ID in profiles.
	ProfileEvent_VIEW ProfileEvent_ProfileEventType = 2
	// The profile is bookmarked.
	ProfileEvent_BOOKMARK ProfileEvent_ProfileEventType = 3
)

var ProfileEvent_ProfileEventType_name = map[int32]string{
	0: "PROFILE_EVENT_TYPE_UNSPECIFIED",
	1: "IMPRESSION",
	2: "VIEW",
	3: "BOOKMARK",
}

var ProfileEvent_ProfileEventType_value = map[string]int32{
	"PROFILE_EVENT_TYPE_UNSPECIFIED": 0,
	"IMPRESSION":                     1,
	"VIEW":                           2,
	"BOOKMARK":                       3,
}

func (x ProfileEvent_ProfileEventType) String() string {
	return proto.EnumName(ProfileEvent_ProfileEventType_name, int32(x))
}

func (ProfileEvent_ProfileEventType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e736440ac47f3d40, []int{2, 0}
}

// An event issued when an end user interacts with the application that
// implements Cloud Talent Solution. Providing this information improves the
// quality of results for the API clients, enabling the
// service to perform optimally. The number of events sent must be consistent
// with other calls, such as job searches, issued to the service by the client.
type ClientEvent struct {
	// Optional but highly recommended.
	//
	// A unique ID generated in the API responses. It can be found in
	// [ResponseMetadata.request_id][google.cloud.talent.v4beta1.ResponseMetadata.request_id].
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Required. A unique identifier, generated by the client application.
	EventId string `protobuf:"bytes,2,opt,name=event_id,json=eventId,proto3" json:"event_id,omitempty"`
	// Required. The timestamp of the event.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Required.
	//
	// The detail information of a specific event type.
	//
	// Types that are valid to be assigned to Event:
	//	*ClientEvent_JobEvent
	//	*ClientEvent_ProfileEvent
	Event isClientEvent_Event `protobuf_oneof:"event"`
	// Optional. Notes about the event provided by recruiters or other users, for
	// example, feedback on why a profile was bookmarked.
	EventNotes           string   `protobuf:"bytes,9,opt,name=event_notes,json=eventNotes,proto3" json:"event_notes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClientEvent) Reset()         { *m = ClientEvent{} }
func (m *ClientEvent) String() string { return proto.CompactTextString(m) }
func (*ClientEvent) ProtoMessage()    {}
func (*ClientEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_e736440ac47f3d40, []int{0}
}

func (m *ClientEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClientEvent.Unmarshal(m, b)
}
func (m *ClientEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClientEvent.Marshal(b, m, deterministic)
}
func (m *ClientEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClientEvent.Merge(m, src)
}
func (m *ClientEvent) XXX_Size() int {
	return xxx_messageInfo_ClientEvent.Size(m)
}
func (m *ClientEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_ClientEvent.DiscardUnknown(m)
}

var xxx_messageInfo_ClientEvent proto.InternalMessageInfo

func (m *ClientEvent) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *ClientEvent) GetEventId() string {
	if m != nil {
		return m.EventId
	}
	return ""
}

func (m *ClientEvent) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

type isClientEvent_Event interface {
	isClientEvent_Event()
}

type ClientEvent_JobEvent struct {
	JobEvent *JobEvent `protobuf:"bytes,5,opt,name=job_event,json=jobEvent,proto3,oneof"`
}

type ClientEvent_ProfileEvent struct {
	ProfileEvent *ProfileEvent `protobuf:"bytes,6,opt,name=profile_event,json=profileEvent,proto3,oneof"`
}

func (*ClientEvent_JobEvent) isClientEvent_Event() {}

func (*ClientEvent_ProfileEvent) isClientEvent_Event() {}

func (m *ClientEvent) GetEvent() isClientEvent_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *ClientEvent) GetJobEvent() *JobEvent {
	if x, ok := m.GetEvent().(*ClientEvent_JobEvent); ok {
		return x.JobEvent
	}
	return nil
}

func (m *ClientEvent) GetProfileEvent() *ProfileEvent {
	if x, ok := m.GetEvent().(*ClientEvent_ProfileEvent); ok {
		return x.ProfileEvent
	}
	return nil
}

func (m *ClientEvent) GetEventNotes() string {
	if m != nil {
		return m.EventNotes
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ClientEvent) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ClientEvent_JobEvent)(nil),
		(*ClientEvent_ProfileEvent)(nil),
	}
}

// An event issued when a job seeker interacts with the application that
// implements Cloud Talent Solution.
type JobEvent struct {
	// Required. The type of the event (see
	// [JobEventType][google.cloud.talent.v4beta1.JobEvent.JobEventType]).
	Type JobEvent_JobEventType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.talent.v4beta1.JobEvent_JobEventType" json:"type,omitempty"`
	// Required. The [job name(s)][google.cloud.talent.v4beta1.Job.name]
	// associated with this event. For example, if this is an
	// [impression][google.cloud.talent.v4beta1.JobEvent.JobEventType.IMPRESSION]
	// event, this field contains the identifiers of all jobs shown to the job
	// seeker. If this was a
	// [view][google.cloud.talent.v4beta1.JobEvent.JobEventType.VIEW] event, this
	// field contains the identifier of the viewed job.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}", for
	// example, "projects/api-test-project/tenants/foo/jobs/1234".
	Jobs []string `protobuf:"bytes,2,rep,name=jobs,proto3" json:"jobs,omitempty"`
	// Optional. The [profile name][google.cloud.talent.v4beta1.Profile.name]
	// associated with this client event.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/profiles/{profile_id}",
	// for example, "projects/api-test-project/tenants/foo/profiles/bar".
	Profile              string   `protobuf:"bytes,3,opt,name=profile,proto3" json:"profile,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobEvent) Reset()         { *m = JobEvent{} }
func (m *JobEvent) String() string { return proto.CompactTextString(m) }
func (*JobEvent) ProtoMessage()    {}
func (*JobEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_e736440ac47f3d40, []int{1}
}

func (m *JobEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobEvent.Unmarshal(m, b)
}
func (m *JobEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobEvent.Marshal(b, m, deterministic)
}
func (m *JobEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobEvent.Merge(m, src)
}
func (m *JobEvent) XXX_Size() int {
	return xxx_messageInfo_JobEvent.Size(m)
}
func (m *JobEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_JobEvent.DiscardUnknown(m)
}

var xxx_messageInfo_JobEvent proto.InternalMessageInfo

func (m *JobEvent) GetType() JobEvent_JobEventType {
	if m != nil {
		return m.Type
	}
	return JobEvent_JOB_EVENT_TYPE_UNSPECIFIED
}

func (m *JobEvent) GetJobs() []string {
	if m != nil {
		return m.Jobs
	}
	return nil
}

func (m *JobEvent) GetProfile() string {
	if m != nil {
		return m.Profile
	}
	return ""
}

// An event issued when a profile searcher interacts with the application
// that implements Cloud Talent Solution.
type ProfileEvent struct {
	// Required. Type of event.
	Type ProfileEvent_ProfileEventType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.talent.v4beta1.ProfileEvent_ProfileEventType" json:"type,omitempty"`
	// Required. The [profile name(s)][google.cloud.talent.v4beta1.Profile.name]
	// associated with this client event.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/profiles/{profile_id}",
	// for example, "projects/api-test-project/tenants/foo/profiles/bar".
	Profiles []string `protobuf:"bytes,2,rep,name=profiles,proto3" json:"profiles,omitempty"`
	// Optional. The [job name(s)][google.cloud.talent.v4beta1.Job.name]
	// associated with this client event. Leave it empty if the event isn't
	// associated with a job.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}", for
	// example, "projects/api-test-project/tenants/foo/jobs/1234".
	Jobs                 []string `protobuf:"bytes,6,rep,name=jobs,proto3" json:"jobs,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProfileEvent) Reset()         { *m = ProfileEvent{} }
func (m *ProfileEvent) String() string { return proto.CompactTextString(m) }
func (*ProfileEvent) ProtoMessage()    {}
func (*ProfileEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_e736440ac47f3d40, []int{2}
}

func (m *ProfileEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProfileEvent.Unmarshal(m, b)
}
func (m *ProfileEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProfileEvent.Marshal(b, m, deterministic)
}
func (m *ProfileEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProfileEvent.Merge(m, src)
}
func (m *ProfileEvent) XXX_Size() int {
	return xxx_messageInfo_ProfileEvent.Size(m)
}
func (m *ProfileEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_ProfileEvent.DiscardUnknown(m)
}

var xxx_messageInfo_ProfileEvent proto.InternalMessageInfo

func (m *ProfileEvent) GetType() ProfileEvent_ProfileEventType {
	if m != nil {
		return m.Type
	}
	return ProfileEvent_PROFILE_EVENT_TYPE_UNSPECIFIED
}

func (m *ProfileEvent) GetProfiles() []string {
	if m != nil {
		return m.Profiles
	}
	return nil
}

func (m *ProfileEvent) GetJobs() []string {
	if m != nil {
		return m.Jobs
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.talent.v4beta1.JobEvent_JobEventType", JobEvent_JobEventType_name, JobEvent_JobEventType_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.ProfileEvent_ProfileEventType", ProfileEvent_ProfileEventType_name, ProfileEvent_ProfileEventType_value)
	proto.RegisterType((*ClientEvent)(nil), "google.cloud.talent.v4beta1.ClientEvent")
	proto.RegisterType((*JobEvent)(nil), "google.cloud.talent.v4beta1.JobEvent")
	proto.RegisterType((*ProfileEvent)(nil), "google.cloud.talent.v4beta1.ProfileEvent")
}

func init() {
	proto.RegisterFile("google/cloud/talent/v4beta1/event.proto", fileDescriptor_e736440ac47f3d40)
}

var fileDescriptor_e736440ac47f3d40 = []byte{
	// 681 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0xcd, 0x6e, 0xd3, 0x40,
	0x10, 0x6e, 0xfe, 0x93, 0x49, 0x5a, 0xb6, 0x2b, 0x40, 0x26, 0xf4, 0x27, 0x44, 0x20, 0xca, 0xc5,
	0x16, 0x85, 0x13, 0x3d, 0x39, 0xce, 0x86, 0x6c, 0xdb, 0xd8, 0x66, 0xed, 0x16, 0x95, 0x03, 0x96,
	0xd3, 0x6c, 0xa3, 0x54, 0xa9, 0xd7, 0x24, 0x6e, 0x45, 0x8f, 0xbc, 0x0a, 0x0f, 0xc3, 0xe3, 0xf0,
	0x08, 0x08, 0x79, 0xed, 0x04, 0x17, 0xaa, 0xaa, 0xe2, 0xb6, 0x33, 0xfb, 0xcd, 0x37, 0xdf, 0x8c,
	0x3f, 0x2f, 0xbc, 0x1c, 0x0b, 0x31, 0x9e, 0x72, 0xed, 0x74, 0x2a, 0x2e, 0x47, 0x5a, 0xe4, 0x4f,
	0x79, 0x10, 0x69, 0x57, 0x6f, 0x87, 0x3c, 0xf2, 0x5f, 0x6b, 0xfc, 0x8a, 0x07, 0x91, 0x1a, 0xce,
	0x44, 0x24, 0xf0, 0xd3, 0x04, 0xa8, 0x4a, 0xa0, 0x9a, 0x00, 0xd5, 0x14, 0xd8, 0xdc, 0x48, 0x59,
	0xfc, 0x70, 0xa2, 0xf9, 0x41, 0x20, 0x22, 0x3f, 0x9a, 0x88, 0x60, 0x9e, 0x94, 0x36, 0xb7, 0xd3,
	0x5b, 0x19, 0x0d, 0x2f, 0xcf, 0xb4, 0x68, 0x72, 0xc1, 0xe7, 0x91, 0x7f, 0x11, 0x26, 0x80, 0xf6,
	0x8f, 0x3c, 0xd4, 0x8d, 0xe9, 0x84, 0x07, 0x11, 0x89, 0x3b, 0xe2, 0x4d, 0x80, 0x19, 0xff, 0x72,
	0xc9, 0xe7, 0x91, 0x37, 0x19, 0x29, 0xb9, 0x56, 0x6e, 0xa7, 0xc6, 0x6a, 0x69, 0x86, 0x8e, 0xf0,
	0x13, 0xa8, 0x4a, 0x65, 0xf1, 0x65, 0x5e, 0x5e, 0x56, 0x64, 0x4c, 0x47, 0x78, 0x0f, 0xea, 0xa7,
	0x33, 0xee, 0x47, 0xdc, 0x8b, 0x7b, 0x28, 0xc5, 0x56, 0x6e, 0xa7, 0xbe, 0xdb, 0x54, 0x53, 0xed,
	0x0b, 0x01, 0xaa, 0xbb, 0x10, 0xc0, 0x20, 0x81, 0xc7, 0x09, 0xdc, 0x85, 0xda, 0xb9, 0x18, 0x7a,
	0x92, 0x4b, 0x29, 0xc9, 0xd2, 0x17, 0xea, 0x1d, 0x63, 0xab, 0xfb, 0x62, 0x28, 0x05, 0xf7, 0x57,
	0x58, 0xf5, 0x3c, 0x3d, 0x63, 0x1b, 0x56, 0xc3, 0x99, 0x38, 0x9b, 0x4c, 0x79, 0xca, 0x54, 0x96,
	0x4c, 0xaf, 0xee, 0x64, 0xb2, 0x93, 0x8a, 0x05, 0x5b, 0x23, 0xcc, 0xc4, 0x78, 0x1b, 0xea, 0xc9,
	0xbc, 0x81, 0x88, 0xf8, 0x5c, 0xa9, 0xc9, 0x91, 0x41, 0xa6, 0xcc, 0x38, 0xd3, 0xa9, 0x40, 0x49,
	0x46, 0xed, 0x6f, 0x45, 0xa8, 0x2e, 0x44, 0xe1, 0x1e, 0x14, 0xa3, 0xeb, 0x90, 0xcb, 0xfd, 0xad,
	0xed, 0xee, 0xde, 0x6b, 0x92, 0xe5, 0xc1, 0xbd, 0x0e, 0x39, 0x93, 0xf5, 0x18, 0x43, 0xf1, 0x5c,
	0x0c, 0xe7, 0x4a, 0xbe, 0x55, 0xd8, 0xa9, 0x31, 0x79, 0xc6, 0x0a, 0x54, 0x52, 0x89, 0x4a, 0x21,
	0xf9, 0x02, 0x69, 0xd8, 0xfe, 0x95, 0x87, 0x46, 0x96, 0x04, 0x6f, 0x41, 0x73, 0xdf, 0xea, 0x78,
	0xe4, 0x98, 0x98, 0xae, 0xe7, 0x9e, 0xd8, 0xc4, 0x3b, 0x32, 0x1d, 0x9b, 0x18, 0xb4, 0x47, 0x49,
	0x17, 0xad, 0xe0, 0x35, 0x00, 0x3a, 0xb0, 0x19, 0x71, 0x1c, 0x6a, 0x99, 0x28, 0x87, 0xab, 0x50,
	0x3c, 0xa6, 0xe4, 0x23, 0xca, 0xe3, 0x75, 0x58, 0x8d, 0x4f, 0x1e, 0x23, 0x5d, 0xca, 0x88, 0xe1,
	0xa2, 0x02, 0x7e, 0x04, 0xeb, 0xba, 0x6d, 0x1f, 0x52, 0x43, 0x77, 0xa9, 0x65, 0x7a, 0x8e, 0xab,
	0x33, 0x17, 0x15, 0xf1, 0x63, 0xc0, 0xd9, 0x74, 0x8f, 0x9a, 0xd4, 0xe9, 0xa3, 0x12, 0x6e, 0xc1,
	0x46, 0x36, 0xff, 0xe1, 0x88, 0x1a, 0x07, 0x9e, 0x73, 0xd4, 0x19, 0xd0, 0xa4, 0x5b, 0x19, 0x2b,
	0xf0, 0x30, 0x8b, 0x58, 0xb6, 0xaa, 0xe0, 0x67, 0xb0, 0xf9, 0x4f, 0x2b, 0xaf, 0xc7, 0xac, 0x81,
	0xe7, 0x10, 0x9d, 0x19, 0x7d, 0x54, 0xc5, 0xcf, 0xa1, 0x75, 0x5b, 0xf1, 0x0d, 0x54, 0x2d, 0x5e,
	0x40, 0x16, 0x65, 0x58, 0x03, 0x5b, 0x37, 0x4f, 0x12, 0x19, 0x2e, 0x02, 0xdc, 0x80, 0x6a, 0xc7,
	0xb2, 0x0e, 0x06, 0x3a, 0x3b, 0x40, 0x75, 0x8c, 0xa0, 0x61, 0x5a, 0x2e, 0xed, 0xa5, 0x70, 0xd4,
	0xc0, 0x35, 0x28, 0xf5, 0x29, 0x23, 0x5d, 0xb4, 0x8a, 0xeb, 0x50, 0x71, 0xe2, 0x35, 0x1a, 0xc7,
	0x68, 0x2d, 0xde, 0x05, 0x35, 0x5d, 0xc2, 0xe4, 0x8e, 0xde, 0x33, 0xdd, 0x74, 0x49, 0x17, 0x3d,
	0x68, 0xff, 0xcc, 0x41, 0x23, 0x6b, 0x27, 0x6c, 0xde, 0xf0, 0xc1, 0xbb, 0x7b, 0xfb, 0xf0, 0x46,
	0x90, 0xf1, 0x43, 0x13, 0xaa, 0xe9, 0xc7, 0x5e, 0x78, 0x62, 0x19, 0x2f, 0xbd, 0x52, 0xfe, 0xe3,
	0x95, 0xf6, 0x67, 0x40, 0x7f, 0x33, 0xe1, 0x36, 0x6c, 0xd9, 0xcc, 0xea, 0xd1, 0x43, 0xf2, 0x3f,
	0xc6, 0xc8, 0x6e, 0xac, 0xd0, 0xf9, 0x0a, 0xdb, 0xa7, 0xe2, 0xe2, 0xae, 0xb1, 0x3a, 0x20, 0x3b,
	0xdb, 0xf1, 0xef, 0x6f, 0xe7, 0x3e, 0xe9, 0x29, 0x74, 0x2c, 0xa6, 0x7e, 0x30, 0x56, 0xc5, 0x6c,
	0xac, 0x8d, 0x79, 0x20, 0x1f, 0x07, 0x2d, 0xb9, 0xf2, 0xc3, 0xc9, 0xfc, 0xd6, 0x27, 0x71, 0x2f,
	0x09, 0xbf, 0xe7, 0x0b, 0x86, 0xeb, 0x0c, 0xcb, 0xb2, 0xe6, 0xcd, 0xef, 0x00, 0x00, 0x00, 0xff,
	0xff, 0xf8, 0xf4, 0x79, 0x1f, 0x45, 0x05, 0x00, 0x00,
}
