// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/talent/v4beta1/profile_service.proto

package talent

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// List profiles request.
type ListProfilesRequest struct {
	// Required. The resource name of the tenant under which the profile is
	// created.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}", for example,
	// "projects/api-test-project/tenants/foo".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The token that specifies the current offset (that is, starting
	// result).
	//
	// Please set the value to
	// [ListProfilesResponse.next_page_token][google.cloud.talent.v4beta1.ListProfilesResponse.next_page_token]
	// to continue the list.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The maximum number of profiles to be returned, at most 100.
	//
	// Default is 100 unless a positive number smaller than 100 is specified.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A field mask to specify the profile fields to be listed in
	// response. All fields are listed if it is unset.
	//
	// Valid values are:
	//
	// * name
	ReadMask             *field_mask.FieldMask `protobuf:"bytes,4,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ListProfilesRequest) Reset()         { *m = ListProfilesRequest{} }
func (m *ListProfilesRequest) String() string { return proto.CompactTextString(m) }
func (*ListProfilesRequest) ProtoMessage()    {}
func (*ListProfilesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d2b7b5f4d4d7ea55, []int{0}
}

func (m *ListProfilesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListProfilesRequest.Unmarshal(m, b)
}
func (m *ListProfilesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListProfilesRequest.Marshal(b, m, deterministic)
}
func (m *ListProfilesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListProfilesRequest.Merge(m, src)
}
func (m *ListProfilesRequest) XXX_Size() int {
	return xxx_messageInfo_ListProfilesRequest.Size(m)
}
func (m *ListProfilesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListProfilesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListProfilesRequest proto.InternalMessageInfo

func (m *ListProfilesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListProfilesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListProfilesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListProfilesRequest) GetReadMask() *field_mask.FieldMask {
	if m != nil {
		return m.ReadMask
	}
	return nil
}

// The List profiles response object.
type ListProfilesResponse struct {
	// Profiles for the specific tenant.
	Profiles []*Profile `protobuf:"bytes,1,rep,name=profiles,proto3" json:"profiles,omitempty"`
	// A token to retrieve the next page of results. This is empty if there are no
	// more results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListProfilesResponse) Reset()         { *m = ListProfilesResponse{} }
func (m *ListProfilesResponse) String() string { return proto.CompactTextString(m) }
func (*ListProfilesResponse) ProtoMessage()    {}
func (*ListProfilesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d2b7b5f4d4d7ea55, []int{1}
}

func (m *ListProfilesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListProfilesResponse.Unmarshal(m, b)
}
func (m *ListProfilesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListProfilesResponse.Marshal(b, m, deterministic)
}
func (m *ListProfilesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListProfilesResponse.Merge(m, src)
}
func (m *ListProfilesResponse) XXX_Size() int {
	return xxx_messageInfo_ListProfilesResponse.Size(m)
}
func (m *ListProfilesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListProfilesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListProfilesResponse proto.InternalMessageInfo

func (m *ListProfilesResponse) GetProfiles() []*Profile {
	if m != nil {
		return m.Profiles
	}
	return nil
}

func (m *ListProfilesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Create profile request.
type CreateProfileRequest struct {
	// Required. The name of the tenant this profile belongs to.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}", for example,
	// "projects/api-test-project/tenants/foo".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The profile to be created.
	Profile              *Profile `protobuf:"bytes,2,opt,name=profile,proto3" json:"profile,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateProfileRequest) Reset()         { *m = CreateProfileRequest{} }
func (m *CreateProfileRequest) String() string { return proto.CompactTextString(m) }
func (*CreateProfileRequest) ProtoMessage()    {}
func (*CreateProfileRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d2b7b5f4d4d7ea55, []int{2}
}

func (m *CreateProfileRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateProfileRequest.Unmarshal(m, b)
}
func (m *CreateProfileRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateProfileRequest.Marshal(b, m, deterministic)
}
func (m *CreateProfileRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateProfileRequest.Merge(m, src)
}
func (m *CreateProfileRequest) XXX_Size() int {
	return xxx_messageInfo_CreateProfileRequest.Size(m)
}
func (m *CreateProfileRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateProfileRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateProfileRequest proto.InternalMessageInfo

func (m *CreateProfileRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateProfileRequest) GetProfile() *Profile {
	if m != nil {
		return m.Profile
	}
	return nil
}

// Get profile request.
type GetProfileRequest struct {
	// Required. Resource name of the profile to get.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/profiles/{profile_id}",
	// for example, "projects/api-test-project/tenants/foo/profiles/bar".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetProfileRequest) Reset()         { *m = GetProfileRequest{} }
func (m *GetProfileRequest) String() string { return proto.CompactTextString(m) }
func (*GetProfileRequest) ProtoMessage()    {}
func (*GetProfileRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d2b7b5f4d4d7ea55, []int{3}
}

func (m *GetProfileRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetProfileRequest.Unmarshal(m, b)
}
func (m *GetProfileRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetProfileRequest.Marshal(b, m, deterministic)
}
func (m *GetProfileRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetProfileRequest.Merge(m, src)
}
func (m *GetProfileRequest) XXX_Size() int {
	return xxx_messageInfo_GetProfileRequest.Size(m)
}
func (m *GetProfileRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetProfileRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetProfileRequest proto.InternalMessageInfo

func (m *GetProfileRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Update profile request
type UpdateProfileRequest struct {
	// Required. Profile to be updated.
	Profile *Profile `protobuf:"bytes,1,opt,name=profile,proto3" json:"profile,omitempty"`
	// Optional. A field mask to specify the profile fields to update.
	//
	// A full update is performed if it is unset.
	//
	// Valid values are:
	// * external_id
	// * source
	// * uri
	// * is_hirable
	// * create_time
	// * update_time
	// * resume
	// * person_names
	// * addresses
	// * email_addresses
	// * phone_numbers
	// * personal_uris
	// * additional_contact_info
	// * employment_records
	// * education_records
	// * skills
	// * activities
	// * publications
	// * patents
	// * certifications
	// * recruiting_notes
	// * custom_attributes
	// * group_id
	// * external_system
	// * source_note
	// * primary_responsibilities
	// * citizenships
	// * work_authorizations
	// * employee_types
	// * language_code
	// * qualification_summary
	// * allowed_contact_types
	// * preferred_contact_types
	// * contact_availability
	// * language_fluencies
	// * work_preference
	// * industry_experiences
	// * work_environment_experiences
	// * work_availability
	// * security_clearances
	// * references
	// * assessments
	// * interviews
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateProfileRequest) Reset()         { *m = UpdateProfileRequest{} }
func (m *UpdateProfileRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateProfileRequest) ProtoMessage()    {}
func (*UpdateProfileRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d2b7b5f4d4d7ea55, []int{4}
}

func (m *UpdateProfileRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateProfileRequest.Unmarshal(m, b)
}
func (m *UpdateProfileRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateProfileRequest.Marshal(b, m, deterministic)
}
func (m *UpdateProfileRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateProfileRequest.Merge(m, src)
}
func (m *UpdateProfileRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateProfileRequest.Size(m)
}
func (m *UpdateProfileRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateProfileRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateProfileRequest proto.InternalMessageInfo

func (m *UpdateProfileRequest) GetProfile() *Profile {
	if m != nil {
		return m.Profile
	}
	return nil
}

func (m *UpdateProfileRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Delete profile request.
type DeleteProfileRequest struct {
	// Required. Resource name of the profile to be deleted.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/profiles/{profile_id}",
	// for example, "projects/api-test-project/tenants/foo/profiles/bar".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteProfileRequest) Reset()         { *m = DeleteProfileRequest{} }
func (m *DeleteProfileRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteProfileRequest) ProtoMessage()    {}
func (*DeleteProfileRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d2b7b5f4d4d7ea55, []int{5}
}

func (m *DeleteProfileRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteProfileRequest.Unmarshal(m, b)
}
func (m *DeleteProfileRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteProfileRequest.Marshal(b, m, deterministic)
}
func (m *DeleteProfileRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteProfileRequest.Merge(m, src)
}
func (m *DeleteProfileRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteProfileRequest.Size(m)
}
func (m *DeleteProfileRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteProfileRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteProfileRequest proto.InternalMessageInfo

func (m *DeleteProfileRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request body of the `SearchProfiles` call.
type SearchProfilesRequest struct {
	// Required. The resource name of the tenant to search within.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}", for example,
	// "projects/api-test-project/tenants/foo".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The meta information collected about the profile search user.
	// This is used to improve the search quality of the service. These values are
	// provided by users, and must be precise and consistent.
	RequestMetadata *RequestMetadata `protobuf:"bytes,2,opt,name=request_metadata,json=requestMetadata,proto3" json:"request_metadata,omitempty"`
	// Optional. Search query to execute. See
	// [ProfileQuery][google.cloud.talent.v4beta1.ProfileQuery] for more details.
	ProfileQuery *ProfileQuery `protobuf:"bytes,3,opt,name=profile_query,json=profileQuery,proto3" json:"profile_query,omitempty"`
	// Optional. A limit on the number of profiles returned in the search results.
	// A value above the default value 10 can increase search response time.
	//
	// The maximum value allowed is 100. Otherwise an error is thrown.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The pageToken, similar to offset enables users of the API to
	// paginate through the search results. To retrieve the first page of results,
	// set the pageToken to empty. The search response includes a
	// [nextPageToken][google.cloud.talent.v4beta1.SearchProfilesResponse.next_page_token]
	// field that can be used to populate the pageToken field for the next page of
	// results. Using pageToken instead of offset increases the performance of the
	// API, especially compared to larger offset values.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. An integer that specifies the current offset (that is, starting
	// result) in search results. This field is only considered if
	// [page_token][google.cloud.talent.v4beta1.SearchProfilesRequest.page_token]
	// is unset.
	//
	// The maximum allowed value is 5000. Otherwise an error is thrown.
	//
	// For example, 0 means to search from the first profile, and 10 means to
	// search from the 11th profile. This can be used for pagination, for example
	// pageSize = 10 and offset = 10 means to search from the second page.
	Offset int32 `protobuf:"varint,6,opt,name=offset,proto3" json:"offset,omitempty"`
	// Optional. This flag controls the spell-check feature. If `false`, the
	// service attempts to correct a misspelled query.
	//
	// For example, "enginee" is corrected to "engineer".
	DisableSpellCheck bool `protobuf:"varint,7,opt,name=disable_spell_check,json=disableSpellCheck,proto3" json:"disable_spell_check,omitempty"`
	// Optional. The criteria that determines how search results are sorted.
	// Defaults is "relevance desc" if no value is specified.
	//
	// Supported options are:
	//
	// * "relevance desc": By descending relevance, as determined by the API
	//    algorithms.
	// * "update_date desc": Sort by
	// [Profile.update_time][google.cloud.talent.v4beta1.Profile.update_time] in
	// descending order
	//   (recently updated profiles first).
	// * "create_date desc": Sort by
	// [Profile.create_time][google.cloud.talent.v4beta1.Profile.create_time] in
	// descending order
	//   (recently created profiles first).
	// * "first_name": Sort by
	// [PersonName.PersonStructuredName.given_name][google.cloud.talent.v4beta1.PersonName.PersonStructuredName.given_name]
	// in
	//   ascending order.
	// * "first_name desc": Sort by
	// [PersonName.PersonStructuredName.given_name][google.cloud.talent.v4beta1.PersonName.PersonStructuredName.given_name]
	//   in descending order.
	// * "last_name": Sort by
	// [PersonName.PersonStructuredName.family_name][google.cloud.talent.v4beta1.PersonName.PersonStructuredName.family_name]
	// in
	//   ascending order.
	// * "last_name desc": Sort by
	// [PersonName.PersonStructuredName.family_name][google.cloud.talent.v4beta1.PersonName.PersonStructuredName.family_name]
	//   in ascending order.
	OrderBy string `protobuf:"bytes,8,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. When sort by field is based on alphabetical order, sort values
	// case sensitively (based on ASCII) when the value is set to true. Default
	// value is case in-sensitive sort (false).
	CaseSensitiveSort bool `protobuf:"varint,9,opt,name=case_sensitive_sort,json=caseSensitiveSort,proto3" json:"case_sensitive_sort,omitempty"`
	// Optional. A list of expressions specifies histogram requests against
	// matching profiles for
	// [SearchProfilesRequest][google.cloud.talent.v4beta1.SearchProfilesRequest].
	//
	// The expression syntax looks like a function definition with optional
	// parameters.
	//
	// Function syntax: function_name(histogram_facet[, list of buckets])
	//
	// Data types:
	//
	// * Histogram facet: facet names with format [a-zA-Z][a-zA-Z0-9_]+.
	// * String: string like "any string with backslash escape for quote(\")."
	// * Number: whole number and floating point number like 10, -1 and -0.01.
	// * List: list of elements with comma(,) separator surrounded by square
	// brackets. For example, [1, 2, 3] and ["one", "two", "three"].
	//
	// Built-in constants:
	//
	// * MIN (minimum number similar to java Double.MIN_VALUE)
	// * MAX (maximum number similar to java Double.MAX_VALUE)
	//
	// Built-in functions:
	//
	// * bucket(start, end[, label])
	// Bucket build-in function creates a bucket with range of [start, end). Note
	// that the end is exclusive.
	// For example, bucket(1, MAX, "positive number") or bucket(1, 10).
	//
	// Histogram Facets:
	//
	// * admin1: Admin1 is a global placeholder for referring to state, province,
	// or the particular term a country uses to define the geographic structure
	// below the country level. Examples include states codes such as "CA", "IL",
	// "NY", and provinces, such as "BC".
	// * locality: Locality is a global placeholder for referring to city, town,
	// or the particular term a country uses to define the geographic structure
	// below the admin1 level. Examples include city names such as
	// "Mountain View" and "New York".
	// * extended_locality: Extended locality is concatenated version of admin1
	// and locality with comma separator. For example, "Mountain View, CA" and
	// "New York, NY".
	// * postal_code: Postal code of profile which follows locale code.
	// * country: Country code (ISO-3166-1 alpha-2 code) of profile, such as US,
	//  JP, GB.
	// * job_title: Normalized job titles specified in EmploymentHistory.
	// * company_name: Normalized company name of profiles to match on.
	// * institution: The school name. For example, "MIT",
	// "University of California, Berkeley"
	// * degree: Highest education degree in ISCED code. Each value in degree
	// covers a specific level of education, without any expansion to upper nor
	// lower levels of education degree.
	// * experience_in_months: experience in months. 0 means 0 month to 1 month
	// (exclusive).
	// * application_date: The application date specifies application start dates.
	// See
	// [ApplicationDateFilter][google.cloud.talent.v4beta1.ApplicationDateFilter]
	// for more details.
	// * application_outcome_notes: The application outcome reason specifies the
	// reasons behind the outcome of the job application.
	// See
	// [ApplicationOutcomeNotesFilter][google.cloud.talent.v4beta1.ApplicationOutcomeNotesFilter]
	// for more details.
	// * application_job_title: The application job title specifies the job
	// applied for in the application.
	// See
	// [ApplicationJobFilter][google.cloud.talent.v4beta1.ApplicationJobFilter]
	// for more details.
	// * hirable_status: Hirable status specifies the profile's hirable status.
	// * string_custom_attribute: String custom attributes. Values can be accessed
	// via square bracket notation like string_custom_attribute["key1"].
	// * numeric_custom_attribute: Numeric custom attributes. Values can be
	// accessed via square bracket notation like numeric_custom_attribute["key1"].
	//
	// Example expressions:
	//
	// * count(admin1)
	// * count(experience_in_months, [bucket(0, 12, "1 year"),
	// bucket(12, 36, "1-3 years"), bucket(36, MAX, "3+ years")])
	// * count(string_custom_attribute["assigned_recruiter"])
	// * count(numeric_custom_attribute["favorite_number"],
	// [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])
	HistogramQueries []*HistogramQuery `protobuf:"bytes,10,rep,name=histogram_queries,json=histogramQueries,proto3" json:"histogram_queries,omitempty"`
	// Optional. An id that uniquely identifies the result set of a
	// [SearchProfiles][google.cloud.talent.v4beta1.ProfileService.SearchProfiles]
	// call. The id should be retrieved from the
	// [SearchProfilesResponse][google.cloud.talent.v4beta1.SearchProfilesResponse]
	// message returned from a previous invocation of
	// [SearchProfiles][google.cloud.talent.v4beta1.ProfileService.SearchProfiles].
	//
	// A result set is an ordered list of search results.
	//
	// If this field is not set, a new result set is computed based on the
	// [profile_query][google.cloud.talent.v4beta1.SearchProfilesRequest.profile_query].
	// A new
	// [result_set_id][google.cloud.talent.v4beta1.SearchProfilesRequest.result_set_id]
	// is returned as a handle to access this result set.
	//
	// If this field is set, the service will ignore the resource and
	// [profile_query][google.cloud.talent.v4beta1.SearchProfilesRequest.profile_query]
	// values, and simply retrieve a page of results from the corresponding result
	// set.  In this case, one and only one of
	// [page_token][google.cloud.talent.v4beta1.SearchProfilesRequest.page_token]
	// or [offset][google.cloud.talent.v4beta1.SearchProfilesRequest.offset] must
	// be set.
	//
	// A typical use case is to invoke
	// [SearchProfilesRequest][google.cloud.talent.v4beta1.SearchProfilesRequest]
	// without this field, then use the resulting
	// [result_set_id][google.cloud.talent.v4beta1.SearchProfilesRequest.result_set_id]
	// in
	// [SearchProfilesResponse][google.cloud.talent.v4beta1.SearchProfilesResponse]
	// to page through the results.
	ResultSetId string `protobuf:"bytes,12,opt,name=result_set_id,json=resultSetId,proto3" json:"result_set_id,omitempty"`
	// Optional. This flag is used to indicate whether the service will attempt to
	// understand synonyms and terms related to the search query or treat the
	// query "as is" when it generates a set of results. By default this flag is
	// set to false, thus allowing expanded results to also be returned. For
	// example a search for "software engineer" might also return candidates who
	// have experience in jobs similar to software engineer positions. By setting
	// this flag to true, the service will only attempt to deliver candidates has
	// software engineer in his/her global fields by treating "software engineer"
	// as a keyword.
	//
	// It is recommended to provide a feature in the UI (such as a checkbox) to
	// allow recruiters to set this flag to true if they intend to search for
	// longer boolean strings.
	StrictKeywordsSearch bool     `protobuf:"varint,13,opt,name=strict_keywords_search,json=strictKeywordsSearch,proto3" json:"strict_keywords_search,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchProfilesRequest) Reset()         { *m = SearchProfilesRequest{} }
func (m *SearchProfilesRequest) String() string { return proto.CompactTextString(m) }
func (*SearchProfilesRequest) ProtoMessage()    {}
func (*SearchProfilesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d2b7b5f4d4d7ea55, []int{6}
}

func (m *SearchProfilesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchProfilesRequest.Unmarshal(m, b)
}
func (m *SearchProfilesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchProfilesRequest.Marshal(b, m, deterministic)
}
func (m *SearchProfilesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchProfilesRequest.Merge(m, src)
}
func (m *SearchProfilesRequest) XXX_Size() int {
	return xxx_messageInfo_SearchProfilesRequest.Size(m)
}
func (m *SearchProfilesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchProfilesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchProfilesRequest proto.InternalMessageInfo

func (m *SearchProfilesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *SearchProfilesRequest) GetRequestMetadata() *RequestMetadata {
	if m != nil {
		return m.RequestMetadata
	}
	return nil
}

func (m *SearchProfilesRequest) GetProfileQuery() *ProfileQuery {
	if m != nil {
		return m.ProfileQuery
	}
	return nil
}

func (m *SearchProfilesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchProfilesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *SearchProfilesRequest) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *SearchProfilesRequest) GetDisableSpellCheck() bool {
	if m != nil {
		return m.DisableSpellCheck
	}
	return false
}

func (m *SearchProfilesRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

func (m *SearchProfilesRequest) GetCaseSensitiveSort() bool {
	if m != nil {
		return m.CaseSensitiveSort
	}
	return false
}

func (m *SearchProfilesRequest) GetHistogramQueries() []*HistogramQuery {
	if m != nil {
		return m.HistogramQueries
	}
	return nil
}

func (m *SearchProfilesRequest) GetResultSetId() string {
	if m != nil {
		return m.ResultSetId
	}
	return ""
}

func (m *SearchProfilesRequest) GetStrictKeywordsSearch() bool {
	if m != nil {
		return m.StrictKeywordsSearch
	}
	return false
}

// Response of SearchProfiles method.
type SearchProfilesResponse struct {
	// An estimation of the number of profiles that match the specified query.
	//
	// This number isn't guaranteed to be accurate.
	EstimatedTotalSize int64 `protobuf:"varint,1,opt,name=estimated_total_size,json=estimatedTotalSize,proto3" json:"estimated_total_size,omitempty"`
	// The spell checking result, and correction.
	SpellCorrection *SpellingCorrection `protobuf:"bytes,2,opt,name=spell_correction,json=spellCorrection,proto3" json:"spell_correction,omitempty"`
	// Additional information for the API invocation, such as the request
	// tracking id.
	Metadata *ResponseMetadata `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// A token to retrieve the next page of results. This is empty if there are no
	// more results.
	NextPageToken string `protobuf:"bytes,4,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The histogram results that match with specified
	// [SearchProfilesRequest.histogram_queries][google.cloud.talent.v4beta1.SearchProfilesRequest.histogram_queries].
	HistogramQueryResults []*HistogramQueryResult `protobuf:"bytes,5,rep,name=histogram_query_results,json=histogramQueryResults,proto3" json:"histogram_query_results,omitempty"`
	// The profile entities that match the specified
	// [SearchProfilesRequest][google.cloud.talent.v4beta1.SearchProfilesRequest].
	SummarizedProfiles []*SummarizedProfile `protobuf:"bytes,6,rep,name=summarized_profiles,json=summarizedProfiles,proto3" json:"summarized_profiles,omitempty"`
	// An id that uniquely identifies the result set of a
	// [SearchProfiles][google.cloud.talent.v4beta1.ProfileService.SearchProfiles]
	// call for consistent results.
	ResultSetId          string   `protobuf:"bytes,7,opt,name=result_set_id,json=resultSetId,proto3" json:"result_set_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchProfilesResponse) Reset()         { *m = SearchProfilesResponse{} }
func (m *SearchProfilesResponse) String() string { return proto.CompactTextString(m) }
func (*SearchProfilesResponse) ProtoMessage()    {}
func (*SearchProfilesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d2b7b5f4d4d7ea55, []int{7}
}

func (m *SearchProfilesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchProfilesResponse.Unmarshal(m, b)
}
func (m *SearchProfilesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchProfilesResponse.Marshal(b, m, deterministic)
}
func (m *SearchProfilesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchProfilesResponse.Merge(m, src)
}
func (m *SearchProfilesResponse) XXX_Size() int {
	return xxx_messageInfo_SearchProfilesResponse.Size(m)
}
func (m *SearchProfilesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchProfilesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchProfilesResponse proto.InternalMessageInfo

func (m *SearchProfilesResponse) GetEstimatedTotalSize() int64 {
	if m != nil {
		return m.EstimatedTotalSize
	}
	return 0
}

func (m *SearchProfilesResponse) GetSpellCorrection() *SpellingCorrection {
	if m != nil {
		return m.SpellCorrection
	}
	return nil
}

func (m *SearchProfilesResponse) GetMetadata() *ResponseMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *SearchProfilesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *SearchProfilesResponse) GetHistogramQueryResults() []*HistogramQueryResult {
	if m != nil {
		return m.HistogramQueryResults
	}
	return nil
}

func (m *SearchProfilesResponse) GetSummarizedProfiles() []*SummarizedProfile {
	if m != nil {
		return m.SummarizedProfiles
	}
	return nil
}

func (m *SearchProfilesResponse) GetResultSetId() string {
	if m != nil {
		return m.ResultSetId
	}
	return ""
}

// Output only.
//
// Profile entry with metadata inside
// [SearchProfilesResponse][google.cloud.talent.v4beta1.SearchProfilesResponse].
type SummarizedProfile struct {
	// A list of profiles that are linked by
	// [Profile.group_id][google.cloud.talent.v4beta1.Profile.group_id].
	Profiles []*Profile `protobuf:"bytes,1,rep,name=profiles,proto3" json:"profiles,omitempty"`
	// A profile summary shows the profile summary and how the profile matches the
	// search query.
	//
	// In profile summary, the profiles with the same
	// [Profile.group_id][google.cloud.talent.v4beta1.Profile.group_id] are merged
	// together. Among profiles, same education/employment records may be slightly
	// different but they are merged into one with best efforts.
	//
	// For example, in one profile the school name is "UC Berkeley" and the field
	// study is "Computer Science" and in another one the school name is
	// "University of California at Berkeley" and the field study is "CS". The API
	// merges these two inputs into one and selects one value for each field. For
	// example, the school name in summary is set to "University of California at
	// Berkeley" and the field of study is set to "Computer Science".
	Summary              *Profile `protobuf:"bytes,2,opt,name=summary,proto3" json:"summary,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SummarizedProfile) Reset()         { *m = SummarizedProfile{} }
func (m *SummarizedProfile) String() string { return proto.CompactTextString(m) }
func (*SummarizedProfile) ProtoMessage()    {}
func (*SummarizedProfile) Descriptor() ([]byte, []int) {
	return fileDescriptor_d2b7b5f4d4d7ea55, []int{8}
}

func (m *SummarizedProfile) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SummarizedProfile.Unmarshal(m, b)
}
func (m *SummarizedProfile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SummarizedProfile.Marshal(b, m, deterministic)
}
func (m *SummarizedProfile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SummarizedProfile.Merge(m, src)
}
func (m *SummarizedProfile) XXX_Size() int {
	return xxx_messageInfo_SummarizedProfile.Size(m)
}
func (m *SummarizedProfile) XXX_DiscardUnknown() {
	xxx_messageInfo_SummarizedProfile.DiscardUnknown(m)
}

var xxx_messageInfo_SummarizedProfile proto.InternalMessageInfo

func (m *SummarizedProfile) GetProfiles() []*Profile {
	if m != nil {
		return m.Profiles
	}
	return nil
}

func (m *SummarizedProfile) GetSummary() *Profile {
	if m != nil {
		return m.Summary
	}
	return nil
}

func init() {
	proto.RegisterType((*ListProfilesRequest)(nil), "google.cloud.talent.v4beta1.ListProfilesRequest")
	proto.RegisterType((*ListProfilesResponse)(nil), "google.cloud.talent.v4beta1.ListProfilesResponse")
	proto.RegisterType((*CreateProfileRequest)(nil), "google.cloud.talent.v4beta1.CreateProfileRequest")
	proto.RegisterType((*GetProfileRequest)(nil), "google.cloud.talent.v4beta1.GetProfileRequest")
	proto.RegisterType((*UpdateProfileRequest)(nil), "google.cloud.talent.v4beta1.UpdateProfileRequest")
	proto.RegisterType((*DeleteProfileRequest)(nil), "google.cloud.talent.v4beta1.DeleteProfileRequest")
	proto.RegisterType((*SearchProfilesRequest)(nil), "google.cloud.talent.v4beta1.SearchProfilesRequest")
	proto.RegisterType((*SearchProfilesResponse)(nil), "google.cloud.talent.v4beta1.SearchProfilesResponse")
	proto.RegisterType((*SummarizedProfile)(nil), "google.cloud.talent.v4beta1.SummarizedProfile")
}

func init() {
	proto.RegisterFile("google/cloud/talent/v4beta1/profile_service.proto", fileDescriptor_d2b7b5f4d4d7ea55)
}

var fileDescriptor_d2b7b5f4d4d7ea55 = []byte{
	// 1177 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0xcf, 0x6f, 0x1b, 0xc5,
	0x17, 0xd7, 0x26, 0x6e, 0xe2, 0x4c, 0xe2, 0x26, 0x99, 0xb8, 0xe9, 0x7e, 0xdd, 0x2f, 0xc2, 0x5a,
	0x21, 0x70, 0xdd, 0x66, 0xb7, 0x71, 0x23, 0x05, 0xa5, 0x50, 0x91, 0x84, 0x5f, 0x15, 0x14, 0x05,
	0x3b, 0x08, 0xd4, 0xcb, 0x6a, 0xbc, 0x1e, 0xdb, 0xdb, 0xec, 0xee, 0x6c, 0x67, 0xc6, 0x09, 0x0e,
	0xaa, 0x04, 0xdc, 0x38, 0x47, 0x9c, 0xb8, 0x55, 0x1c, 0xb9, 0xf1, 0x5f, 0x70, 0x84, 0x23, 0x57,
	0xae, 0xfc, 0x0f, 0x68, 0x7e, 0x78, 0xe3, 0x1f, 0xab, 0xb5, 0x8d, 0xb8, 0xed, 0xbc, 0x37, 0x9f,
	0xf7, 0x3e, 0xf3, 0xde, 0x9b, 0xf7, 0x66, 0xc1, 0x6e, 0x87, 0x90, 0x4e, 0x80, 0x1d, 0x2f, 0x20,
	0xbd, 0x96, 0xc3, 0x51, 0x80, 0x23, 0xee, 0x9c, 0xef, 0x35, 0x31, 0x47, 0xbb, 0x4e, 0x4c, 0x49,
	0xdb, 0x0f, 0xb0, 0xcb, 0x30, 0x3d, 0xf7, 0x3d, 0x6c, 0xc7, 0x94, 0x70, 0x02, 0xef, 0x28, 0x88,
	0x2d, 0x21, 0xb6, 0x82, 0xd8, 0x1a, 0x52, 0xfa, 0xbf, 0xb6, 0x87, 0x62, 0xdf, 0x41, 0x51, 0x44,
	0x38, 0xe2, 0x3e, 0x89, 0x98, 0x82, 0x96, 0x6e, 0x0f, 0x69, 0xbd, 0xc0, 0x17, 0x40, 0xa5, 0xa8,
	0x64, 0xd1, 0xf0, 0x48, 0x18, 0x92, 0x48, 0xef, 0xbc, 0x9b, 0xb5, 0xb3, 0xed, 0x07, 0x1c, 0xd3,
	0x81, 0xb7, 0x7b, 0x59, 0x5b, 0xbb, 0x3e, 0xe3, 0xa4, 0x43, 0x51, 0x38, 0x8b, 0x5d, 0x1d, 0x08,
	0xbd, 0x55, 0x07, 0xc0, 0x91, 0xab, 0x66, 0xaf, 0xed, 0xe0, 0x30, 0xe6, 0x7d, 0xad, 0x2c, 0x8f,
	0x2b, 0xdb, 0x3e, 0x0e, 0x5a, 0x6e, 0x88, 0xd8, 0x99, 0xda, 0x61, 0xbd, 0x32, 0xc0, 0xd6, 0xa7,
	0x3e, 0xe3, 0x27, 0xca, 0x28, 0xab, 0xe3, 0x17, 0x3d, 0xcc, 0x38, 0xdc, 0x06, 0x4b, 0x31, 0xa2,
	0x38, 0xe2, 0xa6, 0x51, 0x36, 0x2a, 0x2b, 0x75, 0xbd, 0x82, 0xaf, 0x01, 0x10, 0xa3, 0x0e, 0x76,
	0x39, 0x39, 0xc3, 0x91, 0xb9, 0x20, 0x75, 0x2b, 0x42, 0x72, 0x2a, 0x04, 0xf0, 0x0e, 0x90, 0x0b,
	0x97, 0xf9, 0x97, 0xd8, 0x5c, 0x2c, 0x1b, 0x95, 0x1b, 0xf5, 0xbc, 0x10, 0x34, 0xfc, 0x4b, 0x0c,
	0xf7, 0xc1, 0x0a, 0xc5, 0x48, 0xb9, 0x37, 0x73, 0x65, 0xa3, 0xb2, 0x5a, 0x2b, 0xd9, 0x3a, 0x7f,
	0x03, 0x86, 0xf6, 0x87, 0x82, 0xe1, 0x53, 0xc4, 0xce, 0xea, 0x79, 0xb1, 0x59, 0x7c, 0x59, 0xdf,
	0x1a, 0xa0, 0x38, 0x4a, 0x92, 0xc5, 0x24, 0x62, 0x18, 0xbe, 0x07, 0xf2, 0x3a, 0x1a, 0xcc, 0x34,
	0xca, 0x8b, 0x95, 0xd5, 0xda, 0x1b, 0x76, 0x46, 0x41, 0xd8, 0xda, 0x40, 0x3d, 0x41, 0xc1, 0x37,
	0xc1, 0x7a, 0x84, 0xbf, 0xe6, 0xee, 0xc4, 0xa1, 0x0a, 0x42, 0x7c, 0x32, 0x38, 0x98, 0x15, 0x81,
	0xe2, 0x31, 0xc5, 0x88, 0xe3, 0x81, 0x89, 0x29, 0x71, 0x7a, 0x0c, 0x96, 0xb5, 0x0f, 0x69, 0x6f,
	0x56, 0x62, 0x03, 0x90, 0xf5, 0x16, 0xd8, 0xfc, 0x08, 0xf3, 0x31, 0x67, 0x10, 0xe4, 0x22, 0x14,
	0x62, 0xed, 0x4a, 0x7e, 0x5b, 0x57, 0x06, 0x28, 0x7e, 0x11, 0xb7, 0x26, 0x99, 0x0d, 0x31, 0x30,
	0xfe, 0x05, 0x03, 0xf8, 0x08, 0xac, 0xf6, 0xa4, 0x5d, 0x95, 0xaf, 0x85, 0xa9, 0xf9, 0x02, 0x6a,
	0xbb, 0xcc, 0x58, 0x15, 0x14, 0xdf, 0xc7, 0x01, 0x9e, 0x20, 0x95, 0x76, 0x82, 0x3f, 0x73, 0xe0,
	0x56, 0x03, 0x23, 0xea, 0x75, 0x67, 0x2d, 0xc2, 0x2f, 0xc1, 0x06, 0x55, 0x5b, 0xdc, 0x10, 0x73,
	0xd4, 0x42, 0x1c, 0x69, 0x7e, 0xf7, 0x33, 0xcf, 0xa8, 0xed, 0x3e, 0xd5, 0x98, 0xfa, 0x3a, 0x1d,
	0x15, 0xc0, 0xcf, 0x40, 0x61, 0xd0, 0x66, 0x5e, 0xf4, 0x30, 0xed, 0xcb, 0x12, 0x5e, 0xad, 0xdd,
	0x9d, 0x25, 0x72, 0x9f, 0x0b, 0x40, 0x7d, 0x2d, 0x1e, 0x5a, 0x8d, 0x5e, 0x87, 0xdc, 0xd8, 0x75,
	0x18, 0xbd, 0x4a, 0x37, 0xc6, 0xaf, 0xd2, 0x36, 0x58, 0x22, 0xed, 0x36, 0xc3, 0xdc, 0x5c, 0x92,
	0x40, 0xbd, 0x82, 0x36, 0xd8, 0x6a, 0xf9, 0x0c, 0x35, 0x45, 0x2b, 0x8c, 0x71, 0x10, 0xb8, 0x5e,
	0x17, 0x7b, 0x67, 0xe6, 0x72, 0xd9, 0xa8, 0xe4, 0xeb, 0x9b, 0x5a, 0xd5, 0x10, 0x9a, 0x63, 0xa1,
	0x80, 0xff, 0x03, 0x79, 0x42, 0x5b, 0x98, 0xba, 0xcd, 0xbe, 0x99, 0x97, 0x4e, 0x96, 0xe5, 0xfa,
	0xa8, 0x2f, 0x4c, 0x79, 0x88, 0x89, 0x96, 0x1a, 0x31, 0x9f, 0xfb, 0xe7, 0xd8, 0x65, 0x84, 0x72,
	0x73, 0x45, 0x99, 0x12, 0xaa, 0xc6, 0x40, 0xd3, 0x20, 0x94, 0xc3, 0xaf, 0xc0, 0x66, 0xd2, 0xa9,
	0x64, 0x80, 0x7c, 0xcc, 0x4c, 0x20, 0xef, 0xdd, 0xbd, 0xcc, 0x10, 0x7d, 0x3c, 0x40, 0xa9, 0x20,
	0x6d, 0x74, 0x87, 0xd7, 0x3e, 0x66, 0xd0, 0x02, 0x05, 0x8a, 0x59, 0x2f, 0xe0, 0x2e, 0xc3, 0xdc,
	0xf5, 0x5b, 0xe6, 0x9a, 0x64, 0xba, 0xaa, 0x84, 0x0d, 0xcc, 0x9f, 0xb4, 0xe0, 0x1e, 0xd8, 0x66,
	0x9c, 0xfa, 0x1e, 0x77, 0xcf, 0x70, 0xff, 0x82, 0xd0, 0x16, 0x73, 0x99, 0x2c, 0x1b, 0xb3, 0x20,
	0x09, 0x17, 0x95, 0xf6, 0x13, 0xad, 0x54, 0x25, 0x65, 0xfd, 0x90, 0x03, 0xdb, 0xe3, 0xd5, 0xa5,
	0xbb, 0xc7, 0x03, 0x50, 0xc4, 0x8c, 0xfb, 0x21, 0xe2, 0xb8, 0xe5, 0x72, 0xc2, 0x51, 0xa0, 0x12,
	0x25, 0x8a, 0x6d, 0xb1, 0x0e, 0x13, 0xdd, 0xa9, 0x50, 0xc9, 0x94, 0x3d, 0x03, 0x1b, 0x3a, 0xe6,
	0x84, 0x52, 0xec, 0x89, 0x69, 0xa2, 0x0b, 0xcf, 0xc9, 0x3c, 0xbf, 0x4c, 0x87, 0x1f, 0x75, 0x8e,
	0x13, 0x58, 0x7d, 0x5d, 0x1a, 0xba, 0x16, 0xc0, 0x27, 0x20, 0x9f, 0x14, 0xb3, 0x2a, 0xbb, 0x9d,
	0x29, 0xc5, 0xac, 0x8e, 0x91, 0x54, 0x73, 0x02, 0x4f, 0x6b, 0x6a, 0xb9, 0x94, 0xa6, 0x06, 0x7d,
	0x70, 0x7b, 0x34, 0x9f, 0x7d, 0x57, 0x05, 0x9c, 0x99, 0x37, 0x64, 0x56, 0x77, 0xe7, 0xc9, 0xaa,
	0x44, 0xd6, 0x6f, 0x75, 0x53, 0xa4, 0x0c, 0xba, 0x60, 0x8b, 0xf5, 0xc2, 0x10, 0x51, 0xff, 0x12,
	0xb7, 0xdc, 0xa4, 0x69, 0x2f, 0x49, 0x37, 0x76, 0x76, 0xf0, 0x12, 0xdc, 0xa0, 0x99, 0x40, 0x36,
	0x2e, 0x4a, 0xa9, 0xa0, 0xe5, 0x89, 0x0a, 0xb2, 0x7e, 0x34, 0xc0, 0xe6, 0x84, 0xb5, 0xff, 0x60,
	0x88, 0x3c, 0x06, 0xcb, 0x8a, 0x51, 0x7f, 0xbe, 0x66, 0xaf, 0x41, 0xb5, 0xbf, 0xf3, 0xe0, 0xa6,
	0x16, 0x36, 0xd4, 0xeb, 0x06, 0xfe, 0x62, 0x80, 0xb5, 0xe1, 0x91, 0x07, 0x1f, 0x64, 0x9a, 0x4c,
	0x19, 0xe1, 0xa5, 0xdd, 0x39, 0x10, 0xaa, 0x94, 0xac, 0xfd, 0xef, 0xff, 0xf8, 0xeb, 0x6a, 0x61,
	0x17, 0x3a, 0xc9, 0x63, 0xe3, 0x1b, 0xd5, 0x72, 0xdf, 0x8d, 0x29, 0x79, 0x8e, 0x3d, 0xce, 0x9c,
	0xaa, 0xc3, 0x71, 0x84, 0x22, 0xf1, 0xf5, 0xd2, 0x49, 0x22, 0xf0, 0xb3, 0x01, 0x0a, 0x23, 0xf3,
	0x11, 0x66, 0x7b, 0x4f, 0x9b, 0xa5, 0xa5, 0x99, 0xa2, 0x66, 0x1d, 0x48, 0x8e, 0x7b, 0xd6, 0xbc,
	0x1c, 0x0f, 0x8c, 0x2a, 0xfc, 0xc9, 0x00, 0xe0, 0x7a, 0xac, 0xc2, 0xec, 0xba, 0x9b, 0x98, 0xbf,
	0x33, 0x12, 0x4c, 0x09, 0xa2, 0x98, 0x73, 0xa9, 0xf4, 0x12, 0x76, 0x4e, 0xf5, 0xa5, 0xc8, 0x79,
	0x61, 0x64, 0x94, 0x4f, 0x09, 0x62, 0xda, 0xd8, 0x9f, 0x91, 0xe3, 0x91, 0xe4, 0xf8, 0x4e, 0x6d,
	0x7f, 0x28, 0x88, 0xfa, 0x59, 0x39, 0x13, 0x57, 0x11, 0xcc, 0x2b, 0x03, 0x14, 0x46, 0x86, 0xfc,
	0x14, 0xba, 0x69, 0x0f, 0x82, 0xd2, 0xf6, 0xc4, 0x83, 0xe2, 0x03, 0xf1, 0x7e, 0x1d, 0x04, 0xb1,
	0x3a, 0x77, 0x10, 0x7f, 0x35, 0xc0, 0xcd, 0xd1, 0x7e, 0x0f, 0x6b, 0xd9, 0xed, 0x25, 0xed, 0xe9,
	0x51, 0x7a, 0x38, 0x17, 0x46, 0x5f, 0x9f, 0xb7, 0x25, 0xe9, 0x9a, 0xb5, 0x33, 0x5b, 0x69, 0x1e,
	0xa8, 0xf1, 0x75, 0x60, 0x54, 0x4b, 0xc1, 0x6f, 0x87, 0x5b, 0xcf, 0x49, 0x93, 0x69, 0xaf, 0x28,
	0xf6, 0x99, 0xed, 0x91, 0xf0, 0xf7, 0xc3, 0x46, 0x97, 0xf3, 0x98, 0x1d, 0x38, 0xce, 0xc5, 0xc5,
	0xc5, 0x98, 0xd2, 0x41, 0x3d, 0xde, 0x55, 0xbf, 0x08, 0x3b, 0x71, 0x80, 0x78, 0x9b, 0xd0, 0xf0,
	0xfe, 0xb4, 0xed, 0xc2, 0xc9, 0xd1, 0x77, 0x06, 0x78, 0xdd, 0x23, 0x61, 0xd6, 0x11, 0x8f, 0xb6,
	0x46, 0x1b, 0xd2, 0x89, 0x48, 0xcf, 0x89, 0xf1, 0xec, 0x50, 0x63, 0x3a, 0x24, 0x40, 0x51, 0xc7,
	0x26, 0xb4, 0xe3, 0x74, 0x70, 0x24, 0x93, 0xe7, 0x5c, 0xfb, 0x4b, 0xfd, 0x71, 0x79, 0xa4, 0x96,
	0xaf, 0x16, 0x16, 0x8f, 0x4f, 0x1b, 0xcd, 0x25, 0x89, 0x79, 0xf8, 0x4f, 0x00, 0x00, 0x00, 0xff,
	0xff, 0xaf, 0x4b, 0x45, 0x04, 0xf4, 0x0d, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ProfileServiceClient is the client API for ProfileService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ProfileServiceClient interface {
	// Lists profiles by filter. The order is unspecified.
	ListProfiles(ctx context.Context, in *ListProfilesRequest, opts ...grpc.CallOption) (*ListProfilesResponse, error)
	// Creates and returns a new profile.
	CreateProfile(ctx context.Context, in *CreateProfileRequest, opts ...grpc.CallOption) (*Profile, error)
	// Gets the specified profile.
	GetProfile(ctx context.Context, in *GetProfileRequest, opts ...grpc.CallOption) (*Profile, error)
	// Updates the specified profile and returns the updated result.
	UpdateProfile(ctx context.Context, in *UpdateProfileRequest, opts ...grpc.CallOption) (*Profile, error)
	// Deletes the specified profile.
	// Prerequisite: The profile has no associated applications or assignments
	// associated.
	DeleteProfile(ctx context.Context, in *DeleteProfileRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Searches for profiles within a tenant.
	//
	// For example, search by raw queries "software engineer in Mountain View" or
	// search by structured filters (location filter, education filter, etc.).
	//
	// See
	// [SearchProfilesRequest][google.cloud.talent.v4beta1.SearchProfilesRequest]
	// for more information.
	SearchProfiles(ctx context.Context, in *SearchProfilesRequest, opts ...grpc.CallOption) (*SearchProfilesResponse, error)
}

type profileServiceClient struct {
	cc *grpc.ClientConn
}

func NewProfileServiceClient(cc *grpc.ClientConn) ProfileServiceClient {
	return &profileServiceClient{cc}
}

func (c *profileServiceClient) ListProfiles(ctx context.Context, in *ListProfilesRequest, opts ...grpc.CallOption) (*ListProfilesResponse, error) {
	out := new(ListProfilesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.ProfileService/ListProfiles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *profileServiceClient) CreateProfile(ctx context.Context, in *CreateProfileRequest, opts ...grpc.CallOption) (*Profile, error) {
	out := new(Profile)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.ProfileService/CreateProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *profileServiceClient) GetProfile(ctx context.Context, in *GetProfileRequest, opts ...grpc.CallOption) (*Profile, error) {
	out := new(Profile)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.ProfileService/GetProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *profileServiceClient) UpdateProfile(ctx context.Context, in *UpdateProfileRequest, opts ...grpc.CallOption) (*Profile, error) {
	out := new(Profile)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.ProfileService/UpdateProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *profileServiceClient) DeleteProfile(ctx context.Context, in *DeleteProfileRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.ProfileService/DeleteProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *profileServiceClient) SearchProfiles(ctx context.Context, in *SearchProfilesRequest, opts ...grpc.CallOption) (*SearchProfilesResponse, error) {
	out := new(SearchProfilesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.ProfileService/SearchProfiles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ProfileServiceServer is the server API for ProfileService service.
type ProfileServiceServer interface {
	// Lists profiles by filter. The order is unspecified.
	ListProfiles(context.Context, *ListProfilesRequest) (*ListProfilesResponse, error)
	// Creates and returns a new profile.
	CreateProfile(context.Context, *CreateProfileRequest) (*Profile, error)
	// Gets the specified profile.
	GetProfile(context.Context, *GetProfileRequest) (*Profile, error)
	// Updates the specified profile and returns the updated result.
	UpdateProfile(context.Context, *UpdateProfileRequest) (*Profile, error)
	// Deletes the specified profile.
	// Prerequisite: The profile has no associated applications or assignments
	// associated.
	DeleteProfile(context.Context, *DeleteProfileRequest) (*empty.Empty, error)
	// Searches for profiles within a tenant.
	//
	// For example, search by raw queries "software engineer in Mountain View" or
	// search by structured filters (location filter, education filter, etc.).
	//
	// See
	// [SearchProfilesRequest][google.cloud.talent.v4beta1.SearchProfilesRequest]
	// for more information.
	SearchProfiles(context.Context, *SearchProfilesRequest) (*SearchProfilesResponse, error)
}

func RegisterProfileServiceServer(s *grpc.Server, srv ProfileServiceServer) {
	s.RegisterService(&_ProfileService_serviceDesc, srv)
}

func _ProfileService_ListProfiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProfilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProfileServiceServer).ListProfiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.ProfileService/ListProfiles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProfileServiceServer).ListProfiles(ctx, req.(*ListProfilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProfileService_CreateProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProfileServiceServer).CreateProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.ProfileService/CreateProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProfileServiceServer).CreateProfile(ctx, req.(*CreateProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProfileService_GetProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProfileServiceServer).GetProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.ProfileService/GetProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProfileServiceServer).GetProfile(ctx, req.(*GetProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProfileService_UpdateProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProfileServiceServer).UpdateProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.ProfileService/UpdateProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProfileServiceServer).UpdateProfile(ctx, req.(*UpdateProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProfileService_DeleteProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProfileServiceServer).DeleteProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.ProfileService/DeleteProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProfileServiceServer).DeleteProfile(ctx, req.(*DeleteProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProfileService_SearchProfiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchProfilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProfileServiceServer).SearchProfiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.ProfileService/SearchProfiles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProfileServiceServer).SearchProfiles(ctx, req.(*SearchProfilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ProfileService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.talent.v4beta1.ProfileService",
	HandlerType: (*ProfileServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListProfiles",
			Handler:    _ProfileService_ListProfiles_Handler,
		},
		{
			MethodName: "CreateProfile",
			Handler:    _ProfileService_CreateProfile_Handler,
		},
		{
			MethodName: "GetProfile",
			Handler:    _ProfileService_GetProfile_Handler,
		},
		{
			MethodName: "UpdateProfile",
			Handler:    _ProfileService_UpdateProfile_Handler,
		},
		{
			MethodName: "DeleteProfile",
			Handler:    _ProfileService_DeleteProfile_Handler,
		},
		{
			MethodName: "SearchProfiles",
			Handler:    _ProfileService_SearchProfiles_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/talent/v4beta1/profile_service.proto",
}
