#!/usr/bin/env node
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const add_1 = require("./commands/add");
const install_1 = require("./commands/install");
const uninstall_1 = require("./commands/uninstall");
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
function readPkg() {
    return JSON.parse(fs_1.default.readFileSync(path_1.default.join(__dirname, '../package.json'), 'utf-8'));
}
const pkg = readPkg();
const [, , cmd, ...args] = process.argv;
function version() {
    console.log(pkg.version);
}
function help() {
    console.log(`Usage

  husky install [dir] (default: .husky)
  husky uninstall
  husky add <file> [cmd]

Examples

  husky install
  husky install .config/husky

  husky add .husky/pre-commit
  husky add .husky/pre-commit "npm test"
  husky add .config/husky/pre-commit "npm test"
`);
}
switch (cmd) {
    case 'install': {
        if (args.length > 2) {
            help();
            process.exit(2);
        }
        install_1.install(args[0]);
        break;
    }
    case 'uninstall': {
        uninstall_1.uninstall();
        break;
    }
    case 'add': {
        if (args.length === 0 || args.length > 2) {
            help();
            process.exit(2);
        }
        add_1.add(args[0], args[1]);
        break;
    }
    case '--version': {
        version();
        break;
    }
    case '-v': {
        version();
        break;
    }
    default:
        help();
}
