'use strict'

const t = require('tap')
const Fastify = require('fastify')
const From = require('..')
const http = require('http')
const get = require('simple-get').concat

const instance = Fastify()
instance.register(From)

t.plan(10)
t.tearDown(instance.close.bind(instance))

const target = http.createServer((req, res) => {
  t.pass('request proxied')
  t.equal(req.method, 'GET')
  res.statusCode = 205
  res.setHeader('Content-Type', 'text/plain')
  res.setHeader('x-my-header', 'hello!')
  res.end('hello world')
})

instance.get('/', (request, reply) => {
  reply.from(`http://localhost:${target.address().port}`, {
    rewriteHeaders: (headers) => {
      t.pass('rewriteHeaders called')
      return {
        'content-type': headers['content-type'],
        'x-another-header': 'so headers!'
      }
    }
  })
})

t.tearDown(target.close.bind(target))

instance.listen(0, (err) => {
  t.error(err)

  target.listen(0, (err) => {
    t.error(err)

    get(`http://localhost:${instance.server.address().port}`, (err, res, data) => {
      t.error(err)
      t.equal(res.headers['content-type'], 'text/plain')
      t.equal(res.headers['x-another-header'], 'so headers!')
      t.notOk(res.headers['x-my-header'])
      t.equal(res.statusCode, 205)
    })
  })
})
