export default {
  "title": "ts-jest",
  "tagline": "A TypeScript preprocessor with source map support for Jest that lets you use Jest to test projects written in TypeScript.",
  "url": "https://kulshekhar.github.io",
  "baseUrl": "/ts-jest/",
  "favicon": "img/logo.svg",
  "organizationName": "kulshekhar",
  "projectName": "ts-jest",
  "themeConfig": {
    "navbar": {
      "title": "Home",
      "logo": {
        "alt": "ts-jest",
        "src": "img/logo.png"
      },
      "items": [
        {
          "to": "docs/installation",
          "activeBasePath": "docs",
          "label": "Docs",
          "position": "left"
        },
        {
          "href": "https://github.com/kulshekhar/ts-jest/",
          "label": "GitHub",
          "position": "right"
        }
      ],
      "hideOnScroll": false
    },
    "footer": {
      "style": "light",
      "links": [
        {
          "title": "Docs",
          "items": [
            {
              "label": "Getting Started",
              "to": "docs/installation"
            }
          ]
        },
        {
          "title": "Community",
          "items": [
            {
              "label": "Slack",
              "href": "https://bit.ly/3bRHFPQ"
            }
          ]
        },
        {
          "title": "Social",
          "items": [
            {
              "label": "GitHub",
              "href": "https://github.com/kulshekhar/ts-jest/"
            }
          ]
        }
      ],
      "copyright": "Copyright © 2021 ts-jest. Built with Docusaurus."
    },
    "prism": {
      "theme": {
        "plain": {
          "color": "#403f53",
          "backgroundColor": "#FBFBFB"
        },
        "styles": [
          {
            "types": [
              "changed"
            ],
            "style": {
              "color": "rgb(162, 191, 252)",
              "fontStyle": "italic"
            }
          },
          {
            "types": [
              "deleted"
            ],
            "style": {
              "color": "rgba(239, 83, 80, 0.56)",
              "fontStyle": "italic"
            }
          },
          {
            "types": [
              "inserted",
              "attr-name"
            ],
            "style": {
              "color": "rgb(72, 118, 214)",
              "fontStyle": "italic"
            }
          },
          {
            "types": [
              "comment"
            ],
            "style": {
              "color": "rgb(152, 159, 177)",
              "fontStyle": "italic"
            }
          },
          {
            "types": [
              "string",
              "builtin",
              "char",
              "constant",
              "url"
            ],
            "style": {
              "color": "rgb(72, 118, 214)"
            }
          },
          {
            "types": [
              "variable"
            ],
            "style": {
              "color": "rgb(201, 103, 101)"
            }
          },
          {
            "types": [
              "number"
            ],
            "style": {
              "color": "rgb(170, 9, 130)"
            }
          },
          {
            "types": [
              "punctuation"
            ],
            "style": {
              "color": "rgb(153, 76, 195)"
            }
          },
          {
            "types": [
              "function",
              "selector",
              "doctype"
            ],
            "style": {
              "color": "rgb(153, 76, 195)",
              "fontStyle": "italic"
            }
          },
          {
            "types": [
              "class-name"
            ],
            "style": {
              "color": "rgb(17, 17, 17)"
            }
          },
          {
            "types": [
              "tag"
            ],
            "style": {
              "color": "rgb(153, 76, 195)"
            }
          },
          {
            "types": [
              "operator",
              "property",
              "keyword",
              "namespace"
            ],
            "style": {
              "color": "rgb(12, 150, 155)"
            }
          },
          {
            "types": [
              "boolean"
            ],
            "style": {
              "color": "rgb(188, 84, 84)"
            }
          }
        ]
      },
      "additionalLanguages": []
    },
    "sidebarCollapsible": false,
    "colorMode": {
      "defaultMode": "light",
      "disableSwitch": false,
      "respectPrefersColorScheme": false,
      "switchConfig": {
        "darkIcon": "🌜",
        "darkIconStyle": {},
        "lightIcon": "🌞",
        "lightIconStyle": {}
      }
    },
    "docs": {
      "versionPersistence": "localStorage"
    },
    "metadatas": [],
    "hideableSidebar": false
  },
  "presets": [
    [
      "@docusaurus/preset-classic",
      {
        "docs": {
          "sidebarPath": "/Users/ahn/ts-jest/website/sidebars.js",
          "editUrl": "https://github.com/kulshekhar/ts-jest/edit/master/docs",
          "remarkPlugins": [
            null
          ]
        },
        "theme": {
          "customCss": "/Users/ahn/ts-jest/website/src/css/custom.css"
        }
      }
    ]
  ],
  "baseUrlIssueBanner": true,
  "i18n": {
    "defaultLocale": "en",
    "locales": [
      "en"
    ]
  },
  "onBrokenLinks": "throw",
  "onBrokenMarkdownLinks": "warn",
  "onDuplicateRoutes": "warn",
  "customFields": {},
  "plugins": [],
  "themes": [],
  "titleDelimiter": "|",
  "noIndex": false
};